/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.codegen;

import com.querydsl.codegen.EntityType;
import com.querydsl.sql.SchemaAndTable;
import com.querydsl.sql.codegen.Naming;
import com.querydsl.sql.codegen.NamingStrategy;
import com.querydsl.sql.codegen.support.ForeignKeyData;
import java.util.regex.Pattern;
import javax.lang.model.SourceVersion;

public abstract class AbstractNamingStrategy
implements NamingStrategy {
    private static final Pattern PATTERN = Pattern.compile("\r");
    private static final Pattern REGEX = Pattern.compile("\n");
    protected String foreignKeysClassName = "ForeignKeys";
    protected String foreignKeysVariable = "fk";
    protected String primaryKeysClassName = "PrimaryKeys";
    protected String primaryKeysVariable = "pk";
    protected String reservedSuffix = "_col";

    @Override
    public String appendSchema(String packageName, String schemaName) {
        if (schemaName == null) {
            return packageName;
        }
        Object suffix = schemaName.toLowerCase();
        if (SourceVersion.isKeyword((CharSequence)suffix)) {
            suffix = (String)suffix + "_";
        }
        return packageName + "." + (String)suffix;
    }

    protected String escape(EntityType entityType, String name) {
        String candidate;
        int suffix = 0;
        while (true) {
            String string = candidate = suffix > 0 ? name + suffix : name;
            if (!entityType.getEscapedPropertyNames().contains(candidate)) break;
            ++suffix;
        }
        return candidate;
    }

    @Override
    public String getForeignKeysClassName() {
        return this.foreignKeysClassName;
    }

    @Override
    public String getForeignKeysVariable(EntityType entityType) {
        return this.foreignKeysVariable;
    }

    @Override
    public String getPrimaryKeysClassName() {
        return this.primaryKeysClassName;
    }

    @Override
    public String getPrimaryKeysVariable(EntityType entityType) {
        return this.primaryKeysVariable;
    }

    @Override
    public String normalizeColumnName(String columnName) {
        return this.normalizeSQLName(columnName);
    }

    @Override
    public String normalizeTableName(String tableName) {
        return this.normalizeSQLName(tableName);
    }

    @Override
    public String normalizeSchemaName(String schemaName) {
        return this.normalizeSQLName(schemaName);
    }

    protected String normalizeSQLName(String name) {
        if (name != null) {
            return REGEX.matcher(PATTERN.matcher(name).replaceAll("")).replaceAll(" ");
        }
        return null;
    }

    protected String normalizeJavaName(String name) {
        return Naming.normalize(name, this.reservedSuffix);
    }

    public void setForeignKeysClassName(String foreignKeysClassName) {
        this.foreignKeysClassName = foreignKeysClassName;
    }

    public void setForeignKeysVariable(String foreignKeysVariable) {
        this.foreignKeysVariable = foreignKeysVariable;
    }

    public void setPrimaryKeysClassName(String primaryKeysClassName) {
        this.primaryKeysClassName = primaryKeysClassName;
    }

    public void setPrimaryKeysVariable(String primaryKeysVariable) {
        this.primaryKeysVariable = primaryKeysVariable;
    }

    public void setReservedSuffix(String reservedSuffix) {
        this.reservedSuffix = reservedSuffix;
    }

    @Override
    public String getPackage(String basePackage, SchemaAndTable schemaAndTable) {
        return this.appendSchema(basePackage, schemaAndTable.getSchema());
    }

    @Override
    public boolean shouldGenerateClass(SchemaAndTable schemaAndTable) {
        return true;
    }

    @Override
    public boolean shouldGenerateForeignKey(SchemaAndTable schemaAndTable, ForeignKeyData foreignKeyData) {
        return true;
    }

    @Override
    public String getClassName(SchemaAndTable schemaAndTable) {
        return this.getClassName(schemaAndTable.getTable());
    }
}

