/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.codegen;

import com.querydsl.codegen.EntityType;
import com.querydsl.codegen.Property;
import com.querydsl.codegen.SimpleSerializerConfig;
import com.querydsl.codegen.utils.CodeWriter;
import com.querydsl.codegen.utils.JavaWriter;
import com.querydsl.codegen.utils.SimpleCompiler;
import com.querydsl.codegen.utils.model.ClassType;
import com.querydsl.codegen.utils.model.SimpleType;
import com.querydsl.codegen.utils.model.Type;
import com.querydsl.codegen.utils.model.TypeCategory;
import com.querydsl.sql.ColumnImpl;
import com.querydsl.sql.codegen.ExtendedBeanSerializer;
import com.querydsl.sql.codegen.support.PrimaryKeyData;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ExtendedBeanSerializerTest {
    private static final String CLASS_NAME = "DomainClass";
    private static final String[] PATH = new String[]{"com", "querydsl", "test", "gen"};
    private static final String PACKAGE = String.join((CharSequence)".", PATH);
    private static final String FULL_NAME = PACKAGE + ".DomainClass";
    @Rule
    public TemporaryFolder compileFolder = new TemporaryFolder();
    private EntityType type;
    private File srcFile;

    @Before
    public void setUp() throws IOException {
        SimpleType typeModel = new SimpleType(TypeCategory.ENTITY, FULL_NAME, PACKAGE, CLASS_NAME, false, false, new Type[0]);
        this.type = new EntityType((Type)typeModel);
        File srcFolder = this.compileFolder.newFolder(PATH);
        this.srcFile = new File(srcFolder, "DomainClass.java");
    }

    @Test
    public void equals_hashcode_tostring() throws Exception {
        Property idCol = new Property(this.type, "id", (Type)new ClassType(Integer.class, new Type[0]));
        idCol.addAnnotation((Annotation)new ColumnImpl("ID"));
        Property subIdCol = new Property(this.type, "sub_id", (Type)new ClassType(String.class, new Type[0]));
        subIdCol.addAnnotation((Annotation)new ColumnImpl("SUB_ID"));
        Property nameCol = new Property(this.type, "name", (Type)new ClassType(String.class, new Type[0]));
        nameCol.addAnnotation((Annotation)new ColumnImpl("NAME"));
        this.type.addProperty(idCol);
        this.type.addProperty(subIdCol);
        this.type.addProperty(nameCol);
        this.type.getData().put(PrimaryKeyData.class, Arrays.asList(new PrimaryKeyData("PK", new String[]{"ID", "SUB_ID"})));
        ExtendedBeanSerializer extendedBeanSerializer = new ExtendedBeanSerializer();
        extendedBeanSerializer.setAddToString(true);
        FileWriter fw = new FileWriter(this.srcFile);
        extendedBeanSerializer.serialize(this.type, SimpleSerializerConfig.DEFAULT, (CodeWriter)new JavaWriter((Appendable)fw));
        fw.close();
        URLClassLoader classLoader = URLClassLoader.newInstance(new URL[]{this.compileFolder.getRoot().toURI().toURL()});
        int retCode = new SimpleCompiler().run(null, (OutputStream)System.out, (OutputStream)System.err, new String[]{this.srcFile.getAbsolutePath()});
        ((AbstractIntegerAssert)Assertions.assertThat((int)retCode).as("The generated source should compile", new Object[0])).isEqualTo(0);
        Class<?> cls = Class.forName(FULL_NAME, true, classLoader);
        ReflectionHelper reflection = new ReflectionHelper(cls);
        Object obj1 = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Object obj1a = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Object obj2 = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        reflection.setValues(obj1, 1, "##", "X");
        reflection.setValues(obj1a, 1, "##", null);
        reflection.setValues(obj2, 2, "--", "Y");
        Assertions.assertThat(obj1a).isEqualTo(obj1);
        Assertions.assertThat((int)obj1a.hashCode()).isEqualTo(obj1.hashCode());
        Assertions.assertThat(obj2).isNotEqualTo(obj1);
        Assertions.assertThat((String)"DomainClass#1;##").isEqualTo(obj1.toString());
    }

    private static class ReflectionHelper {
        private final Map<String, Method> methodByName = new HashMap<String, Method>();

        ReflectionHelper(Class<?> cls) {
            for (Method m : cls.getDeclaredMethods()) {
                this.methodByName.put(m.getName(), m);
            }
        }

        private void setValues(Object instance, int id, String subId, String name) throws Exception {
            this.methodByName.get("setId").invoke(instance, id);
            this.methodByName.get("setSub_id").invoke(instance, subId);
            this.methodByName.get("setName").invoke(instance, name);
        }
    }
}

