/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.api;

import com.google.gson.reflect.TypeToken;
import io.github.pod4dev.libpodj.ApiCallback;
import io.github.pod4dev.libpodj.ApiClient;
import io.github.pod4dev.libpodj.ApiException;
import io.github.pod4dev.libpodj.ApiResponse;
import io.github.pod4dev.libpodj.Configuration;
import io.github.pod4dev.libpodj.Pair;
import io.github.pod4dev.libpodj.model.Container;
import io.github.pod4dev.libpodj.model.ContainerCreateResponse;
import io.github.pod4dev.libpodj.model.ContainerJSON;
import io.github.pod4dev.libpodj.model.ContainerTopOKBody;
import io.github.pod4dev.libpodj.model.ContainerWait200Response;
import io.github.pod4dev.libpodj.model.ContainersPruneReport;
import io.github.pod4dev.libpodj.model.CreateContainerConfig;
import io.github.pod4dev.libpodj.model.UpdateConfig;
import jakarta.validation.constraints.NotNull;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class ContainersCompatApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ContainersCompatApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ContainersCompatApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call containerArchiveCall(String name, String path, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/containers/{name}/archive".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (path != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("path", path));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call containerArchiveValidateBeforeCall(String name, String path, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerArchive(Async)");
        }
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling containerArchive(Async)");
        }
        return this.containerArchiveCall(name, path, _callback);
    }

    private ApiResponse<File> containerArchiveWithHttpInfo(@NotNull String name, @NotNull String path) throws ApiException {
        Call localVarCall = this.containerArchiveValidateBeforeCall(name, path, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call containerArchiveAsync(String name, String path, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.containerArchiveValidateBeforeCall(name, path, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcontainerArchiveRequest containerArchive(String name, String path) {
        return new APIcontainerArchiveRequest(name, path);
    }

    private Call containerArchiveLibpodCall(String name, String path, String rename, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/containers/{name}/archive".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (path != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("path", path));
        }
        if (rename != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("rename", rename));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call containerArchiveLibpodValidateBeforeCall(String name, String path, String rename, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerArchiveLibpod(Async)");
        }
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling containerArchiveLibpod(Async)");
        }
        return this.containerArchiveLibpodCall(name, path, rename, _callback);
    }

    private ApiResponse<File> containerArchiveLibpodWithHttpInfo(@NotNull String name, @NotNull String path, String rename) throws ApiException {
        Call localVarCall = this.containerArchiveLibpodValidateBeforeCall(name, path, rename, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call containerArchiveLibpodAsync(String name, String path, String rename, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.containerArchiveLibpodValidateBeforeCall(name, path, rename, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcontainerArchiveLibpodRequest containerArchiveLibpod(String name, String path) {
        return new APIcontainerArchiveLibpodRequest(name, path);
    }

    private Call containerAttachCall(String name, String detachKeys, Boolean logs, Boolean stream, Boolean stdout, Boolean stderr, Boolean stdin, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/containers/{name}/attach".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (detachKeys != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("detachKeys", detachKeys));
        }
        if (logs != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("logs", logs));
        }
        if (stream != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("stream", stream));
        }
        if (stdout != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("stdout", stdout));
        }
        if (stderr != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("stderr", stderr));
        }
        if (stdin != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("stdin", stdin));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call containerAttachValidateBeforeCall(String name, String detachKeys, Boolean logs, Boolean stream, Boolean stdout, Boolean stderr, Boolean stdin, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerAttach(Async)");
        }
        return this.containerAttachCall(name, detachKeys, logs, stream, stdout, stderr, stdin, _callback);
    }

    private ApiResponse<Void> containerAttachWithHttpInfo(@NotNull String name, String detachKeys, Boolean logs, Boolean stream, Boolean stdout, Boolean stderr, Boolean stdin) throws ApiException {
        Call localVarCall = this.containerAttachValidateBeforeCall(name, detachKeys, logs, stream, stdout, stderr, stdin, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call containerAttachAsync(String name, String detachKeys, Boolean logs, Boolean stream, Boolean stdout, Boolean stderr, Boolean stdin, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.containerAttachValidateBeforeCall(name, detachKeys, logs, stream, stdout, stderr, stdin, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIcontainerAttachRequest containerAttach(String name) {
        return new APIcontainerAttachRequest(name);
    }

    private Call containerChangesLibpod_0Call(String name, String parent, String diffType, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/containers/{name}/changes".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (parent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("parent", parent));
        }
        if (diffType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("diffType", diffType));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/octet-stream", "text/plain"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call containerChangesLibpod_0ValidateBeforeCall(String name, String parent, String diffType, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerChangesLibpod_0(Async)");
        }
        return this.containerChangesLibpod_0Call(name, parent, diffType, _callback);
    }

    private ApiResponse<Void> containerChangesLibpod_0WithHttpInfo(@NotNull String name, String parent, String diffType) throws ApiException {
        Call localVarCall = this.containerChangesLibpod_0ValidateBeforeCall(name, parent, diffType, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call containerChangesLibpod_0Async(String name, String parent, String diffType, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.containerChangesLibpod_0ValidateBeforeCall(name, parent, diffType, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIcontainerChangesLibpod_0Request containerChangesLibpod_0(String name) {
        return new APIcontainerChangesLibpod_0Request(name);
    }

    private Call containerCreateCall(CreateContainerConfig body, String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateContainerConfig localVarPostBody = body;
        String localVarPath = "/containers/create";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (name != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("name", name));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/x-tar"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call containerCreateValidateBeforeCall(CreateContainerConfig body, String name, ApiCallback _callback) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling containerCreate(Async)");
        }
        return this.containerCreateCall(body, name, _callback);
    }

    private ApiResponse<ContainerCreateResponse> containerCreateWithHttpInfo(@NotNull CreateContainerConfig body, String name) throws ApiException {
        Call localVarCall = this.containerCreateValidateBeforeCall(body, name, null);
        Type localVarReturnType = new TypeToken<ContainerCreateResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call containerCreateAsync(CreateContainerConfig body, String name, ApiCallback<ContainerCreateResponse> _callback) throws ApiException {
        Call localVarCall = this.containerCreateValidateBeforeCall(body, name, _callback);
        Type localVarReturnType = new TypeToken<ContainerCreateResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcontainerCreateRequest containerCreate(CreateContainerConfig body) {
        return new APIcontainerCreateRequest(body);
    }

    private Call containerDeleteCall(String name, Boolean force, Boolean v, Boolean link, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/containers/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if (v != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("v", v));
        }
        if (link != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("link", link));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call containerDeleteValidateBeforeCall(String name, Boolean force, Boolean v, Boolean link, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerDelete(Async)");
        }
        return this.containerDeleteCall(name, force, v, link, _callback);
    }

    private ApiResponse<Void> containerDeleteWithHttpInfo(@NotNull String name, Boolean force, Boolean v, Boolean link) throws ApiException {
        Call localVarCall = this.containerDeleteValidateBeforeCall(name, force, v, link, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call containerDeleteAsync(String name, Boolean force, Boolean v, Boolean link, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.containerDeleteValidateBeforeCall(name, force, v, link, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIcontainerDeleteRequest containerDelete(String name) {
        return new APIcontainerDeleteRequest(name);
    }

    private Call containerExportCall(String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/containers/{name}/export".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call containerExportValidateBeforeCall(String name, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerExport(Async)");
        }
        return this.containerExportCall(name, _callback);
    }

    private ApiResponse<Void> containerExportWithHttpInfo(@NotNull String name) throws ApiException {
        Call localVarCall = this.containerExportValidateBeforeCall(name, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call containerExportAsync(String name, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.containerExportValidateBeforeCall(name, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIcontainerExportRequest containerExport(String name) {
        return new APIcontainerExportRequest(name);
    }

    private Call containerInspectCall(String name, Boolean size, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/containers/{name}/json".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (size != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("size", size));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call containerInspectValidateBeforeCall(String name, Boolean size, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerInspect(Async)");
        }
        return this.containerInspectCall(name, size, _callback);
    }

    private ApiResponse<ContainerJSON> containerInspectWithHttpInfo(@NotNull String name, Boolean size) throws ApiException {
        Call localVarCall = this.containerInspectValidateBeforeCall(name, size, null);
        Type localVarReturnType = new TypeToken<ContainerJSON>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call containerInspectAsync(String name, Boolean size, ApiCallback<ContainerJSON> _callback) throws ApiException {
        Call localVarCall = this.containerInspectValidateBeforeCall(name, size, _callback);
        Type localVarReturnType = new TypeToken<ContainerJSON>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcontainerInspectRequest containerInspect(String name) {
        return new APIcontainerInspectRequest(name);
    }

    private Call containerKillCall(String name, Boolean all, String signal, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/containers/{name}/kill".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (all != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("all", all));
        }
        if (signal != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("signal", signal));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call containerKillValidateBeforeCall(String name, Boolean all, String signal, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerKill(Async)");
        }
        return this.containerKillCall(name, all, signal, _callback);
    }

    private ApiResponse<Void> containerKillWithHttpInfo(@NotNull String name, Boolean all, String signal) throws ApiException {
        Call localVarCall = this.containerKillValidateBeforeCall(name, all, signal, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call containerKillAsync(String name, Boolean all, String signal, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.containerKillValidateBeforeCall(name, all, signal, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIcontainerKillRequest containerKill(String name) {
        return new APIcontainerKillRequest(name);
    }

    private Call containerListCall(Boolean all, Boolean external, Integer limit, Boolean size, String filters, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/containers/json";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (all != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("all", all));
        }
        if (external != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("external", external));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (size != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("size", size));
        }
        if (filters != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filters", filters));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call containerListValidateBeforeCall(Boolean all, Boolean external, Integer limit, Boolean size, String filters, ApiCallback _callback) throws ApiException {
        return this.containerListCall(all, external, limit, size, filters, _callback);
    }

    private ApiResponse<List<Container>> containerListWithHttpInfo(Boolean all, Boolean external, Integer limit, Boolean size, String filters) throws ApiException {
        Call localVarCall = this.containerListValidateBeforeCall(all, external, limit, size, filters, null);
        Type localVarReturnType = new TypeToken<List<Container>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call containerListAsync(Boolean all, Boolean external, Integer limit, Boolean size, String filters, ApiCallback<List<Container>> _callback) throws ApiException {
        Call localVarCall = this.containerListValidateBeforeCall(all, external, limit, size, filters, _callback);
        Type localVarReturnType = new TypeToken<List<Container>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcontainerListRequest containerList() {
        return new APIcontainerListRequest();
    }

    private Call containerLogsCall(String name, Boolean follow, Boolean stdout, Boolean stderr, String since, String until, Boolean timestamps, String tail, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/containers/{name}/logs".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (follow != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("follow", follow));
        }
        if (stdout != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("stdout", stdout));
        }
        if (stderr != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("stderr", stderr));
        }
        if (since != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("since", since));
        }
        if (until != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("until", until));
        }
        if (timestamps != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timestamps", timestamps));
        }
        if (tail != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tail", tail));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call containerLogsValidateBeforeCall(String name, Boolean follow, Boolean stdout, Boolean stderr, String since, String until, Boolean timestamps, String tail, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerLogs(Async)");
        }
        return this.containerLogsCall(name, follow, stdout, stderr, since, until, timestamps, tail, _callback);
    }

    private ApiResponse<Void> containerLogsWithHttpInfo(@NotNull String name, Boolean follow, Boolean stdout, Boolean stderr, String since, String until, Boolean timestamps, String tail) throws ApiException {
        Call localVarCall = this.containerLogsValidateBeforeCall(name, follow, stdout, stderr, since, until, timestamps, tail, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call containerLogsAsync(String name, Boolean follow, Boolean stdout, Boolean stderr, String since, String until, Boolean timestamps, String tail, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.containerLogsValidateBeforeCall(name, follow, stdout, stderr, since, until, timestamps, tail, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIcontainerLogsRequest containerLogs(String name) {
        return new APIcontainerLogsRequest(name);
    }

    private Call containerPauseCall(String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/containers/{name}/pause".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call containerPauseValidateBeforeCall(String name, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerPause(Async)");
        }
        return this.containerPauseCall(name, _callback);
    }

    private ApiResponse<Void> containerPauseWithHttpInfo(@NotNull String name) throws ApiException {
        Call localVarCall = this.containerPauseValidateBeforeCall(name, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call containerPauseAsync(String name, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.containerPauseValidateBeforeCall(name, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIcontainerPauseRequest containerPause(String name) {
        return new APIcontainerPauseRequest(name);
    }

    private Call containerPruneCall(String filters, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/containers/prune";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (filters != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filters", filters));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call containerPruneValidateBeforeCall(String filters, ApiCallback _callback) throws ApiException {
        return this.containerPruneCall(filters, _callback);
    }

    private ApiResponse<List<ContainersPruneReport>> containerPruneWithHttpInfo(String filters) throws ApiException {
        Call localVarCall = this.containerPruneValidateBeforeCall(filters, null);
        Type localVarReturnType = new TypeToken<List<ContainersPruneReport>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call containerPruneAsync(String filters, ApiCallback<List<ContainersPruneReport>> _callback) throws ApiException {
        Call localVarCall = this.containerPruneValidateBeforeCall(filters, _callback);
        Type localVarReturnType = new TypeToken<List<ContainersPruneReport>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcontainerPruneRequest containerPrune() {
        return new APIcontainerPruneRequest();
    }

    private Call containerRenameCall(String name, String name2, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/containers/{name}/rename".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (name2 != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("name", name2));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call containerRenameValidateBeforeCall(String name, String name2, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerRename(Async)");
        }
        if (name2 == null) {
            throw new ApiException("Missing the required parameter 'name2' when calling containerRename(Async)");
        }
        return this.containerRenameCall(name, name2, _callback);
    }

    private ApiResponse<Void> containerRenameWithHttpInfo(@NotNull String name, @NotNull String name2) throws ApiException {
        Call localVarCall = this.containerRenameValidateBeforeCall(name, name2, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call containerRenameAsync(String name, String name2, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.containerRenameValidateBeforeCall(name, name2, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIcontainerRenameRequest containerRename(String name, String name2) {
        return new APIcontainerRenameRequest(name, name2);
    }

    private Call containerResizeCall(String name, Integer h, Integer w, Boolean running, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/containers/{name}/resize".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (h != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("h", h));
        }
        if (w != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("w", w));
        }
        if (running != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("running", running));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call containerResizeValidateBeforeCall(String name, Integer h, Integer w, Boolean running, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerResize(Async)");
        }
        return this.containerResizeCall(name, h, w, running, _callback);
    }

    private ApiResponse<Object> containerResizeWithHttpInfo(@NotNull String name, Integer h, Integer w, Boolean running) throws ApiException {
        Call localVarCall = this.containerResizeValidateBeforeCall(name, h, w, running, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call containerResizeAsync(String name, Integer h, Integer w, Boolean running, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.containerResizeValidateBeforeCall(name, h, w, running, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcontainerResizeRequest containerResize(String name) {
        return new APIcontainerResizeRequest(name);
    }

    private Call containerRestartCall(String name, Integer t, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/containers/{name}/restart".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (t != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("t", t));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call containerRestartValidateBeforeCall(String name, Integer t, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerRestart(Async)");
        }
        return this.containerRestartCall(name, t, _callback);
    }

    private ApiResponse<Void> containerRestartWithHttpInfo(@NotNull String name, Integer t) throws ApiException {
        Call localVarCall = this.containerRestartValidateBeforeCall(name, t, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call containerRestartAsync(String name, Integer t, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.containerRestartValidateBeforeCall(name, t, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIcontainerRestartRequest containerRestart(String name) {
        return new APIcontainerRestartRequest(name);
    }

    private Call containerStartCall(String name, String detachKeys, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/containers/{name}/start".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (detachKeys != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("detachKeys", detachKeys));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call containerStartValidateBeforeCall(String name, String detachKeys, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerStart(Async)");
        }
        return this.containerStartCall(name, detachKeys, _callback);
    }

    private ApiResponse<Void> containerStartWithHttpInfo(@NotNull String name, String detachKeys) throws ApiException {
        Call localVarCall = this.containerStartValidateBeforeCall(name, detachKeys, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call containerStartAsync(String name, String detachKeys, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.containerStartValidateBeforeCall(name, detachKeys, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIcontainerStartRequest containerStart(String name) {
        return new APIcontainerStartRequest(name);
    }

    private Call containerStatsCall(String name, Boolean stream, Boolean oneShot, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/containers/{name}/stats".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (stream != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("stream", stream));
        }
        if (oneShot != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("one-shot", oneShot));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call containerStatsValidateBeforeCall(String name, Boolean stream, Boolean oneShot, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerStats(Async)");
        }
        return this.containerStatsCall(name, stream, oneShot, _callback);
    }

    private ApiResponse<Object> containerStatsWithHttpInfo(@NotNull String name, Boolean stream, Boolean oneShot) throws ApiException {
        Call localVarCall = this.containerStatsValidateBeforeCall(name, stream, oneShot, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call containerStatsAsync(String name, Boolean stream, Boolean oneShot, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.containerStatsValidateBeforeCall(name, stream, oneShot, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcontainerStatsRequest containerStats(String name) {
        return new APIcontainerStatsRequest(name);
    }

    private Call containerStopCall(String name, Integer t, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/containers/{name}/stop".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (t != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("t", t));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call containerStopValidateBeforeCall(String name, Integer t, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerStop(Async)");
        }
        return this.containerStopCall(name, t, _callback);
    }

    private ApiResponse<Void> containerStopWithHttpInfo(@NotNull String name, Integer t) throws ApiException {
        Call localVarCall = this.containerStopValidateBeforeCall(name, t, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call containerStopAsync(String name, Integer t, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.containerStopValidateBeforeCall(name, t, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIcontainerStopRequest containerStop(String name) {
        return new APIcontainerStopRequest(name);
    }

    private Call containerTopCall(String name, String psArgs, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/containers/{name}/top".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (psArgs != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ps_args", psArgs));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call containerTopValidateBeforeCall(String name, String psArgs, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerTop(Async)");
        }
        return this.containerTopCall(name, psArgs, _callback);
    }

    private ApiResponse<ContainerTopOKBody> containerTopWithHttpInfo(@NotNull String name, String psArgs) throws ApiException {
        Call localVarCall = this.containerTopValidateBeforeCall(name, psArgs, null);
        Type localVarReturnType = new TypeToken<ContainerTopOKBody>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call containerTopAsync(String name, String psArgs, ApiCallback<ContainerTopOKBody> _callback) throws ApiException {
        Call localVarCall = this.containerTopValidateBeforeCall(name, psArgs, _callback);
        Type localVarReturnType = new TypeToken<ContainerTopOKBody>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcontainerTopRequest containerTop(String name) {
        return new APIcontainerTopRequest(name);
    }

    private Call containerUnpauseCall(String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/containers/{name}/unpause".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call containerUnpauseValidateBeforeCall(String name, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerUnpause(Async)");
        }
        return this.containerUnpauseCall(name, _callback);
    }

    private ApiResponse<Void> containerUnpauseWithHttpInfo(@NotNull String name) throws ApiException {
        Call localVarCall = this.containerUnpauseValidateBeforeCall(name, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call containerUnpauseAsync(String name, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.containerUnpauseValidateBeforeCall(name, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIcontainerUnpauseRequest containerUnpause(String name) {
        return new APIcontainerUnpauseRequest(name);
    }

    private Call containerUpdateCall(String name, UpdateConfig resources, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        UpdateConfig localVarPostBody = resources;
        String localVarPath = "/containers/{name}/update".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/x-tar"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call containerUpdateValidateBeforeCall(String name, UpdateConfig resources, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerUpdate(Async)");
        }
        return this.containerUpdateCall(name, resources, _callback);
    }

    private ApiResponse<Void> containerUpdateWithHttpInfo(@NotNull String name, UpdateConfig resources) throws ApiException {
        Call localVarCall = this.containerUpdateValidateBeforeCall(name, resources, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call containerUpdateAsync(String name, UpdateConfig resources, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.containerUpdateValidateBeforeCall(name, resources, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIcontainerUpdateRequest containerUpdate(String name) {
        return new APIcontainerUpdateRequest(name);
    }

    private Call containerWaitCall(String name, String condition, String interval, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/containers/{name}/wait".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (condition != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("condition", condition));
        }
        if (interval != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("interval", interval));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call containerWaitValidateBeforeCall(String name, String condition, String interval, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerWait(Async)");
        }
        return this.containerWaitCall(name, condition, interval, _callback);
    }

    private ApiResponse<ContainerWait200Response> containerWaitWithHttpInfo(@NotNull String name, String condition, String interval) throws ApiException {
        Call localVarCall = this.containerWaitValidateBeforeCall(name, condition, interval, null);
        Type localVarReturnType = new TypeToken<ContainerWait200Response>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call containerWaitAsync(String name, String condition, String interval, ApiCallback<ContainerWait200Response> _callback) throws ApiException {
        Call localVarCall = this.containerWaitValidateBeforeCall(name, condition, interval, _callback);
        Type localVarReturnType = new TypeToken<ContainerWait200Response>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcontainerWaitRequest containerWait(String name) {
        return new APIcontainerWaitRequest(name);
    }

    private Call imageCommitCall(String container, String repo, String tag, String comment, String author, Boolean pause, String changes, Boolean squash, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/commit";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (container != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("container", container));
        }
        if (repo != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("repo", repo));
        }
        if (tag != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tag", tag));
        }
        if (comment != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("comment", comment));
        }
        if (author != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("author", author));
        }
        if (pause != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pause", pause));
        }
        if (changes != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("changes", changes));
        }
        if (squash != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("squash", squash));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imageCommitValidateBeforeCall(String container, String repo, String tag, String comment, String author, Boolean pause, String changes, Boolean squash, ApiCallback _callback) throws ApiException {
        return this.imageCommitCall(container, repo, tag, comment, author, pause, changes, squash, _callback);
    }

    private ApiResponse<Void> imageCommitWithHttpInfo(String container, String repo, String tag, String comment, String author, Boolean pause, String changes, Boolean squash) throws ApiException {
        Call localVarCall = this.imageCommitValidateBeforeCall(container, repo, tag, comment, author, pause, changes, squash, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call imageCommitAsync(String container, String repo, String tag, String comment, String author, Boolean pause, String changes, Boolean squash, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.imageCommitValidateBeforeCall(container, repo, tag, comment, author, pause, changes, squash, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIimageCommitRequest imageCommit() {
        return new APIimageCommitRequest();
    }

    private Call putContainerArchiveCall(String name, String path, String noOverwriteDirNonDir, String copyUIDGID, String request, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        String localVarPostBody = request;
        String localVarPath = "/containers/{name}/archive".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (path != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("path", path));
        }
        if (noOverwriteDirNonDir != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("noOverwriteDirNonDir", noOverwriteDirNonDir));
        }
        if (copyUIDGID != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("copyUIDGID", copyUIDGID));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/x-tar"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call putContainerArchiveValidateBeforeCall(String name, String path, String noOverwriteDirNonDir, String copyUIDGID, String request, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling putContainerArchive(Async)");
        }
        if (path == null) {
            throw new ApiException("Missing the required parameter 'path' when calling putContainerArchive(Async)");
        }
        return this.putContainerArchiveCall(name, path, noOverwriteDirNonDir, copyUIDGID, request, _callback);
    }

    private ApiResponse<Void> putContainerArchiveWithHttpInfo(@NotNull String name, @NotNull String path, String noOverwriteDirNonDir, String copyUIDGID, String request) throws ApiException {
        Call localVarCall = this.putContainerArchiveValidateBeforeCall(name, path, noOverwriteDirNonDir, copyUIDGID, request, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call putContainerArchiveAsync(String name, String path, String noOverwriteDirNonDir, String copyUIDGID, String request, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.putContainerArchiveValidateBeforeCall(name, path, noOverwriteDirNonDir, copyUIDGID, request, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIputContainerArchiveRequest putContainerArchive(String name, String path) {
        return new APIputContainerArchiveRequest(name, path);
    }

    public class APIcontainerArchiveRequest {
        private final String name;
        private final String path;

        private APIcontainerArchiveRequest(String name, String path) {
            this.name = name;
            this.path = path;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ContainersCompatApi.this.containerArchiveCall(this.name, this.path, _callback);
        }

        public File execute() throws ApiException {
            ApiResponse<File> localVarResp = ContainersCompatApi.this.containerArchiveWithHttpInfo(this.name, this.path);
            return localVarResp.getData();
        }

        public ApiResponse<File> executeWithHttpInfo() throws ApiException {
            return ContainersCompatApi.this.containerArchiveWithHttpInfo(this.name, this.path);
        }

        public Call executeAsync(ApiCallback<File> _callback) throws ApiException {
            return ContainersCompatApi.this.containerArchiveAsync(this.name, this.path, _callback);
        }
    }

    public class APIcontainerArchiveLibpodRequest {
        private final String name;
        private final String path;
        private String rename;

        private APIcontainerArchiveLibpodRequest(String name, String path) {
            this.name = name;
            this.path = path;
        }

        public APIcontainerArchiveLibpodRequest rename(String rename) {
            this.rename = rename;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ContainersCompatApi.this.containerArchiveLibpodCall(this.name, this.path, this.rename, _callback);
        }

        public File execute() throws ApiException {
            ApiResponse<File> localVarResp = ContainersCompatApi.this.containerArchiveLibpodWithHttpInfo(this.name, this.path, this.rename);
            return localVarResp.getData();
        }

        public ApiResponse<File> executeWithHttpInfo() throws ApiException {
            return ContainersCompatApi.this.containerArchiveLibpodWithHttpInfo(this.name, this.path, this.rename);
        }

        public Call executeAsync(ApiCallback<File> _callback) throws ApiException {
            return ContainersCompatApi.this.containerArchiveLibpodAsync(this.name, this.path, this.rename, _callback);
        }
    }

    public class APIcontainerAttachRequest {
        private final String name;
        private String detachKeys;
        private Boolean logs;
        private Boolean stream;
        private Boolean stdout;
        private Boolean stderr;
        private Boolean stdin;

        private APIcontainerAttachRequest(String name) {
            this.name = name;
        }

        public APIcontainerAttachRequest detachKeys(String detachKeys) {
            this.detachKeys = detachKeys;
            return this;
        }

        public APIcontainerAttachRequest logs(Boolean logs) {
            this.logs = logs;
            return this;
        }

        public APIcontainerAttachRequest stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        public APIcontainerAttachRequest stdout(Boolean stdout) {
            this.stdout = stdout;
            return this;
        }

        public APIcontainerAttachRequest stderr(Boolean stderr) {
            this.stderr = stderr;
            return this;
        }

        public APIcontainerAttachRequest stdin(Boolean stdin) {
            this.stdin = stdin;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ContainersCompatApi.this.containerAttachCall(this.name, this.detachKeys, this.logs, this.stream, this.stdout, this.stderr, this.stdin, _callback);
        }

        public void execute() throws ApiException {
            ContainersCompatApi.this.containerAttachWithHttpInfo(this.name, this.detachKeys, this.logs, this.stream, this.stdout, this.stderr, this.stdin);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return ContainersCompatApi.this.containerAttachWithHttpInfo(this.name, this.detachKeys, this.logs, this.stream, this.stdout, this.stderr, this.stdin);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return ContainersCompatApi.this.containerAttachAsync(this.name, this.detachKeys, this.logs, this.stream, this.stdout, this.stderr, this.stdin, _callback);
        }
    }

    public class APIcontainerChangesLibpod_0Request {
        private final String name;
        private String parent;
        private String diffType;

        private APIcontainerChangesLibpod_0Request(String name) {
            this.name = name;
        }

        public APIcontainerChangesLibpod_0Request parent(String parent) {
            this.parent = parent;
            return this;
        }

        public APIcontainerChangesLibpod_0Request diffType(String diffType) {
            this.diffType = diffType;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ContainersCompatApi.this.containerChangesLibpod_0Call(this.name, this.parent, this.diffType, _callback);
        }

        public void execute() throws ApiException {
            ContainersCompatApi.this.containerChangesLibpod_0WithHttpInfo(this.name, this.parent, this.diffType);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return ContainersCompatApi.this.containerChangesLibpod_0WithHttpInfo(this.name, this.parent, this.diffType);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return ContainersCompatApi.this.containerChangesLibpod_0Async(this.name, this.parent, this.diffType, _callback);
        }
    }

    public class APIcontainerCreateRequest {
        private final CreateContainerConfig body;
        private String name;

        private APIcontainerCreateRequest(CreateContainerConfig body) {
            this.body = body;
        }

        public APIcontainerCreateRequest name(String name) {
            this.name = name;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ContainersCompatApi.this.containerCreateCall(this.body, this.name, _callback);
        }

        public ContainerCreateResponse execute() throws ApiException {
            ApiResponse<ContainerCreateResponse> localVarResp = ContainersCompatApi.this.containerCreateWithHttpInfo(this.body, this.name);
            return localVarResp.getData();
        }

        public ApiResponse<ContainerCreateResponse> executeWithHttpInfo() throws ApiException {
            return ContainersCompatApi.this.containerCreateWithHttpInfo(this.body, this.name);
        }

        public Call executeAsync(ApiCallback<ContainerCreateResponse> _callback) throws ApiException {
            return ContainersCompatApi.this.containerCreateAsync(this.body, this.name, _callback);
        }
    }

    public class APIcontainerDeleteRequest {
        private final String name;
        private Boolean force;
        private Boolean v;
        private Boolean link;

        private APIcontainerDeleteRequest(String name) {
            this.name = name;
        }

        public APIcontainerDeleteRequest force(Boolean force) {
            this.force = force;
            return this;
        }

        public APIcontainerDeleteRequest v(Boolean v) {
            this.v = v;
            return this;
        }

        public APIcontainerDeleteRequest link(Boolean link) {
            this.link = link;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ContainersCompatApi.this.containerDeleteCall(this.name, this.force, this.v, this.link, _callback);
        }

        public void execute() throws ApiException {
            ContainersCompatApi.this.containerDeleteWithHttpInfo(this.name, this.force, this.v, this.link);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return ContainersCompatApi.this.containerDeleteWithHttpInfo(this.name, this.force, this.v, this.link);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return ContainersCompatApi.this.containerDeleteAsync(this.name, this.force, this.v, this.link, _callback);
        }
    }

    public class APIcontainerExportRequest {
        private final String name;

        private APIcontainerExportRequest(String name) {
            this.name = name;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ContainersCompatApi.this.containerExportCall(this.name, _callback);
        }

        public void execute() throws ApiException {
            ContainersCompatApi.this.containerExportWithHttpInfo(this.name);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return ContainersCompatApi.this.containerExportWithHttpInfo(this.name);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return ContainersCompatApi.this.containerExportAsync(this.name, _callback);
        }
    }

    public class APIcontainerInspectRequest {
        private final String name;
        private Boolean size;

        private APIcontainerInspectRequest(String name) {
            this.name = name;
        }

        public APIcontainerInspectRequest size(Boolean size) {
            this.size = size;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ContainersCompatApi.this.containerInspectCall(this.name, this.size, _callback);
        }

        public ContainerJSON execute() throws ApiException {
            ApiResponse<ContainerJSON> localVarResp = ContainersCompatApi.this.containerInspectWithHttpInfo(this.name, this.size);
            return localVarResp.getData();
        }

        public ApiResponse<ContainerJSON> executeWithHttpInfo() throws ApiException {
            return ContainersCompatApi.this.containerInspectWithHttpInfo(this.name, this.size);
        }

        public Call executeAsync(ApiCallback<ContainerJSON> _callback) throws ApiException {
            return ContainersCompatApi.this.containerInspectAsync(this.name, this.size, _callback);
        }
    }

    public class APIcontainerKillRequest {
        private final String name;
        private Boolean all;
        private String signal;

        private APIcontainerKillRequest(String name) {
            this.name = name;
        }

        public APIcontainerKillRequest all(Boolean all) {
            this.all = all;
            return this;
        }

        public APIcontainerKillRequest signal(String signal) {
            this.signal = signal;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ContainersCompatApi.this.containerKillCall(this.name, this.all, this.signal, _callback);
        }

        public void execute() throws ApiException {
            ContainersCompatApi.this.containerKillWithHttpInfo(this.name, this.all, this.signal);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return ContainersCompatApi.this.containerKillWithHttpInfo(this.name, this.all, this.signal);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return ContainersCompatApi.this.containerKillAsync(this.name, this.all, this.signal, _callback);
        }
    }

    public class APIcontainerListRequest {
        private Boolean all;
        private Boolean external;
        private Integer limit;
        private Boolean size;
        private String filters;

        private APIcontainerListRequest() {
        }

        public APIcontainerListRequest all(Boolean all) {
            this.all = all;
            return this;
        }

        public APIcontainerListRequest external(Boolean external) {
            this.external = external;
            return this;
        }

        public APIcontainerListRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIcontainerListRequest size(Boolean size) {
            this.size = size;
            return this;
        }

        public APIcontainerListRequest filters(String filters) {
            this.filters = filters;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ContainersCompatApi.this.containerListCall(this.all, this.external, this.limit, this.size, this.filters, _callback);
        }

        public List<Container> execute() throws ApiException {
            ApiResponse<List<Container>> localVarResp = ContainersCompatApi.this.containerListWithHttpInfo(this.all, this.external, this.limit, this.size, this.filters);
            return localVarResp.getData();
        }

        public ApiResponse<List<Container>> executeWithHttpInfo() throws ApiException {
            return ContainersCompatApi.this.containerListWithHttpInfo(this.all, this.external, this.limit, this.size, this.filters);
        }

        public Call executeAsync(ApiCallback<List<Container>> _callback) throws ApiException {
            return ContainersCompatApi.this.containerListAsync(this.all, this.external, this.limit, this.size, this.filters, _callback);
        }
    }

    public class APIcontainerLogsRequest {
        private final String name;
        private Boolean follow;
        private Boolean stdout;
        private Boolean stderr;
        private String since;
        private String until;
        private Boolean timestamps;
        private String tail;

        private APIcontainerLogsRequest(String name) {
            this.name = name;
        }

        public APIcontainerLogsRequest follow(Boolean follow) {
            this.follow = follow;
            return this;
        }

        public APIcontainerLogsRequest stdout(Boolean stdout) {
            this.stdout = stdout;
            return this;
        }

        public APIcontainerLogsRequest stderr(Boolean stderr) {
            this.stderr = stderr;
            return this;
        }

        public APIcontainerLogsRequest since(String since) {
            this.since = since;
            return this;
        }

        public APIcontainerLogsRequest until(String until) {
            this.until = until;
            return this;
        }

        public APIcontainerLogsRequest timestamps(Boolean timestamps) {
            this.timestamps = timestamps;
            return this;
        }

        public APIcontainerLogsRequest tail(String tail) {
            this.tail = tail;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ContainersCompatApi.this.containerLogsCall(this.name, this.follow, this.stdout, this.stderr, this.since, this.until, this.timestamps, this.tail, _callback);
        }

        public void execute() throws ApiException {
            ContainersCompatApi.this.containerLogsWithHttpInfo(this.name, this.follow, this.stdout, this.stderr, this.since, this.until, this.timestamps, this.tail);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return ContainersCompatApi.this.containerLogsWithHttpInfo(this.name, this.follow, this.stdout, this.stderr, this.since, this.until, this.timestamps, this.tail);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return ContainersCompatApi.this.containerLogsAsync(this.name, this.follow, this.stdout, this.stderr, this.since, this.until, this.timestamps, this.tail, _callback);
        }
    }

    public class APIcontainerPauseRequest {
        private final String name;

        private APIcontainerPauseRequest(String name) {
            this.name = name;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ContainersCompatApi.this.containerPauseCall(this.name, _callback);
        }

        public void execute() throws ApiException {
            ContainersCompatApi.this.containerPauseWithHttpInfo(this.name);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return ContainersCompatApi.this.containerPauseWithHttpInfo(this.name);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return ContainersCompatApi.this.containerPauseAsync(this.name, _callback);
        }
    }

    public class APIcontainerPruneRequest {
        private String filters;

        private APIcontainerPruneRequest() {
        }

        public APIcontainerPruneRequest filters(String filters) {
            this.filters = filters;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ContainersCompatApi.this.containerPruneCall(this.filters, _callback);
        }

        public List<ContainersPruneReport> execute() throws ApiException {
            ApiResponse<List<ContainersPruneReport>> localVarResp = ContainersCompatApi.this.containerPruneWithHttpInfo(this.filters);
            return localVarResp.getData();
        }

        public ApiResponse<List<ContainersPruneReport>> executeWithHttpInfo() throws ApiException {
            return ContainersCompatApi.this.containerPruneWithHttpInfo(this.filters);
        }

        public Call executeAsync(ApiCallback<List<ContainersPruneReport>> _callback) throws ApiException {
            return ContainersCompatApi.this.containerPruneAsync(this.filters, _callback);
        }
    }

    public class APIcontainerRenameRequest {
        private final String name;
        private final String name2;

        private APIcontainerRenameRequest(String name, String name2) {
            this.name = name;
            this.name2 = name2;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ContainersCompatApi.this.containerRenameCall(this.name, this.name2, _callback);
        }

        public void execute() throws ApiException {
            ContainersCompatApi.this.containerRenameWithHttpInfo(this.name, this.name2);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return ContainersCompatApi.this.containerRenameWithHttpInfo(this.name, this.name2);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return ContainersCompatApi.this.containerRenameAsync(this.name, this.name2, _callback);
        }
    }

    public class APIcontainerResizeRequest {
        private final String name;
        private Integer h;
        private Integer w;
        private Boolean running;

        private APIcontainerResizeRequest(String name) {
            this.name = name;
        }

        public APIcontainerResizeRequest h(Integer h) {
            this.h = h;
            return this;
        }

        public APIcontainerResizeRequest w(Integer w) {
            this.w = w;
            return this;
        }

        public APIcontainerResizeRequest running(Boolean running) {
            this.running = running;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ContainersCompatApi.this.containerResizeCall(this.name, this.h, this.w, this.running, _callback);
        }

        public Object execute() throws ApiException {
            ApiResponse<Object> localVarResp = ContainersCompatApi.this.containerResizeWithHttpInfo(this.name, this.h, this.w, this.running);
            return localVarResp.getData();
        }

        public ApiResponse<Object> executeWithHttpInfo() throws ApiException {
            return ContainersCompatApi.this.containerResizeWithHttpInfo(this.name, this.h, this.w, this.running);
        }

        public Call executeAsync(ApiCallback<Object> _callback) throws ApiException {
            return ContainersCompatApi.this.containerResizeAsync(this.name, this.h, this.w, this.running, _callback);
        }
    }

    public class APIcontainerRestartRequest {
        private final String name;
        private Integer t;

        private APIcontainerRestartRequest(String name) {
            this.name = name;
        }

        public APIcontainerRestartRequest t(Integer t) {
            this.t = t;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ContainersCompatApi.this.containerRestartCall(this.name, this.t, _callback);
        }

        public void execute() throws ApiException {
            ContainersCompatApi.this.containerRestartWithHttpInfo(this.name, this.t);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return ContainersCompatApi.this.containerRestartWithHttpInfo(this.name, this.t);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return ContainersCompatApi.this.containerRestartAsync(this.name, this.t, _callback);
        }
    }

    public class APIcontainerStartRequest {
        private final String name;
        private String detachKeys;

        private APIcontainerStartRequest(String name) {
            this.name = name;
        }

        public APIcontainerStartRequest detachKeys(String detachKeys) {
            this.detachKeys = detachKeys;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ContainersCompatApi.this.containerStartCall(this.name, this.detachKeys, _callback);
        }

        public void execute() throws ApiException {
            ContainersCompatApi.this.containerStartWithHttpInfo(this.name, this.detachKeys);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return ContainersCompatApi.this.containerStartWithHttpInfo(this.name, this.detachKeys);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return ContainersCompatApi.this.containerStartAsync(this.name, this.detachKeys, _callback);
        }
    }

    public class APIcontainerStatsRequest {
        private final String name;
        private Boolean stream;
        private Boolean oneShot;

        private APIcontainerStatsRequest(String name) {
            this.name = name;
        }

        public APIcontainerStatsRequest stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        public APIcontainerStatsRequest oneShot(Boolean oneShot) {
            this.oneShot = oneShot;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ContainersCompatApi.this.containerStatsCall(this.name, this.stream, this.oneShot, _callback);
        }

        public Object execute() throws ApiException {
            ApiResponse<Object> localVarResp = ContainersCompatApi.this.containerStatsWithHttpInfo(this.name, this.stream, this.oneShot);
            return localVarResp.getData();
        }

        public ApiResponse<Object> executeWithHttpInfo() throws ApiException {
            return ContainersCompatApi.this.containerStatsWithHttpInfo(this.name, this.stream, this.oneShot);
        }

        public Call executeAsync(ApiCallback<Object> _callback) throws ApiException {
            return ContainersCompatApi.this.containerStatsAsync(this.name, this.stream, this.oneShot, _callback);
        }
    }

    public class APIcontainerStopRequest {
        private final String name;
        private Integer t;

        private APIcontainerStopRequest(String name) {
            this.name = name;
        }

        public APIcontainerStopRequest t(Integer t) {
            this.t = t;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ContainersCompatApi.this.containerStopCall(this.name, this.t, _callback);
        }

        public void execute() throws ApiException {
            ContainersCompatApi.this.containerStopWithHttpInfo(this.name, this.t);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return ContainersCompatApi.this.containerStopWithHttpInfo(this.name, this.t);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return ContainersCompatApi.this.containerStopAsync(this.name, this.t, _callback);
        }
    }

    public class APIcontainerTopRequest {
        private final String name;
        private String psArgs;

        private APIcontainerTopRequest(String name) {
            this.name = name;
        }

        public APIcontainerTopRequest psArgs(String psArgs) {
            this.psArgs = psArgs;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ContainersCompatApi.this.containerTopCall(this.name, this.psArgs, _callback);
        }

        public ContainerTopOKBody execute() throws ApiException {
            ApiResponse<ContainerTopOKBody> localVarResp = ContainersCompatApi.this.containerTopWithHttpInfo(this.name, this.psArgs);
            return localVarResp.getData();
        }

        public ApiResponse<ContainerTopOKBody> executeWithHttpInfo() throws ApiException {
            return ContainersCompatApi.this.containerTopWithHttpInfo(this.name, this.psArgs);
        }

        public Call executeAsync(ApiCallback<ContainerTopOKBody> _callback) throws ApiException {
            return ContainersCompatApi.this.containerTopAsync(this.name, this.psArgs, _callback);
        }
    }

    public class APIcontainerUnpauseRequest {
        private final String name;

        private APIcontainerUnpauseRequest(String name) {
            this.name = name;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ContainersCompatApi.this.containerUnpauseCall(this.name, _callback);
        }

        public void execute() throws ApiException {
            ContainersCompatApi.this.containerUnpauseWithHttpInfo(this.name);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return ContainersCompatApi.this.containerUnpauseWithHttpInfo(this.name);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return ContainersCompatApi.this.containerUnpauseAsync(this.name, _callback);
        }
    }

    public class APIcontainerUpdateRequest {
        private final String name;
        private UpdateConfig resources;

        private APIcontainerUpdateRequest(String name) {
            this.name = name;
        }

        public APIcontainerUpdateRequest resources(UpdateConfig resources) {
            this.resources = resources;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ContainersCompatApi.this.containerUpdateCall(this.name, this.resources, _callback);
        }

        public void execute() throws ApiException {
            ContainersCompatApi.this.containerUpdateWithHttpInfo(this.name, this.resources);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return ContainersCompatApi.this.containerUpdateWithHttpInfo(this.name, this.resources);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return ContainersCompatApi.this.containerUpdateAsync(this.name, this.resources, _callback);
        }
    }

    public class APIcontainerWaitRequest {
        private final String name;
        private String condition;
        private String interval;

        private APIcontainerWaitRequest(String name) {
            this.name = name;
        }

        public APIcontainerWaitRequest condition(String condition) {
            this.condition = condition;
            return this;
        }

        public APIcontainerWaitRequest interval(String interval) {
            this.interval = interval;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ContainersCompatApi.this.containerWaitCall(this.name, this.condition, this.interval, _callback);
        }

        public ContainerWait200Response execute() throws ApiException {
            ApiResponse<ContainerWait200Response> localVarResp = ContainersCompatApi.this.containerWaitWithHttpInfo(this.name, this.condition, this.interval);
            return localVarResp.getData();
        }

        public ApiResponse<ContainerWait200Response> executeWithHttpInfo() throws ApiException {
            return ContainersCompatApi.this.containerWaitWithHttpInfo(this.name, this.condition, this.interval);
        }

        public Call executeAsync(ApiCallback<ContainerWait200Response> _callback) throws ApiException {
            return ContainersCompatApi.this.containerWaitAsync(this.name, this.condition, this.interval, _callback);
        }
    }

    public class APIimageCommitRequest {
        private String container;
        private String repo;
        private String tag;
        private String comment;
        private String author;
        private Boolean pause;
        private String changes;
        private Boolean squash;

        private APIimageCommitRequest() {
        }

        public APIimageCommitRequest container(String container) {
            this.container = container;
            return this;
        }

        public APIimageCommitRequest repo(String repo) {
            this.repo = repo;
            return this;
        }

        public APIimageCommitRequest tag(String tag) {
            this.tag = tag;
            return this;
        }

        public APIimageCommitRequest comment(String comment) {
            this.comment = comment;
            return this;
        }

        public APIimageCommitRequest author(String author) {
            this.author = author;
            return this;
        }

        public APIimageCommitRequest pause(Boolean pause) {
            this.pause = pause;
            return this;
        }

        public APIimageCommitRequest changes(String changes) {
            this.changes = changes;
            return this;
        }

        public APIimageCommitRequest squash(Boolean squash) {
            this.squash = squash;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ContainersCompatApi.this.imageCommitCall(this.container, this.repo, this.tag, this.comment, this.author, this.pause, this.changes, this.squash, _callback);
        }

        public void execute() throws ApiException {
            ContainersCompatApi.this.imageCommitWithHttpInfo(this.container, this.repo, this.tag, this.comment, this.author, this.pause, this.changes, this.squash);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return ContainersCompatApi.this.imageCommitWithHttpInfo(this.container, this.repo, this.tag, this.comment, this.author, this.pause, this.changes, this.squash);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return ContainersCompatApi.this.imageCommitAsync(this.container, this.repo, this.tag, this.comment, this.author, this.pause, this.changes, this.squash, _callback);
        }
    }

    public class APIputContainerArchiveRequest {
        private final String name;
        private final String path;
        private String noOverwriteDirNonDir;
        private String copyUIDGID;
        private String request;

        private APIputContainerArchiveRequest(String name, String path) {
            this.name = name;
            this.path = path;
        }

        public APIputContainerArchiveRequest noOverwriteDirNonDir(String noOverwriteDirNonDir) {
            this.noOverwriteDirNonDir = noOverwriteDirNonDir;
            return this;
        }

        public APIputContainerArchiveRequest copyUIDGID(String copyUIDGID) {
            this.copyUIDGID = copyUIDGID;
            return this;
        }

        public APIputContainerArchiveRequest request(String request) {
            this.request = request;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ContainersCompatApi.this.putContainerArchiveCall(this.name, this.path, this.noOverwriteDirNonDir, this.copyUIDGID, this.request, _callback);
        }

        public void execute() throws ApiException {
            ContainersCompatApi.this.putContainerArchiveWithHttpInfo(this.name, this.path, this.noOverwriteDirNonDir, this.copyUIDGID, this.request);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return ContainersCompatApi.this.putContainerArchiveWithHttpInfo(this.name, this.path, this.noOverwriteDirNonDir, this.copyUIDGID, this.request);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return ContainersCompatApi.this.putContainerArchiveAsync(this.name, this.path, this.noOverwriteDirNonDir, this.copyUIDGID, this.request, _callback);
        }
    }
}

