/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.api;

import io.github.pod4dev.libpodj.ApiCallback;
import io.github.pod4dev.libpodj.ApiClient;
import io.github.pod4dev.libpodj.ApiException;
import io.github.pod4dev.libpodj.ApiResponse;
import io.github.pod4dev.libpodj.Configuration;
import io.github.pod4dev.libpodj.Pair;
import io.github.pod4dev.libpodj.model.ContainerExecRequest;
import io.github.pod4dev.libpodj.model.ExecStartLibpodRequest;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ExecApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ExecApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ExecApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call containerExecLibpodCall(String name, ContainerExecRequest control, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ContainerExecRequest localVarPostBody = control;
        String localVarPath = "/libpod/containers/{name}/exec".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/x-tar"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call containerExecLibpodValidateBeforeCall(String name, ContainerExecRequest control, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling containerExecLibpod(Async)");
        }
        return this.containerExecLibpodCall(name, control, _callback);
    }

    private ApiResponse<Void> containerExecLibpodWithHttpInfo(@NotNull String name, ContainerExecRequest control) throws ApiException {
        Call localVarCall = this.containerExecLibpodValidateBeforeCall(name, control, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call containerExecLibpodAsync(String name, ContainerExecRequest control, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.containerExecLibpodValidateBeforeCall(name, control, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIcontainerExecLibpodRequest containerExecLibpod(String name) {
        return new APIcontainerExecLibpodRequest(name);
    }

    private Call execInspectLibpodCall(String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/exec/{id}/json".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call execInspectLibpodValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling execInspectLibpod(Async)");
        }
        return this.execInspectLibpodCall(id, _callback);
    }

    private ApiResponse<Void> execInspectLibpodWithHttpInfo(@NotNull String id) throws ApiException {
        Call localVarCall = this.execInspectLibpodValidateBeforeCall(id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call execInspectLibpodAsync(String id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.execInspectLibpodValidateBeforeCall(id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIexecInspectLibpodRequest execInspectLibpod(String id) {
        return new APIexecInspectLibpodRequest(id);
    }

    private Call execResizeLibpodCall(String id, Integer h, Integer w, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/exec/{id}/resize".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (h != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("h", h));
        }
        if (w != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("w", w));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call execResizeLibpodValidateBeforeCall(String id, Integer h, Integer w, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling execResizeLibpod(Async)");
        }
        return this.execResizeLibpodCall(id, h, w, _callback);
    }

    private ApiResponse<Void> execResizeLibpodWithHttpInfo(@NotNull String id, Integer h, Integer w) throws ApiException {
        Call localVarCall = this.execResizeLibpodValidateBeforeCall(id, h, w, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call execResizeLibpodAsync(String id, Integer h, Integer w, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.execResizeLibpodValidateBeforeCall(id, h, w, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIexecResizeLibpodRequest execResizeLibpod(String id) {
        return new APIexecResizeLibpodRequest(id);
    }

    private Call execStartLibpodCall(String id, ExecStartLibpodRequest control, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ExecStartLibpodRequest localVarPostBody = control;
        String localVarPath = "/libpod/exec/{id}/start".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/x-tar"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call execStartLibpodValidateBeforeCall(String id, ExecStartLibpodRequest control, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling execStartLibpod(Async)");
        }
        return this.execStartLibpodCall(id, control, _callback);
    }

    private ApiResponse<Void> execStartLibpodWithHttpInfo(@NotNull String id, ExecStartLibpodRequest control) throws ApiException {
        Call localVarCall = this.execStartLibpodValidateBeforeCall(id, control, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call execStartLibpodAsync(String id, ExecStartLibpodRequest control, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.execStartLibpodValidateBeforeCall(id, control, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIexecStartLibpodRequest execStartLibpod(String id) {
        return new APIexecStartLibpodRequest(id);
    }

    public class APIcontainerExecLibpodRequest {
        private final String name;
        private ContainerExecRequest control;

        private APIcontainerExecLibpodRequest(String name) {
            this.name = name;
        }

        public APIcontainerExecLibpodRequest control(ContainerExecRequest control) {
            this.control = control;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ExecApi.this.containerExecLibpodCall(this.name, this.control, _callback);
        }

        public void execute() throws ApiException {
            ExecApi.this.containerExecLibpodWithHttpInfo(this.name, this.control);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return ExecApi.this.containerExecLibpodWithHttpInfo(this.name, this.control);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return ExecApi.this.containerExecLibpodAsync(this.name, this.control, _callback);
        }
    }

    public class APIexecInspectLibpodRequest {
        private final String id;

        private APIexecInspectLibpodRequest(String id) {
            this.id = id;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ExecApi.this.execInspectLibpodCall(this.id, _callback);
        }

        public void execute() throws ApiException {
            ExecApi.this.execInspectLibpodWithHttpInfo(this.id);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return ExecApi.this.execInspectLibpodWithHttpInfo(this.id);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return ExecApi.this.execInspectLibpodAsync(this.id, _callback);
        }
    }

    public class APIexecResizeLibpodRequest {
        private final String id;
        private Integer h;
        private Integer w;

        private APIexecResizeLibpodRequest(String id) {
            this.id = id;
        }

        public APIexecResizeLibpodRequest h(Integer h) {
            this.h = h;
            return this;
        }

        public APIexecResizeLibpodRequest w(Integer w) {
            this.w = w;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ExecApi.this.execResizeLibpodCall(this.id, this.h, this.w, _callback);
        }

        public void execute() throws ApiException {
            ExecApi.this.execResizeLibpodWithHttpInfo(this.id, this.h, this.w);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return ExecApi.this.execResizeLibpodWithHttpInfo(this.id, this.h, this.w);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return ExecApi.this.execResizeLibpodAsync(this.id, this.h, this.w, _callback);
        }
    }

    public class APIexecStartLibpodRequest {
        private final String id;
        private ExecStartLibpodRequest control;

        private APIexecStartLibpodRequest(String id) {
            this.id = id;
        }

        public APIexecStartLibpodRequest control(ExecStartLibpodRequest control) {
            this.control = control;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return ExecApi.this.execStartLibpodCall(this.id, this.control, _callback);
        }

        public void execute() throws ApiException {
            ExecApi.this.execStartLibpodWithHttpInfo(this.id, this.control);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return ExecApi.this.execStartLibpodWithHttpInfo(this.id, this.control);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return ExecApi.this.execStartLibpodAsync(this.id, this.control, _callback);
        }
    }
}

