/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Platform
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ARCHITECTURE = "architecture";
    @SerializedName(value="architecture")
    private String architecture;
    public static final String SERIALIZED_NAME_OS = "os";
    @SerializedName(value="os")
    private String os;
    public static final String SERIALIZED_NAME_OS_FEATURES = "os.features";
    @SerializedName(value="os.features")
    private List<String> osFeatures = new ArrayList<String>();
    public static final String SERIALIZED_NAME_OS_VERSION = "os.version";
    @SerializedName(value="os.version")
    private String osVersion;
    public static final String SERIALIZED_NAME_VARIANT = "variant";
    @SerializedName(value="variant")
    private String variant;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Platform architecture(String architecture) {
        this.architecture = architecture;
        return this;
    }

    @Nullable
    public String getArchitecture() {
        return this.architecture;
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    public Platform os(String os) {
        this.os = os;
        return this;
    }

    @Nullable
    public String getOs() {
        return this.os;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public Platform osFeatures(List<String> osFeatures) {
        this.osFeatures = osFeatures;
        return this;
    }

    public Platform addOsFeaturesItem(String osFeaturesItem) {
        if (this.osFeatures == null) {
            this.osFeatures = new ArrayList<String>();
        }
        this.osFeatures.add(osFeaturesItem);
        return this;
    }

    @Nullable
    public List<String> getOsFeatures() {
        return this.osFeatures;
    }

    public void setOsFeatures(List<String> osFeatures) {
        this.osFeatures = osFeatures;
    }

    public Platform osVersion(String osVersion) {
        this.osVersion = osVersion;
        return this;
    }

    @Nullable
    public String getOsVersion() {
        return this.osVersion;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public Platform variant(String variant) {
        this.variant = variant;
        return this;
    }

    @Nullable
    public String getVariant() {
        return this.variant;
    }

    public void setVariant(String variant) {
        this.variant = variant;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Platform platform = (Platform)o;
        return Objects.equals(this.architecture, platform.architecture) && Objects.equals(this.os, platform.os) && Objects.equals(this.osFeatures, platform.osFeatures) && Objects.equals(this.osVersion, platform.osVersion) && Objects.equals(this.variant, platform.variant);
    }

    public int hashCode() {
        return Objects.hash(this.architecture, this.os, this.osFeatures, this.osVersion, this.variant);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Platform {\n");
        sb.append("    architecture: ").append(this.toIndentedString(this.architecture)).append("\n");
        sb.append("    os: ").append(this.toIndentedString(this.os)).append("\n");
        sb.append("    osFeatures: ").append(this.toIndentedString(this.osFeatures)).append("\n");
        sb.append("    osVersion: ").append(this.toIndentedString(this.osVersion)).append("\n");
        sb.append("    variant: ").append(this.toIndentedString(this.variant)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in Platform is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Platform` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ARCHITECTURE) != null && !jsonObj.get(SERIALIZED_NAME_ARCHITECTURE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ARCHITECTURE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `architecture` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ARCHITECTURE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OS) != null && !jsonObj.get(SERIALIZED_NAME_OS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_OS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `os` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OS_FEATURES) != null && !jsonObj.get(SERIALIZED_NAME_OS_FEATURES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_OS_FEATURES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `os.features` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OS_FEATURES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OS_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_OS_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_OS_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `os.version` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OS_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VARIANT) != null && !jsonObj.get(SERIALIZED_NAME_VARIANT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VARIANT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `variant` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VARIANT).toString()));
        }
    }

    public static Platform fromJson(String jsonString) throws IOException {
        return (Platform)JSON.getGson().fromJson(jsonString, Platform.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ARCHITECTURE);
        openapiFields.add(SERIALIZED_NAME_OS);
        openapiFields.add(SERIALIZED_NAME_OS_FEATURES);
        openapiFields.add(SERIALIZED_NAME_OS_VERSION);
        openapiFields.add(SERIALIZED_NAME_VARIANT);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Platform.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Platform.class));
            return new TypeAdapter<Platform>(){

                public void write(JsonWriter out, Platform value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Platform read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    Platform.validateJsonElement(jsonElement);
                    return (Platform)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

