/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.EndpointSettings;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.Valid;

@ApiModel(description="ConnectOptions represents the data to be used to connect a container to the network.")
public class ConnectOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_CONTAINER = "Container";
    @SerializedName(value="Container")
    private String container;
    public static final String SERIALIZED_NAME_ENDPOINT_CONFIG = "EndpointConfig";
    @SerializedName(value="EndpointConfig")
    private EndpointSettings endpointConfig;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ConnectOptions container(String container) {
        this.container = container;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getContainer() {
        return this.container;
    }

    public void setContainer(String container) {
        this.container = container;
    }

    public ConnectOptions endpointConfig(EndpointSettings endpointConfig) {
        this.endpointConfig = endpointConfig;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public EndpointSettings getEndpointConfig() {
        return this.endpointConfig;
    }

    public void setEndpointConfig(EndpointSettings endpointConfig) {
        this.endpointConfig = endpointConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectOptions connectOptions = (ConnectOptions)o;
        return Objects.equals(this.container, connectOptions.container) && Objects.equals(this.endpointConfig, connectOptions.endpointConfig);
    }

    public int hashCode() {
        return Objects.hash(this.container, this.endpointConfig);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConnectOptions {\n");
        sb.append("    container: ").append(this.toIndentedString(this.container)).append("\n");
        sb.append("    endpointConfig: ").append(this.toIndentedString(this.endpointConfig)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ConnectOptions is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ConnectOptions` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONTAINER) != null && !jsonObj.get(SERIALIZED_NAME_CONTAINER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CONTAINER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Container` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTAINER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENDPOINT_CONFIG) != null && !jsonObj.get(SERIALIZED_NAME_ENDPOINT_CONFIG).isJsonNull()) {
            EndpointSettings.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ENDPOINT_CONFIG));
        }
    }

    public static ConnectOptions fromJson(String jsonString) throws IOException {
        return (ConnectOptions)JSON.getGson().fromJson(jsonString, ConnectOptions.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CONTAINER);
        openapiFields.add(SERIALIZED_NAME_ENDPOINT_CONFIG);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ConnectOptions.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ConnectOptions.class));
            return new TypeAdapter<ConnectOptions>(){

                public void write(JsonWriter out, ConnectOptions value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ConnectOptions read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ConnectOptions.validateJsonObject(jsonObj);
                    return (ConnectOptions)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

