/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.Address;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.Valid;

@ApiModel(description="InspectAdditionalNetwork holds information about non-default networks the container has been connected to. As with InspectNetworkSettings, many fields are unused and maintained only for compatibility with Docker.")
public class InspectAdditionalNetwork
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ADDITIONAL_M_A_C_ADDRESSES = "AdditionalMACAddresses";
    @SerializedName(value="AdditionalMACAddresses")
    private List<String> additionalMACAddresses = null;
    public static final String SERIALIZED_NAME_ALIASES = "Aliases";
    @SerializedName(value="Aliases")
    private List<String> aliases = null;
    public static final String SERIALIZED_NAME_DRIVER_OPTS = "DriverOpts";
    @SerializedName(value="DriverOpts")
    private Map<String, String> driverOpts = null;
    public static final String SERIALIZED_NAME_ENDPOINT_I_D = "EndpointID";
    @SerializedName(value="EndpointID")
    private String endpointID;
    public static final String SERIALIZED_NAME_GATEWAY = "Gateway";
    @SerializedName(value="Gateway")
    private String gateway;
    public static final String SERIALIZED_NAME_GLOBAL_I_PV6_ADDRESS = "GlobalIPv6Address";
    @SerializedName(value="GlobalIPv6Address")
    private String globalIPv6Address;
    public static final String SERIALIZED_NAME_GLOBAL_I_PV6_PREFIX_LEN = "GlobalIPv6PrefixLen";
    @SerializedName(value="GlobalIPv6PrefixLen")
    private Long globalIPv6PrefixLen;
    public static final String SERIALIZED_NAME_IP_A_M_CONFIG = "IPAMConfig";
    @SerializedName(value="IPAMConfig")
    private Map<String, String> ipAMConfig = null;
    public static final String SERIALIZED_NAME_IP_ADDRESS = "IPAddress";
    @SerializedName(value="IPAddress")
    private String ipAddress;
    public static final String SERIALIZED_NAME_IP_PREFIX_LEN = "IPPrefixLen";
    @SerializedName(value="IPPrefixLen")
    private Long ipPrefixLen;
    public static final String SERIALIZED_NAME_IPV6_GATEWAY = "IPv6Gateway";
    @SerializedName(value="IPv6Gateway")
    private String ipv6Gateway;
    public static final String SERIALIZED_NAME_LINKS = "Links";
    @SerializedName(value="Links")
    private List<String> links = null;
    public static final String SERIALIZED_NAME_MAC_ADDRESS = "MacAddress";
    @SerializedName(value="MacAddress")
    private String macAddress;
    public static final String SERIALIZED_NAME_NETWORK_I_D = "NetworkID";
    @SerializedName(value="NetworkID")
    private String networkID;
    public static final String SERIALIZED_NAME_SECONDARY_I_P_ADDRESSES = "SecondaryIPAddresses";
    @SerializedName(value="SecondaryIPAddresses")
    private List<Address> secondaryIPAddresses = null;
    public static final String SERIALIZED_NAME_SECONDARY_I_PV6_ADDRESSES = "SecondaryIPv6Addresses";
    @SerializedName(value="SecondaryIPv6Addresses")
    private List<Address> secondaryIPv6Addresses = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public InspectAdditionalNetwork additionalMACAddresses(List<String> additionalMACAddresses) {
        this.additionalMACAddresses = additionalMACAddresses;
        return this;
    }

    public InspectAdditionalNetwork addAdditionalMACAddressesItem(String additionalMACAddressesItem) {
        if (this.additionalMACAddresses == null) {
            this.additionalMACAddresses = new ArrayList<String>();
        }
        this.additionalMACAddresses.add(additionalMACAddressesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="AdditionalMacAddresses is a set of additional MAC Addresses beyond the first. CNI may configure more than one interface for a single network, which can cause this.")
    public List<String> getAdditionalMACAddresses() {
        return this.additionalMACAddresses;
    }

    public void setAdditionalMACAddresses(List<String> additionalMACAddresses) {
        this.additionalMACAddresses = additionalMACAddresses;
    }

    public InspectAdditionalNetwork aliases(List<String> aliases) {
        this.aliases = aliases;
        return this;
    }

    public InspectAdditionalNetwork addAliasesItem(String aliasesItem) {
        if (this.aliases == null) {
            this.aliases = new ArrayList<String>();
        }
        this.aliases.add(aliasesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Aliases are any network aliases the container has in this network.")
    public List<String> getAliases() {
        return this.aliases;
    }

    public void setAliases(List<String> aliases) {
        this.aliases = aliases;
    }

    public InspectAdditionalNetwork driverOpts(Map<String, String> driverOpts) {
        this.driverOpts = driverOpts;
        return this;
    }

    public InspectAdditionalNetwork putDriverOptsItem(String key, String driverOptsItem) {
        if (this.driverOpts == null) {
            this.driverOpts = new HashMap<String, String>();
        }
        this.driverOpts.put(key, driverOptsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="DriverOpts is presently unused and maintained exclusively for compatibility.")
    public Map<String, String> getDriverOpts() {
        return this.driverOpts;
    }

    public void setDriverOpts(Map<String, String> driverOpts) {
        this.driverOpts = driverOpts;
    }

    public InspectAdditionalNetwork endpointID(String endpointID) {
        this.endpointID = endpointID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="EndpointID is unused, maintained exclusively for compatibility.")
    public String getEndpointID() {
        return this.endpointID;
    }

    public void setEndpointID(String endpointID) {
        this.endpointID = endpointID;
    }

    public InspectAdditionalNetwork gateway(String gateway) {
        this.gateway = gateway;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Gateway is the IP address of the gateway this network will use.")
    public String getGateway() {
        return this.gateway;
    }

    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    public InspectAdditionalNetwork globalIPv6Address(String globalIPv6Address) {
        this.globalIPv6Address = globalIPv6Address;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="GlobalIPv6Address is the global-scope IPv6 Address for this network.")
    public String getGlobalIPv6Address() {
        return this.globalIPv6Address;
    }

    public void setGlobalIPv6Address(String globalIPv6Address) {
        this.globalIPv6Address = globalIPv6Address;
    }

    public InspectAdditionalNetwork globalIPv6PrefixLen(Long globalIPv6PrefixLen) {
        this.globalIPv6PrefixLen = globalIPv6PrefixLen;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="GlobalIPv6PrefixLen is the length of the subnet mask of this network.")
    public Long getGlobalIPv6PrefixLen() {
        return this.globalIPv6PrefixLen;
    }

    public void setGlobalIPv6PrefixLen(Long globalIPv6PrefixLen) {
        this.globalIPv6PrefixLen = globalIPv6PrefixLen;
    }

    public InspectAdditionalNetwork ipAMConfig(Map<String, String> ipAMConfig) {
        this.ipAMConfig = ipAMConfig;
        return this;
    }

    public InspectAdditionalNetwork putIpAMConfigItem(String key, String ipAMConfigItem) {
        if (this.ipAMConfig == null) {
            this.ipAMConfig = new HashMap<String, String>();
        }
        this.ipAMConfig.put(key, ipAMConfigItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IPAMConfig is presently unused and maintained exclusively for compatibility.")
    public Map<String, String> getIpAMConfig() {
        return this.ipAMConfig;
    }

    public void setIpAMConfig(Map<String, String> ipAMConfig) {
        this.ipAMConfig = ipAMConfig;
    }

    public InspectAdditionalNetwork ipAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IPAddress is the IP address for this network.")
    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public InspectAdditionalNetwork ipPrefixLen(Long ipPrefixLen) {
        this.ipPrefixLen = ipPrefixLen;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IPPrefixLen is the length of the subnet mask of this network.")
    public Long getIpPrefixLen() {
        return this.ipPrefixLen;
    }

    public void setIpPrefixLen(Long ipPrefixLen) {
        this.ipPrefixLen = ipPrefixLen;
    }

    public InspectAdditionalNetwork ipv6Gateway(String ipv6Gateway) {
        this.ipv6Gateway = ipv6Gateway;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IPv6Gateway is the IPv6 gateway this network will use.")
    public String getIpv6Gateway() {
        return this.ipv6Gateway;
    }

    public void setIpv6Gateway(String ipv6Gateway) {
        this.ipv6Gateway = ipv6Gateway;
    }

    public InspectAdditionalNetwork links(List<String> links) {
        this.links = links;
        return this;
    }

    public InspectAdditionalNetwork addLinksItem(String linksItem) {
        if (this.links == null) {
            this.links = new ArrayList<String>();
        }
        this.links.add(linksItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Links is presently unused and maintained exclusively for compatibility.")
    public List<String> getLinks() {
        return this.links;
    }

    public void setLinks(List<String> links) {
        this.links = links;
    }

    public InspectAdditionalNetwork macAddress(String macAddress) {
        this.macAddress = macAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="MacAddress is the MAC address for the interface in this network.")
    public String getMacAddress() {
        return this.macAddress;
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public InspectAdditionalNetwork networkID(String networkID) {
        this.networkID = networkID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the network we're connecting to.")
    public String getNetworkID() {
        return this.networkID;
    }

    public void setNetworkID(String networkID) {
        this.networkID = networkID;
    }

    public InspectAdditionalNetwork secondaryIPAddresses(List<Address> secondaryIPAddresses) {
        this.secondaryIPAddresses = secondaryIPAddresses;
        return this;
    }

    public InspectAdditionalNetwork addSecondaryIPAddressesItem(Address secondaryIPAddressesItem) {
        if (this.secondaryIPAddresses == null) {
            this.secondaryIPAddresses = new ArrayList<Address>();
        }
        this.secondaryIPAddresses.add(secondaryIPAddressesItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="SecondaryIPAddresses is a list of extra IP Addresses that the container has been assigned in this network.")
    public List<Address> getSecondaryIPAddresses() {
        return this.secondaryIPAddresses;
    }

    public void setSecondaryIPAddresses(List<Address> secondaryIPAddresses) {
        this.secondaryIPAddresses = secondaryIPAddresses;
    }

    public InspectAdditionalNetwork secondaryIPv6Addresses(List<Address> secondaryIPv6Addresses) {
        this.secondaryIPv6Addresses = secondaryIPv6Addresses;
        return this;
    }

    public InspectAdditionalNetwork addSecondaryIPv6AddressesItem(Address secondaryIPv6AddressesItem) {
        if (this.secondaryIPv6Addresses == null) {
            this.secondaryIPv6Addresses = new ArrayList<Address>();
        }
        this.secondaryIPv6Addresses.add(secondaryIPv6AddressesItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="SecondaryIPv6Addresses is a list of extra IPv6 Addresses that the container has been assigned in this network.")
    public List<Address> getSecondaryIPv6Addresses() {
        return this.secondaryIPv6Addresses;
    }

    public void setSecondaryIPv6Addresses(List<Address> secondaryIPv6Addresses) {
        this.secondaryIPv6Addresses = secondaryIPv6Addresses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InspectAdditionalNetwork inspectAdditionalNetwork = (InspectAdditionalNetwork)o;
        return Objects.equals(this.additionalMACAddresses, inspectAdditionalNetwork.additionalMACAddresses) && Objects.equals(this.aliases, inspectAdditionalNetwork.aliases) && Objects.equals(this.driverOpts, inspectAdditionalNetwork.driverOpts) && Objects.equals(this.endpointID, inspectAdditionalNetwork.endpointID) && Objects.equals(this.gateway, inspectAdditionalNetwork.gateway) && Objects.equals(this.globalIPv6Address, inspectAdditionalNetwork.globalIPv6Address) && Objects.equals(this.globalIPv6PrefixLen, inspectAdditionalNetwork.globalIPv6PrefixLen) && Objects.equals(this.ipAMConfig, inspectAdditionalNetwork.ipAMConfig) && Objects.equals(this.ipAddress, inspectAdditionalNetwork.ipAddress) && Objects.equals(this.ipPrefixLen, inspectAdditionalNetwork.ipPrefixLen) && Objects.equals(this.ipv6Gateway, inspectAdditionalNetwork.ipv6Gateway) && Objects.equals(this.links, inspectAdditionalNetwork.links) && Objects.equals(this.macAddress, inspectAdditionalNetwork.macAddress) && Objects.equals(this.networkID, inspectAdditionalNetwork.networkID) && Objects.equals(this.secondaryIPAddresses, inspectAdditionalNetwork.secondaryIPAddresses) && Objects.equals(this.secondaryIPv6Addresses, inspectAdditionalNetwork.secondaryIPv6Addresses);
    }

    public int hashCode() {
        return Objects.hash(this.additionalMACAddresses, this.aliases, this.driverOpts, this.endpointID, this.gateway, this.globalIPv6Address, this.globalIPv6PrefixLen, this.ipAMConfig, this.ipAddress, this.ipPrefixLen, this.ipv6Gateway, this.links, this.macAddress, this.networkID, this.secondaryIPAddresses, this.secondaryIPv6Addresses);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InspectAdditionalNetwork {\n");
        sb.append("    additionalMACAddresses: ").append(this.toIndentedString(this.additionalMACAddresses)).append("\n");
        sb.append("    aliases: ").append(this.toIndentedString(this.aliases)).append("\n");
        sb.append("    driverOpts: ").append(this.toIndentedString(this.driverOpts)).append("\n");
        sb.append("    endpointID: ").append(this.toIndentedString(this.endpointID)).append("\n");
        sb.append("    gateway: ").append(this.toIndentedString(this.gateway)).append("\n");
        sb.append("    globalIPv6Address: ").append(this.toIndentedString(this.globalIPv6Address)).append("\n");
        sb.append("    globalIPv6PrefixLen: ").append(this.toIndentedString(this.globalIPv6PrefixLen)).append("\n");
        sb.append("    ipAMConfig: ").append(this.toIndentedString(this.ipAMConfig)).append("\n");
        sb.append("    ipAddress: ").append(this.toIndentedString(this.ipAddress)).append("\n");
        sb.append("    ipPrefixLen: ").append(this.toIndentedString(this.ipPrefixLen)).append("\n");
        sb.append("    ipv6Gateway: ").append(this.toIndentedString(this.ipv6Gateway)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    macAddress: ").append(this.toIndentedString(this.macAddress)).append("\n");
        sb.append("    networkID: ").append(this.toIndentedString(this.networkID)).append("\n");
        sb.append("    secondaryIPAddresses: ").append(this.toIndentedString(this.secondaryIPAddresses)).append("\n");
        sb.append("    secondaryIPv6Addresses: ").append(this.toIndentedString(this.secondaryIPv6Addresses)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraysecondaryIPv6Addresses;
        JsonArray jsonArraysecondaryIPAddresses;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in InspectAdditionalNetwork is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `InspectAdditionalNetwork` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ADDITIONAL_M_A_C_ADDRESSES) != null && !jsonObj.get(SERIALIZED_NAME_ADDITIONAL_M_A_C_ADDRESSES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ADDITIONAL_M_A_C_ADDRESSES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `AdditionalMACAddresses` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ADDITIONAL_M_A_C_ADDRESSES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ALIASES) != null && !jsonObj.get(SERIALIZED_NAME_ALIASES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ALIASES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `Aliases` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ALIASES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENDPOINT_I_D) != null && !jsonObj.get(SERIALIZED_NAME_ENDPOINT_I_D).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ENDPOINT_I_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `EndpointID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENDPOINT_I_D).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_GATEWAY) != null && !jsonObj.get(SERIALIZED_NAME_GATEWAY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_GATEWAY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Gateway` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GATEWAY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_GLOBAL_I_PV6_ADDRESS) != null && !jsonObj.get(SERIALIZED_NAME_GLOBAL_I_PV6_ADDRESS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_GLOBAL_I_PV6_ADDRESS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `GlobalIPv6Address` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GLOBAL_I_PV6_ADDRESS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IP_ADDRESS) != null && !jsonObj.get(SERIALIZED_NAME_IP_ADDRESS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_IP_ADDRESS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `IPAddress` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IP_ADDRESS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IPV6_GATEWAY) != null && !jsonObj.get(SERIALIZED_NAME_IPV6_GATEWAY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_IPV6_GATEWAY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `IPv6Gateway` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IPV6_GATEWAY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LINKS) != null && !jsonObj.get(SERIALIZED_NAME_LINKS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LINKS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `Links` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LINKS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MAC_ADDRESS) != null && !jsonObj.get(SERIALIZED_NAME_MAC_ADDRESS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MAC_ADDRESS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `MacAddress` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MAC_ADDRESS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NETWORK_I_D) != null && !jsonObj.get(SERIALIZED_NAME_NETWORK_I_D).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NETWORK_I_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `NetworkID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NETWORK_I_D).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SECONDARY_I_P_ADDRESSES) != null && !jsonObj.get(SERIALIZED_NAME_SECONDARY_I_P_ADDRESSES).isJsonNull() && (jsonArraysecondaryIPAddresses = jsonObj.getAsJsonArray(SERIALIZED_NAME_SECONDARY_I_P_ADDRESSES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SECONDARY_I_P_ADDRESSES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `SecondaryIPAddresses` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SECONDARY_I_P_ADDRESSES).toString()));
            }
            for (int i = 0; i < jsonArraysecondaryIPAddresses.size(); ++i) {
                Address.validateJsonObject(jsonArraysecondaryIPAddresses.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_SECONDARY_I_PV6_ADDRESSES) != null && !jsonObj.get(SERIALIZED_NAME_SECONDARY_I_PV6_ADDRESSES).isJsonNull() && (jsonArraysecondaryIPv6Addresses = jsonObj.getAsJsonArray(SERIALIZED_NAME_SECONDARY_I_PV6_ADDRESSES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SECONDARY_I_PV6_ADDRESSES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `SecondaryIPv6Addresses` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SECONDARY_I_PV6_ADDRESSES).toString()));
            }
            for (int i = 0; i < jsonArraysecondaryIPv6Addresses.size(); ++i) {
                Address.validateJsonObject(jsonArraysecondaryIPv6Addresses.get(i).getAsJsonObject());
            }
        }
    }

    public static InspectAdditionalNetwork fromJson(String jsonString) throws IOException {
        return (InspectAdditionalNetwork)JSON.getGson().fromJson(jsonString, InspectAdditionalNetwork.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ADDITIONAL_M_A_C_ADDRESSES);
        openapiFields.add(SERIALIZED_NAME_ALIASES);
        openapiFields.add(SERIALIZED_NAME_DRIVER_OPTS);
        openapiFields.add(SERIALIZED_NAME_ENDPOINT_I_D);
        openapiFields.add(SERIALIZED_NAME_GATEWAY);
        openapiFields.add(SERIALIZED_NAME_GLOBAL_I_PV6_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_GLOBAL_I_PV6_PREFIX_LEN);
        openapiFields.add(SERIALIZED_NAME_IP_A_M_CONFIG);
        openapiFields.add(SERIALIZED_NAME_IP_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_IP_PREFIX_LEN);
        openapiFields.add(SERIALIZED_NAME_IPV6_GATEWAY);
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiFields.add(SERIALIZED_NAME_MAC_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_NETWORK_I_D);
        openapiFields.add(SERIALIZED_NAME_SECONDARY_I_P_ADDRESSES);
        openapiFields.add(SERIALIZED_NAME_SECONDARY_I_PV6_ADDRESSES);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!InspectAdditionalNetwork.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(InspectAdditionalNetwork.class));
            return new TypeAdapter<InspectAdditionalNetwork>(){

                public void write(JsonWriter out, InspectAdditionalNetwork value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public InspectAdditionalNetwork read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    InspectAdditionalNetwork.validateJsonObject(jsonObj);
                    return (InspectAdditionalNetwork)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

