/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.LeaseRange;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.Valid;

public class Subnet
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_GATEWAY = "gateway";
    @SerializedName(value="gateway")
    private String gateway;
    public static final String SERIALIZED_NAME_LEASE_RANGE = "lease_range";
    @SerializedName(value="lease_range")
    private LeaseRange leaseRange;
    public static final String SERIALIZED_NAME_SUBNET = "subnet";
    @SerializedName(value="subnet")
    private String subnet;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Subnet gateway(String gateway) {
        this.gateway = gateway;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Gateway IP for this Network.")
    public String getGateway() {
        return this.gateway;
    }

    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    public Subnet leaseRange(LeaseRange leaseRange) {
        this.leaseRange = leaseRange;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public LeaseRange getLeaseRange() {
        return this.leaseRange;
    }

    public void setLeaseRange(LeaseRange leaseRange) {
        this.leaseRange = leaseRange;
    }

    public Subnet subnet(String subnet) {
        this.subnet = subnet;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Subnet for this Network in CIDR form.")
    public String getSubnet() {
        return this.subnet;
    }

    public void setSubnet(String subnet) {
        this.subnet = subnet;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Subnet subnet = (Subnet)o;
        return Objects.equals(this.gateway, subnet.gateway) && Objects.equals(this.leaseRange, subnet.leaseRange) && Objects.equals(this.subnet, subnet.subnet);
    }

    public int hashCode() {
        return Objects.hash(this.gateway, this.leaseRange, this.subnet);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Subnet {\n");
        sb.append("    gateway: ").append(this.toIndentedString(this.gateway)).append("\n");
        sb.append("    leaseRange: ").append(this.toIndentedString(this.leaseRange)).append("\n");
        sb.append("    subnet: ").append(this.toIndentedString(this.subnet)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Subnet is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Subnet` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_GATEWAY) != null && !jsonObj.get(SERIALIZED_NAME_GATEWAY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_GATEWAY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `gateway` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GATEWAY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LEASE_RANGE) != null && !jsonObj.get(SERIALIZED_NAME_LEASE_RANGE).isJsonNull()) {
            LeaseRange.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_LEASE_RANGE));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUBNET) != null && !jsonObj.get(SERIALIZED_NAME_SUBNET).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SUBNET).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `subnet` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUBNET).toString()));
        }
    }

    public static Subnet fromJson(String jsonString) throws IOException {
        return (Subnet)JSON.getGson().fromJson(jsonString, Subnet.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_GATEWAY);
        openapiFields.add(SERIALIZED_NAME_LEASE_RANGE);
        openapiFields.add(SERIALIZED_NAME_SUBNET);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Subnet.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Subnet.class));
            return new TypeAdapter<Subnet>(){

                public void write(JsonWriter out, Subnet value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Subnet read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Subnet.validateJsonObject(jsonObj);
                    return (Subnet)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

