/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.Valid;

public class VolumeConfigResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ANONYMOUS = "Anonymous";
    @SerializedName(value="Anonymous")
    private Boolean anonymous;
    public static final String SERIALIZED_NAME_CREATED_AT = "CreatedAt";
    @SerializedName(value="CreatedAt")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_DRIVER = "Driver";
    @SerializedName(value="Driver")
    private String driver;
    public static final String SERIALIZED_NAME_G_I_D = "GID";
    @SerializedName(value="GID")
    private Long GID;
    public static final String SERIALIZED_NAME_LABELS = "Labels";
    @SerializedName(value="Labels")
    private Map<String, String> labels = null;
    public static final String SERIALIZED_NAME_LOCK_NUMBER = "LockNumber";
    @SerializedName(value="LockNumber")
    private Integer lockNumber;
    public static final String SERIALIZED_NAME_MOUNT_COUNT = "MountCount";
    @SerializedName(value="MountCount")
    private Integer mountCount;
    public static final String SERIALIZED_NAME_MOUNTPOINT = "Mountpoint";
    @SerializedName(value="Mountpoint")
    private String mountpoint;
    public static final String SERIALIZED_NAME_NAME = "Name";
    @SerializedName(value="Name")
    private String name;
    public static final String SERIALIZED_NAME_NEEDS_CHOWN = "NeedsChown";
    @SerializedName(value="NeedsChown")
    private Boolean needsChown;
    public static final String SERIALIZED_NAME_NEEDS_COPY_UP = "NeedsCopyUp";
    @SerializedName(value="NeedsCopyUp")
    private Boolean needsCopyUp;
    public static final String SERIALIZED_NAME_OPTIONS = "Options";
    @SerializedName(value="Options")
    private Map<String, String> options = null;
    public static final String SERIALIZED_NAME_SCOPE = "Scope";
    @SerializedName(value="Scope")
    private String scope;
    public static final String SERIALIZED_NAME_STATUS = "Status";
    @SerializedName(value="Status")
    private Map<String, Object> status = null;
    public static final String SERIALIZED_NAME_STORAGE_I_D = "StorageID";
    @SerializedName(value="StorageID")
    private String storageID;
    public static final String SERIALIZED_NAME_TIMEOUT = "Timeout";
    @SerializedName(value="Timeout")
    private Integer timeout;
    public static final String SERIALIZED_NAME_U_I_D = "UID";
    @SerializedName(value="UID")
    private Long UID;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public VolumeConfigResponse anonymous(Boolean anonymous) {
        this.anonymous = anonymous;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Anonymous indicates that the volume was created as an anonymous volume for a specific container, and will be removed when any container using it is removed.")
    public Boolean getAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(Boolean anonymous) {
        this.anonymous = anonymous;
    }

    public VolumeConfigResponse createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="CreatedAt is the date and time the volume was created at. This is not stored for older Libpod volumes; if so, it will be omitted.")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public VolumeConfigResponse driver(String driver) {
        this.driver = driver;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Driver is the driver used to create the volume. If set to \"local\" or \"\", the Local driver (Podman built-in code) is used to service the volume; otherwise, a volume plugin with the given name is used to mount and manage the volume.")
    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public VolumeConfigResponse GID(Long GID) {
        this.GID = GID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="GID is the GID that the volume was created with.")
    public Long getGID() {
        return this.GID;
    }

    public void setGID(Long GID) {
        this.GID = GID;
    }

    public VolumeConfigResponse labels(Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    public VolumeConfigResponse putLabelsItem(String key, String labelsItem) {
        if (this.labels == null) {
            this.labels = new HashMap<String, String>();
        }
        this.labels.put(key, labelsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Labels includes the volume's configured labels, key:value pairs that can be passed during volume creation to provide information for third party tools.")
    public Map<String, String> getLabels() {
        return this.labels;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    public VolumeConfigResponse lockNumber(Integer lockNumber) {
        this.lockNumber = lockNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="LockNumber is the number of the volume's Libpod lock.")
    public Integer getLockNumber() {
        return this.lockNumber;
    }

    public void setLockNumber(Integer lockNumber) {
        this.lockNumber = lockNumber;
    }

    public VolumeConfigResponse mountCount(Integer mountCount) {
        this.mountCount = mountCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="MountCount is the number of times this volume has been mounted.")
    public Integer getMountCount() {
        return this.mountCount;
    }

    public void setMountCount(Integer mountCount) {
        this.mountCount = mountCount;
    }

    public VolumeConfigResponse mountpoint(String mountpoint) {
        this.mountpoint = mountpoint;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Mountpoint is the path on the host where the volume is mounted.")
    public String getMountpoint() {
        return this.mountpoint;
    }

    public void setMountpoint(String mountpoint) {
        this.mountpoint = mountpoint;
    }

    public VolumeConfigResponse name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name is the name of the volume.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public VolumeConfigResponse needsChown(Boolean needsChown) {
        this.needsChown = needsChown;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="NeedsChown indicates that the next time the volume is mounted into a container, the container will chown the volume to the container process UID/GID.")
    public Boolean getNeedsChown() {
        return this.needsChown;
    }

    public void setNeedsChown(Boolean needsChown) {
        this.needsChown = needsChown;
    }

    public VolumeConfigResponse needsCopyUp(Boolean needsCopyUp) {
        this.needsCopyUp = needsCopyUp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="NeedsCopyUp indicates that the next time the volume is mounted into")
    public Boolean getNeedsCopyUp() {
        return this.needsCopyUp;
    }

    public void setNeedsCopyUp(Boolean needsCopyUp) {
        this.needsCopyUp = needsCopyUp;
    }

    public VolumeConfigResponse options(Map<String, String> options) {
        this.options = options;
        return this;
    }

    public VolumeConfigResponse putOptionsItem(String key, String optionsItem) {
        if (this.options == null) {
            this.options = new HashMap<String, String>();
        }
        this.options.put(key, optionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Options is a set of options that were used when creating the volume. For the Local driver, these are mount options that will be used to determine how a local filesystem is mounted; they are handled as parameters to Mount in a manner described in the volume create manpage. For non-local drivers, these are passed as-is to the volume plugin.")
    public Map<String, String> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, String> options) {
        this.options = options;
    }

    public VolumeConfigResponse scope(String scope) {
        this.scope = scope;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Scope is unused and provided solely for Docker compatibility. It is unconditionally set to \"local\".")
    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public VolumeConfigResponse status(Map<String, Object> status) {
        this.status = status;
        return this;
    }

    public VolumeConfigResponse putStatusItem(String key, Object statusItem) {
        if (this.status == null) {
            this.status = new HashMap<String, Object>();
        }
        this.status.put(key, statusItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Status is used to return information on the volume's current state, if the volume was created using a volume plugin (uses a Driver that is not the local driver). Status is provided to us by an external program, so no guarantees are made about its format or contents. Further, it is an optional field, so it may not be set even in cases where a volume plugin is in use.")
    public Map<String, Object> getStatus() {
        return this.status;
    }

    public void setStatus(Map<String, Object> status) {
        this.status = status;
    }

    public VolumeConfigResponse storageID(String storageID) {
        this.storageID = storageID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="StorageID is the ID of the container backing the volume in c/storage. Only used with Image Volumes.")
    public String getStorageID() {
        return this.storageID;
    }

    public void setStorageID(String storageID) {
        this.storageID = storageID;
    }

    public VolumeConfigResponse timeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Timeout is the specified driver timeout if given")
    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public VolumeConfigResponse UID(Long UID) {
        this.UID = UID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="UID is the UID that the volume was created with.")
    public Long getUID() {
        return this.UID;
    }

    public void setUID(Long UID) {
        this.UID = UID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VolumeConfigResponse volumeConfigResponse = (VolumeConfigResponse)o;
        return Objects.equals(this.anonymous, volumeConfigResponse.anonymous) && Objects.equals(this.createdAt, volumeConfigResponse.createdAt) && Objects.equals(this.driver, volumeConfigResponse.driver) && Objects.equals(this.GID, volumeConfigResponse.GID) && Objects.equals(this.labels, volumeConfigResponse.labels) && Objects.equals(this.lockNumber, volumeConfigResponse.lockNumber) && Objects.equals(this.mountCount, volumeConfigResponse.mountCount) && Objects.equals(this.mountpoint, volumeConfigResponse.mountpoint) && Objects.equals(this.name, volumeConfigResponse.name) && Objects.equals(this.needsChown, volumeConfigResponse.needsChown) && Objects.equals(this.needsCopyUp, volumeConfigResponse.needsCopyUp) && Objects.equals(this.options, volumeConfigResponse.options) && Objects.equals(this.scope, volumeConfigResponse.scope) && Objects.equals(this.status, volumeConfigResponse.status) && Objects.equals(this.storageID, volumeConfigResponse.storageID) && Objects.equals(this.timeout, volumeConfigResponse.timeout) && Objects.equals(this.UID, volumeConfigResponse.UID);
    }

    public int hashCode() {
        return Objects.hash(this.anonymous, this.createdAt, this.driver, this.GID, this.labels, this.lockNumber, this.mountCount, this.mountpoint, this.name, this.needsChown, this.needsCopyUp, this.options, this.scope, this.status, this.storageID, this.timeout, this.UID);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VolumeConfigResponse {\n");
        sb.append("    anonymous: ").append(this.toIndentedString(this.anonymous)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    driver: ").append(this.toIndentedString(this.driver)).append("\n");
        sb.append("    GID: ").append(this.toIndentedString(this.GID)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("    lockNumber: ").append(this.toIndentedString(this.lockNumber)).append("\n");
        sb.append("    mountCount: ").append(this.toIndentedString(this.mountCount)).append("\n");
        sb.append("    mountpoint: ").append(this.toIndentedString(this.mountpoint)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    needsChown: ").append(this.toIndentedString(this.needsChown)).append("\n");
        sb.append("    needsCopyUp: ").append(this.toIndentedString(this.needsCopyUp)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    storageID: ").append(this.toIndentedString(this.storageID)).append("\n");
        sb.append("    timeout: ").append(this.toIndentedString(this.timeout)).append("\n");
        sb.append("    UID: ").append(this.toIndentedString(this.UID)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in VolumeConfigResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `VolumeConfigResponse` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DRIVER) != null && !jsonObj.get(SERIALIZED_NAME_DRIVER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DRIVER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Driver` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DRIVER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MOUNTPOINT) != null && !jsonObj.get(SERIALIZED_NAME_MOUNTPOINT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MOUNTPOINT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Mountpoint` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MOUNTPOINT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SCOPE) != null && !jsonObj.get(SERIALIZED_NAME_SCOPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SCOPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Scope` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SCOPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STORAGE_I_D) != null && !jsonObj.get(SERIALIZED_NAME_STORAGE_I_D).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_STORAGE_I_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `StorageID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STORAGE_I_D).toString()));
        }
    }

    public static VolumeConfigResponse fromJson(String jsonString) throws IOException {
        return (VolumeConfigResponse)JSON.getGson().fromJson(jsonString, VolumeConfigResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ANONYMOUS);
        openapiFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiFields.add(SERIALIZED_NAME_DRIVER);
        openapiFields.add(SERIALIZED_NAME_G_I_D);
        openapiFields.add(SERIALIZED_NAME_LABELS);
        openapiFields.add(SERIALIZED_NAME_LOCK_NUMBER);
        openapiFields.add(SERIALIZED_NAME_MOUNT_COUNT);
        openapiFields.add(SERIALIZED_NAME_MOUNTPOINT);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_NEEDS_CHOWN);
        openapiFields.add(SERIALIZED_NAME_NEEDS_COPY_UP);
        openapiFields.add(SERIALIZED_NAME_OPTIONS);
        openapiFields.add(SERIALIZED_NAME_SCOPE);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_STORAGE_I_D);
        openapiFields.add(SERIALIZED_NAME_TIMEOUT);
        openapiFields.add(SERIALIZED_NAME_U_I_D);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!VolumeConfigResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(VolumeConfigResponse.class));
            return new TypeAdapter<VolumeConfigResponse>(){

                public void write(JsonWriter out, VolumeConfigResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public VolumeConfigResponse read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    VolumeConfigResponse.validateJsonObject(jsonObj);
                    return (VolumeConfigResponse)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

