/*
 * supports a RESTful API for the Libpod library
 * This documentation describes the Podman v2.x+ RESTful API. It consists of a Docker-compatible API and a Libpod API providing support for Podman’s unique features such as pods.  To start the service and keep it running for 5,000 seconds (-t 0 runs forever):  podman system service -t 5000 &  You can then use cURL on the socket using requests documented below.  NOTE: if you install the package podman-docker, it will create a symbolic link for /run/docker.sock to /run/podman/podman.sock  NOTE: Some fields in the API response JSON are encoded as omitempty, which means that if said field has a zero value, they will not be encoded in the API response. This is a feature to help reduce the size of the JSON responses returned via the API.  NOTE: Due to the limitations of [go-swagger](https://github.com/go-swagger/go-swagger), some field values that have a complex type show up as null in the docs as well as in the API responses. This is because the zero value for the field type is null. The field description in the docs will state what type the field is expected to be for such cases.  See podman-system-service(1) for more information.  Quick Examples:  'podman info'  curl --unix-socket /run/podman/podman.sock http://d/v5.0.0/libpod/info  'podman pull quay.io/containers/podman'  curl -XPOST --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/images/create?fromImage=quay.io%2Fcontainers%2Fpodman'  'podman list images'  curl --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/libpod/images/json' | jq
 *
 * The version of the OpenAPI document: 5.0.0
 * Contact: podman@lists.podman.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.pod4dev.libpodj.api;

import io.github.pod4dev.libpodj.ApiCallback;
import io.github.pod4dev.libpodj.ApiClient;
import io.github.pod4dev.libpodj.ApiException;
import io.github.pod4dev.libpodj.ApiResponse;
import io.github.pod4dev.libpodj.Configuration;
import io.github.pod4dev.libpodj.Pair;
import io.github.pod4dev.libpodj.ProgressRequestBody;
import io.github.pod4dev.libpodj.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;

import jakarta.validation.constraints.*;
import jakarta.validation.Valid;

import io.github.pod4dev.libpodj.model.ErrorModel;
import java.io.File;
import io.github.pod4dev.libpodj.model.IDResponse;
import io.github.pod4dev.libpodj.model.InspectPodData;
import io.github.pod4dev.libpodj.model.ListPodsReport;
import io.github.pod4dev.libpodj.model.PlayKubeReport;
import io.github.pod4dev.libpodj.model.PodKillReport;
import io.github.pod4dev.libpodj.model.PodPauseReport;
import io.github.pod4dev.libpodj.model.PodPruneReport;
import io.github.pod4dev.libpodj.model.PodRestartReport;
import io.github.pod4dev.libpodj.model.PodRmReport;
import io.github.pod4dev.libpodj.model.PodSpecGenerator;
import io.github.pod4dev.libpodj.model.PodStartReport;
import io.github.pod4dev.libpodj.model.PodStatsReport;
import io.github.pod4dev.libpodj.model.PodStopReport;
import io.github.pod4dev.libpodj.model.PodTopOKBody;
import io.github.pod4dev.libpodj.model.PodUnpauseReport;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PodsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public PodsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PodsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private okhttp3.Call generateKubeLibpod_0Call(List<String> names, Boolean service, String type, Integer replicas, Boolean noTrunc, Boolean podmanOnly, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/generate/kube";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (names != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "names", names));
        }

        if (service != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("service", service));
        }

        if (type != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("type", type));
        }

        if (replicas != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("replicas", replicas));
        }

        if (noTrunc != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("noTrunc", noTrunc));
        }

        if (podmanOnly != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("podmanOnly", podmanOnly));
        }

        final String[] localVarAccepts = {
            "text/vnd.yaml",
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call generateKubeLibpod_0ValidateBeforeCall(List<String> names, Boolean service, String type, Integer replicas, Boolean noTrunc, Boolean podmanOnly, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'names' is set
        if (names == null) {
            throw new ApiException("Missing the required parameter 'names' when calling generateKubeLibpod_0(Async)");
        }

        return generateKubeLibpod_0Call(names, service, type, replicas, noTrunc, podmanOnly, _callback);

    }


    private ApiResponse<File> generateKubeLibpod_0WithHttpInfo( @NotNull List<String> names, Boolean service, String type, Integer replicas, Boolean noTrunc, Boolean podmanOnly) throws ApiException {
        okhttp3.Call localVarCall = generateKubeLibpod_0ValidateBeforeCall(names, service, type, replicas, noTrunc, podmanOnly, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call generateKubeLibpod_0Async(List<String> names, Boolean service, String type, Integer replicas, Boolean noTrunc, Boolean podmanOnly, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = generateKubeLibpod_0ValidateBeforeCall(names, service, type, replicas, noTrunc, podmanOnly, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIgenerateKubeLibpod_0Request {
        private final List<String> names;
        private Boolean service;
        private String type;
        private Integer replicas;
        private Boolean noTrunc;
        private Boolean podmanOnly;

        private APIgenerateKubeLibpod_0Request(List<String> names) {
            this.names = names;
        }

        /**
         * Set service
         * @param service Generate YAML for a Kubernetes service object. (optional, default to false)
         * @return APIgenerateKubeLibpod_0Request
         */
        public APIgenerateKubeLibpod_0Request service(Boolean service) {
            this.service = service;
            return this;
        }

        /**
         * Set type
         * @param type Generate YAML for the given Kubernetes kind. (optional, default to pod)
         * @return APIgenerateKubeLibpod_0Request
         */
        public APIgenerateKubeLibpod_0Request type(String type) {
            this.type = type;
            return this;
        }

        /**
         * Set replicas
         * @param replicas Set the replica number for Deployment kind. (optional, default to 0)
         * @return APIgenerateKubeLibpod_0Request
         */
        public APIgenerateKubeLibpod_0Request replicas(Integer replicas) {
            this.replicas = replicas;
            return this;
        }

        /**
         * Set noTrunc
         * @param noTrunc don&#39;t truncate annotations to the Kubernetes maximum length of 63 characters (optional, default to false)
         * @return APIgenerateKubeLibpod_0Request
         */
        public APIgenerateKubeLibpod_0Request noTrunc(Boolean noTrunc) {
            this.noTrunc = noTrunc;
            return this;
        }

        /**
         * Set podmanOnly
         * @param podmanOnly add podman-only reserved annotations in generated YAML file (cannot be used by Kubernetes) (optional, default to false)
         * @return APIgenerateKubeLibpod_0Request
         */
        public APIgenerateKubeLibpod_0Request podmanOnly(Boolean podmanOnly) {
            this.podmanOnly = podmanOnly;
            return this;
        }

        /**
         * Build call for generateKubeLibpod_0
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Kubernetes YAML file describing pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return generateKubeLibpod_0Call(names, service, type, replicas, noTrunc, podmanOnly, _callback);
        }

        /**
         * Execute generateKubeLibpod_0 request
         * @return File
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Kubernetes YAML file describing pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public File execute() throws ApiException {
            ApiResponse<File> localVarResp = generateKubeLibpod_0WithHttpInfo(names, service, type, replicas, noTrunc, podmanOnly);
            return localVarResp.getData();
        }

        /**
         * Execute generateKubeLibpod_0 request with HTTP info returned
         * @return ApiResponse&lt;File&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Kubernetes YAML file describing pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<File> executeWithHttpInfo() throws ApiException {
            return generateKubeLibpod_0WithHttpInfo(names, service, type, replicas, noTrunc, podmanOnly);
        }

        /**
         * Execute generateKubeLibpod_0 request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Kubernetes YAML file describing pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<File> _callback) throws ApiException {
            return generateKubeLibpod_0Async(names, service, type, replicas, noTrunc, podmanOnly, _callback);
        }
    }

    /**
     * Generate a Kubernetes YAML file.
     * Generate Kubernetes YAML based on a pod or container.
     * @param names Name or ID of the container or pod. (required)
     * @return APIgenerateKubeLibpod_0Request
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Kubernetes YAML file describing pod </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIgenerateKubeLibpod_0Request generateKubeLibpod_0(List<String> names) {
        return new APIgenerateKubeLibpod_0Request(names);
    }
    private okhttp3.Call generateSystemdLibpod_0Call(String name, Boolean useName, Boolean _new, Boolean noHeader, Integer startTimeout, Integer stopTimeout, String restartPolicy, String containerPrefix, String podPrefix, String separator, Integer restartSec, List<String> wants, List<String> after, List<String> requires, List<String> additionalEnvVariables, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/generate/{name}/systemd"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (useName != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("useName", useName));
        }

        if (_new != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("new", _new));
        }

        if (noHeader != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("noHeader", noHeader));
        }

        if (startTimeout != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("startTimeout", startTimeout));
        }

        if (stopTimeout != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("stopTimeout", stopTimeout));
        }

        if (restartPolicy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("restartPolicy", restartPolicy));
        }

        if (containerPrefix != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("containerPrefix", containerPrefix));
        }

        if (podPrefix != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("podPrefix", podPrefix));
        }

        if (separator != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("separator", separator));
        }

        if (restartSec != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("restartSec", restartSec));
        }

        if (wants != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "wants", wants));
        }

        if (after != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "after", after));
        }

        if (requires != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "requires", requires));
        }

        if (additionalEnvVariables != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "additionalEnvVariables", additionalEnvVariables));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call generateSystemdLibpod_0ValidateBeforeCall(String name, Boolean useName, Boolean _new, Boolean noHeader, Integer startTimeout, Integer stopTimeout, String restartPolicy, String containerPrefix, String podPrefix, String separator, Integer restartSec, List<String> wants, List<String> after, List<String> requires, List<String> additionalEnvVariables, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling generateSystemdLibpod_0(Async)");
        }

        return generateSystemdLibpod_0Call(name, useName, _new, noHeader, startTimeout, stopTimeout, restartPolicy, containerPrefix, podPrefix, separator, restartSec, wants, after, requires, additionalEnvVariables, _callback);

    }


    private ApiResponse<Map<String, String>> generateSystemdLibpod_0WithHttpInfo( @NotNull String name, Boolean useName, Boolean _new, Boolean noHeader, Integer startTimeout, Integer stopTimeout, String restartPolicy, String containerPrefix, String podPrefix, String separator, Integer restartSec, List<String> wants, List<String> after, List<String> requires, List<String> additionalEnvVariables) throws ApiException {
        okhttp3.Call localVarCall = generateSystemdLibpod_0ValidateBeforeCall(name, useName, _new, noHeader, startTimeout, stopTimeout, restartPolicy, containerPrefix, podPrefix, separator, restartSec, wants, after, requires, additionalEnvVariables, null);
        Type localVarReturnType = new TypeToken<Map<String, String>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call generateSystemdLibpod_0Async(String name, Boolean useName, Boolean _new, Boolean noHeader, Integer startTimeout, Integer stopTimeout, String restartPolicy, String containerPrefix, String podPrefix, String separator, Integer restartSec, List<String> wants, List<String> after, List<String> requires, List<String> additionalEnvVariables, final ApiCallback<Map<String, String>> _callback) throws ApiException {

        okhttp3.Call localVarCall = generateSystemdLibpod_0ValidateBeforeCall(name, useName, _new, noHeader, startTimeout, stopTimeout, restartPolicy, containerPrefix, podPrefix, separator, restartSec, wants, after, requires, additionalEnvVariables, _callback);
        Type localVarReturnType = new TypeToken<Map<String, String>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIgenerateSystemdLibpod_0Request {
        private final String name;
        private Boolean useName;
        private Boolean _new;
        private Boolean noHeader;
        private Integer startTimeout;
        private Integer stopTimeout;
        private String restartPolicy;
        private String containerPrefix;
        private String podPrefix;
        private String separator;
        private Integer restartSec;
        private List<String> wants;
        private List<String> after;
        private List<String> requires;
        private List<String> additionalEnvVariables;

        private APIgenerateSystemdLibpod_0Request(String name) {
            this.name = name;
        }

        /**
         * Set useName
         * @param useName Use container/pod names instead of IDs. (optional, default to false)
         * @return APIgenerateSystemdLibpod_0Request
         */
        public APIgenerateSystemdLibpod_0Request useName(Boolean useName) {
            this.useName = useName;
            return this;
        }

        /**
         * Set _new
         * @param _new Create a new container instead of starting an existing one. (optional, default to false)
         * @return APIgenerateSystemdLibpod_0Request
         */
        public APIgenerateSystemdLibpod_0Request _new(Boolean _new) {
            this._new = _new;
            return this;
        }

        /**
         * Set noHeader
         * @param noHeader Do not generate the header including the Podman version and the timestamp. (optional, default to false)
         * @return APIgenerateSystemdLibpod_0Request
         */
        public APIgenerateSystemdLibpod_0Request noHeader(Boolean noHeader) {
            this.noHeader = noHeader;
            return this;
        }

        /**
         * Set startTimeout
         * @param startTimeout Start timeout in seconds. (optional, default to 0)
         * @return APIgenerateSystemdLibpod_0Request
         */
        public APIgenerateSystemdLibpod_0Request startTimeout(Integer startTimeout) {
            this.startTimeout = startTimeout;
            return this;
        }

        /**
         * Set stopTimeout
         * @param stopTimeout Stop timeout in seconds. (optional, default to 10)
         * @return APIgenerateSystemdLibpod_0Request
         */
        public APIgenerateSystemdLibpod_0Request stopTimeout(Integer stopTimeout) {
            this.stopTimeout = stopTimeout;
            return this;
        }

        /**
         * Set restartPolicy
         * @param restartPolicy Systemd restart-policy. (optional, default to on-failure)
         * @return APIgenerateSystemdLibpod_0Request
         */
        public APIgenerateSystemdLibpod_0Request restartPolicy(String restartPolicy) {
            this.restartPolicy = restartPolicy;
            return this;
        }

        /**
         * Set containerPrefix
         * @param containerPrefix Systemd unit name prefix for containers. (optional, default to container)
         * @return APIgenerateSystemdLibpod_0Request
         */
        public APIgenerateSystemdLibpod_0Request containerPrefix(String containerPrefix) {
            this.containerPrefix = containerPrefix;
            return this;
        }

        /**
         * Set podPrefix
         * @param podPrefix Systemd unit name prefix for pods. (optional, default to pod)
         * @return APIgenerateSystemdLibpod_0Request
         */
        public APIgenerateSystemdLibpod_0Request podPrefix(String podPrefix) {
            this.podPrefix = podPrefix;
            return this;
        }

        /**
         * Set separator
         * @param separator Systemd unit name separator between name/id and prefix. (optional, default to -)
         * @return APIgenerateSystemdLibpod_0Request
         */
        public APIgenerateSystemdLibpod_0Request separator(String separator) {
            this.separator = separator;
            return this;
        }

        /**
         * Set restartSec
         * @param restartSec Configures the time to sleep before restarting a service. (optional, default to 0)
         * @return APIgenerateSystemdLibpod_0Request
         */
        public APIgenerateSystemdLibpod_0Request restartSec(Integer restartSec) {
            this.restartSec = restartSec;
            return this;
        }

        /**
         * Set wants
         * @param wants Systemd Wants list for the container or pods. (optional)
         * @return APIgenerateSystemdLibpod_0Request
         */
        public APIgenerateSystemdLibpod_0Request wants(List<String> wants) {
            this.wants = wants;
            return this;
        }

        /**
         * Set after
         * @param after Systemd After list for the container or pods. (optional)
         * @return APIgenerateSystemdLibpod_0Request
         */
        public APIgenerateSystemdLibpod_0Request after(List<String> after) {
            this.after = after;
            return this;
        }

        /**
         * Set requires
         * @param requires Systemd Requires list for the container or pods. (optional)
         * @return APIgenerateSystemdLibpod_0Request
         */
        public APIgenerateSystemdLibpod_0Request requires(List<String> requires) {
            this.requires = requires;
            return this;
        }

        /**
         * Set additionalEnvVariables
         * @param additionalEnvVariables Set environment variables to the systemd unit files. (optional)
         * @return APIgenerateSystemdLibpod_0Request
         */
        public APIgenerateSystemdLibpod_0Request additionalEnvVariables(List<String> additionalEnvVariables) {
            this.additionalEnvVariables = additionalEnvVariables;
            return this;
        }

        /**
         * Build call for generateSystemdLibpod_0
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return generateSystemdLibpod_0Call(name, useName, _new, noHeader, startTimeout, stopTimeout, restartPolicy, containerPrefix, podPrefix, separator, restartSec, wants, after, requires, additionalEnvVariables, _callback);
        }

        /**
         * Execute generateSystemdLibpod_0 request
         * @return Map&lt;String, String&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public Map<String, String> execute() throws ApiException {
            ApiResponse<Map<String, String>> localVarResp = generateSystemdLibpod_0WithHttpInfo(name, useName, _new, noHeader, startTimeout, stopTimeout, restartPolicy, containerPrefix, podPrefix, separator, restartSec, wants, after, requires, additionalEnvVariables);
            return localVarResp.getData();
        }

        /**
         * Execute generateSystemdLibpod_0 request with HTTP info returned
         * @return ApiResponse&lt;Map&lt;String, String&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Map<String, String>> executeWithHttpInfo() throws ApiException {
            return generateSystemdLibpod_0WithHttpInfo(name, useName, _new, noHeader, startTimeout, stopTimeout, restartPolicy, containerPrefix, podPrefix, separator, restartSec, wants, after, requires, additionalEnvVariables);
        }

        /**
         * Execute generateSystemdLibpod_0 request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Map<String, String>> _callback) throws ApiException {
            return generateSystemdLibpod_0Async(name, useName, _new, noHeader, startTimeout, stopTimeout, restartPolicy, containerPrefix, podPrefix, separator, restartSec, wants, after, requires, additionalEnvVariables, _callback);
        }
    }

    /**
     * Generate Systemd Units
     * Generate Systemd Units based on a pod or container.
     * @param name Name or ID of the container or pod. (required)
     * @return APIgenerateSystemdLibpod_0Request
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIgenerateSystemdLibpod_0Request generateSystemdLibpod_0(String name) {
        return new APIgenerateSystemdLibpod_0Request(name);
    }
    private okhttp3.Call kubeApplyLibpod_0Call(String caCertFile, String kubeConfig, String namespace, Boolean service, String _file, String request, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = request;

        // create path and map variables
        String localVarPath = "/libpod/kube/apply";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (caCertFile != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("caCertFile", caCertFile));
        }

        if (kubeConfig != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("kubeConfig", kubeConfig));
        }

        if (namespace != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("namespace", namespace));
        }

        if (service != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("service", service));
        }

        if (_file != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("file", _file));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json",
            "application/x-tar"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call kubeApplyLibpod_0ValidateBeforeCall(String caCertFile, String kubeConfig, String namespace, Boolean service, String _file, String request, final ApiCallback _callback) throws ApiException {
        return kubeApplyLibpod_0Call(caCertFile, kubeConfig, namespace, service, _file, request, _callback);

    }


    private ApiResponse<File> kubeApplyLibpod_0WithHttpInfo(String caCertFile, String kubeConfig, String namespace, Boolean service, String _file, String request) throws ApiException {
        okhttp3.Call localVarCall = kubeApplyLibpod_0ValidateBeforeCall(caCertFile, kubeConfig, namespace, service, _file, request, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call kubeApplyLibpod_0Async(String caCertFile, String kubeConfig, String namespace, Boolean service, String _file, String request, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = kubeApplyLibpod_0ValidateBeforeCall(caCertFile, kubeConfig, namespace, service, _file, request, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIkubeApplyLibpod_0Request {
        private String caCertFile;
        private String kubeConfig;
        private String namespace;
        private Boolean service;
        private String _file;
        private String request;

        private APIkubeApplyLibpod_0Request() {
        }

        /**
         * Set caCertFile
         * @param caCertFile Path to the CA cert file for the Kubernetes cluster. (optional)
         * @return APIkubeApplyLibpod_0Request
         */
        public APIkubeApplyLibpod_0Request caCertFile(String caCertFile) {
            this.caCertFile = caCertFile;
            return this;
        }

        /**
         * Set kubeConfig
         * @param kubeConfig Path to the kubeconfig file for the Kubernetes cluster. (optional)
         * @return APIkubeApplyLibpod_0Request
         */
        public APIkubeApplyLibpod_0Request kubeConfig(String kubeConfig) {
            this.kubeConfig = kubeConfig;
            return this;
        }

        /**
         * Set namespace
         * @param namespace The namespace to deploy the workload to on the Kubernetes cluster. (optional)
         * @return APIkubeApplyLibpod_0Request
         */
        public APIkubeApplyLibpod_0Request namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        /**
         * Set service
         * @param service Create a service object for the container being deployed. (optional)
         * @return APIkubeApplyLibpod_0Request
         */
        public APIkubeApplyLibpod_0Request service(Boolean service) {
            this.service = service;
            return this;
        }

        /**
         * Set _file
         * @param _file Path to the Kubernetes yaml file to deploy. (optional)
         * @return APIkubeApplyLibpod_0Request
         */
        public APIkubeApplyLibpod_0Request _file(String _file) {
            this._file = _file;
            return this;
        }

        /**
         * Set request
         * @param request Kubernetes YAML file. (optional)
         * @return APIkubeApplyLibpod_0Request
         */
        public APIkubeApplyLibpod_0Request request(String request) {
            this.request = request;
            return this;
        }

        /**
         * Build call for kubeApplyLibpod_0
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Kubernetes YAML file successfully deployed to cluster </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return kubeApplyLibpod_0Call(caCertFile, kubeConfig, namespace, service, _file, request, _callback);
        }

        /**
         * Execute kubeApplyLibpod_0 request
         * @return File
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Kubernetes YAML file successfully deployed to cluster </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public File execute() throws ApiException {
            ApiResponse<File> localVarResp = kubeApplyLibpod_0WithHttpInfo(caCertFile, kubeConfig, namespace, service, _file, request);
            return localVarResp.getData();
        }

        /**
         * Execute kubeApplyLibpod_0 request with HTTP info returned
         * @return ApiResponse&lt;File&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Kubernetes YAML file successfully deployed to cluster </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<File> executeWithHttpInfo() throws ApiException {
            return kubeApplyLibpod_0WithHttpInfo(caCertFile, kubeConfig, namespace, service, _file, request);
        }

        /**
         * Execute kubeApplyLibpod_0 request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Kubernetes YAML file successfully deployed to cluster </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<File> _callback) throws ApiException {
            return kubeApplyLibpod_0Async(caCertFile, kubeConfig, namespace, service, _file, request, _callback);
        }
    }

    /**
     * Apply a podman workload or Kubernetes YAML file.
     * Deploy a podman container, pod, volume, or Kubernetes yaml to a Kubernetes cluster.
     * @return APIkubeApplyLibpod_0Request
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Kubernetes YAML file successfully deployed to cluster </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIkubeApplyLibpod_0Request kubeApplyLibpod_0() {
        return new APIkubeApplyLibpod_0Request();
    }
    private okhttp3.Call playKubeDownLibpod_0Call(String contentType, Boolean force, String request, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = request;

        // create path and map variables
        String localVarPath = "/libpod/play/kube";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (force != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("force", force));
        }

        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", localVarApiClient.parameterToString(contentType));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "text/plain",
            "application/x-tar"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call playKubeDownLibpod_0ValidateBeforeCall(String contentType, Boolean force, String request, final ApiCallback _callback) throws ApiException {
        return playKubeDownLibpod_0Call(contentType, force, request, _callback);

    }


    private ApiResponse<PlayKubeReport> playKubeDownLibpod_0WithHttpInfo(String contentType, Boolean force, String request) throws ApiException {
        okhttp3.Call localVarCall = playKubeDownLibpod_0ValidateBeforeCall(contentType, force, request, null);
        Type localVarReturnType = new TypeToken<PlayKubeReport>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call playKubeDownLibpod_0Async(String contentType, Boolean force, String request, final ApiCallback<PlayKubeReport> _callback) throws ApiException {

        okhttp3.Call localVarCall = playKubeDownLibpod_0ValidateBeforeCall(contentType, force, request, _callback);
        Type localVarReturnType = new TypeToken<PlayKubeReport>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIplayKubeDownLibpod_0Request {
        private String contentType;
        private Boolean force;
        private String request;

        private APIplayKubeDownLibpod_0Request() {
        }

        /**
         * Set contentType
         * @param contentType  (optional, default to text/plain)
         * @return APIplayKubeDownLibpod_0Request
         */
        public APIplayKubeDownLibpod_0Request contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        /**
         * Set force
         * @param force Remove volumes. (optional, default to false)
         * @return APIplayKubeDownLibpod_0Request
         */
        public APIplayKubeDownLibpod_0Request force(Boolean force) {
            this.force = force;
            return this;
        }

        /**
         * Set request
         * @param request Kubernetes YAML file. (optional)
         * @return APIplayKubeDownLibpod_0Request
         */
        public APIplayKubeDownLibpod_0Request request(String request) {
            this.request = request;
            return this;
        }

        /**
         * Build call for playKubeDownLibpod_0
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> PlayKube response </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return playKubeDownLibpod_0Call(contentType, force, request, _callback);
        }

        /**
         * Execute playKubeDownLibpod_0 request
         * @return PlayKubeReport
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> PlayKube response </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public PlayKubeReport execute() throws ApiException {
            ApiResponse<PlayKubeReport> localVarResp = playKubeDownLibpod_0WithHttpInfo(contentType, force, request);
            return localVarResp.getData();
        }

        /**
         * Execute playKubeDownLibpod_0 request with HTTP info returned
         * @return ApiResponse&lt;PlayKubeReport&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> PlayKube response </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<PlayKubeReport> executeWithHttpInfo() throws ApiException {
            return playKubeDownLibpod_0WithHttpInfo(contentType, force, request);
        }

        /**
         * Execute playKubeDownLibpod_0 request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> PlayKube response </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<PlayKubeReport> _callback) throws ApiException {
            return playKubeDownLibpod_0Async(contentType, force, request, _callback);
        }
    }

    /**
     * Remove resources created from kube play
     * Tears down pods, secrets, and volumes defined in a YAML file
     * @return APIplayKubeDownLibpod_0Request
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> PlayKube response </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIplayKubeDownLibpod_0Request playKubeDownLibpod_0() {
        return new APIplayKubeDownLibpod_0Request();
    }
    private okhttp3.Call playKubeLibpod_0Call(String contentType, String annotations, String logDriver, List<String> logOptions, List<String> network, Boolean noHosts, Boolean noTrunc, List<String> publishPorts, Boolean publishAllPorts, Boolean replace, Boolean serviceContainer, Boolean start, List<String> staticIPs, List<String> staticMACs, Boolean tlsVerify, String userns, Boolean wait, Boolean build, String request, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = request;

        // create path and map variables
        String localVarPath = "/libpod/play/kube";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (annotations != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("annotations", annotations));
        }

        if (logDriver != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("logDriver", logDriver));
        }

        if (logOptions != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "logOptions", logOptions));
        }

        if (network != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "network", network));
        }

        if (noHosts != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("noHosts", noHosts));
        }

        if (noTrunc != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("noTrunc", noTrunc));
        }

        if (publishPorts != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "publishPorts", publishPorts));
        }

        if (publishAllPorts != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("publishAllPorts", publishAllPorts));
        }

        if (replace != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("replace", replace));
        }

        if (serviceContainer != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("serviceContainer", serviceContainer));
        }

        if (start != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("start", start));
        }

        if (staticIPs != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "staticIPs", staticIPs));
        }

        if (staticMACs != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "staticMACs", staticMACs));
        }

        if (tlsVerify != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tlsVerify", tlsVerify));
        }

        if (userns != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("userns", userns));
        }

        if (wait != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("wait", wait));
        }

        if (build != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("build", build));
        }

        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", localVarApiClient.parameterToString(contentType));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "text/plain",
            "application/x-tar"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call playKubeLibpod_0ValidateBeforeCall(String contentType, String annotations, String logDriver, List<String> logOptions, List<String> network, Boolean noHosts, Boolean noTrunc, List<String> publishPorts, Boolean publishAllPorts, Boolean replace, Boolean serviceContainer, Boolean start, List<String> staticIPs, List<String> staticMACs, Boolean tlsVerify, String userns, Boolean wait, Boolean build, String request, final ApiCallback _callback) throws ApiException {
        return playKubeLibpod_0Call(contentType, annotations, logDriver, logOptions, network, noHosts, noTrunc, publishPorts, publishAllPorts, replace, serviceContainer, start, staticIPs, staticMACs, tlsVerify, userns, wait, build, request, _callback);

    }


    private ApiResponse<PlayKubeReport> playKubeLibpod_0WithHttpInfo(String contentType, String annotations, String logDriver, List<String> logOptions, List<String> network, Boolean noHosts, Boolean noTrunc, List<String> publishPorts, Boolean publishAllPorts, Boolean replace, Boolean serviceContainer, Boolean start, List<String> staticIPs, List<String> staticMACs, Boolean tlsVerify, String userns, Boolean wait, Boolean build, String request) throws ApiException {
        okhttp3.Call localVarCall = playKubeLibpod_0ValidateBeforeCall(contentType, annotations, logDriver, logOptions, network, noHosts, noTrunc, publishPorts, publishAllPorts, replace, serviceContainer, start, staticIPs, staticMACs, tlsVerify, userns, wait, build, request, null);
        Type localVarReturnType = new TypeToken<PlayKubeReport>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call playKubeLibpod_0Async(String contentType, String annotations, String logDriver, List<String> logOptions, List<String> network, Boolean noHosts, Boolean noTrunc, List<String> publishPorts, Boolean publishAllPorts, Boolean replace, Boolean serviceContainer, Boolean start, List<String> staticIPs, List<String> staticMACs, Boolean tlsVerify, String userns, Boolean wait, Boolean build, String request, final ApiCallback<PlayKubeReport> _callback) throws ApiException {

        okhttp3.Call localVarCall = playKubeLibpod_0ValidateBeforeCall(contentType, annotations, logDriver, logOptions, network, noHosts, noTrunc, publishPorts, publishAllPorts, replace, serviceContainer, start, staticIPs, staticMACs, tlsVerify, userns, wait, build, request, _callback);
        Type localVarReturnType = new TypeToken<PlayKubeReport>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIplayKubeLibpod_0Request {
        private String contentType;
        private String annotations;
        private String logDriver;
        private List<String> logOptions;
        private List<String> network;
        private Boolean noHosts;
        private Boolean noTrunc;
        private List<String> publishPorts;
        private Boolean publishAllPorts;
        private Boolean replace;
        private Boolean serviceContainer;
        private Boolean start;
        private List<String> staticIPs;
        private List<String> staticMACs;
        private Boolean tlsVerify;
        private String userns;
        private Boolean wait;
        private Boolean build;
        private String request;

        private APIplayKubeLibpod_0Request() {
        }

        /**
         * Set contentType
         * @param contentType  (optional, default to text/plain)
         * @return APIplayKubeLibpod_0Request
         */
        public APIplayKubeLibpod_0Request contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        /**
         * Set annotations
         * @param annotations JSON encoded value of annotations (a map[string]string). (optional)
         * @return APIplayKubeLibpod_0Request
         */
        public APIplayKubeLibpod_0Request annotations(String annotations) {
            this.annotations = annotations;
            return this;
        }

        /**
         * Set logDriver
         * @param logDriver Logging driver for the containers in the pod. (optional)
         * @return APIplayKubeLibpod_0Request
         */
        public APIplayKubeLibpod_0Request logDriver(String logDriver) {
            this.logDriver = logDriver;
            return this;
        }

        /**
         * Set logOptions
         * @param logOptions logging driver options (optional)
         * @return APIplayKubeLibpod_0Request
         */
        public APIplayKubeLibpod_0Request logOptions(List<String> logOptions) {
            this.logOptions = logOptions;
            return this;
        }

        /**
         * Set network
         * @param network USe the network mode or specify an array of networks. (optional)
         * @return APIplayKubeLibpod_0Request
         */
        public APIplayKubeLibpod_0Request network(List<String> network) {
            this.network = network;
            return this;
        }

        /**
         * Set noHosts
         * @param noHosts do not setup /etc/hosts file in container (optional, default to false)
         * @return APIplayKubeLibpod_0Request
         */
        public APIplayKubeLibpod_0Request noHosts(Boolean noHosts) {
            this.noHosts = noHosts;
            return this;
        }

        /**
         * Set noTrunc
         * @param noTrunc use annotations that are not truncated to the Kubernetes maximum length of 63 characters (optional, default to false)
         * @return APIplayKubeLibpod_0Request
         */
        public APIplayKubeLibpod_0Request noTrunc(Boolean noTrunc) {
            this.noTrunc = noTrunc;
            return this;
        }

        /**
         * Set publishPorts
         * @param publishPorts publish a container&#39;s port, or a range of ports, to the host (optional)
         * @return APIplayKubeLibpod_0Request
         */
        public APIplayKubeLibpod_0Request publishPorts(List<String> publishPorts) {
            this.publishPorts = publishPorts;
            return this;
        }

        /**
         * Set publishAllPorts
         * @param publishAllPorts Whether to publish all ports defined in the K8S YAML file (containerPort, hostPort), if false only hostPort will be published (optional)
         * @return APIplayKubeLibpod_0Request
         */
        public APIplayKubeLibpod_0Request publishAllPorts(Boolean publishAllPorts) {
            this.publishAllPorts = publishAllPorts;
            return this;
        }

        /**
         * Set replace
         * @param replace replace existing pods and containers (optional, default to false)
         * @return APIplayKubeLibpod_0Request
         */
        public APIplayKubeLibpod_0Request replace(Boolean replace) {
            this.replace = replace;
            return this;
        }

        /**
         * Set serviceContainer
         * @param serviceContainer Starts a service container before all pods. (optional, default to false)
         * @return APIplayKubeLibpod_0Request
         */
        public APIplayKubeLibpod_0Request serviceContainer(Boolean serviceContainer) {
            this.serviceContainer = serviceContainer;
            return this;
        }

        /**
         * Set start
         * @param start Start the pod after creating it. (optional, default to true)
         * @return APIplayKubeLibpod_0Request
         */
        public APIplayKubeLibpod_0Request start(Boolean start) {
            this.start = start;
            return this;
        }

        /**
         * Set staticIPs
         * @param staticIPs Static IPs used for the pods. (optional)
         * @return APIplayKubeLibpod_0Request
         */
        public APIplayKubeLibpod_0Request staticIPs(List<String> staticIPs) {
            this.staticIPs = staticIPs;
            return this;
        }

        /**
         * Set staticMACs
         * @param staticMACs Static MACs used for the pods. (optional)
         * @return APIplayKubeLibpod_0Request
         */
        public APIplayKubeLibpod_0Request staticMACs(List<String> staticMACs) {
            this.staticMACs = staticMACs;
            return this;
        }

        /**
         * Set tlsVerify
         * @param tlsVerify Require HTTPS and verify signatures when contacting registries. (optional, default to true)
         * @return APIplayKubeLibpod_0Request
         */
        public APIplayKubeLibpod_0Request tlsVerify(Boolean tlsVerify) {
            this.tlsVerify = tlsVerify;
            return this;
        }

        /**
         * Set userns
         * @param userns Set the user namespace mode for the pods. (optional)
         * @return APIplayKubeLibpod_0Request
         */
        public APIplayKubeLibpod_0Request userns(String userns) {
            this.userns = userns;
            return this;
        }

        /**
         * Set wait
         * @param wait Clean up all objects created when a SIGTERM is received or pods exit. (optional, default to false)
         * @return APIplayKubeLibpod_0Request
         */
        public APIplayKubeLibpod_0Request wait(Boolean wait) {
            this.wait = wait;
            return this;
        }

        /**
         * Set build
         * @param build Build the images with corresponding context. (optional)
         * @return APIplayKubeLibpod_0Request
         */
        public APIplayKubeLibpod_0Request build(Boolean build) {
            this.build = build;
            return this;
        }

        /**
         * Set request
         * @param request Kubernetes YAML file. (optional)
         * @return APIplayKubeLibpod_0Request
         */
        public APIplayKubeLibpod_0Request request(String request) {
            this.request = request;
            return this;
        }

        /**
         * Build call for playKubeLibpod_0
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> PlayKube response </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return playKubeLibpod_0Call(contentType, annotations, logDriver, logOptions, network, noHosts, noTrunc, publishPorts, publishAllPorts, replace, serviceContainer, start, staticIPs, staticMACs, tlsVerify, userns, wait, build, request, _callback);
        }

        /**
         * Execute playKubeLibpod_0 request
         * @return PlayKubeReport
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> PlayKube response </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public PlayKubeReport execute() throws ApiException {
            ApiResponse<PlayKubeReport> localVarResp = playKubeLibpod_0WithHttpInfo(contentType, annotations, logDriver, logOptions, network, noHosts, noTrunc, publishPorts, publishAllPorts, replace, serviceContainer, start, staticIPs, staticMACs, tlsVerify, userns, wait, build, request);
            return localVarResp.getData();
        }

        /**
         * Execute playKubeLibpod_0 request with HTTP info returned
         * @return ApiResponse&lt;PlayKubeReport&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> PlayKube response </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<PlayKubeReport> executeWithHttpInfo() throws ApiException {
            return playKubeLibpod_0WithHttpInfo(contentType, annotations, logDriver, logOptions, network, noHosts, noTrunc, publishPorts, publishAllPorts, replace, serviceContainer, start, staticIPs, staticMACs, tlsVerify, userns, wait, build, request);
        }

        /**
         * Execute playKubeLibpod_0 request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> PlayKube response </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<PlayKubeReport> _callback) throws ApiException {
            return playKubeLibpod_0Async(contentType, annotations, logDriver, logOptions, network, noHosts, noTrunc, publishPorts, publishAllPorts, replace, serviceContainer, start, staticIPs, staticMACs, tlsVerify, userns, wait, build, request, _callback);
        }
    }

    /**
     * Play a Kubernetes YAML file.
     * Create and run pods based on a Kubernetes YAML file.  ### Content-Type  Then endpoint support two Content-Type  - &#x60;text/plain&#x60; for yaml format  - &#x60;application/x-tar&#x60; for sending context(s) required for building images  #### Tar format  The tar format must contain a &#x60;play.yaml&#x60; file at the root that will be used. If the file format requires context to build an image, it uses the image name and check for corresponding folder.  For example, the client sends a tar file with the following structure:  &#x60;&#x60;&#x60; └── content.tar  ├── play.yaml  └── foobar/      └── Containerfile &#x60;&#x60;&#x60;  The &#x60;play.yaml&#x60; is the following, the &#x60;foobar&#x60; image means we are looking for a context with this name. &#x60;&#x60;&#x60; apiVersion: v1 kind: Pod metadata: name: demo-build-remote spec: containers:  - name: container    image: foobar &#x60;&#x60;&#x60; 
     * @return APIplayKubeLibpod_0Request
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> PlayKube response </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIplayKubeLibpod_0Request playKubeLibpod_0() {
        return new APIplayKubeLibpod_0Request();
    }
    private okhttp3.Call podCreateLibpodCall(PodSpecGenerator create, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = create;

        // create path and map variables
        String localVarPath = "/libpod/pods/create";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json",
            "application/x-tar"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call podCreateLibpodValidateBeforeCall(PodSpecGenerator create, final ApiCallback _callback) throws ApiException {
        return podCreateLibpodCall(create, _callback);

    }


    private ApiResponse<IDResponse> podCreateLibpodWithHttpInfo(PodSpecGenerator create) throws ApiException {
        okhttp3.Call localVarCall = podCreateLibpodValidateBeforeCall(create, null);
        Type localVarReturnType = new TypeToken<IDResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call podCreateLibpodAsync(PodSpecGenerator create, final ApiCallback<IDResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = podCreateLibpodValidateBeforeCall(create, _callback);
        Type localVarReturnType = new TypeToken<IDResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIpodCreateLibpodRequest {
        private PodSpecGenerator create;

        private APIpodCreateLibpodRequest() {
        }

        /**
         * Set create
         * @param create attributes for creating a pod (optional)
         * @return APIpodCreateLibpodRequest
         */
        public APIpodCreateLibpodRequest create(PodSpecGenerator create) {
            this.create = create;
            return this;
        }

        /**
         * Build call for podCreateLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td>  </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> status conflict </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return podCreateLibpodCall(create, _callback);
        }

        /**
         * Execute podCreateLibpod request
         * @return IDResponse
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td>  </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> status conflict </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public IDResponse execute() throws ApiException {
            ApiResponse<IDResponse> localVarResp = podCreateLibpodWithHttpInfo(create);
            return localVarResp.getData();
        }

        /**
         * Execute podCreateLibpod request with HTTP info returned
         * @return ApiResponse&lt;IDResponse&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td>  </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> status conflict </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<IDResponse> executeWithHttpInfo() throws ApiException {
            return podCreateLibpodWithHttpInfo(create);
        }

        /**
         * Execute podCreateLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td>  </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> status conflict </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<IDResponse> _callback) throws ApiException {
            return podCreateLibpodAsync(create, _callback);
        }
    }

    /**
     * Create a pod
     * 
     * @return APIpodCreateLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td>  </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> status conflict </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIpodCreateLibpodRequest podCreateLibpod() {
        return new APIpodCreateLibpodRequest();
    }
    private okhttp3.Call podDeleteLibpodCall(String name, Boolean force, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/pods/{name}"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (force != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("force", force));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call podDeleteLibpodValidateBeforeCall(String name, Boolean force, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling podDeleteLibpod(Async)");
        }

        return podDeleteLibpodCall(name, force, _callback);

    }


    private ApiResponse<PodRmReport> podDeleteLibpodWithHttpInfo( @NotNull String name, Boolean force) throws ApiException {
        okhttp3.Call localVarCall = podDeleteLibpodValidateBeforeCall(name, force, null);
        Type localVarReturnType = new TypeToken<PodRmReport>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call podDeleteLibpodAsync(String name, Boolean force, final ApiCallback<PodRmReport> _callback) throws ApiException {

        okhttp3.Call localVarCall = podDeleteLibpodValidateBeforeCall(name, force, _callback);
        Type localVarReturnType = new TypeToken<PodRmReport>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIpodDeleteLibpodRequest {
        private final String name;
        private Boolean force;

        private APIpodDeleteLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Set force
         * @param force force removal of a running pod by first stopping all containers, then removing all containers in the pod (optional)
         * @return APIpodDeleteLibpodRequest
         */
        public APIpodDeleteLibpodRequest force(Boolean force) {
            this.force = force;
            return this;
        }

        /**
         * Build call for podDeleteLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Rm pod </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return podDeleteLibpodCall(name, force, _callback);
        }

        /**
         * Execute podDeleteLibpod request
         * @return PodRmReport
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Rm pod </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public PodRmReport execute() throws ApiException {
            ApiResponse<PodRmReport> localVarResp = podDeleteLibpodWithHttpInfo(name, force);
            return localVarResp.getData();
        }

        /**
         * Execute podDeleteLibpod request with HTTP info returned
         * @return ApiResponse&lt;PodRmReport&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Rm pod </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<PodRmReport> executeWithHttpInfo() throws ApiException {
            return podDeleteLibpodWithHttpInfo(name, force);
        }

        /**
         * Execute podDeleteLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Rm pod </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<PodRmReport> _callback) throws ApiException {
            return podDeleteLibpodAsync(name, force, _callback);
        }
    }

    /**
     * Remove pod
     * 
     * @param name the name or ID of the pod (required)
     * @return APIpodDeleteLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Rm pod </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIpodDeleteLibpodRequest podDeleteLibpod(String name) {
        return new APIpodDeleteLibpodRequest(name);
    }
    private okhttp3.Call podExistsLibpodCall(String name, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/pods/{name}/exists"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call podExistsLibpodValidateBeforeCall(String name, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling podExistsLibpod(Async)");
        }

        return podExistsLibpodCall(name, _callback);

    }


    private ApiResponse<Void> podExistsLibpodWithHttpInfo( @NotNull String name) throws ApiException {
        okhttp3.Call localVarCall = podExistsLibpodValidateBeforeCall(name, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call podExistsLibpodAsync(String name, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = podExistsLibpodValidateBeforeCall(name, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIpodExistsLibpodRequest {
        private final String name;

        private APIpodExistsLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Build call for podExistsLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> pod exists </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return podExistsLibpodCall(name, _callback);
        }

        /**
         * Execute podExistsLibpod request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> pod exists </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            podExistsLibpodWithHttpInfo(name);
        }

        /**
         * Execute podExistsLibpod request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> pod exists </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return podExistsLibpodWithHttpInfo(name);
        }

        /**
         * Execute podExistsLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> pod exists </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return podExistsLibpodAsync(name, _callback);
        }
    }

    /**
     * Pod exists
     * Check if a pod exists by name or ID
     * @param name the name or ID of the pod (required)
     * @return APIpodExistsLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> pod exists </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIpodExistsLibpodRequest podExistsLibpod(String name) {
        return new APIpodExistsLibpodRequest(name);
    }
    private okhttp3.Call podInspectLibpodCall(String name, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/pods/{name}/json"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call podInspectLibpodValidateBeforeCall(String name, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling podInspectLibpod(Async)");
        }

        return podInspectLibpodCall(name, _callback);

    }


    private ApiResponse<InspectPodData> podInspectLibpodWithHttpInfo( @NotNull String name) throws ApiException {
        okhttp3.Call localVarCall = podInspectLibpodValidateBeforeCall(name, null);
        Type localVarReturnType = new TypeToken<InspectPodData>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call podInspectLibpodAsync(String name, final ApiCallback<InspectPodData> _callback) throws ApiException {

        okhttp3.Call localVarCall = podInspectLibpodValidateBeforeCall(name, _callback);
        Type localVarReturnType = new TypeToken<InspectPodData>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIpodInspectLibpodRequest {
        private final String name;

        private APIpodInspectLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Build call for podInspectLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Inspect pod </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return podInspectLibpodCall(name, _callback);
        }

        /**
         * Execute podInspectLibpod request
         * @return InspectPodData
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Inspect pod </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public InspectPodData execute() throws ApiException {
            ApiResponse<InspectPodData> localVarResp = podInspectLibpodWithHttpInfo(name);
            return localVarResp.getData();
        }

        /**
         * Execute podInspectLibpod request with HTTP info returned
         * @return ApiResponse&lt;InspectPodData&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Inspect pod </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<InspectPodData> executeWithHttpInfo() throws ApiException {
            return podInspectLibpodWithHttpInfo(name);
        }

        /**
         * Execute podInspectLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Inspect pod </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<InspectPodData> _callback) throws ApiException {
            return podInspectLibpodAsync(name, _callback);
        }
    }

    /**
     * Inspect pod
     * 
     * @param name the name or ID of the pod (required)
     * @return APIpodInspectLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Inspect pod </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIpodInspectLibpodRequest podInspectLibpod(String name) {
        return new APIpodInspectLibpodRequest(name);
    }
    private okhttp3.Call podKillLibpodCall(String name, String signal, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/pods/{name}/kill"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (signal != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("signal", signal));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call podKillLibpodValidateBeforeCall(String name, String signal, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling podKillLibpod(Async)");
        }

        return podKillLibpodCall(name, signal, _callback);

    }


    private ApiResponse<PodKillReport> podKillLibpodWithHttpInfo( @NotNull String name, String signal) throws ApiException {
        okhttp3.Call localVarCall = podKillLibpodValidateBeforeCall(name, signal, null);
        Type localVarReturnType = new TypeToken<PodKillReport>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call podKillLibpodAsync(String name, String signal, final ApiCallback<PodKillReport> _callback) throws ApiException {

        okhttp3.Call localVarCall = podKillLibpodValidateBeforeCall(name, signal, _callback);
        Type localVarReturnType = new TypeToken<PodKillReport>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIpodKillLibpodRequest {
        private final String name;
        private String signal;

        private APIpodKillLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Set signal
         * @param signal signal to be sent to pod (optional, default to SIGKILL)
         * @return APIpodKillLibpodRequest
         */
        public APIpodKillLibpodRequest signal(String signal) {
            this.signal = signal;
            return this;
        }

        /**
         * Build call for podKillLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Kill Pod </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Kill Pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return podKillLibpodCall(name, signal, _callback);
        }

        /**
         * Execute podKillLibpod request
         * @return PodKillReport
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Kill Pod </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Kill Pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public PodKillReport execute() throws ApiException {
            ApiResponse<PodKillReport> localVarResp = podKillLibpodWithHttpInfo(name, signal);
            return localVarResp.getData();
        }

        /**
         * Execute podKillLibpod request with HTTP info returned
         * @return ApiResponse&lt;PodKillReport&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Kill Pod </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Kill Pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<PodKillReport> executeWithHttpInfo() throws ApiException {
            return podKillLibpodWithHttpInfo(name, signal);
        }

        /**
         * Execute podKillLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Kill Pod </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Kill Pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<PodKillReport> _callback) throws ApiException {
            return podKillLibpodAsync(name, signal, _callback);
        }
    }

    /**
     * Kill a pod
     * 
     * @param name the name or ID of the pod (required)
     * @return APIpodKillLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Kill Pod </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Kill Pod </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIpodKillLibpodRequest podKillLibpod(String name) {
        return new APIpodKillLibpodRequest(name);
    }
    private okhttp3.Call podListLibpodCall(String filters, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/pods/json";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (filters != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("filters", filters));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call podListLibpodValidateBeforeCall(String filters, final ApiCallback _callback) throws ApiException {
        return podListLibpodCall(filters, _callback);

    }


    private ApiResponse<List<ListPodsReport>> podListLibpodWithHttpInfo(String filters) throws ApiException {
        okhttp3.Call localVarCall = podListLibpodValidateBeforeCall(filters, null);
        Type localVarReturnType = new TypeToken<List<ListPodsReport>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call podListLibpodAsync(String filters, final ApiCallback<List<ListPodsReport>> _callback) throws ApiException {

        okhttp3.Call localVarCall = podListLibpodValidateBeforeCall(filters, _callback);
        Type localVarReturnType = new TypeToken<List<ListPodsReport>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIpodListLibpodRequest {
        private String filters;

        private APIpodListLibpodRequest() {
        }

        /**
         * Set filters
         * @param filters JSON encoded value of the filters (a map[string][]string) to process on the pods list. Available filters:   - &#x60;id&#x3D;&lt;pod-id&gt;&#x60; Matches all of pod id.   - &#x60;label&#x3D;&lt;key&gt;&#x60; or &#x60;label&#x3D;&lt;key&gt;:&lt;value&gt;&#x60; Matches pods based on the presence of a label alone or a label and a value.   - &#x60;name&#x3D;&lt;pod-name&gt;&#x60; Matches all of pod name.   - &#x60;until&#x3D;&lt;timestamp&gt;&#x60; List pods created before this timestamp. The &#x60;&lt;timestamp&gt;&#x60; can be Unix timestamps, date formatted timestamps, or Go duration strings (e.g. &#x60;10m&#x60;, &#x60;1h30m&#x60;) computed relative to the daemon machine’s time.   - &#x60;status&#x3D;&lt;pod-status&gt;&#x60; Pod&#39;s status: &#x60;stopped&#x60;, &#x60;running&#x60;, &#x60;paused&#x60;, &#x60;exited&#x60;, &#x60;dead&#x60;, &#x60;created&#x60;, &#x60;degraded&#x60;.   - &#x60;network&#x3D;&lt;pod-network&gt;&#x60; Name or full ID of network.   - &#x60;ctr-names&#x3D;&lt;pod-ctr-names&gt;&#x60; Container name within the pod.   - &#x60;ctr-ids&#x3D;&lt;pod-ctr-ids&gt;&#x60; Container ID within the pod.   - &#x60;ctr-status&#x3D;&lt;pod-ctr-status&gt;&#x60; Container status within the pod.   - &#x60;ctr-number&#x3D;&lt;pod-ctr-number&gt;&#x60; Number of containers in the pod.  (optional)
         * @return APIpodListLibpodRequest
         */
        public APIpodListLibpodRequest filters(String filters) {
            this.filters = filters;
            return this;
        }

        /**
         * Build call for podListLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List pods </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return podListLibpodCall(filters, _callback);
        }

        /**
         * Execute podListLibpod request
         * @return List&lt;ListPodsReport&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List pods </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public List<ListPodsReport> execute() throws ApiException {
            ApiResponse<List<ListPodsReport>> localVarResp = podListLibpodWithHttpInfo(filters);
            return localVarResp.getData();
        }

        /**
         * Execute podListLibpod request with HTTP info returned
         * @return ApiResponse&lt;List&lt;ListPodsReport&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List pods </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<ListPodsReport>> executeWithHttpInfo() throws ApiException {
            return podListLibpodWithHttpInfo(filters);
        }

        /**
         * Execute podListLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List pods </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<ListPodsReport>> _callback) throws ApiException {
            return podListLibpodAsync(filters, _callback);
        }
    }

    /**
     * List pods
     * 
     * @return APIpodListLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List pods </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIpodListLibpodRequest podListLibpod() {
        return new APIpodListLibpodRequest();
    }
    private okhttp3.Call podPauseLibpodCall(String name, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/pods/{name}/pause"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call podPauseLibpodValidateBeforeCall(String name, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling podPauseLibpod(Async)");
        }

        return podPauseLibpodCall(name, _callback);

    }


    private ApiResponse<PodPauseReport> podPauseLibpodWithHttpInfo( @NotNull String name) throws ApiException {
        okhttp3.Call localVarCall = podPauseLibpodValidateBeforeCall(name, null);
        Type localVarReturnType = new TypeToken<PodPauseReport>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call podPauseLibpodAsync(String name, final ApiCallback<PodPauseReport> _callback) throws ApiException {

        okhttp3.Call localVarCall = podPauseLibpodValidateBeforeCall(name, _callback);
        Type localVarReturnType = new TypeToken<PodPauseReport>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIpodPauseLibpodRequest {
        private final String name;

        private APIpodPauseLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Build call for podPauseLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Pause pod </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Pause pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return podPauseLibpodCall(name, _callback);
        }

        /**
         * Execute podPauseLibpod request
         * @return PodPauseReport
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Pause pod </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Pause pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public PodPauseReport execute() throws ApiException {
            ApiResponse<PodPauseReport> localVarResp = podPauseLibpodWithHttpInfo(name);
            return localVarResp.getData();
        }

        /**
         * Execute podPauseLibpod request with HTTP info returned
         * @return ApiResponse&lt;PodPauseReport&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Pause pod </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Pause pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<PodPauseReport> executeWithHttpInfo() throws ApiException {
            return podPauseLibpodWithHttpInfo(name);
        }

        /**
         * Execute podPauseLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Pause pod </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Pause pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<PodPauseReport> _callback) throws ApiException {
            return podPauseLibpodAsync(name, _callback);
        }
    }

    /**
     * Pause a pod
     * Pause a pod
     * @param name the name or ID of the pod (required)
     * @return APIpodPauseLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Pause pod </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Pause pod </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIpodPauseLibpodRequest podPauseLibpod(String name) {
        return new APIpodPauseLibpodRequest(name);
    }
    private okhttp3.Call podPruneLibpodCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/pods/prune";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call podPruneLibpodValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        return podPruneLibpodCall(_callback);

    }


    private ApiResponse<PodPruneReport> podPruneLibpodWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = podPruneLibpodValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<PodPruneReport>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call podPruneLibpodAsync(final ApiCallback<PodPruneReport> _callback) throws ApiException {

        okhttp3.Call localVarCall = podPruneLibpodValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<PodPruneReport>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIpodPruneLibpodRequest {

        private APIpodPruneLibpodRequest() {
        }

        /**
         * Build call for podPruneLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Prune pod </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> pod already exists </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return podPruneLibpodCall(_callback);
        }

        /**
         * Execute podPruneLibpod request
         * @return PodPruneReport
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Prune pod </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> pod already exists </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public PodPruneReport execute() throws ApiException {
            ApiResponse<PodPruneReport> localVarResp = podPruneLibpodWithHttpInfo();
            return localVarResp.getData();
        }

        /**
         * Execute podPruneLibpod request with HTTP info returned
         * @return ApiResponse&lt;PodPruneReport&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Prune pod </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> pod already exists </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<PodPruneReport> executeWithHttpInfo() throws ApiException {
            return podPruneLibpodWithHttpInfo();
        }

        /**
         * Execute podPruneLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Prune pod </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> pod already exists </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<PodPruneReport> _callback) throws ApiException {
            return podPruneLibpodAsync(_callback);
        }
    }

    /**
     * Prune unused pods
     * 
     * @return APIpodPruneLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Prune pod </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> pod already exists </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIpodPruneLibpodRequest podPruneLibpod() {
        return new APIpodPruneLibpodRequest();
    }
    private okhttp3.Call podRestartLibpodCall(String name, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/pods/{name}/restart"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call podRestartLibpodValidateBeforeCall(String name, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling podRestartLibpod(Async)");
        }

        return podRestartLibpodCall(name, _callback);

    }


    private ApiResponse<PodRestartReport> podRestartLibpodWithHttpInfo( @NotNull String name) throws ApiException {
        okhttp3.Call localVarCall = podRestartLibpodValidateBeforeCall(name, null);
        Type localVarReturnType = new TypeToken<PodRestartReport>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call podRestartLibpodAsync(String name, final ApiCallback<PodRestartReport> _callback) throws ApiException {

        okhttp3.Call localVarCall = podRestartLibpodValidateBeforeCall(name, _callback);
        Type localVarReturnType = new TypeToken<PodRestartReport>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIpodRestartLibpodRequest {
        private final String name;

        private APIpodRestartLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Build call for podRestartLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Restart pod </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Restart pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return podRestartLibpodCall(name, _callback);
        }

        /**
         * Execute podRestartLibpod request
         * @return PodRestartReport
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Restart pod </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Restart pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public PodRestartReport execute() throws ApiException {
            ApiResponse<PodRestartReport> localVarResp = podRestartLibpodWithHttpInfo(name);
            return localVarResp.getData();
        }

        /**
         * Execute podRestartLibpod request with HTTP info returned
         * @return ApiResponse&lt;PodRestartReport&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Restart pod </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Restart pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<PodRestartReport> executeWithHttpInfo() throws ApiException {
            return podRestartLibpodWithHttpInfo(name);
        }

        /**
         * Execute podRestartLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Restart pod </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Restart pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<PodRestartReport> _callback) throws ApiException {
            return podRestartLibpodAsync(name, _callback);
        }
    }

    /**
     * Restart a pod
     * 
     * @param name the name or ID of the pod (required)
     * @return APIpodRestartLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Restart pod </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Restart pod </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIpodRestartLibpodRequest podRestartLibpod(String name) {
        return new APIpodRestartLibpodRequest(name);
    }
    private okhttp3.Call podStartLibpodCall(String name, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/pods/{name}/start"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call podStartLibpodValidateBeforeCall(String name, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling podStartLibpod(Async)");
        }

        return podStartLibpodCall(name, _callback);

    }


    private ApiResponse<PodStartReport> podStartLibpodWithHttpInfo( @NotNull String name) throws ApiException {
        okhttp3.Call localVarCall = podStartLibpodValidateBeforeCall(name, null);
        Type localVarReturnType = new TypeToken<PodStartReport>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call podStartLibpodAsync(String name, final ApiCallback<PodStartReport> _callback) throws ApiException {

        okhttp3.Call localVarCall = podStartLibpodValidateBeforeCall(name, _callback);
        Type localVarReturnType = new TypeToken<PodStartReport>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIpodStartLibpodRequest {
        private final String name;

        private APIpodStartLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Build call for podStartLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Start pod </td><td>  -  </td></tr>
            <tr><td> 304 </td><td> Pod already started </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Start pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return podStartLibpodCall(name, _callback);
        }

        /**
         * Execute podStartLibpod request
         * @return PodStartReport
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Start pod </td><td>  -  </td></tr>
            <tr><td> 304 </td><td> Pod already started </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Start pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public PodStartReport execute() throws ApiException {
            ApiResponse<PodStartReport> localVarResp = podStartLibpodWithHttpInfo(name);
            return localVarResp.getData();
        }

        /**
         * Execute podStartLibpod request with HTTP info returned
         * @return ApiResponse&lt;PodStartReport&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Start pod </td><td>  -  </td></tr>
            <tr><td> 304 </td><td> Pod already started </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Start pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<PodStartReport> executeWithHttpInfo() throws ApiException {
            return podStartLibpodWithHttpInfo(name);
        }

        /**
         * Execute podStartLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Start pod </td><td>  -  </td></tr>
            <tr><td> 304 </td><td> Pod already started </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Start pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<PodStartReport> _callback) throws ApiException {
            return podStartLibpodAsync(name, _callback);
        }
    }

    /**
     * Start a pod
     * 
     * @param name the name or ID of the pod (required)
     * @return APIpodStartLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Start pod </td><td>  -  </td></tr>
        <tr><td> 304 </td><td> Pod already started </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Start pod </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIpodStartLibpodRequest podStartLibpod(String name) {
        return new APIpodStartLibpodRequest(name);
    }
    private okhttp3.Call podStatsAllLibpodCall(Boolean all, List<String> namesOrIDs, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/pods/stats";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (all != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("all", all));
        }

        if (namesOrIDs != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "namesOrIDs", namesOrIDs));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call podStatsAllLibpodValidateBeforeCall(Boolean all, List<String> namesOrIDs, final ApiCallback _callback) throws ApiException {
        return podStatsAllLibpodCall(all, namesOrIDs, _callback);

    }


    private ApiResponse<List<PodStatsReport>> podStatsAllLibpodWithHttpInfo(Boolean all, List<String> namesOrIDs) throws ApiException {
        okhttp3.Call localVarCall = podStatsAllLibpodValidateBeforeCall(all, namesOrIDs, null);
        Type localVarReturnType = new TypeToken<List<PodStatsReport>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call podStatsAllLibpodAsync(Boolean all, List<String> namesOrIDs, final ApiCallback<List<PodStatsReport>> _callback) throws ApiException {

        okhttp3.Call localVarCall = podStatsAllLibpodValidateBeforeCall(all, namesOrIDs, _callback);
        Type localVarReturnType = new TypeToken<List<PodStatsReport>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIpodStatsAllLibpodRequest {
        private Boolean all;
        private List<String> namesOrIDs;

        private APIpodStatsAllLibpodRequest() {
        }

        /**
         * Set all
         * @param all Provide statistics for all running pods. (optional)
         * @return APIpodStatsAllLibpodRequest
         */
        public APIpodStatsAllLibpodRequest all(Boolean all) {
            this.all = all;
            return this;
        }

        /**
         * Set namesOrIDs
         * @param namesOrIDs Names or IDs of pods. (optional)
         * @return APIpodStatsAllLibpodRequest
         */
        public APIpodStatsAllLibpodRequest namesOrIDs(List<String> namesOrIDs) {
            this.namesOrIDs = namesOrIDs;
            return this;
        }

        /**
         * Build call for podStatsAllLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Pod Statistics </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return podStatsAllLibpodCall(all, namesOrIDs, _callback);
        }

        /**
         * Execute podStatsAllLibpod request
         * @return List&lt;PodStatsReport&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Pod Statistics </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public List<PodStatsReport> execute() throws ApiException {
            ApiResponse<List<PodStatsReport>> localVarResp = podStatsAllLibpodWithHttpInfo(all, namesOrIDs);
            return localVarResp.getData();
        }

        /**
         * Execute podStatsAllLibpod request with HTTP info returned
         * @return ApiResponse&lt;List&lt;PodStatsReport&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Pod Statistics </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<PodStatsReport>> executeWithHttpInfo() throws ApiException {
            return podStatsAllLibpodWithHttpInfo(all, namesOrIDs);
        }

        /**
         * Execute podStatsAllLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Pod Statistics </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<PodStatsReport>> _callback) throws ApiException {
            return podStatsAllLibpodAsync(all, namesOrIDs, _callback);
        }
    }

    /**
     * Statistics for one or more pods
     * Display a live stream of resource usage statistics for the containers in one or more pods
     * @return APIpodStatsAllLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Pod Statistics </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIpodStatsAllLibpodRequest podStatsAllLibpod() {
        return new APIpodStatsAllLibpodRequest();
    }
    private okhttp3.Call podStopLibpodCall(String name, Integer t, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/pods/{name}/stop"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (t != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("t", t));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call podStopLibpodValidateBeforeCall(String name, Integer t, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling podStopLibpod(Async)");
        }

        return podStopLibpodCall(name, t, _callback);

    }


    private ApiResponse<PodStopReport> podStopLibpodWithHttpInfo( @NotNull String name, Integer t) throws ApiException {
        okhttp3.Call localVarCall = podStopLibpodValidateBeforeCall(name, t, null);
        Type localVarReturnType = new TypeToken<PodStopReport>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call podStopLibpodAsync(String name, Integer t, final ApiCallback<PodStopReport> _callback) throws ApiException {

        okhttp3.Call localVarCall = podStopLibpodValidateBeforeCall(name, t, _callback);
        Type localVarReturnType = new TypeToken<PodStopReport>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIpodStopLibpodRequest {
        private final String name;
        private Integer t;

        private APIpodStopLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Set t
         * @param t timeout (optional)
         * @return APIpodStopLibpodRequest
         */
        public APIpodStopLibpodRequest t(Integer t) {
            this.t = t;
            return this;
        }

        /**
         * Build call for podStopLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Stop pod </td><td>  -  </td></tr>
            <tr><td> 304 </td><td> Pod already stopped </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Stop pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return podStopLibpodCall(name, t, _callback);
        }

        /**
         * Execute podStopLibpod request
         * @return PodStopReport
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Stop pod </td><td>  -  </td></tr>
            <tr><td> 304 </td><td> Pod already stopped </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Stop pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public PodStopReport execute() throws ApiException {
            ApiResponse<PodStopReport> localVarResp = podStopLibpodWithHttpInfo(name, t);
            return localVarResp.getData();
        }

        /**
         * Execute podStopLibpod request with HTTP info returned
         * @return ApiResponse&lt;PodStopReport&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Stop pod </td><td>  -  </td></tr>
            <tr><td> 304 </td><td> Pod already stopped </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Stop pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<PodStopReport> executeWithHttpInfo() throws ApiException {
            return podStopLibpodWithHttpInfo(name, t);
        }

        /**
         * Execute podStopLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Stop pod </td><td>  -  </td></tr>
            <tr><td> 304 </td><td> Pod already stopped </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Stop pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<PodStopReport> _callback) throws ApiException {
            return podStopLibpodAsync(name, t, _callback);
        }
    }

    /**
     * Stop a pod
     * 
     * @param name the name or ID of the pod (required)
     * @return APIpodStopLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Stop pod </td><td>  -  </td></tr>
        <tr><td> 304 </td><td> Pod already stopped </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Stop pod </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIpodStopLibpodRequest podStopLibpod(String name) {
        return new APIpodStopLibpodRequest(name);
    }
    private okhttp3.Call podTopLibpodCall(String name, Boolean stream, Integer delay, String psArgs, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/pods/{name}/top"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (stream != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("stream", stream));
        }

        if (delay != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("delay", delay));
        }

        if (psArgs != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("ps_args", psArgs));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call podTopLibpodValidateBeforeCall(String name, Boolean stream, Integer delay, String psArgs, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling podTopLibpod(Async)");
        }

        return podTopLibpodCall(name, stream, delay, psArgs, _callback);

    }


    private ApiResponse<PodTopOKBody> podTopLibpodWithHttpInfo( @NotNull String name, Boolean stream, Integer delay, String psArgs) throws ApiException {
        okhttp3.Call localVarCall = podTopLibpodValidateBeforeCall(name, stream, delay, psArgs, null);
        Type localVarReturnType = new TypeToken<PodTopOKBody>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call podTopLibpodAsync(String name, Boolean stream, Integer delay, String psArgs, final ApiCallback<PodTopOKBody> _callback) throws ApiException {

        okhttp3.Call localVarCall = podTopLibpodValidateBeforeCall(name, stream, delay, psArgs, _callback);
        Type localVarReturnType = new TypeToken<PodTopOKBody>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIpodTopLibpodRequest {
        private final String name;
        private Boolean stream;
        private Integer delay;
        private String psArgs;

        private APIpodTopLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Set stream
         * @param stream when true, repeatedly stream the latest output (As of version 4.0) (optional)
         * @return APIpodTopLibpodRequest
         */
        public APIpodTopLibpodRequest stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        /**
         * Set delay
         * @param delay if streaming, delay in seconds between updates. Must be &gt;1. (As of version 4.0) (optional, default to 5)
         * @return APIpodTopLibpodRequest
         */
        public APIpodTopLibpodRequest delay(Integer delay) {
            this.delay = delay;
            return this;
        }

        /**
         * Set psArgs
         * @param psArgs arguments to pass to ps such as aux.  (optional)
         * @return APIpodTopLibpodRequest
         */
        public APIpodTopLibpodRequest psArgs(String psArgs) {
            this.psArgs = psArgs;
            return this;
        }

        /**
         * Build call for podTopLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List processes in pod </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return podTopLibpodCall(name, stream, delay, psArgs, _callback);
        }

        /**
         * Execute podTopLibpod request
         * @return PodTopOKBody
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List processes in pod </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public PodTopOKBody execute() throws ApiException {
            ApiResponse<PodTopOKBody> localVarResp = podTopLibpodWithHttpInfo(name, stream, delay, psArgs);
            return localVarResp.getData();
        }

        /**
         * Execute podTopLibpod request with HTTP info returned
         * @return ApiResponse&lt;PodTopOKBody&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List processes in pod </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<PodTopOKBody> executeWithHttpInfo() throws ApiException {
            return podTopLibpodWithHttpInfo(name, stream, delay, psArgs);
        }

        /**
         * Execute podTopLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List processes in pod </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<PodTopOKBody> _callback) throws ApiException {
            return podTopLibpodAsync(name, stream, delay, psArgs, _callback);
        }
    }

    /**
     * List processes
     * List processes running inside a pod
     * @param name Name of pod to query for processes (required)
     * @return APIpodTopLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List processes in pod </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIpodTopLibpodRequest podTopLibpod(String name) {
        return new APIpodTopLibpodRequest(name);
    }
    private okhttp3.Call podUnpauseLibpodCall(String name, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/pods/{name}/unpause"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call podUnpauseLibpodValidateBeforeCall(String name, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling podUnpauseLibpod(Async)");
        }

        return podUnpauseLibpodCall(name, _callback);

    }


    private ApiResponse<PodUnpauseReport> podUnpauseLibpodWithHttpInfo( @NotNull String name) throws ApiException {
        okhttp3.Call localVarCall = podUnpauseLibpodValidateBeforeCall(name, null);
        Type localVarReturnType = new TypeToken<PodUnpauseReport>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call podUnpauseLibpodAsync(String name, final ApiCallback<PodUnpauseReport> _callback) throws ApiException {

        okhttp3.Call localVarCall = podUnpauseLibpodValidateBeforeCall(name, _callback);
        Type localVarReturnType = new TypeToken<PodUnpauseReport>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIpodUnpauseLibpodRequest {
        private final String name;

        private APIpodUnpauseLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Build call for podUnpauseLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Unpause pod </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Unpause pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return podUnpauseLibpodCall(name, _callback);
        }

        /**
         * Execute podUnpauseLibpod request
         * @return PodUnpauseReport
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Unpause pod </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Unpause pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public PodUnpauseReport execute() throws ApiException {
            ApiResponse<PodUnpauseReport> localVarResp = podUnpauseLibpodWithHttpInfo(name);
            return localVarResp.getData();
        }

        /**
         * Execute podUnpauseLibpod request with HTTP info returned
         * @return ApiResponse&lt;PodUnpauseReport&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Unpause pod </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Unpause pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<PodUnpauseReport> executeWithHttpInfo() throws ApiException {
            return podUnpauseLibpodWithHttpInfo(name);
        }

        /**
         * Execute podUnpauseLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Unpause pod </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Unpause pod </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<PodUnpauseReport> _callback) throws ApiException {
            return podUnpauseLibpodAsync(name, _callback);
        }
    }

    /**
     * Unpause a pod
     * 
     * @param name the name or ID of the pod (required)
     * @return APIpodUnpauseLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Unpause pod </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such pod </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Unpause pod </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIpodUnpauseLibpodRequest podUnpauseLibpod(String name) {
        return new APIpodUnpauseLibpodRequest(name);
    }
}
