/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.api;

import com.google.gson.reflect.TypeToken;
import io.github.pod4dev.libpodj.ApiCallback;
import io.github.pod4dev.libpodj.ApiClient;
import io.github.pod4dev.libpodj.ApiException;
import io.github.pod4dev.libpodj.ApiResponse;
import io.github.pod4dev.libpodj.Configuration;
import io.github.pod4dev.libpodj.Pair;
import io.github.pod4dev.libpodj.model.IDResponse;
import io.github.pod4dev.libpodj.model.InspectPodData;
import io.github.pod4dev.libpodj.model.ListPodsReport;
import io.github.pod4dev.libpodj.model.PlayKubeReport;
import io.github.pod4dev.libpodj.model.PodKillReport;
import io.github.pod4dev.libpodj.model.PodPauseReport;
import io.github.pod4dev.libpodj.model.PodPruneReport;
import io.github.pod4dev.libpodj.model.PodRestartReport;
import io.github.pod4dev.libpodj.model.PodRmReport;
import io.github.pod4dev.libpodj.model.PodSpecGenerator;
import io.github.pod4dev.libpodj.model.PodStartReport;
import io.github.pod4dev.libpodj.model.PodStatsReport;
import io.github.pod4dev.libpodj.model.PodStopReport;
import io.github.pod4dev.libpodj.model.PodTopOKBody;
import io.github.pod4dev.libpodj.model.PodUnpauseReport;
import jakarta.validation.constraints.NotNull;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Call;

public class PodsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public PodsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PodsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call generateKubeLibpod_0Call(List<String> names, Boolean service, String type, Integer replicas, Boolean noTrunc, Boolean podmanOnly, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/generate/kube";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (names != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "names", names));
        }
        if (service != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("service", service));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if (replicas != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("replicas", replicas));
        }
        if (noTrunc != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("noTrunc", noTrunc));
        }
        if (podmanOnly != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("podmanOnly", podmanOnly));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"text/vnd.yaml", "application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call generateKubeLibpod_0ValidateBeforeCall(List<String> names, Boolean service, String type, Integer replicas, Boolean noTrunc, Boolean podmanOnly, ApiCallback _callback) throws ApiException {
        if (names == null) {
            throw new ApiException("Missing the required parameter 'names' when calling generateKubeLibpod_0(Async)");
        }
        return this.generateKubeLibpod_0Call(names, service, type, replicas, noTrunc, podmanOnly, _callback);
    }

    private ApiResponse<File> generateKubeLibpod_0WithHttpInfo(@NotNull List<String> names, Boolean service, String type, Integer replicas, Boolean noTrunc, Boolean podmanOnly) throws ApiException {
        Call localVarCall = this.generateKubeLibpod_0ValidateBeforeCall(names, service, type, replicas, noTrunc, podmanOnly, null);
        Type localVarReturnType = new TypeToken<File>(this){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call generateKubeLibpod_0Async(List<String> names, Boolean service, String type, Integer replicas, Boolean noTrunc, Boolean podmanOnly, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.generateKubeLibpod_0ValidateBeforeCall(names, service, type, replicas, noTrunc, podmanOnly, _callback);
        Type localVarReturnType = new TypeToken<File>(this){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgenerateKubeLibpod_0Request generateKubeLibpod_0(List<String> names) {
        return new APIgenerateKubeLibpod_0Request(names);
    }

    private Call generateSystemdLibpod_0Call(String name, Boolean useName, Boolean _new, Boolean noHeader, Integer startTimeout, Integer stopTimeout, String restartPolicy, String containerPrefix, String podPrefix, String separator, Integer restartSec, List<String> wants, List<String> after, List<String> requires, List<String> additionalEnvVariables, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/generate/{name}/systemd".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (useName != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("useName", useName));
        }
        if (_new != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("new", _new));
        }
        if (noHeader != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("noHeader", noHeader));
        }
        if (startTimeout != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("startTimeout", startTimeout));
        }
        if (stopTimeout != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("stopTimeout", stopTimeout));
        }
        if (restartPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("restartPolicy", restartPolicy));
        }
        if (containerPrefix != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("containerPrefix", containerPrefix));
        }
        if (podPrefix != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("podPrefix", podPrefix));
        }
        if (separator != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("separator", separator));
        }
        if (restartSec != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("restartSec", restartSec));
        }
        if (wants != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "wants", wants));
        }
        if (after != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "after", after));
        }
        if (requires != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "requires", requires));
        }
        if (additionalEnvVariables != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "additionalEnvVariables", additionalEnvVariables));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call generateSystemdLibpod_0ValidateBeforeCall(String name, Boolean useName, Boolean _new, Boolean noHeader, Integer startTimeout, Integer stopTimeout, String restartPolicy, String containerPrefix, String podPrefix, String separator, Integer restartSec, List<String> wants, List<String> after, List<String> requires, List<String> additionalEnvVariables, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling generateSystemdLibpod_0(Async)");
        }
        return this.generateSystemdLibpod_0Call(name, useName, _new, noHeader, startTimeout, stopTimeout, restartPolicy, containerPrefix, podPrefix, separator, restartSec, wants, after, requires, additionalEnvVariables, _callback);
    }

    private ApiResponse<Map<String, String>> generateSystemdLibpod_0WithHttpInfo(@NotNull String name, Boolean useName, Boolean _new, Boolean noHeader, Integer startTimeout, Integer stopTimeout, String restartPolicy, String containerPrefix, String podPrefix, String separator, Integer restartSec, List<String> wants, List<String> after, List<String> requires, List<String> additionalEnvVariables) throws ApiException {
        Call localVarCall = this.generateSystemdLibpod_0ValidateBeforeCall(name, useName, _new, noHeader, startTimeout, stopTimeout, restartPolicy, containerPrefix, podPrefix, separator, restartSec, wants, after, requires, additionalEnvVariables, null);
        Type localVarReturnType = new TypeToken<Map<String, String>>(this){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call generateSystemdLibpod_0Async(String name, Boolean useName, Boolean _new, Boolean noHeader, Integer startTimeout, Integer stopTimeout, String restartPolicy, String containerPrefix, String podPrefix, String separator, Integer restartSec, List<String> wants, List<String> after, List<String> requires, List<String> additionalEnvVariables, ApiCallback<Map<String, String>> _callback) throws ApiException {
        Call localVarCall = this.generateSystemdLibpod_0ValidateBeforeCall(name, useName, _new, noHeader, startTimeout, stopTimeout, restartPolicy, containerPrefix, podPrefix, separator, restartSec, wants, after, requires, additionalEnvVariables, _callback);
        Type localVarReturnType = new TypeToken<Map<String, String>>(this){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgenerateSystemdLibpod_0Request generateSystemdLibpod_0(String name) {
        return new APIgenerateSystemdLibpod_0Request(name);
    }

    private Call kubeApplyLibpod_0Call(String caCertFile, String kubeConfig, String namespace, Boolean service, String _file, String request, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        String localVarPostBody = request;
        String localVarPath = "/libpod/kube/apply";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (caCertFile != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("caCertFile", caCertFile));
        }
        if (kubeConfig != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("kubeConfig", kubeConfig));
        }
        if (namespace != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("namespace", namespace));
        }
        if (service != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("service", service));
        }
        if (_file != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("file", _file));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/x-tar"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call kubeApplyLibpod_0ValidateBeforeCall(String caCertFile, String kubeConfig, String namespace, Boolean service, String _file, String request, ApiCallback _callback) throws ApiException {
        return this.kubeApplyLibpod_0Call(caCertFile, kubeConfig, namespace, service, _file, request, _callback);
    }

    private ApiResponse<File> kubeApplyLibpod_0WithHttpInfo(String caCertFile, String kubeConfig, String namespace, Boolean service, String _file, String request) throws ApiException {
        Call localVarCall = this.kubeApplyLibpod_0ValidateBeforeCall(caCertFile, kubeConfig, namespace, service, _file, request, null);
        Type localVarReturnType = new TypeToken<File>(this){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call kubeApplyLibpod_0Async(String caCertFile, String kubeConfig, String namespace, Boolean service, String _file, String request, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.kubeApplyLibpod_0ValidateBeforeCall(caCertFile, kubeConfig, namespace, service, _file, request, _callback);
        Type localVarReturnType = new TypeToken<File>(this){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIkubeApplyLibpod_0Request kubeApplyLibpod_0() {
        return new APIkubeApplyLibpod_0Request();
    }

    private Call playKubeDownLibpod_0Call(String contentType, Boolean force, String request, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        String localVarPostBody = request;
        String localVarPath = "/libpod/play/kube";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", this.localVarApiClient.parameterToString(contentType));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"text/plain", "application/x-tar"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call playKubeDownLibpod_0ValidateBeforeCall(String contentType, Boolean force, String request, ApiCallback _callback) throws ApiException {
        return this.playKubeDownLibpod_0Call(contentType, force, request, _callback);
    }

    private ApiResponse<PlayKubeReport> playKubeDownLibpod_0WithHttpInfo(String contentType, Boolean force, String request) throws ApiException {
        Call localVarCall = this.playKubeDownLibpod_0ValidateBeforeCall(contentType, force, request, null);
        Type localVarReturnType = new TypeToken<PlayKubeReport>(this){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call playKubeDownLibpod_0Async(String contentType, Boolean force, String request, ApiCallback<PlayKubeReport> _callback) throws ApiException {
        Call localVarCall = this.playKubeDownLibpod_0ValidateBeforeCall(contentType, force, request, _callback);
        Type localVarReturnType = new TypeToken<PlayKubeReport>(this){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIplayKubeDownLibpod_0Request playKubeDownLibpod_0() {
        return new APIplayKubeDownLibpod_0Request();
    }

    private Call playKubeLibpod_0Call(String contentType, String annotations, String logDriver, List<String> logOptions, List<String> network, Boolean noHosts, Boolean noTrunc, List<String> publishPorts, Boolean publishAllPorts, Boolean replace, Boolean serviceContainer, Boolean start, List<String> staticIPs, List<String> staticMACs, Boolean tlsVerify, String userns, Boolean wait, Boolean build, String request, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        String localVarPostBody = request;
        String localVarPath = "/libpod/play/kube";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (annotations != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("annotations", annotations));
        }
        if (logDriver != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("logDriver", logDriver));
        }
        if (logOptions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "logOptions", logOptions));
        }
        if (network != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "network", network));
        }
        if (noHosts != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("noHosts", noHosts));
        }
        if (noTrunc != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("noTrunc", noTrunc));
        }
        if (publishPorts != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "publishPorts", publishPorts));
        }
        if (publishAllPorts != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("publishAllPorts", publishAllPorts));
        }
        if (replace != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("replace", replace));
        }
        if (serviceContainer != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("serviceContainer", serviceContainer));
        }
        if (start != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start", start));
        }
        if (staticIPs != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "staticIPs", staticIPs));
        }
        if (staticMACs != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "staticMACs", staticMACs));
        }
        if (tlsVerify != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tlsVerify", tlsVerify));
        }
        if (userns != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("userns", userns));
        }
        if (wait != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("wait", wait));
        }
        if (build != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("build", build));
        }
        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", this.localVarApiClient.parameterToString(contentType));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"text/plain", "application/x-tar"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call playKubeLibpod_0ValidateBeforeCall(String contentType, String annotations, String logDriver, List<String> logOptions, List<String> network, Boolean noHosts, Boolean noTrunc, List<String> publishPorts, Boolean publishAllPorts, Boolean replace, Boolean serviceContainer, Boolean start, List<String> staticIPs, List<String> staticMACs, Boolean tlsVerify, String userns, Boolean wait, Boolean build, String request, ApiCallback _callback) throws ApiException {
        return this.playKubeLibpod_0Call(contentType, annotations, logDriver, logOptions, network, noHosts, noTrunc, publishPorts, publishAllPorts, replace, serviceContainer, start, staticIPs, staticMACs, tlsVerify, userns, wait, build, request, _callback);
    }

    private ApiResponse<PlayKubeReport> playKubeLibpod_0WithHttpInfo(String contentType, String annotations, String logDriver, List<String> logOptions, List<String> network, Boolean noHosts, Boolean noTrunc, List<String> publishPorts, Boolean publishAllPorts, Boolean replace, Boolean serviceContainer, Boolean start, List<String> staticIPs, List<String> staticMACs, Boolean tlsVerify, String userns, Boolean wait, Boolean build, String request) throws ApiException {
        Call localVarCall = this.playKubeLibpod_0ValidateBeforeCall(contentType, annotations, logDriver, logOptions, network, noHosts, noTrunc, publishPorts, publishAllPorts, replace, serviceContainer, start, staticIPs, staticMACs, tlsVerify, userns, wait, build, request, null);
        Type localVarReturnType = new TypeToken<PlayKubeReport>(this){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call playKubeLibpod_0Async(String contentType, String annotations, String logDriver, List<String> logOptions, List<String> network, Boolean noHosts, Boolean noTrunc, List<String> publishPorts, Boolean publishAllPorts, Boolean replace, Boolean serviceContainer, Boolean start, List<String> staticIPs, List<String> staticMACs, Boolean tlsVerify, String userns, Boolean wait, Boolean build, String request, ApiCallback<PlayKubeReport> _callback) throws ApiException {
        Call localVarCall = this.playKubeLibpod_0ValidateBeforeCall(contentType, annotations, logDriver, logOptions, network, noHosts, noTrunc, publishPorts, publishAllPorts, replace, serviceContainer, start, staticIPs, staticMACs, tlsVerify, userns, wait, build, request, _callback);
        Type localVarReturnType = new TypeToken<PlayKubeReport>(this){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIplayKubeLibpod_0Request playKubeLibpod_0() {
        return new APIplayKubeLibpod_0Request();
    }

    private Call podCreateLibpodCall(PodSpecGenerator create, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        PodSpecGenerator localVarPostBody = create;
        String localVarPath = "/libpod/pods/create";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/x-tar"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call podCreateLibpodValidateBeforeCall(PodSpecGenerator create, ApiCallback _callback) throws ApiException {
        return this.podCreateLibpodCall(create, _callback);
    }

    private ApiResponse<IDResponse> podCreateLibpodWithHttpInfo(PodSpecGenerator create) throws ApiException {
        Call localVarCall = this.podCreateLibpodValidateBeforeCall(create, null);
        Type localVarReturnType = new TypeToken<IDResponse>(this){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call podCreateLibpodAsync(PodSpecGenerator create, ApiCallback<IDResponse> _callback) throws ApiException {
        Call localVarCall = this.podCreateLibpodValidateBeforeCall(create, _callback);
        Type localVarReturnType = new TypeToken<IDResponse>(this){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpodCreateLibpodRequest podCreateLibpod() {
        return new APIpodCreateLibpodRequest();
    }

    private Call podDeleteLibpodCall(String name, Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/pods/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call podDeleteLibpodValidateBeforeCall(String name, Boolean force, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling podDeleteLibpod(Async)");
        }
        return this.podDeleteLibpodCall(name, force, _callback);
    }

    private ApiResponse<PodRmReport> podDeleteLibpodWithHttpInfo(@NotNull String name, Boolean force) throws ApiException {
        Call localVarCall = this.podDeleteLibpodValidateBeforeCall(name, force, null);
        Type localVarReturnType = new TypeToken<PodRmReport>(this){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call podDeleteLibpodAsync(String name, Boolean force, ApiCallback<PodRmReport> _callback) throws ApiException {
        Call localVarCall = this.podDeleteLibpodValidateBeforeCall(name, force, _callback);
        Type localVarReturnType = new TypeToken<PodRmReport>(this){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpodDeleteLibpodRequest podDeleteLibpod(String name) {
        return new APIpodDeleteLibpodRequest(name);
    }

    private Call podExistsLibpodCall(String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/pods/{name}/exists".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call podExistsLibpodValidateBeforeCall(String name, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling podExistsLibpod(Async)");
        }
        return this.podExistsLibpodCall(name, _callback);
    }

    private ApiResponse<Void> podExistsLibpodWithHttpInfo(@NotNull String name) throws ApiException {
        Call localVarCall = this.podExistsLibpodValidateBeforeCall(name, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call podExistsLibpodAsync(String name, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.podExistsLibpodValidateBeforeCall(name, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIpodExistsLibpodRequest podExistsLibpod(String name) {
        return new APIpodExistsLibpodRequest(name);
    }

    private Call podInspectLibpodCall(String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/pods/{name}/json".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call podInspectLibpodValidateBeforeCall(String name, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling podInspectLibpod(Async)");
        }
        return this.podInspectLibpodCall(name, _callback);
    }

    private ApiResponse<InspectPodData> podInspectLibpodWithHttpInfo(@NotNull String name) throws ApiException {
        Call localVarCall = this.podInspectLibpodValidateBeforeCall(name, null);
        Type localVarReturnType = new TypeToken<InspectPodData>(this){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call podInspectLibpodAsync(String name, ApiCallback<InspectPodData> _callback) throws ApiException {
        Call localVarCall = this.podInspectLibpodValidateBeforeCall(name, _callback);
        Type localVarReturnType = new TypeToken<InspectPodData>(this){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpodInspectLibpodRequest podInspectLibpod(String name) {
        return new APIpodInspectLibpodRequest(name);
    }

    private Call podKillLibpodCall(String name, String signal, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/pods/{name}/kill".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (signal != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("signal", signal));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call podKillLibpodValidateBeforeCall(String name, String signal, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling podKillLibpod(Async)");
        }
        return this.podKillLibpodCall(name, signal, _callback);
    }

    private ApiResponse<PodKillReport> podKillLibpodWithHttpInfo(@NotNull String name, String signal) throws ApiException {
        Call localVarCall = this.podKillLibpodValidateBeforeCall(name, signal, null);
        Type localVarReturnType = new TypeToken<PodKillReport>(this){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call podKillLibpodAsync(String name, String signal, ApiCallback<PodKillReport> _callback) throws ApiException {
        Call localVarCall = this.podKillLibpodValidateBeforeCall(name, signal, _callback);
        Type localVarReturnType = new TypeToken<PodKillReport>(this){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpodKillLibpodRequest podKillLibpod(String name) {
        return new APIpodKillLibpodRequest(name);
    }

    private Call podListLibpodCall(String filters, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/pods/json";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (filters != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filters", filters));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call podListLibpodValidateBeforeCall(String filters, ApiCallback _callback) throws ApiException {
        return this.podListLibpodCall(filters, _callback);
    }

    private ApiResponse<List<ListPodsReport>> podListLibpodWithHttpInfo(String filters) throws ApiException {
        Call localVarCall = this.podListLibpodValidateBeforeCall(filters, null);
        Type localVarReturnType = new TypeToken<List<ListPodsReport>>(this){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call podListLibpodAsync(String filters, ApiCallback<List<ListPodsReport>> _callback) throws ApiException {
        Call localVarCall = this.podListLibpodValidateBeforeCall(filters, _callback);
        Type localVarReturnType = new TypeToken<List<ListPodsReport>>(this){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpodListLibpodRequest podListLibpod() {
        return new APIpodListLibpodRequest();
    }

    private Call podPauseLibpodCall(String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/pods/{name}/pause".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call podPauseLibpodValidateBeforeCall(String name, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling podPauseLibpod(Async)");
        }
        return this.podPauseLibpodCall(name, _callback);
    }

    private ApiResponse<PodPauseReport> podPauseLibpodWithHttpInfo(@NotNull String name) throws ApiException {
        Call localVarCall = this.podPauseLibpodValidateBeforeCall(name, null);
        Type localVarReturnType = new TypeToken<PodPauseReport>(this){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call podPauseLibpodAsync(String name, ApiCallback<PodPauseReport> _callback) throws ApiException {
        Call localVarCall = this.podPauseLibpodValidateBeforeCall(name, _callback);
        Type localVarReturnType = new TypeToken<PodPauseReport>(this){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpodPauseLibpodRequest podPauseLibpod(String name) {
        return new APIpodPauseLibpodRequest(name);
    }

    private Call podPruneLibpodCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/pods/prune";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call podPruneLibpodValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.podPruneLibpodCall(_callback);
    }

    private ApiResponse<PodPruneReport> podPruneLibpodWithHttpInfo() throws ApiException {
        Call localVarCall = this.podPruneLibpodValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<PodPruneReport>(this){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call podPruneLibpodAsync(ApiCallback<PodPruneReport> _callback) throws ApiException {
        Call localVarCall = this.podPruneLibpodValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<PodPruneReport>(this){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpodPruneLibpodRequest podPruneLibpod() {
        return new APIpodPruneLibpodRequest();
    }

    private Call podRestartLibpodCall(String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/pods/{name}/restart".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call podRestartLibpodValidateBeforeCall(String name, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling podRestartLibpod(Async)");
        }
        return this.podRestartLibpodCall(name, _callback);
    }

    private ApiResponse<PodRestartReport> podRestartLibpodWithHttpInfo(@NotNull String name) throws ApiException {
        Call localVarCall = this.podRestartLibpodValidateBeforeCall(name, null);
        Type localVarReturnType = new TypeToken<PodRestartReport>(this){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call podRestartLibpodAsync(String name, ApiCallback<PodRestartReport> _callback) throws ApiException {
        Call localVarCall = this.podRestartLibpodValidateBeforeCall(name, _callback);
        Type localVarReturnType = new TypeToken<PodRestartReport>(this){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpodRestartLibpodRequest podRestartLibpod(String name) {
        return new APIpodRestartLibpodRequest(name);
    }

    private Call podStartLibpodCall(String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/pods/{name}/start".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call podStartLibpodValidateBeforeCall(String name, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling podStartLibpod(Async)");
        }
        return this.podStartLibpodCall(name, _callback);
    }

    private ApiResponse<PodStartReport> podStartLibpodWithHttpInfo(@NotNull String name) throws ApiException {
        Call localVarCall = this.podStartLibpodValidateBeforeCall(name, null);
        Type localVarReturnType = new TypeToken<PodStartReport>(this){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call podStartLibpodAsync(String name, ApiCallback<PodStartReport> _callback) throws ApiException {
        Call localVarCall = this.podStartLibpodValidateBeforeCall(name, _callback);
        Type localVarReturnType = new TypeToken<PodStartReport>(this){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpodStartLibpodRequest podStartLibpod(String name) {
        return new APIpodStartLibpodRequest(name);
    }

    private Call podStatsAllLibpodCall(Boolean all, List<String> namesOrIDs, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/pods/stats";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (all != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("all", all));
        }
        if (namesOrIDs != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "namesOrIDs", namesOrIDs));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call podStatsAllLibpodValidateBeforeCall(Boolean all, List<String> namesOrIDs, ApiCallback _callback) throws ApiException {
        return this.podStatsAllLibpodCall(all, namesOrIDs, _callback);
    }

    private ApiResponse<List<PodStatsReport>> podStatsAllLibpodWithHttpInfo(Boolean all, List<String> namesOrIDs) throws ApiException {
        Call localVarCall = this.podStatsAllLibpodValidateBeforeCall(all, namesOrIDs, null);
        Type localVarReturnType = new TypeToken<List<PodStatsReport>>(this){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call podStatsAllLibpodAsync(Boolean all, List<String> namesOrIDs, ApiCallback<List<PodStatsReport>> _callback) throws ApiException {
        Call localVarCall = this.podStatsAllLibpodValidateBeforeCall(all, namesOrIDs, _callback);
        Type localVarReturnType = new TypeToken<List<PodStatsReport>>(this){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpodStatsAllLibpodRequest podStatsAllLibpod() {
        return new APIpodStatsAllLibpodRequest();
    }

    private Call podStopLibpodCall(String name, Integer t, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/pods/{name}/stop".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (t != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("t", t));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call podStopLibpodValidateBeforeCall(String name, Integer t, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling podStopLibpod(Async)");
        }
        return this.podStopLibpodCall(name, t, _callback);
    }

    private ApiResponse<PodStopReport> podStopLibpodWithHttpInfo(@NotNull String name, Integer t) throws ApiException {
        Call localVarCall = this.podStopLibpodValidateBeforeCall(name, t, null);
        Type localVarReturnType = new TypeToken<PodStopReport>(this){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call podStopLibpodAsync(String name, Integer t, ApiCallback<PodStopReport> _callback) throws ApiException {
        Call localVarCall = this.podStopLibpodValidateBeforeCall(name, t, _callback);
        Type localVarReturnType = new TypeToken<PodStopReport>(this){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpodStopLibpodRequest podStopLibpod(String name) {
        return new APIpodStopLibpodRequest(name);
    }

    private Call podTopLibpodCall(String name, Boolean stream, Integer delay, String psArgs, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/pods/{name}/top".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (stream != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("stream", stream));
        }
        if (delay != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("delay", delay));
        }
        if (psArgs != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ps_args", psArgs));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call podTopLibpodValidateBeforeCall(String name, Boolean stream, Integer delay, String psArgs, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling podTopLibpod(Async)");
        }
        return this.podTopLibpodCall(name, stream, delay, psArgs, _callback);
    }

    private ApiResponse<PodTopOKBody> podTopLibpodWithHttpInfo(@NotNull String name, Boolean stream, Integer delay, String psArgs) throws ApiException {
        Call localVarCall = this.podTopLibpodValidateBeforeCall(name, stream, delay, psArgs, null);
        Type localVarReturnType = new TypeToken<PodTopOKBody>(this){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call podTopLibpodAsync(String name, Boolean stream, Integer delay, String psArgs, ApiCallback<PodTopOKBody> _callback) throws ApiException {
        Call localVarCall = this.podTopLibpodValidateBeforeCall(name, stream, delay, psArgs, _callback);
        Type localVarReturnType = new TypeToken<PodTopOKBody>(this){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpodTopLibpodRequest podTopLibpod(String name) {
        return new APIpodTopLibpodRequest(name);
    }

    private Call podUnpauseLibpodCall(String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/pods/{name}/unpause".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call podUnpauseLibpodValidateBeforeCall(String name, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling podUnpauseLibpod(Async)");
        }
        return this.podUnpauseLibpodCall(name, _callback);
    }

    private ApiResponse<PodUnpauseReport> podUnpauseLibpodWithHttpInfo(@NotNull String name) throws ApiException {
        Call localVarCall = this.podUnpauseLibpodValidateBeforeCall(name, null);
        Type localVarReturnType = new TypeToken<PodUnpauseReport>(this){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call podUnpauseLibpodAsync(String name, ApiCallback<PodUnpauseReport> _callback) throws ApiException {
        Call localVarCall = this.podUnpauseLibpodValidateBeforeCall(name, _callback);
        Type localVarReturnType = new TypeToken<PodUnpauseReport>(this){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpodUnpauseLibpodRequest podUnpauseLibpod(String name) {
        return new APIpodUnpauseLibpodRequest(name);
    }

    public class APIgenerateKubeLibpod_0Request {
        private final List<String> names;
        private Boolean service;
        private String type;
        private Integer replicas;
        private Boolean noTrunc;
        private Boolean podmanOnly;

        private APIgenerateKubeLibpod_0Request(List<String> names) {
            this.names = names;
        }

        public APIgenerateKubeLibpod_0Request service(Boolean service) {
            this.service = service;
            return this;
        }

        public APIgenerateKubeLibpod_0Request type(String type) {
            this.type = type;
            return this;
        }

        public APIgenerateKubeLibpod_0Request replicas(Integer replicas) {
            this.replicas = replicas;
            return this;
        }

        public APIgenerateKubeLibpod_0Request noTrunc(Boolean noTrunc) {
            this.noTrunc = noTrunc;
            return this;
        }

        public APIgenerateKubeLibpod_0Request podmanOnly(Boolean podmanOnly) {
            this.podmanOnly = podmanOnly;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PodsApi.this.generateKubeLibpod_0Call(this.names, this.service, this.type, this.replicas, this.noTrunc, this.podmanOnly, _callback);
        }

        public File execute() throws ApiException {
            ApiResponse<File> localVarResp = PodsApi.this.generateKubeLibpod_0WithHttpInfo(this.names, this.service, this.type, this.replicas, this.noTrunc, this.podmanOnly);
            return localVarResp.getData();
        }

        public ApiResponse<File> executeWithHttpInfo() throws ApiException {
            return PodsApi.this.generateKubeLibpod_0WithHttpInfo(this.names, this.service, this.type, this.replicas, this.noTrunc, this.podmanOnly);
        }

        public Call executeAsync(ApiCallback<File> _callback) throws ApiException {
            return PodsApi.this.generateKubeLibpod_0Async(this.names, this.service, this.type, this.replicas, this.noTrunc, this.podmanOnly, _callback);
        }
    }

    public class APIgenerateSystemdLibpod_0Request {
        private final String name;
        private Boolean useName;
        private Boolean _new;
        private Boolean noHeader;
        private Integer startTimeout;
        private Integer stopTimeout;
        private String restartPolicy;
        private String containerPrefix;
        private String podPrefix;
        private String separator;
        private Integer restartSec;
        private List<String> wants;
        private List<String> after;
        private List<String> requires;
        private List<String> additionalEnvVariables;

        private APIgenerateSystemdLibpod_0Request(String name) {
            this.name = name;
        }

        public APIgenerateSystemdLibpod_0Request useName(Boolean useName) {
            this.useName = useName;
            return this;
        }

        public APIgenerateSystemdLibpod_0Request _new(Boolean _new) {
            this._new = _new;
            return this;
        }

        public APIgenerateSystemdLibpod_0Request noHeader(Boolean noHeader) {
            this.noHeader = noHeader;
            return this;
        }

        public APIgenerateSystemdLibpod_0Request startTimeout(Integer startTimeout) {
            this.startTimeout = startTimeout;
            return this;
        }

        public APIgenerateSystemdLibpod_0Request stopTimeout(Integer stopTimeout) {
            this.stopTimeout = stopTimeout;
            return this;
        }

        public APIgenerateSystemdLibpod_0Request restartPolicy(String restartPolicy) {
            this.restartPolicy = restartPolicy;
            return this;
        }

        public APIgenerateSystemdLibpod_0Request containerPrefix(String containerPrefix) {
            this.containerPrefix = containerPrefix;
            return this;
        }

        public APIgenerateSystemdLibpod_0Request podPrefix(String podPrefix) {
            this.podPrefix = podPrefix;
            return this;
        }

        public APIgenerateSystemdLibpod_0Request separator(String separator) {
            this.separator = separator;
            return this;
        }

        public APIgenerateSystemdLibpod_0Request restartSec(Integer restartSec) {
            this.restartSec = restartSec;
            return this;
        }

        public APIgenerateSystemdLibpod_0Request wants(List<String> wants) {
            this.wants = wants;
            return this;
        }

        public APIgenerateSystemdLibpod_0Request after(List<String> after) {
            this.after = after;
            return this;
        }

        public APIgenerateSystemdLibpod_0Request requires(List<String> requires) {
            this.requires = requires;
            return this;
        }

        public APIgenerateSystemdLibpod_0Request additionalEnvVariables(List<String> additionalEnvVariables) {
            this.additionalEnvVariables = additionalEnvVariables;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PodsApi.this.generateSystemdLibpod_0Call(this.name, this.useName, this._new, this.noHeader, this.startTimeout, this.stopTimeout, this.restartPolicy, this.containerPrefix, this.podPrefix, this.separator, this.restartSec, this.wants, this.after, this.requires, this.additionalEnvVariables, _callback);
        }

        public Map<String, String> execute() throws ApiException {
            ApiResponse<Map<String, String>> localVarResp = PodsApi.this.generateSystemdLibpod_0WithHttpInfo(this.name, this.useName, this._new, this.noHeader, this.startTimeout, this.stopTimeout, this.restartPolicy, this.containerPrefix, this.podPrefix, this.separator, this.restartSec, this.wants, this.after, this.requires, this.additionalEnvVariables);
            return localVarResp.getData();
        }

        public ApiResponse<Map<String, String>> executeWithHttpInfo() throws ApiException {
            return PodsApi.this.generateSystemdLibpod_0WithHttpInfo(this.name, this.useName, this._new, this.noHeader, this.startTimeout, this.stopTimeout, this.restartPolicy, this.containerPrefix, this.podPrefix, this.separator, this.restartSec, this.wants, this.after, this.requires, this.additionalEnvVariables);
        }

        public Call executeAsync(ApiCallback<Map<String, String>> _callback) throws ApiException {
            return PodsApi.this.generateSystemdLibpod_0Async(this.name, this.useName, this._new, this.noHeader, this.startTimeout, this.stopTimeout, this.restartPolicy, this.containerPrefix, this.podPrefix, this.separator, this.restartSec, this.wants, this.after, this.requires, this.additionalEnvVariables, _callback);
        }
    }

    public class APIkubeApplyLibpod_0Request {
        private String caCertFile;
        private String kubeConfig;
        private String namespace;
        private Boolean service;
        private String _file;
        private String request;

        private APIkubeApplyLibpod_0Request() {
        }

        public APIkubeApplyLibpod_0Request caCertFile(String caCertFile) {
            this.caCertFile = caCertFile;
            return this;
        }

        public APIkubeApplyLibpod_0Request kubeConfig(String kubeConfig) {
            this.kubeConfig = kubeConfig;
            return this;
        }

        public APIkubeApplyLibpod_0Request namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public APIkubeApplyLibpod_0Request service(Boolean service) {
            this.service = service;
            return this;
        }

        public APIkubeApplyLibpod_0Request _file(String _file) {
            this._file = _file;
            return this;
        }

        public APIkubeApplyLibpod_0Request request(String request) {
            this.request = request;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PodsApi.this.kubeApplyLibpod_0Call(this.caCertFile, this.kubeConfig, this.namespace, this.service, this._file, this.request, _callback);
        }

        public File execute() throws ApiException {
            ApiResponse<File> localVarResp = PodsApi.this.kubeApplyLibpod_0WithHttpInfo(this.caCertFile, this.kubeConfig, this.namespace, this.service, this._file, this.request);
            return localVarResp.getData();
        }

        public ApiResponse<File> executeWithHttpInfo() throws ApiException {
            return PodsApi.this.kubeApplyLibpod_0WithHttpInfo(this.caCertFile, this.kubeConfig, this.namespace, this.service, this._file, this.request);
        }

        public Call executeAsync(ApiCallback<File> _callback) throws ApiException {
            return PodsApi.this.kubeApplyLibpod_0Async(this.caCertFile, this.kubeConfig, this.namespace, this.service, this._file, this.request, _callback);
        }
    }

    public class APIplayKubeDownLibpod_0Request {
        private String contentType;
        private Boolean force;
        private String request;

        private APIplayKubeDownLibpod_0Request() {
        }

        public APIplayKubeDownLibpod_0Request contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public APIplayKubeDownLibpod_0Request force(Boolean force) {
            this.force = force;
            return this;
        }

        public APIplayKubeDownLibpod_0Request request(String request) {
            this.request = request;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PodsApi.this.playKubeDownLibpod_0Call(this.contentType, this.force, this.request, _callback);
        }

        public PlayKubeReport execute() throws ApiException {
            ApiResponse<PlayKubeReport> localVarResp = PodsApi.this.playKubeDownLibpod_0WithHttpInfo(this.contentType, this.force, this.request);
            return localVarResp.getData();
        }

        public ApiResponse<PlayKubeReport> executeWithHttpInfo() throws ApiException {
            return PodsApi.this.playKubeDownLibpod_0WithHttpInfo(this.contentType, this.force, this.request);
        }

        public Call executeAsync(ApiCallback<PlayKubeReport> _callback) throws ApiException {
            return PodsApi.this.playKubeDownLibpod_0Async(this.contentType, this.force, this.request, _callback);
        }
    }

    public class APIplayKubeLibpod_0Request {
        private String contentType;
        private String annotations;
        private String logDriver;
        private List<String> logOptions;
        private List<String> network;
        private Boolean noHosts;
        private Boolean noTrunc;
        private List<String> publishPorts;
        private Boolean publishAllPorts;
        private Boolean replace;
        private Boolean serviceContainer;
        private Boolean start;
        private List<String> staticIPs;
        private List<String> staticMACs;
        private Boolean tlsVerify;
        private String userns;
        private Boolean wait;
        private Boolean build;
        private String request;

        private APIplayKubeLibpod_0Request() {
        }

        public APIplayKubeLibpod_0Request contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public APIplayKubeLibpod_0Request annotations(String annotations) {
            this.annotations = annotations;
            return this;
        }

        public APIplayKubeLibpod_0Request logDriver(String logDriver) {
            this.logDriver = logDriver;
            return this;
        }

        public APIplayKubeLibpod_0Request logOptions(List<String> logOptions) {
            this.logOptions = logOptions;
            return this;
        }

        public APIplayKubeLibpod_0Request network(List<String> network) {
            this.network = network;
            return this;
        }

        public APIplayKubeLibpod_0Request noHosts(Boolean noHosts) {
            this.noHosts = noHosts;
            return this;
        }

        public APIplayKubeLibpod_0Request noTrunc(Boolean noTrunc) {
            this.noTrunc = noTrunc;
            return this;
        }

        public APIplayKubeLibpod_0Request publishPorts(List<String> publishPorts) {
            this.publishPorts = publishPorts;
            return this;
        }

        public APIplayKubeLibpod_0Request publishAllPorts(Boolean publishAllPorts) {
            this.publishAllPorts = publishAllPorts;
            return this;
        }

        public APIplayKubeLibpod_0Request replace(Boolean replace) {
            this.replace = replace;
            return this;
        }

        public APIplayKubeLibpod_0Request serviceContainer(Boolean serviceContainer) {
            this.serviceContainer = serviceContainer;
            return this;
        }

        public APIplayKubeLibpod_0Request start(Boolean start) {
            this.start = start;
            return this;
        }

        public APIplayKubeLibpod_0Request staticIPs(List<String> staticIPs) {
            this.staticIPs = staticIPs;
            return this;
        }

        public APIplayKubeLibpod_0Request staticMACs(List<String> staticMACs) {
            this.staticMACs = staticMACs;
            return this;
        }

        public APIplayKubeLibpod_0Request tlsVerify(Boolean tlsVerify) {
            this.tlsVerify = tlsVerify;
            return this;
        }

        public APIplayKubeLibpod_0Request userns(String userns) {
            this.userns = userns;
            return this;
        }

        public APIplayKubeLibpod_0Request wait(Boolean wait) {
            this.wait = wait;
            return this;
        }

        public APIplayKubeLibpod_0Request build(Boolean build) {
            this.build = build;
            return this;
        }

        public APIplayKubeLibpod_0Request request(String request) {
            this.request = request;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PodsApi.this.playKubeLibpod_0Call(this.contentType, this.annotations, this.logDriver, this.logOptions, this.network, this.noHosts, this.noTrunc, this.publishPorts, this.publishAllPorts, this.replace, this.serviceContainer, this.start, this.staticIPs, this.staticMACs, this.tlsVerify, this.userns, this.wait, this.build, this.request, _callback);
        }

        public PlayKubeReport execute() throws ApiException {
            ApiResponse<PlayKubeReport> localVarResp = PodsApi.this.playKubeLibpod_0WithHttpInfo(this.contentType, this.annotations, this.logDriver, this.logOptions, this.network, this.noHosts, this.noTrunc, this.publishPorts, this.publishAllPorts, this.replace, this.serviceContainer, this.start, this.staticIPs, this.staticMACs, this.tlsVerify, this.userns, this.wait, this.build, this.request);
            return localVarResp.getData();
        }

        public ApiResponse<PlayKubeReport> executeWithHttpInfo() throws ApiException {
            return PodsApi.this.playKubeLibpod_0WithHttpInfo(this.contentType, this.annotations, this.logDriver, this.logOptions, this.network, this.noHosts, this.noTrunc, this.publishPorts, this.publishAllPorts, this.replace, this.serviceContainer, this.start, this.staticIPs, this.staticMACs, this.tlsVerify, this.userns, this.wait, this.build, this.request);
        }

        public Call executeAsync(ApiCallback<PlayKubeReport> _callback) throws ApiException {
            return PodsApi.this.playKubeLibpod_0Async(this.contentType, this.annotations, this.logDriver, this.logOptions, this.network, this.noHosts, this.noTrunc, this.publishPorts, this.publishAllPorts, this.replace, this.serviceContainer, this.start, this.staticIPs, this.staticMACs, this.tlsVerify, this.userns, this.wait, this.build, this.request, _callback);
        }
    }

    public class APIpodCreateLibpodRequest {
        private PodSpecGenerator create;

        private APIpodCreateLibpodRequest() {
        }

        public APIpodCreateLibpodRequest create(PodSpecGenerator create) {
            this.create = create;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PodsApi.this.podCreateLibpodCall(this.create, _callback);
        }

        public IDResponse execute() throws ApiException {
            ApiResponse<IDResponse> localVarResp = PodsApi.this.podCreateLibpodWithHttpInfo(this.create);
            return localVarResp.getData();
        }

        public ApiResponse<IDResponse> executeWithHttpInfo() throws ApiException {
            return PodsApi.this.podCreateLibpodWithHttpInfo(this.create);
        }

        public Call executeAsync(ApiCallback<IDResponse> _callback) throws ApiException {
            return PodsApi.this.podCreateLibpodAsync(this.create, _callback);
        }
    }

    public class APIpodDeleteLibpodRequest {
        private final String name;
        private Boolean force;

        private APIpodDeleteLibpodRequest(String name) {
            this.name = name;
        }

        public APIpodDeleteLibpodRequest force(Boolean force) {
            this.force = force;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PodsApi.this.podDeleteLibpodCall(this.name, this.force, _callback);
        }

        public PodRmReport execute() throws ApiException {
            ApiResponse<PodRmReport> localVarResp = PodsApi.this.podDeleteLibpodWithHttpInfo(this.name, this.force);
            return localVarResp.getData();
        }

        public ApiResponse<PodRmReport> executeWithHttpInfo() throws ApiException {
            return PodsApi.this.podDeleteLibpodWithHttpInfo(this.name, this.force);
        }

        public Call executeAsync(ApiCallback<PodRmReport> _callback) throws ApiException {
            return PodsApi.this.podDeleteLibpodAsync(this.name, this.force, _callback);
        }
    }

    public class APIpodExistsLibpodRequest {
        private final String name;

        private APIpodExistsLibpodRequest(String name) {
            this.name = name;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PodsApi.this.podExistsLibpodCall(this.name, _callback);
        }

        public void execute() throws ApiException {
            PodsApi.this.podExistsLibpodWithHttpInfo(this.name);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return PodsApi.this.podExistsLibpodWithHttpInfo(this.name);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return PodsApi.this.podExistsLibpodAsync(this.name, _callback);
        }
    }

    public class APIpodInspectLibpodRequest {
        private final String name;

        private APIpodInspectLibpodRequest(String name) {
            this.name = name;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PodsApi.this.podInspectLibpodCall(this.name, _callback);
        }

        public InspectPodData execute() throws ApiException {
            ApiResponse<InspectPodData> localVarResp = PodsApi.this.podInspectLibpodWithHttpInfo(this.name);
            return localVarResp.getData();
        }

        public ApiResponse<InspectPodData> executeWithHttpInfo() throws ApiException {
            return PodsApi.this.podInspectLibpodWithHttpInfo(this.name);
        }

        public Call executeAsync(ApiCallback<InspectPodData> _callback) throws ApiException {
            return PodsApi.this.podInspectLibpodAsync(this.name, _callback);
        }
    }

    public class APIpodKillLibpodRequest {
        private final String name;
        private String signal;

        private APIpodKillLibpodRequest(String name) {
            this.name = name;
        }

        public APIpodKillLibpodRequest signal(String signal) {
            this.signal = signal;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PodsApi.this.podKillLibpodCall(this.name, this.signal, _callback);
        }

        public PodKillReport execute() throws ApiException {
            ApiResponse<PodKillReport> localVarResp = PodsApi.this.podKillLibpodWithHttpInfo(this.name, this.signal);
            return localVarResp.getData();
        }

        public ApiResponse<PodKillReport> executeWithHttpInfo() throws ApiException {
            return PodsApi.this.podKillLibpodWithHttpInfo(this.name, this.signal);
        }

        public Call executeAsync(ApiCallback<PodKillReport> _callback) throws ApiException {
            return PodsApi.this.podKillLibpodAsync(this.name, this.signal, _callback);
        }
    }

    public class APIpodListLibpodRequest {
        private String filters;

        private APIpodListLibpodRequest() {
        }

        public APIpodListLibpodRequest filters(String filters) {
            this.filters = filters;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PodsApi.this.podListLibpodCall(this.filters, _callback);
        }

        public List<ListPodsReport> execute() throws ApiException {
            ApiResponse<List<ListPodsReport>> localVarResp = PodsApi.this.podListLibpodWithHttpInfo(this.filters);
            return localVarResp.getData();
        }

        public ApiResponse<List<ListPodsReport>> executeWithHttpInfo() throws ApiException {
            return PodsApi.this.podListLibpodWithHttpInfo(this.filters);
        }

        public Call executeAsync(ApiCallback<List<ListPodsReport>> _callback) throws ApiException {
            return PodsApi.this.podListLibpodAsync(this.filters, _callback);
        }
    }

    public class APIpodPauseLibpodRequest {
        private final String name;

        private APIpodPauseLibpodRequest(String name) {
            this.name = name;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PodsApi.this.podPauseLibpodCall(this.name, _callback);
        }

        public PodPauseReport execute() throws ApiException {
            ApiResponse<PodPauseReport> localVarResp = PodsApi.this.podPauseLibpodWithHttpInfo(this.name);
            return localVarResp.getData();
        }

        public ApiResponse<PodPauseReport> executeWithHttpInfo() throws ApiException {
            return PodsApi.this.podPauseLibpodWithHttpInfo(this.name);
        }

        public Call executeAsync(ApiCallback<PodPauseReport> _callback) throws ApiException {
            return PodsApi.this.podPauseLibpodAsync(this.name, _callback);
        }
    }

    public class APIpodPruneLibpodRequest {
        private APIpodPruneLibpodRequest() {
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PodsApi.this.podPruneLibpodCall(_callback);
        }

        public PodPruneReport execute() throws ApiException {
            ApiResponse<PodPruneReport> localVarResp = PodsApi.this.podPruneLibpodWithHttpInfo();
            return localVarResp.getData();
        }

        public ApiResponse<PodPruneReport> executeWithHttpInfo() throws ApiException {
            return PodsApi.this.podPruneLibpodWithHttpInfo();
        }

        public Call executeAsync(ApiCallback<PodPruneReport> _callback) throws ApiException {
            return PodsApi.this.podPruneLibpodAsync(_callback);
        }
    }

    public class APIpodRestartLibpodRequest {
        private final String name;

        private APIpodRestartLibpodRequest(String name) {
            this.name = name;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PodsApi.this.podRestartLibpodCall(this.name, _callback);
        }

        public PodRestartReport execute() throws ApiException {
            ApiResponse<PodRestartReport> localVarResp = PodsApi.this.podRestartLibpodWithHttpInfo(this.name);
            return localVarResp.getData();
        }

        public ApiResponse<PodRestartReport> executeWithHttpInfo() throws ApiException {
            return PodsApi.this.podRestartLibpodWithHttpInfo(this.name);
        }

        public Call executeAsync(ApiCallback<PodRestartReport> _callback) throws ApiException {
            return PodsApi.this.podRestartLibpodAsync(this.name, _callback);
        }
    }

    public class APIpodStartLibpodRequest {
        private final String name;

        private APIpodStartLibpodRequest(String name) {
            this.name = name;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PodsApi.this.podStartLibpodCall(this.name, _callback);
        }

        public PodStartReport execute() throws ApiException {
            ApiResponse<PodStartReport> localVarResp = PodsApi.this.podStartLibpodWithHttpInfo(this.name);
            return localVarResp.getData();
        }

        public ApiResponse<PodStartReport> executeWithHttpInfo() throws ApiException {
            return PodsApi.this.podStartLibpodWithHttpInfo(this.name);
        }

        public Call executeAsync(ApiCallback<PodStartReport> _callback) throws ApiException {
            return PodsApi.this.podStartLibpodAsync(this.name, _callback);
        }
    }

    public class APIpodStatsAllLibpodRequest {
        private Boolean all;
        private List<String> namesOrIDs;

        private APIpodStatsAllLibpodRequest() {
        }

        public APIpodStatsAllLibpodRequest all(Boolean all) {
            this.all = all;
            return this;
        }

        public APIpodStatsAllLibpodRequest namesOrIDs(List<String> namesOrIDs) {
            this.namesOrIDs = namesOrIDs;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PodsApi.this.podStatsAllLibpodCall(this.all, this.namesOrIDs, _callback);
        }

        public List<PodStatsReport> execute() throws ApiException {
            ApiResponse<List<PodStatsReport>> localVarResp = PodsApi.this.podStatsAllLibpodWithHttpInfo(this.all, this.namesOrIDs);
            return localVarResp.getData();
        }

        public ApiResponse<List<PodStatsReport>> executeWithHttpInfo() throws ApiException {
            return PodsApi.this.podStatsAllLibpodWithHttpInfo(this.all, this.namesOrIDs);
        }

        public Call executeAsync(ApiCallback<List<PodStatsReport>> _callback) throws ApiException {
            return PodsApi.this.podStatsAllLibpodAsync(this.all, this.namesOrIDs, _callback);
        }
    }

    public class APIpodStopLibpodRequest {
        private final String name;
        private Integer t;

        private APIpodStopLibpodRequest(String name) {
            this.name = name;
        }

        public APIpodStopLibpodRequest t(Integer t) {
            this.t = t;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PodsApi.this.podStopLibpodCall(this.name, this.t, _callback);
        }

        public PodStopReport execute() throws ApiException {
            ApiResponse<PodStopReport> localVarResp = PodsApi.this.podStopLibpodWithHttpInfo(this.name, this.t);
            return localVarResp.getData();
        }

        public ApiResponse<PodStopReport> executeWithHttpInfo() throws ApiException {
            return PodsApi.this.podStopLibpodWithHttpInfo(this.name, this.t);
        }

        public Call executeAsync(ApiCallback<PodStopReport> _callback) throws ApiException {
            return PodsApi.this.podStopLibpodAsync(this.name, this.t, _callback);
        }
    }

    public class APIpodTopLibpodRequest {
        private final String name;
        private Boolean stream;
        private Integer delay;
        private String psArgs;

        private APIpodTopLibpodRequest(String name) {
            this.name = name;
        }

        public APIpodTopLibpodRequest stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        public APIpodTopLibpodRequest delay(Integer delay) {
            this.delay = delay;
            return this;
        }

        public APIpodTopLibpodRequest psArgs(String psArgs) {
            this.psArgs = psArgs;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PodsApi.this.podTopLibpodCall(this.name, this.stream, this.delay, this.psArgs, _callback);
        }

        public PodTopOKBody execute() throws ApiException {
            ApiResponse<PodTopOKBody> localVarResp = PodsApi.this.podTopLibpodWithHttpInfo(this.name, this.stream, this.delay, this.psArgs);
            return localVarResp.getData();
        }

        public ApiResponse<PodTopOKBody> executeWithHttpInfo() throws ApiException {
            return PodsApi.this.podTopLibpodWithHttpInfo(this.name, this.stream, this.delay, this.psArgs);
        }

        public Call executeAsync(ApiCallback<PodTopOKBody> _callback) throws ApiException {
            return PodsApi.this.podTopLibpodAsync(this.name, this.stream, this.delay, this.psArgs, _callback);
        }
    }

    public class APIpodUnpauseLibpodRequest {
        private final String name;

        private APIpodUnpauseLibpodRequest(String name) {
            this.name = name;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return PodsApi.this.podUnpauseLibpodCall(this.name, _callback);
        }

        public PodUnpauseReport execute() throws ApiException {
            ApiResponse<PodUnpauseReport> localVarResp = PodsApi.this.podUnpauseLibpodWithHttpInfo(this.name);
            return localVarResp.getData();
        }

        public ApiResponse<PodUnpauseReport> executeWithHttpInfo() throws ApiException {
            return PodsApi.this.podUnpauseLibpodWithHttpInfo(this.name);
        }

        public Call executeAsync(ApiCallback<PodUnpauseReport> _callback) throws ApiException {
            return PodsApi.this.podUnpauseLibpodAsync(this.name, _callback);
        }
    }
}

