/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.ConfigReference;
import io.github.pod4dev.libpodj.model.IPAM;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CreateOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ATTACHABLE = "Attachable";
    @SerializedName(value="Attachable")
    private Boolean attachable;
    public static final String SERIALIZED_NAME_CONFIG_FROM = "ConfigFrom";
    @SerializedName(value="ConfigFrom")
    private ConfigReference configFrom;
    public static final String SERIALIZED_NAME_CONFIG_ONLY = "ConfigOnly";
    @SerializedName(value="ConfigOnly")
    private Boolean configOnly;
    public static final String SERIALIZED_NAME_DRIVER = "Driver";
    @SerializedName(value="Driver")
    private String driver;
    public static final String SERIALIZED_NAME_ENABLE_I_PV4 = "EnableIPv4";
    @SerializedName(value="EnableIPv4")
    private Boolean enableIPv4;
    public static final String SERIALIZED_NAME_ENABLE_I_PV6 = "EnableIPv6";
    @SerializedName(value="EnableIPv6")
    private Boolean enableIPv6;
    public static final String SERIALIZED_NAME_I_P_A_M = "IPAM";
    @SerializedName(value="IPAM")
    private IPAM ipam;
    public static final String SERIALIZED_NAME_INGRESS = "Ingress";
    @SerializedName(value="Ingress")
    private Boolean ingress;
    public static final String SERIALIZED_NAME_INTERNAL = "Internal";
    @SerializedName(value="Internal")
    private Boolean internal;
    public static final String SERIALIZED_NAME_LABELS = "Labels";
    @SerializedName(value="Labels")
    private Map<String, String> labels = new HashMap<String, String>();
    public static final String SERIALIZED_NAME_OPTIONS = "Options";
    @SerializedName(value="Options")
    private Map<String, String> options = new HashMap<String, String>();
    public static final String SERIALIZED_NAME_SCOPE = "Scope";
    @SerializedName(value="Scope")
    private String scope;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public CreateOptions attachable(Boolean attachable) {
        this.attachable = attachable;
        return this;
    }

    @Nullable
    public Boolean getAttachable() {
        return this.attachable;
    }

    public void setAttachable(Boolean attachable) {
        this.attachable = attachable;
    }

    public CreateOptions configFrom(ConfigReference configFrom) {
        this.configFrom = configFrom;
        return this;
    }

    @Nullable
    @Valid
    public ConfigReference getConfigFrom() {
        return this.configFrom;
    }

    public void setConfigFrom(ConfigReference configFrom) {
        this.configFrom = configFrom;
    }

    public CreateOptions configOnly(Boolean configOnly) {
        this.configOnly = configOnly;
        return this;
    }

    @Nullable
    public Boolean getConfigOnly() {
        return this.configOnly;
    }

    public void setConfigOnly(Boolean configOnly) {
        this.configOnly = configOnly;
    }

    public CreateOptions driver(String driver) {
        this.driver = driver;
        return this;
    }

    @Nullable
    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public CreateOptions enableIPv4(Boolean enableIPv4) {
        this.enableIPv4 = enableIPv4;
        return this;
    }

    @Nullable
    public Boolean getEnableIPv4() {
        return this.enableIPv4;
    }

    public void setEnableIPv4(Boolean enableIPv4) {
        this.enableIPv4 = enableIPv4;
    }

    public CreateOptions enableIPv6(Boolean enableIPv6) {
        this.enableIPv6 = enableIPv6;
        return this;
    }

    @Nullable
    public Boolean getEnableIPv6() {
        return this.enableIPv6;
    }

    public void setEnableIPv6(Boolean enableIPv6) {
        this.enableIPv6 = enableIPv6;
    }

    public CreateOptions ipam(IPAM ipam) {
        this.ipam = ipam;
        return this;
    }

    @Nullable
    @Valid
    public IPAM getIPAM() {
        return this.ipam;
    }

    public void setIPAM(IPAM ipam) {
        this.ipam = ipam;
    }

    public CreateOptions ingress(Boolean ingress) {
        this.ingress = ingress;
        return this;
    }

    @Nullable
    public Boolean getIngress() {
        return this.ingress;
    }

    public void setIngress(Boolean ingress) {
        this.ingress = ingress;
    }

    public CreateOptions internal(Boolean internal) {
        this.internal = internal;
        return this;
    }

    @Nullable
    public Boolean getInternal() {
        return this.internal;
    }

    public void setInternal(Boolean internal) {
        this.internal = internal;
    }

    public CreateOptions labels(Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    public CreateOptions putLabelsItem(String key, String labelsItem) {
        if (this.labels == null) {
            this.labels = new HashMap<String, String>();
        }
        this.labels.put(key, labelsItem);
        return this;
    }

    @Nullable
    public Map<String, String> getLabels() {
        return this.labels;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    public CreateOptions options(Map<String, String> options) {
        this.options = options;
        return this;
    }

    public CreateOptions putOptionsItem(String key, String optionsItem) {
        if (this.options == null) {
            this.options = new HashMap<String, String>();
        }
        this.options.put(key, optionsItem);
        return this;
    }

    @Nullable
    public Map<String, String> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, String> options) {
        this.options = options;
    }

    public CreateOptions scope(String scope) {
        this.scope = scope;
        return this;
    }

    @Nullable
    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateOptions createOptions = (CreateOptions)o;
        return Objects.equals(this.attachable, createOptions.attachable) && Objects.equals(this.configFrom, createOptions.configFrom) && Objects.equals(this.configOnly, createOptions.configOnly) && Objects.equals(this.driver, createOptions.driver) && Objects.equals(this.enableIPv4, createOptions.enableIPv4) && Objects.equals(this.enableIPv6, createOptions.enableIPv6) && Objects.equals(this.ipam, createOptions.ipam) && Objects.equals(this.ingress, createOptions.ingress) && Objects.equals(this.internal, createOptions.internal) && Objects.equals(this.labels, createOptions.labels) && Objects.equals(this.options, createOptions.options) && Objects.equals(this.scope, createOptions.scope);
    }

    public int hashCode() {
        return Objects.hash(this.attachable, this.configFrom, this.configOnly, this.driver, this.enableIPv4, this.enableIPv6, this.ipam, this.ingress, this.internal, this.labels, this.options, this.scope);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateOptions {\n");
        sb.append("    attachable: ").append(this.toIndentedString(this.attachable)).append("\n");
        sb.append("    configFrom: ").append(this.toIndentedString(this.configFrom)).append("\n");
        sb.append("    configOnly: ").append(this.toIndentedString(this.configOnly)).append("\n");
        sb.append("    driver: ").append(this.toIndentedString(this.driver)).append("\n");
        sb.append("    enableIPv4: ").append(this.toIndentedString(this.enableIPv4)).append("\n");
        sb.append("    enableIPv6: ").append(this.toIndentedString(this.enableIPv6)).append("\n");
        sb.append("    ipam: ").append(this.toIndentedString(this.ipam)).append("\n");
        sb.append("    ingress: ").append(this.toIndentedString(this.ingress)).append("\n");
        sb.append("    internal: ").append(this.toIndentedString(this.internal)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in CreateOptions is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CreateOptions` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_CONFIG_FROM) != null && !jsonObj.get(SERIALIZED_NAME_CONFIG_FROM).isJsonNull()) {
            ConfigReference.validateJsonElement(jsonObj.get(SERIALIZED_NAME_CONFIG_FROM));
        }
        if (jsonObj.get(SERIALIZED_NAME_DRIVER) != null && !jsonObj.get(SERIALIZED_NAME_DRIVER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DRIVER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Driver` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DRIVER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_I_P_A_M) != null && !jsonObj.get(SERIALIZED_NAME_I_P_A_M).isJsonNull()) {
            IPAM.validateJsonElement(jsonObj.get(SERIALIZED_NAME_I_P_A_M));
        }
        if (jsonObj.get(SERIALIZED_NAME_SCOPE) != null && !jsonObj.get(SERIALIZED_NAME_SCOPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SCOPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Scope` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SCOPE).toString()));
        }
    }

    public static CreateOptions fromJson(String jsonString) throws IOException {
        return (CreateOptions)JSON.getGson().fromJson(jsonString, CreateOptions.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ATTACHABLE);
        openapiFields.add(SERIALIZED_NAME_CONFIG_FROM);
        openapiFields.add(SERIALIZED_NAME_CONFIG_ONLY);
        openapiFields.add(SERIALIZED_NAME_DRIVER);
        openapiFields.add(SERIALIZED_NAME_ENABLE_I_PV4);
        openapiFields.add(SERIALIZED_NAME_ENABLE_I_PV6);
        openapiFields.add(SERIALIZED_NAME_I_P_A_M);
        openapiFields.add(SERIALIZED_NAME_INGRESS);
        openapiFields.add(SERIALIZED_NAME_INTERNAL);
        openapiFields.add(SERIALIZED_NAME_LABELS);
        openapiFields.add(SERIALIZED_NAME_OPTIONS);
        openapiFields.add(SERIALIZED_NAME_SCOPE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CreateOptions.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CreateOptions.class));
            return new TypeAdapter<CreateOptions>(this){

                public void write(JsonWriter out, CreateOptions value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CreateOptions read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    CreateOptions.validateJsonElement(jsonElement);
                    return (CreateOptions)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

