/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.Platform;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Descriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ANNOTATIONS = "annotations";
    @SerializedName(value="annotations")
    private Map<String, String> annotations = new HashMap<String, String>();
    public static final String SERIALIZED_NAME_ARTIFACT_TYPE = "artifactType";
    @SerializedName(value="artifactType")
    private String artifactType;
    public static final String SERIALIZED_NAME_DATA = "data";
    @SerializedName(value="data")
    private List<Integer> data = new ArrayList<Integer>();
    public static final String SERIALIZED_NAME_DIGEST = "digest";
    @SerializedName(value="digest")
    private String digest;
    public static final String SERIALIZED_NAME_MEDIA_TYPE = "mediaType";
    @SerializedName(value="mediaType")
    private String mediaType;
    public static final String SERIALIZED_NAME_PLATFORM = "platform";
    @SerializedName(value="platform")
    private Platform platform;
    public static final String SERIALIZED_NAME_SIZE = "size";
    @SerializedName(value="size")
    private Long size;
    public static final String SERIALIZED_NAME_URLS = "urls";
    @SerializedName(value="urls")
    private List<String> urls = new ArrayList<String>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Descriptor annotations(Map<String, String> annotations) {
        this.annotations = annotations;
        return this;
    }

    public Descriptor putAnnotationsItem(String key, String annotationsItem) {
        if (this.annotations == null) {
            this.annotations = new HashMap<String, String>();
        }
        this.annotations.put(key, annotationsItem);
        return this;
    }

    @Nullable
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Map<String, String> annotations) {
        this.annotations = annotations;
    }

    public Descriptor artifactType(String artifactType) {
        this.artifactType = artifactType;
        return this;
    }

    @Nullable
    public String getArtifactType() {
        return this.artifactType;
    }

    public void setArtifactType(String artifactType) {
        this.artifactType = artifactType;
    }

    public Descriptor data(List<Integer> data) {
        this.data = data;
        return this;
    }

    public Descriptor addDataItem(Integer dataItem) {
        if (this.data == null) {
            this.data = new ArrayList<Integer>();
        }
        this.data.add(dataItem);
        return this;
    }

    @Nullable
    public List<Integer> getData() {
        return this.data;
    }

    public void setData(List<Integer> data) {
        this.data = data;
    }

    public Descriptor digest(String digest) {
        this.digest = digest;
        return this;
    }

    @Nullable
    public String getDigest() {
        return this.digest;
    }

    public void setDigest(String digest) {
        this.digest = digest;
    }

    public Descriptor mediaType(String mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    @Nullable
    public String getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public Descriptor platform(Platform platform) {
        this.platform = platform;
        return this;
    }

    @Nullable
    @Valid
    public Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
    }

    public Descriptor size(Long size) {
        this.size = size;
        return this;
    }

    @Nullable
    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public Descriptor urls(List<String> urls) {
        this.urls = urls;
        return this;
    }

    public Descriptor addUrlsItem(String urlsItem) {
        if (this.urls == null) {
            this.urls = new ArrayList<String>();
        }
        this.urls.add(urlsItem);
        return this;
    }

    @Nullable
    public List<String> getUrls() {
        return this.urls;
    }

    public void setUrls(List<String> urls) {
        this.urls = urls;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Descriptor descriptor = (Descriptor)o;
        return Objects.equals(this.annotations, descriptor.annotations) && Objects.equals(this.artifactType, descriptor.artifactType) && Objects.equals(this.data, descriptor.data) && Objects.equals(this.digest, descriptor.digest) && Objects.equals(this.mediaType, descriptor.mediaType) && Objects.equals(this.platform, descriptor.platform) && Objects.equals(this.size, descriptor.size) && Objects.equals(this.urls, descriptor.urls);
    }

    public int hashCode() {
        return Objects.hash(this.annotations, this.artifactType, this.data, this.digest, this.mediaType, this.platform, this.size, this.urls);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Descriptor {\n");
        sb.append("    annotations: ").append(this.toIndentedString(this.annotations)).append("\n");
        sb.append("    artifactType: ").append(this.toIndentedString(this.artifactType)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    digest: ").append(this.toIndentedString(this.digest)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString(this.mediaType)).append("\n");
        sb.append("    platform: ").append(this.toIndentedString(this.platform)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    urls: ").append(this.toIndentedString(this.urls)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in Descriptor is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Descriptor` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ARTIFACT_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_ARTIFACT_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ARTIFACT_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `artifactType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ARTIFACT_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DATA) != null && !jsonObj.get(SERIALIZED_NAME_DATA).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DATA).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `data` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DATA).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DIGEST) != null && !jsonObj.get(SERIALIZED_NAME_DIGEST).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DIGEST).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `digest` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DIGEST).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MEDIA_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_MEDIA_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MEDIA_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `mediaType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MEDIA_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PLATFORM) != null && !jsonObj.get(SERIALIZED_NAME_PLATFORM).isJsonNull()) {
            Platform.validateJsonElement(jsonObj.get(SERIALIZED_NAME_PLATFORM));
        }
        if (jsonObj.get(SERIALIZED_NAME_URLS) != null && !jsonObj.get(SERIALIZED_NAME_URLS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_URLS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `urls` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_URLS).toString()));
        }
    }

    public static Descriptor fromJson(String jsonString) throws IOException {
        return (Descriptor)JSON.getGson().fromJson(jsonString, Descriptor.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ANNOTATIONS);
        openapiFields.add(SERIALIZED_NAME_ARTIFACT_TYPE);
        openapiFields.add(SERIALIZED_NAME_DATA);
        openapiFields.add(SERIALIZED_NAME_DIGEST);
        openapiFields.add(SERIALIZED_NAME_MEDIA_TYPE);
        openapiFields.add(SERIALIZED_NAME_PLATFORM);
        openapiFields.add(SERIALIZED_NAME_SIZE);
        openapiFields.add(SERIALIZED_NAME_URLS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Descriptor.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Descriptor.class));
            return new TypeAdapter<Descriptor>(this){

                public void write(JsonWriter out, Descriptor value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Descriptor read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    Descriptor.validateJsonElement(jsonElement);
                    return (Descriptor)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

