/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.InspectBlkioThrottleDevice;
import io.github.pod4dev.libpodj.model.InspectBlkioWeightDevice;
import io.github.pod4dev.libpodj.model.InspectDevice;
import io.github.pod4dev.libpodj.model.InspectMount;
import io.github.pod4dev.libpodj.model.InspectPodContainerInfo;
import io.github.pod4dev.libpodj.model.InspectPodInfraConfig;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import java.io.IOException;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class InspectPodData
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_CGROUP_PARENT = "CgroupParent";
    @SerializedName(value="CgroupParent")
    private String cgroupParent;
    public static final String SERIALIZED_NAME_CGROUP_PATH = "CgroupPath";
    @SerializedName(value="CgroupPath")
    private String cgroupPath;
    public static final String SERIALIZED_NAME_CONTAINERS = "Containers";
    @SerializedName(value="Containers")
    private List<@Valid InspectPodContainerInfo> containers = new ArrayList<InspectPodContainerInfo>();
    public static final String SERIALIZED_NAME_CREATE_CGROUP = "CreateCgroup";
    @SerializedName(value="CreateCgroup")
    private Boolean createCgroup;
    public static final String SERIALIZED_NAME_CREATE_COMMAND = "CreateCommand";
    @SerializedName(value="CreateCommand")
    private List<String> createCommand = new ArrayList<String>();
    public static final String SERIALIZED_NAME_CREATE_INFRA = "CreateInfra";
    @SerializedName(value="CreateInfra")
    private Boolean createInfra;
    public static final String SERIALIZED_NAME_CREATED = "Created";
    @SerializedName(value="Created")
    private OffsetDateTime created;
    public static final String SERIALIZED_NAME_EXIT_POLICY = "ExitPolicy";
    @SerializedName(value="ExitPolicy")
    private String exitPolicy;
    public static final String SERIALIZED_NAME_HOSTNAME = "Hostname";
    @SerializedName(value="Hostname")
    private String hostname;
    public static final String SERIALIZED_NAME_ID = "Id";
    @SerializedName(value="Id")
    private String id;
    public static final String SERIALIZED_NAME_INFRA_CONFIG = "InfraConfig";
    @SerializedName(value="InfraConfig")
    private InspectPodInfraConfig infraConfig;
    public static final String SERIALIZED_NAME_INFRA_CONTAINER_I_D = "InfraContainerID";
    @SerializedName(value="InfraContainerID")
    private String infraContainerID;
    public static final String SERIALIZED_NAME_LABELS = "Labels";
    @SerializedName(value="Labels")
    private Map<String, String> labels = new HashMap<String, String>();
    public static final String SERIALIZED_NAME_LOCK_NUMBER = "LockNumber";
    @SerializedName(value="LockNumber")
    private Integer lockNumber;
    public static final String SERIALIZED_NAME_NAME = "Name";
    @SerializedName(value="Name")
    private String name;
    public static final String SERIALIZED_NAME_NAMESPACE = "Namespace";
    @SerializedName(value="Namespace")
    private String namespace;
    public static final String SERIALIZED_NAME_NUM_CONTAINERS = "NumContainers";
    @SerializedName(value="NumContainers")
    private Integer numContainers;
    public static final String SERIALIZED_NAME_RESTART_POLICY = "RestartPolicy";
    @SerializedName(value="RestartPolicy")
    private String restartPolicy;
    public static final String SERIALIZED_NAME_SHARED_NAMESPACES = "SharedNamespaces";
    @SerializedName(value="SharedNamespaces")
    private List<String> sharedNamespaces = new ArrayList<String>();
    public static final String SERIALIZED_NAME_STATE = "State";
    @SerializedName(value="State")
    private String state;
    public static final String SERIALIZED_NAME_BLKIO_WEIGHT = "blkio_weight";
    @SerializedName(value="blkio_weight")
    private Integer blkioWeight;
    public static final String SERIALIZED_NAME_BLKIO_WEIGHT_DEVICE = "blkio_weight_device";
    @SerializedName(value="blkio_weight_device")
    private List<@Valid InspectBlkioWeightDevice> blkioWeightDevice = new ArrayList<InspectBlkioWeightDevice>();
    public static final String SERIALIZED_NAME_CPU_PERIOD = "cpu_period";
    @SerializedName(value="cpu_period")
    private Integer cpuPeriod;
    public static final String SERIALIZED_NAME_CPU_QUOTA = "cpu_quota";
    @SerializedName(value="cpu_quota")
    private Long cpuQuota;
    public static final String SERIALIZED_NAME_CPU_SHARES = "cpu_shares";
    @SerializedName(value="cpu_shares")
    private Integer cpuShares;
    public static final String SERIALIZED_NAME_CPUSET_CPUS = "cpuset_cpus";
    @SerializedName(value="cpuset_cpus")
    private String cpusetCpus;
    public static final String SERIALIZED_NAME_CPUSET_MEMS = "cpuset_mems";
    @SerializedName(value="cpuset_mems")
    private String cpusetMems;
    public static final String SERIALIZED_NAME_DEVICE_READ_BPS = "device_read_bps";
    @SerializedName(value="device_read_bps")
    private List<@Valid InspectBlkioThrottleDevice> deviceReadBps = new ArrayList<InspectBlkioThrottleDevice>();
    public static final String SERIALIZED_NAME_DEVICE_WRITE_BPS = "device_write_bps";
    @SerializedName(value="device_write_bps")
    private List<@Valid InspectBlkioThrottleDevice> deviceWriteBps = new ArrayList<InspectBlkioThrottleDevice>();
    public static final String SERIALIZED_NAME_DEVICES = "devices";
    @SerializedName(value="devices")
    private List<@Valid InspectDevice> devices = new ArrayList<InspectDevice>();
    public static final String SERIALIZED_NAME_MEMORY_LIMIT = "memory_limit";
    @SerializedName(value="memory_limit")
    private Integer memoryLimit;
    public static final String SERIALIZED_NAME_MEMORY_SWAP = "memory_swap";
    @SerializedName(value="memory_swap")
    private Integer memorySwap;
    public static final String SERIALIZED_NAME_MOUNTS = "mounts";
    @SerializedName(value="mounts")
    private List<@Valid InspectMount> mounts = new ArrayList<InspectMount>();
    public static final String SERIALIZED_NAME_SECURITY_OPT = "security_opt";
    @SerializedName(value="security_opt")
    private List<String> securityOpt = new ArrayList<String>();
    public static final String SERIALIZED_NAME_VOLUMES_FROM = "volumes_from";
    @SerializedName(value="volumes_from")
    private List<String> volumesFrom = new ArrayList<String>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public InspectPodData cgroupParent(String cgroupParent) {
        this.cgroupParent = cgroupParent;
        return this;
    }

    @Nullable
    public String getCgroupParent() {
        return this.cgroupParent;
    }

    public void setCgroupParent(String cgroupParent) {
        this.cgroupParent = cgroupParent;
    }

    public InspectPodData cgroupPath(String cgroupPath) {
        this.cgroupPath = cgroupPath;
        return this;
    }

    @Nullable
    public String getCgroupPath() {
        return this.cgroupPath;
    }

    public void setCgroupPath(String cgroupPath) {
        this.cgroupPath = cgroupPath;
    }

    public InspectPodData containers(List<@Valid InspectPodContainerInfo> containers) {
        this.containers = containers;
        return this;
    }

    public InspectPodData addContainersItem(InspectPodContainerInfo containersItem) {
        if (this.containers == null) {
            this.containers = new ArrayList<InspectPodContainerInfo>();
        }
        this.containers.add(containersItem);
        return this;
    }

    @Nullable
    @Valid
    public @Valid List<@Valid InspectPodContainerInfo> getContainers() {
        return this.containers;
    }

    public void setContainers(List<@Valid InspectPodContainerInfo> containers) {
        this.containers = containers;
    }

    public InspectPodData createCgroup(Boolean createCgroup) {
        this.createCgroup = createCgroup;
        return this;
    }

    @Nullable
    public Boolean getCreateCgroup() {
        return this.createCgroup;
    }

    public void setCreateCgroup(Boolean createCgroup) {
        this.createCgroup = createCgroup;
    }

    public InspectPodData createCommand(List<String> createCommand) {
        this.createCommand = createCommand;
        return this;
    }

    public InspectPodData addCreateCommandItem(String createCommandItem) {
        if (this.createCommand == null) {
            this.createCommand = new ArrayList<String>();
        }
        this.createCommand.add(createCommandItem);
        return this;
    }

    @Nullable
    public List<String> getCreateCommand() {
        return this.createCommand;
    }

    public void setCreateCommand(List<String> createCommand) {
        this.createCommand = createCommand;
    }

    public InspectPodData createInfra(Boolean createInfra) {
        this.createInfra = createInfra;
        return this;
    }

    @Nullable
    public Boolean getCreateInfra() {
        return this.createInfra;
    }

    public void setCreateInfra(Boolean createInfra) {
        this.createInfra = createInfra;
    }

    public InspectPodData created(OffsetDateTime created) {
        this.created = created;
        return this;
    }

    @Nullable
    @Valid
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public void setCreated(OffsetDateTime created) {
        this.created = created;
    }

    public InspectPodData exitPolicy(String exitPolicy) {
        this.exitPolicy = exitPolicy;
        return this;
    }

    @Nullable
    public String getExitPolicy() {
        return this.exitPolicy;
    }

    public void setExitPolicy(String exitPolicy) {
        this.exitPolicy = exitPolicy;
    }

    public InspectPodData hostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    @Nullable
    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public InspectPodData id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public InspectPodData infraConfig(InspectPodInfraConfig infraConfig) {
        this.infraConfig = infraConfig;
        return this;
    }

    @Nullable
    @Valid
    public InspectPodInfraConfig getInfraConfig() {
        return this.infraConfig;
    }

    public void setInfraConfig(InspectPodInfraConfig infraConfig) {
        this.infraConfig = infraConfig;
    }

    public InspectPodData infraContainerID(String infraContainerID) {
        this.infraContainerID = infraContainerID;
        return this;
    }

    @Nullable
    public String getInfraContainerID() {
        return this.infraContainerID;
    }

    public void setInfraContainerID(String infraContainerID) {
        this.infraContainerID = infraContainerID;
    }

    public InspectPodData labels(Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    public InspectPodData putLabelsItem(String key, String labelsItem) {
        if (this.labels == null) {
            this.labels = new HashMap<String, String>();
        }
        this.labels.put(key, labelsItem);
        return this;
    }

    @Nullable
    public Map<String, String> getLabels() {
        return this.labels;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    public InspectPodData lockNumber(Integer lockNumber) {
        this.lockNumber = lockNumber;
        return this;
    }

    @Nullable
    public Integer getLockNumber() {
        return this.lockNumber;
    }

    public void setLockNumber(Integer lockNumber) {
        this.lockNumber = lockNumber;
    }

    public InspectPodData name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public InspectPodData namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @Nullable
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public InspectPodData numContainers(Integer numContainers) {
        this.numContainers = numContainers;
        return this;
    }

    @Nullable
    public Integer getNumContainers() {
        return this.numContainers;
    }

    public void setNumContainers(Integer numContainers) {
        this.numContainers = numContainers;
    }

    public InspectPodData restartPolicy(String restartPolicy) {
        this.restartPolicy = restartPolicy;
        return this;
    }

    @Nullable
    public String getRestartPolicy() {
        return this.restartPolicy;
    }

    public void setRestartPolicy(String restartPolicy) {
        this.restartPolicy = restartPolicy;
    }

    public InspectPodData sharedNamespaces(List<String> sharedNamespaces) {
        this.sharedNamespaces = sharedNamespaces;
        return this;
    }

    public InspectPodData addSharedNamespacesItem(String sharedNamespacesItem) {
        if (this.sharedNamespaces == null) {
            this.sharedNamespaces = new ArrayList<String>();
        }
        this.sharedNamespaces.add(sharedNamespacesItem);
        return this;
    }

    @Nullable
    public List<String> getSharedNamespaces() {
        return this.sharedNamespaces;
    }

    public void setSharedNamespaces(List<String> sharedNamespaces) {
        this.sharedNamespaces = sharedNamespaces;
    }

    public InspectPodData state(String state) {
        this.state = state;
        return this;
    }

    @Nullable
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public InspectPodData blkioWeight(Integer blkioWeight) {
        this.blkioWeight = blkioWeight;
        return this;
    }

    @Nullable
    public Integer getBlkioWeight() {
        return this.blkioWeight;
    }

    public void setBlkioWeight(Integer blkioWeight) {
        this.blkioWeight = blkioWeight;
    }

    public InspectPodData blkioWeightDevice(List<@Valid InspectBlkioWeightDevice> blkioWeightDevice) {
        this.blkioWeightDevice = blkioWeightDevice;
        return this;
    }

    public InspectPodData addBlkioWeightDeviceItem(InspectBlkioWeightDevice blkioWeightDeviceItem) {
        if (this.blkioWeightDevice == null) {
            this.blkioWeightDevice = new ArrayList<InspectBlkioWeightDevice>();
        }
        this.blkioWeightDevice.add(blkioWeightDeviceItem);
        return this;
    }

    @Nullable
    @Valid
    public @Valid List<@Valid InspectBlkioWeightDevice> getBlkioWeightDevice() {
        return this.blkioWeightDevice;
    }

    public void setBlkioWeightDevice(List<@Valid InspectBlkioWeightDevice> blkioWeightDevice) {
        this.blkioWeightDevice = blkioWeightDevice;
    }

    public InspectPodData cpuPeriod(Integer cpuPeriod) {
        this.cpuPeriod = cpuPeriod;
        return this;
    }

    @Nullable
    public Integer getCpuPeriod() {
        return this.cpuPeriod;
    }

    public void setCpuPeriod(Integer cpuPeriod) {
        this.cpuPeriod = cpuPeriod;
    }

    public InspectPodData cpuQuota(Long cpuQuota) {
        this.cpuQuota = cpuQuota;
        return this;
    }

    @Nullable
    public Long getCpuQuota() {
        return this.cpuQuota;
    }

    public void setCpuQuota(Long cpuQuota) {
        this.cpuQuota = cpuQuota;
    }

    public InspectPodData cpuShares(Integer cpuShares) {
        this.cpuShares = cpuShares;
        return this;
    }

    @Nullable
    public Integer getCpuShares() {
        return this.cpuShares;
    }

    public void setCpuShares(Integer cpuShares) {
        this.cpuShares = cpuShares;
    }

    public InspectPodData cpusetCpus(String cpusetCpus) {
        this.cpusetCpus = cpusetCpus;
        return this;
    }

    @Nullable
    public String getCpusetCpus() {
        return this.cpusetCpus;
    }

    public void setCpusetCpus(String cpusetCpus) {
        this.cpusetCpus = cpusetCpus;
    }

    public InspectPodData cpusetMems(String cpusetMems) {
        this.cpusetMems = cpusetMems;
        return this;
    }

    @Nullable
    public String getCpusetMems() {
        return this.cpusetMems;
    }

    public void setCpusetMems(String cpusetMems) {
        this.cpusetMems = cpusetMems;
    }

    public InspectPodData deviceReadBps(List<@Valid InspectBlkioThrottleDevice> deviceReadBps) {
        this.deviceReadBps = deviceReadBps;
        return this;
    }

    public InspectPodData addDeviceReadBpsItem(InspectBlkioThrottleDevice deviceReadBpsItem) {
        if (this.deviceReadBps == null) {
            this.deviceReadBps = new ArrayList<InspectBlkioThrottleDevice>();
        }
        this.deviceReadBps.add(deviceReadBpsItem);
        return this;
    }

    @Nullable
    @Valid
    public @Valid List<@Valid InspectBlkioThrottleDevice> getDeviceReadBps() {
        return this.deviceReadBps;
    }

    public void setDeviceReadBps(List<@Valid InspectBlkioThrottleDevice> deviceReadBps) {
        this.deviceReadBps = deviceReadBps;
    }

    public InspectPodData deviceWriteBps(List<@Valid InspectBlkioThrottleDevice> deviceWriteBps) {
        this.deviceWriteBps = deviceWriteBps;
        return this;
    }

    public InspectPodData addDeviceWriteBpsItem(InspectBlkioThrottleDevice deviceWriteBpsItem) {
        if (this.deviceWriteBps == null) {
            this.deviceWriteBps = new ArrayList<InspectBlkioThrottleDevice>();
        }
        this.deviceWriteBps.add(deviceWriteBpsItem);
        return this;
    }

    @Nullable
    @Valid
    public @Valid List<@Valid InspectBlkioThrottleDevice> getDeviceWriteBps() {
        return this.deviceWriteBps;
    }

    public void setDeviceWriteBps(List<@Valid InspectBlkioThrottleDevice> deviceWriteBps) {
        this.deviceWriteBps = deviceWriteBps;
    }

    public InspectPodData devices(List<@Valid InspectDevice> devices) {
        this.devices = devices;
        return this;
    }

    public InspectPodData addDevicesItem(InspectDevice devicesItem) {
        if (this.devices == null) {
            this.devices = new ArrayList<InspectDevice>();
        }
        this.devices.add(devicesItem);
        return this;
    }

    @Nullable
    @Valid
    public @Valid List<@Valid InspectDevice> getDevices() {
        return this.devices;
    }

    public void setDevices(List<@Valid InspectDevice> devices) {
        this.devices = devices;
    }

    public InspectPodData memoryLimit(Integer memoryLimit) {
        this.memoryLimit = memoryLimit;
        return this;
    }

    @Nullable
    public Integer getMemoryLimit() {
        return this.memoryLimit;
    }

    public void setMemoryLimit(Integer memoryLimit) {
        this.memoryLimit = memoryLimit;
    }

    public InspectPodData memorySwap(Integer memorySwap) {
        this.memorySwap = memorySwap;
        return this;
    }

    @Nullable
    public Integer getMemorySwap() {
        return this.memorySwap;
    }

    public void setMemorySwap(Integer memorySwap) {
        this.memorySwap = memorySwap;
    }

    public InspectPodData mounts(List<@Valid InspectMount> mounts) {
        this.mounts = mounts;
        return this;
    }

    public InspectPodData addMountsItem(InspectMount mountsItem) {
        if (this.mounts == null) {
            this.mounts = new ArrayList<InspectMount>();
        }
        this.mounts.add(mountsItem);
        return this;
    }

    @Nullable
    @Valid
    public @Valid List<@Valid InspectMount> getMounts() {
        return this.mounts;
    }

    public void setMounts(List<@Valid InspectMount> mounts) {
        this.mounts = mounts;
    }

    public InspectPodData securityOpt(List<String> securityOpt) {
        this.securityOpt = securityOpt;
        return this;
    }

    public InspectPodData addSecurityOptItem(String securityOptItem) {
        if (this.securityOpt == null) {
            this.securityOpt = new ArrayList<String>();
        }
        this.securityOpt.add(securityOptItem);
        return this;
    }

    @Nullable
    public List<String> getSecurityOpt() {
        return this.securityOpt;
    }

    public void setSecurityOpt(List<String> securityOpt) {
        this.securityOpt = securityOpt;
    }

    public InspectPodData volumesFrom(List<String> volumesFrom) {
        this.volumesFrom = volumesFrom;
        return this;
    }

    public InspectPodData addVolumesFromItem(String volumesFromItem) {
        if (this.volumesFrom == null) {
            this.volumesFrom = new ArrayList<String>();
        }
        this.volumesFrom.add(volumesFromItem);
        return this;
    }

    @Nullable
    public List<String> getVolumesFrom() {
        return this.volumesFrom;
    }

    public void setVolumesFrom(List<String> volumesFrom) {
        this.volumesFrom = volumesFrom;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InspectPodData inspectPodData = (InspectPodData)o;
        return Objects.equals(this.cgroupParent, inspectPodData.cgroupParent) && Objects.equals(this.cgroupPath, inspectPodData.cgroupPath) && Objects.equals(this.containers, inspectPodData.containers) && Objects.equals(this.createCgroup, inspectPodData.createCgroup) && Objects.equals(this.createCommand, inspectPodData.createCommand) && Objects.equals(this.createInfra, inspectPodData.createInfra) && Objects.equals(this.created, inspectPodData.created) && Objects.equals(this.exitPolicy, inspectPodData.exitPolicy) && Objects.equals(this.hostname, inspectPodData.hostname) && Objects.equals(this.id, inspectPodData.id) && Objects.equals(this.infraConfig, inspectPodData.infraConfig) && Objects.equals(this.infraContainerID, inspectPodData.infraContainerID) && Objects.equals(this.labels, inspectPodData.labels) && Objects.equals(this.lockNumber, inspectPodData.lockNumber) && Objects.equals(this.name, inspectPodData.name) && Objects.equals(this.namespace, inspectPodData.namespace) && Objects.equals(this.numContainers, inspectPodData.numContainers) && Objects.equals(this.restartPolicy, inspectPodData.restartPolicy) && Objects.equals(this.sharedNamespaces, inspectPodData.sharedNamespaces) && Objects.equals(this.state, inspectPodData.state) && Objects.equals(this.blkioWeight, inspectPodData.blkioWeight) && Objects.equals(this.blkioWeightDevice, inspectPodData.blkioWeightDevice) && Objects.equals(this.cpuPeriod, inspectPodData.cpuPeriod) && Objects.equals(this.cpuQuota, inspectPodData.cpuQuota) && Objects.equals(this.cpuShares, inspectPodData.cpuShares) && Objects.equals(this.cpusetCpus, inspectPodData.cpusetCpus) && Objects.equals(this.cpusetMems, inspectPodData.cpusetMems) && Objects.equals(this.deviceReadBps, inspectPodData.deviceReadBps) && Objects.equals(this.deviceWriteBps, inspectPodData.deviceWriteBps) && Objects.equals(this.devices, inspectPodData.devices) && Objects.equals(this.memoryLimit, inspectPodData.memoryLimit) && Objects.equals(this.memorySwap, inspectPodData.memorySwap) && Objects.equals(this.mounts, inspectPodData.mounts) && Objects.equals(this.securityOpt, inspectPodData.securityOpt) && Objects.equals(this.volumesFrom, inspectPodData.volumesFrom);
    }

    public int hashCode() {
        return Objects.hash(this.cgroupParent, this.cgroupPath, this.containers, this.createCgroup, this.createCommand, this.createInfra, this.created, this.exitPolicy, this.hostname, this.id, this.infraConfig, this.infraContainerID, this.labels, this.lockNumber, this.name, this.namespace, this.numContainers, this.restartPolicy, this.sharedNamespaces, this.state, this.blkioWeight, this.blkioWeightDevice, this.cpuPeriod, this.cpuQuota, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.deviceReadBps, this.deviceWriteBps, this.devices, this.memoryLimit, this.memorySwap, this.mounts, this.securityOpt, this.volumesFrom);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InspectPodData {\n");
        sb.append("    cgroupParent: ").append(this.toIndentedString(this.cgroupParent)).append("\n");
        sb.append("    cgroupPath: ").append(this.toIndentedString(this.cgroupPath)).append("\n");
        sb.append("    containers: ").append(this.toIndentedString(this.containers)).append("\n");
        sb.append("    createCgroup: ").append(this.toIndentedString(this.createCgroup)).append("\n");
        sb.append("    createCommand: ").append(this.toIndentedString(this.createCommand)).append("\n");
        sb.append("    createInfra: ").append(this.toIndentedString(this.createInfra)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    exitPolicy: ").append(this.toIndentedString(this.exitPolicy)).append("\n");
        sb.append("    hostname: ").append(this.toIndentedString(this.hostname)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    infraConfig: ").append(this.toIndentedString(this.infraConfig)).append("\n");
        sb.append("    infraContainerID: ").append(this.toIndentedString(this.infraContainerID)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("    lockNumber: ").append(this.toIndentedString(this.lockNumber)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("    numContainers: ").append(this.toIndentedString(this.numContainers)).append("\n");
        sb.append("    restartPolicy: ").append(this.toIndentedString(this.restartPolicy)).append("\n");
        sb.append("    sharedNamespaces: ").append(this.toIndentedString(this.sharedNamespaces)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    blkioWeight: ").append(this.toIndentedString(this.blkioWeight)).append("\n");
        sb.append("    blkioWeightDevice: ").append(this.toIndentedString(this.blkioWeightDevice)).append("\n");
        sb.append("    cpuPeriod: ").append(this.toIndentedString(this.cpuPeriod)).append("\n");
        sb.append("    cpuQuota: ").append(this.toIndentedString(this.cpuQuota)).append("\n");
        sb.append("    cpuShares: ").append(this.toIndentedString(this.cpuShares)).append("\n");
        sb.append("    cpusetCpus: ").append(this.toIndentedString(this.cpusetCpus)).append("\n");
        sb.append("    cpusetMems: ").append(this.toIndentedString(this.cpusetMems)).append("\n");
        sb.append("    deviceReadBps: ").append(this.toIndentedString(this.deviceReadBps)).append("\n");
        sb.append("    deviceWriteBps: ").append(this.toIndentedString(this.deviceWriteBps)).append("\n");
        sb.append("    devices: ").append(this.toIndentedString(this.devices)).append("\n");
        sb.append("    memoryLimit: ").append(this.toIndentedString(this.memoryLimit)).append("\n");
        sb.append("    memorySwap: ").append(this.toIndentedString(this.memorySwap)).append("\n");
        sb.append("    mounts: ").append(this.toIndentedString(this.mounts)).append("\n");
        sb.append("    securityOpt: ").append(this.toIndentedString(this.securityOpt)).append("\n");
        sb.append("    volumesFrom: ").append(this.toIndentedString(this.volumesFrom)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArraymounts;
        JsonArray jsonArraydevices;
        JsonArray jsonArraydeviceWriteBps;
        JsonArray jsonArraydeviceReadBps;
        JsonArray jsonArrayblkioWeightDevice;
        int i;
        JsonArray jsonArraycontainers;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in InspectPodData is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `InspectPodData` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_CGROUP_PARENT) != null && !jsonObj.get(SERIALIZED_NAME_CGROUP_PARENT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CGROUP_PARENT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `CgroupParent` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CGROUP_PARENT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CGROUP_PATH) != null && !jsonObj.get(SERIALIZED_NAME_CGROUP_PATH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CGROUP_PATH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `CgroupPath` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CGROUP_PATH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONTAINERS) != null && !jsonObj.get(SERIALIZED_NAME_CONTAINERS).isJsonNull() && (jsonArraycontainers = jsonObj.getAsJsonArray(SERIALIZED_NAME_CONTAINERS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CONTAINERS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `Containers` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTAINERS).toString()));
            }
            for (i = 0; i < jsonArraycontainers.size(); ++i) {
                InspectPodContainerInfo.validateJsonElement(jsonArraycontainers.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_CREATE_COMMAND) != null && !jsonObj.get(SERIALIZED_NAME_CREATE_COMMAND).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CREATE_COMMAND).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `CreateCommand` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CREATE_COMMAND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXIT_POLICY) != null && !jsonObj.get(SERIALIZED_NAME_EXIT_POLICY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_EXIT_POLICY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `ExitPolicy` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXIT_POLICY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HOSTNAME) != null && !jsonObj.get(SERIALIZED_NAME_HOSTNAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_HOSTNAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Hostname` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HOSTNAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INFRA_CONFIG) != null && !jsonObj.get(SERIALIZED_NAME_INFRA_CONFIG).isJsonNull()) {
            InspectPodInfraConfig.validateJsonElement(jsonObj.get(SERIALIZED_NAME_INFRA_CONFIG));
        }
        if (jsonObj.get(SERIALIZED_NAME_INFRA_CONTAINER_I_D) != null && !jsonObj.get(SERIALIZED_NAME_INFRA_CONTAINER_I_D).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_INFRA_CONTAINER_I_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `InfraContainerID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INFRA_CONTAINER_I_D).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAMESPACE) != null && !jsonObj.get(SERIALIZED_NAME_NAMESPACE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAMESPACE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Namespace` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAMESPACE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESTART_POLICY) != null && !jsonObj.get(SERIALIZED_NAME_RESTART_POLICY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RESTART_POLICY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `RestartPolicy` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESTART_POLICY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHARED_NAMESPACES) != null && !jsonObj.get(SERIALIZED_NAME_SHARED_NAMESPACES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SHARED_NAMESPACES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `SharedNamespaces` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHARED_NAMESPACES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATE) != null && !jsonObj.get(SERIALIZED_NAME_STATE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_STATE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `State` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BLKIO_WEIGHT_DEVICE) != null && !jsonObj.get(SERIALIZED_NAME_BLKIO_WEIGHT_DEVICE).isJsonNull() && (jsonArrayblkioWeightDevice = jsonObj.getAsJsonArray(SERIALIZED_NAME_BLKIO_WEIGHT_DEVICE)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_BLKIO_WEIGHT_DEVICE).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `blkio_weight_device` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BLKIO_WEIGHT_DEVICE).toString()));
            }
            for (i = 0; i < jsonArrayblkioWeightDevice.size(); ++i) {
                InspectBlkioWeightDevice.validateJsonElement(jsonArrayblkioWeightDevice.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_CPUSET_CPUS) != null && !jsonObj.get(SERIALIZED_NAME_CPUSET_CPUS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CPUSET_CPUS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `cpuset_cpus` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CPUSET_CPUS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CPUSET_MEMS) != null && !jsonObj.get(SERIALIZED_NAME_CPUSET_MEMS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CPUSET_MEMS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `cpuset_mems` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CPUSET_MEMS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DEVICE_READ_BPS) != null && !jsonObj.get(SERIALIZED_NAME_DEVICE_READ_BPS).isJsonNull() && (jsonArraydeviceReadBps = jsonObj.getAsJsonArray(SERIALIZED_NAME_DEVICE_READ_BPS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_DEVICE_READ_BPS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `device_read_bps` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEVICE_READ_BPS).toString()));
            }
            for (i = 0; i < jsonArraydeviceReadBps.size(); ++i) {
                InspectBlkioThrottleDevice.validateJsonElement(jsonArraydeviceReadBps.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_DEVICE_WRITE_BPS) != null && !jsonObj.get(SERIALIZED_NAME_DEVICE_WRITE_BPS).isJsonNull() && (jsonArraydeviceWriteBps = jsonObj.getAsJsonArray(SERIALIZED_NAME_DEVICE_WRITE_BPS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_DEVICE_WRITE_BPS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `device_write_bps` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEVICE_WRITE_BPS).toString()));
            }
            for (i = 0; i < jsonArraydeviceWriteBps.size(); ++i) {
                InspectBlkioThrottleDevice.validateJsonElement(jsonArraydeviceWriteBps.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_DEVICES) != null && !jsonObj.get(SERIALIZED_NAME_DEVICES).isJsonNull() && (jsonArraydevices = jsonObj.getAsJsonArray(SERIALIZED_NAME_DEVICES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_DEVICES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `devices` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEVICES).toString()));
            }
            for (i = 0; i < jsonArraydevices.size(); ++i) {
                InspectDevice.validateJsonElement(jsonArraydevices.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_MOUNTS) != null && !jsonObj.get(SERIALIZED_NAME_MOUNTS).isJsonNull() && (jsonArraymounts = jsonObj.getAsJsonArray(SERIALIZED_NAME_MOUNTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_MOUNTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `mounts` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MOUNTS).toString()));
            }
            for (i = 0; i < jsonArraymounts.size(); ++i) {
                InspectMount.validateJsonElement(jsonArraymounts.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_SECURITY_OPT) != null && !jsonObj.get(SERIALIZED_NAME_SECURITY_OPT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SECURITY_OPT).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `security_opt` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SECURITY_OPT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VOLUMES_FROM) != null && !jsonObj.get(SERIALIZED_NAME_VOLUMES_FROM).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VOLUMES_FROM).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `volumes_from` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VOLUMES_FROM).toString()));
        }
    }

    public static InspectPodData fromJson(String jsonString) throws IOException {
        return (InspectPodData)JSON.getGson().fromJson(jsonString, InspectPodData.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CGROUP_PARENT);
        openapiFields.add(SERIALIZED_NAME_CGROUP_PATH);
        openapiFields.add(SERIALIZED_NAME_CONTAINERS);
        openapiFields.add(SERIALIZED_NAME_CREATE_CGROUP);
        openapiFields.add(SERIALIZED_NAME_CREATE_COMMAND);
        openapiFields.add(SERIALIZED_NAME_CREATE_INFRA);
        openapiFields.add(SERIALIZED_NAME_CREATED);
        openapiFields.add(SERIALIZED_NAME_EXIT_POLICY);
        openapiFields.add(SERIALIZED_NAME_HOSTNAME);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_INFRA_CONFIG);
        openapiFields.add(SERIALIZED_NAME_INFRA_CONTAINER_I_D);
        openapiFields.add(SERIALIZED_NAME_LABELS);
        openapiFields.add(SERIALIZED_NAME_LOCK_NUMBER);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_NAMESPACE);
        openapiFields.add(SERIALIZED_NAME_NUM_CONTAINERS);
        openapiFields.add(SERIALIZED_NAME_RESTART_POLICY);
        openapiFields.add(SERIALIZED_NAME_SHARED_NAMESPACES);
        openapiFields.add(SERIALIZED_NAME_STATE);
        openapiFields.add(SERIALIZED_NAME_BLKIO_WEIGHT);
        openapiFields.add(SERIALIZED_NAME_BLKIO_WEIGHT_DEVICE);
        openapiFields.add(SERIALIZED_NAME_CPU_PERIOD);
        openapiFields.add(SERIALIZED_NAME_CPU_QUOTA);
        openapiFields.add(SERIALIZED_NAME_CPU_SHARES);
        openapiFields.add(SERIALIZED_NAME_CPUSET_CPUS);
        openapiFields.add(SERIALIZED_NAME_CPUSET_MEMS);
        openapiFields.add(SERIALIZED_NAME_DEVICE_READ_BPS);
        openapiFields.add(SERIALIZED_NAME_DEVICE_WRITE_BPS);
        openapiFields.add(SERIALIZED_NAME_DEVICES);
        openapiFields.add(SERIALIZED_NAME_MEMORY_LIMIT);
        openapiFields.add(SERIALIZED_NAME_MEMORY_SWAP);
        openapiFields.add(SERIALIZED_NAME_MOUNTS);
        openapiFields.add(SERIALIZED_NAME_SECURITY_OPT);
        openapiFields.add(SERIALIZED_NAME_VOLUMES_FROM);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!InspectPodData.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(InspectPodData.class));
            return new TypeAdapter<InspectPodData>(this){

                public void write(JsonWriter out, InspectPodData value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public InspectPodData read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    InspectPodData.validateJsonElement(jsonElement);
                    return (InspectPodData)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

