/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.Namespace;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class PodBasicConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_EXIT_POLICY = "exit_policy";
    @SerializedName(value="exit_policy")
    private String exitPolicy;
    public static final String SERIALIZED_NAME_HOSTNAME = "hostname";
    @SerializedName(value="hostname")
    private String hostname;
    public static final String SERIALIZED_NAME_INFRA_COMMAND = "infra_command";
    @SerializedName(value="infra_command")
    private List<String> infraCommand = new ArrayList<String>();
    public static final String SERIALIZED_NAME_INFRA_CONMON_PID_FILE = "infra_conmon_pid_file";
    @SerializedName(value="infra_conmon_pid_file")
    private String infraConmonPidFile;
    public static final String SERIALIZED_NAME_INFRA_IMAGE = "infra_image";
    @SerializedName(value="infra_image")
    private String infraImage;
    public static final String SERIALIZED_NAME_INFRA_NAME = "infra_name";
    @SerializedName(value="infra_name")
    private String infraName;
    public static final String SERIALIZED_NAME_IPCNS = "ipcns";
    @SerializedName(value="ipcns")
    private Namespace ipcns;
    public static final String SERIALIZED_NAME_LABELS = "labels";
    @SerializedName(value="labels")
    private Map<String, String> labels = new HashMap<String, String>();
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_NO_INFRA = "no_infra";
    @SerializedName(value="no_infra")
    private Boolean noInfra;
    public static final String SERIALIZED_NAME_PIDNS = "pidns";
    @SerializedName(value="pidns")
    private Namespace pidns;
    public static final String SERIALIZED_NAME_POD_CREATE_COMMAND = "pod_create_command";
    @SerializedName(value="pod_create_command")
    private List<String> podCreateCommand = new ArrayList<String>();
    public static final String SERIALIZED_NAME_POD_DEVICES = "pod_devices";
    @SerializedName(value="pod_devices")
    private List<String> podDevices = new ArrayList<String>();
    public static final String SERIALIZED_NAME_RESTART_POLICY = "restart_policy";
    @SerializedName(value="restart_policy")
    private String restartPolicy;
    public static final String SERIALIZED_NAME_RESTART_TRIES = "restart_tries";
    @SerializedName(value="restart_tries")
    private Integer restartTries;
    public static final String SERIALIZED_NAME_SHARE_PARENT = "share_parent";
    @SerializedName(value="share_parent")
    private Boolean shareParent;
    public static final String SERIALIZED_NAME_SHARED_NAMESPACES = "shared_namespaces";
    @SerializedName(value="shared_namespaces")
    private List<String> sharedNamespaces = new ArrayList<String>();
    public static final String SERIALIZED_NAME_SYSCTL = "sysctl";
    @SerializedName(value="sysctl")
    private Map<String, String> sysctl = new HashMap<String, String>();
    public static final String SERIALIZED_NAME_USERNS = "userns";
    @SerializedName(value="userns")
    private Namespace userns;
    public static final String SERIALIZED_NAME_UTSNS = "utsns";
    @SerializedName(value="utsns")
    private Namespace utsns;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public PodBasicConfig exitPolicy(String exitPolicy) {
        this.exitPolicy = exitPolicy;
        return this;
    }

    @Nullable
    public String getExitPolicy() {
        return this.exitPolicy;
    }

    public void setExitPolicy(String exitPolicy) {
        this.exitPolicy = exitPolicy;
    }

    public PodBasicConfig hostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    @Nullable
    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public PodBasicConfig infraCommand(List<String> infraCommand) {
        this.infraCommand = infraCommand;
        return this;
    }

    public PodBasicConfig addInfraCommandItem(String infraCommandItem) {
        if (this.infraCommand == null) {
            this.infraCommand = new ArrayList<String>();
        }
        this.infraCommand.add(infraCommandItem);
        return this;
    }

    @Nullable
    public List<String> getInfraCommand() {
        return this.infraCommand;
    }

    public void setInfraCommand(List<String> infraCommand) {
        this.infraCommand = infraCommand;
    }

    public PodBasicConfig infraConmonPidFile(String infraConmonPidFile) {
        this.infraConmonPidFile = infraConmonPidFile;
        return this;
    }

    @Nullable
    public String getInfraConmonPidFile() {
        return this.infraConmonPidFile;
    }

    public void setInfraConmonPidFile(String infraConmonPidFile) {
        this.infraConmonPidFile = infraConmonPidFile;
    }

    public PodBasicConfig infraImage(String infraImage) {
        this.infraImage = infraImage;
        return this;
    }

    @Nullable
    public String getInfraImage() {
        return this.infraImage;
    }

    public void setInfraImage(String infraImage) {
        this.infraImage = infraImage;
    }

    public PodBasicConfig infraName(String infraName) {
        this.infraName = infraName;
        return this;
    }

    @Nullable
    public String getInfraName() {
        return this.infraName;
    }

    public void setInfraName(String infraName) {
        this.infraName = infraName;
    }

    public PodBasicConfig ipcns(Namespace ipcns) {
        this.ipcns = ipcns;
        return this;
    }

    @Nullable
    @Valid
    public Namespace getIpcns() {
        return this.ipcns;
    }

    public void setIpcns(Namespace ipcns) {
        this.ipcns = ipcns;
    }

    public PodBasicConfig labels(Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    public PodBasicConfig putLabelsItem(String key, String labelsItem) {
        if (this.labels == null) {
            this.labels = new HashMap<String, String>();
        }
        this.labels.put(key, labelsItem);
        return this;
    }

    @Nullable
    public Map<String, String> getLabels() {
        return this.labels;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    public PodBasicConfig name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PodBasicConfig noInfra(Boolean noInfra) {
        this.noInfra = noInfra;
        return this;
    }

    @Nullable
    public Boolean getNoInfra() {
        return this.noInfra;
    }

    public void setNoInfra(Boolean noInfra) {
        this.noInfra = noInfra;
    }

    public PodBasicConfig pidns(Namespace pidns) {
        this.pidns = pidns;
        return this;
    }

    @Nullable
    @Valid
    public Namespace getPidns() {
        return this.pidns;
    }

    public void setPidns(Namespace pidns) {
        this.pidns = pidns;
    }

    public PodBasicConfig podCreateCommand(List<String> podCreateCommand) {
        this.podCreateCommand = podCreateCommand;
        return this;
    }

    public PodBasicConfig addPodCreateCommandItem(String podCreateCommandItem) {
        if (this.podCreateCommand == null) {
            this.podCreateCommand = new ArrayList<String>();
        }
        this.podCreateCommand.add(podCreateCommandItem);
        return this;
    }

    @Nullable
    public List<String> getPodCreateCommand() {
        return this.podCreateCommand;
    }

    public void setPodCreateCommand(List<String> podCreateCommand) {
        this.podCreateCommand = podCreateCommand;
    }

    public PodBasicConfig podDevices(List<String> podDevices) {
        this.podDevices = podDevices;
        return this;
    }

    public PodBasicConfig addPodDevicesItem(String podDevicesItem) {
        if (this.podDevices == null) {
            this.podDevices = new ArrayList<String>();
        }
        this.podDevices.add(podDevicesItem);
        return this;
    }

    @Nullable
    public List<String> getPodDevices() {
        return this.podDevices;
    }

    public void setPodDevices(List<String> podDevices) {
        this.podDevices = podDevices;
    }

    public PodBasicConfig restartPolicy(String restartPolicy) {
        this.restartPolicy = restartPolicy;
        return this;
    }

    @Nullable
    public String getRestartPolicy() {
        return this.restartPolicy;
    }

    public void setRestartPolicy(String restartPolicy) {
        this.restartPolicy = restartPolicy;
    }

    public PodBasicConfig restartTries(Integer restartTries) {
        this.restartTries = restartTries;
        return this;
    }

    @Nullable
    public Integer getRestartTries() {
        return this.restartTries;
    }

    public void setRestartTries(Integer restartTries) {
        this.restartTries = restartTries;
    }

    public PodBasicConfig shareParent(Boolean shareParent) {
        this.shareParent = shareParent;
        return this;
    }

    @Nullable
    public Boolean getShareParent() {
        return this.shareParent;
    }

    public void setShareParent(Boolean shareParent) {
        this.shareParent = shareParent;
    }

    public PodBasicConfig sharedNamespaces(List<String> sharedNamespaces) {
        this.sharedNamespaces = sharedNamespaces;
        return this;
    }

    public PodBasicConfig addSharedNamespacesItem(String sharedNamespacesItem) {
        if (this.sharedNamespaces == null) {
            this.sharedNamespaces = new ArrayList<String>();
        }
        this.sharedNamespaces.add(sharedNamespacesItem);
        return this;
    }

    @Nullable
    public List<String> getSharedNamespaces() {
        return this.sharedNamespaces;
    }

    public void setSharedNamespaces(List<String> sharedNamespaces) {
        this.sharedNamespaces = sharedNamespaces;
    }

    public PodBasicConfig sysctl(Map<String, String> sysctl) {
        this.sysctl = sysctl;
        return this;
    }

    public PodBasicConfig putSysctlItem(String key, String sysctlItem) {
        if (this.sysctl == null) {
            this.sysctl = new HashMap<String, String>();
        }
        this.sysctl.put(key, sysctlItem);
        return this;
    }

    @Nullable
    public Map<String, String> getSysctl() {
        return this.sysctl;
    }

    public void setSysctl(Map<String, String> sysctl) {
        this.sysctl = sysctl;
    }

    public PodBasicConfig userns(Namespace userns) {
        this.userns = userns;
        return this;
    }

    @Nullable
    @Valid
    public Namespace getUserns() {
        return this.userns;
    }

    public void setUserns(Namespace userns) {
        this.userns = userns;
    }

    public PodBasicConfig utsns(Namespace utsns) {
        this.utsns = utsns;
        return this;
    }

    @Nullable
    @Valid
    public Namespace getUtsns() {
        return this.utsns;
    }

    public void setUtsns(Namespace utsns) {
        this.utsns = utsns;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodBasicConfig podBasicConfig = (PodBasicConfig)o;
        return Objects.equals(this.exitPolicy, podBasicConfig.exitPolicy) && Objects.equals(this.hostname, podBasicConfig.hostname) && Objects.equals(this.infraCommand, podBasicConfig.infraCommand) && Objects.equals(this.infraConmonPidFile, podBasicConfig.infraConmonPidFile) && Objects.equals(this.infraImage, podBasicConfig.infraImage) && Objects.equals(this.infraName, podBasicConfig.infraName) && Objects.equals(this.ipcns, podBasicConfig.ipcns) && Objects.equals(this.labels, podBasicConfig.labels) && Objects.equals(this.name, podBasicConfig.name) && Objects.equals(this.noInfra, podBasicConfig.noInfra) && Objects.equals(this.pidns, podBasicConfig.pidns) && Objects.equals(this.podCreateCommand, podBasicConfig.podCreateCommand) && Objects.equals(this.podDevices, podBasicConfig.podDevices) && Objects.equals(this.restartPolicy, podBasicConfig.restartPolicy) && Objects.equals(this.restartTries, podBasicConfig.restartTries) && Objects.equals(this.shareParent, podBasicConfig.shareParent) && Objects.equals(this.sharedNamespaces, podBasicConfig.sharedNamespaces) && Objects.equals(this.sysctl, podBasicConfig.sysctl) && Objects.equals(this.userns, podBasicConfig.userns) && Objects.equals(this.utsns, podBasicConfig.utsns);
    }

    public int hashCode() {
        return Objects.hash(this.exitPolicy, this.hostname, this.infraCommand, this.infraConmonPidFile, this.infraImage, this.infraName, this.ipcns, this.labels, this.name, this.noInfra, this.pidns, this.podCreateCommand, this.podDevices, this.restartPolicy, this.restartTries, this.shareParent, this.sharedNamespaces, this.sysctl, this.userns, this.utsns);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PodBasicConfig {\n");
        sb.append("    exitPolicy: ").append(this.toIndentedString(this.exitPolicy)).append("\n");
        sb.append("    hostname: ").append(this.toIndentedString(this.hostname)).append("\n");
        sb.append("    infraCommand: ").append(this.toIndentedString(this.infraCommand)).append("\n");
        sb.append("    infraConmonPidFile: ").append(this.toIndentedString(this.infraConmonPidFile)).append("\n");
        sb.append("    infraImage: ").append(this.toIndentedString(this.infraImage)).append("\n");
        sb.append("    infraName: ").append(this.toIndentedString(this.infraName)).append("\n");
        sb.append("    ipcns: ").append(this.toIndentedString(this.ipcns)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    noInfra: ").append(this.toIndentedString(this.noInfra)).append("\n");
        sb.append("    pidns: ").append(this.toIndentedString(this.pidns)).append("\n");
        sb.append("    podCreateCommand: ").append(this.toIndentedString(this.podCreateCommand)).append("\n");
        sb.append("    podDevices: ").append(this.toIndentedString(this.podDevices)).append("\n");
        sb.append("    restartPolicy: ").append(this.toIndentedString(this.restartPolicy)).append("\n");
        sb.append("    restartTries: ").append(this.toIndentedString(this.restartTries)).append("\n");
        sb.append("    shareParent: ").append(this.toIndentedString(this.shareParent)).append("\n");
        sb.append("    sharedNamespaces: ").append(this.toIndentedString(this.sharedNamespaces)).append("\n");
        sb.append("    sysctl: ").append(this.toIndentedString(this.sysctl)).append("\n");
        sb.append("    userns: ").append(this.toIndentedString(this.userns)).append("\n");
        sb.append("    utsns: ").append(this.toIndentedString(this.utsns)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in PodBasicConfig is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `PodBasicConfig` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_EXIT_POLICY) != null && !jsonObj.get(SERIALIZED_NAME_EXIT_POLICY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_EXIT_POLICY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `exit_policy` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXIT_POLICY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HOSTNAME) != null && !jsonObj.get(SERIALIZED_NAME_HOSTNAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_HOSTNAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `hostname` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HOSTNAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INFRA_COMMAND) != null && !jsonObj.get(SERIALIZED_NAME_INFRA_COMMAND).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_INFRA_COMMAND).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `infra_command` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INFRA_COMMAND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INFRA_CONMON_PID_FILE) != null && !jsonObj.get(SERIALIZED_NAME_INFRA_CONMON_PID_FILE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_INFRA_CONMON_PID_FILE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `infra_conmon_pid_file` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INFRA_CONMON_PID_FILE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INFRA_IMAGE) != null && !jsonObj.get(SERIALIZED_NAME_INFRA_IMAGE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_INFRA_IMAGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `infra_image` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INFRA_IMAGE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INFRA_NAME) != null && !jsonObj.get(SERIALIZED_NAME_INFRA_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_INFRA_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `infra_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INFRA_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IPCNS) != null && !jsonObj.get(SERIALIZED_NAME_IPCNS).isJsonNull()) {
            Namespace.validateJsonElement(jsonObj.get(SERIALIZED_NAME_IPCNS));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PIDNS) != null && !jsonObj.get(SERIALIZED_NAME_PIDNS).isJsonNull()) {
            Namespace.validateJsonElement(jsonObj.get(SERIALIZED_NAME_PIDNS));
        }
        if (jsonObj.get(SERIALIZED_NAME_POD_CREATE_COMMAND) != null && !jsonObj.get(SERIALIZED_NAME_POD_CREATE_COMMAND).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_POD_CREATE_COMMAND).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `pod_create_command` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_POD_CREATE_COMMAND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_POD_DEVICES) != null && !jsonObj.get(SERIALIZED_NAME_POD_DEVICES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_POD_DEVICES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `pod_devices` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_POD_DEVICES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESTART_POLICY) != null && !jsonObj.get(SERIALIZED_NAME_RESTART_POLICY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RESTART_POLICY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `restart_policy` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESTART_POLICY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHARED_NAMESPACES) != null && !jsonObj.get(SERIALIZED_NAME_SHARED_NAMESPACES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SHARED_NAMESPACES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `shared_namespaces` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHARED_NAMESPACES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_USERNS) != null && !jsonObj.get(SERIALIZED_NAME_USERNS).isJsonNull()) {
            Namespace.validateJsonElement(jsonObj.get(SERIALIZED_NAME_USERNS));
        }
        if (jsonObj.get(SERIALIZED_NAME_UTSNS) != null && !jsonObj.get(SERIALIZED_NAME_UTSNS).isJsonNull()) {
            Namespace.validateJsonElement(jsonObj.get(SERIALIZED_NAME_UTSNS));
        }
    }

    public static PodBasicConfig fromJson(String jsonString) throws IOException {
        return (PodBasicConfig)JSON.getGson().fromJson(jsonString, PodBasicConfig.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_EXIT_POLICY);
        openapiFields.add(SERIALIZED_NAME_HOSTNAME);
        openapiFields.add(SERIALIZED_NAME_INFRA_COMMAND);
        openapiFields.add(SERIALIZED_NAME_INFRA_CONMON_PID_FILE);
        openapiFields.add(SERIALIZED_NAME_INFRA_IMAGE);
        openapiFields.add(SERIALIZED_NAME_INFRA_NAME);
        openapiFields.add(SERIALIZED_NAME_IPCNS);
        openapiFields.add(SERIALIZED_NAME_LABELS);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_NO_INFRA);
        openapiFields.add(SERIALIZED_NAME_PIDNS);
        openapiFields.add(SERIALIZED_NAME_POD_CREATE_COMMAND);
        openapiFields.add(SERIALIZED_NAME_POD_DEVICES);
        openapiFields.add(SERIALIZED_NAME_RESTART_POLICY);
        openapiFields.add(SERIALIZED_NAME_RESTART_TRIES);
        openapiFields.add(SERIALIZED_NAME_SHARE_PARENT);
        openapiFields.add(SERIALIZED_NAME_SHARED_NAMESPACES);
        openapiFields.add(SERIALIZED_NAME_SYSCTL);
        openapiFields.add(SERIALIZED_NAME_USERNS);
        openapiFields.add(SERIALIZED_NAME_UTSNS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!PodBasicConfig.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PodBasicConfig.class));
            return new TypeAdapter<PodBasicConfig>(this){

                public void write(JsonWriter out, PodBasicConfig value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public PodBasicConfig read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    PodBasicConfig.validateJsonElement(jsonElement);
                    return (PodBasicConfig)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

