/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.Namespace;
import io.github.pod4dev.libpodj.model.PerNetworkOptions;
import io.github.pod4dev.libpodj.model.PortMapping;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class PodNetworkConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_NETWORKS = "Networks";
    @SerializedName(value="Networks")
    private Map<String, PerNetworkOptions> networks = new HashMap<String, PerNetworkOptions>();
    public static final String SERIALIZED_NAME_CNI_NETWORKS = "cni_networks";
    @SerializedName(value="cni_networks")
    private List<String> cniNetworks = new ArrayList<String>();
    public static final String SERIALIZED_NAME_DNS_OPTION = "dns_option";
    @SerializedName(value="dns_option")
    private List<String> dnsOption = new ArrayList<String>();
    public static final String SERIALIZED_NAME_DNS_SEARCH = "dns_search";
    @SerializedName(value="dns_search")
    private List<String> dnsSearch = new ArrayList<String>();
    public static final String SERIALIZED_NAME_DNS_SERVER = "dns_server";
    @SerializedName(value="dns_server")
    private List<String> dnsServer = new ArrayList<String>();
    public static final String SERIALIZED_NAME_HOSTADD = "hostadd";
    @SerializedName(value="hostadd")
    private List<String> hostadd = new ArrayList<String>();
    public static final String SERIALIZED_NAME_HOSTS_FILE = "hostsFile";
    @SerializedName(value="hostsFile")
    private String hostsFile;
    public static final String SERIALIZED_NAME_NETNS = "netns";
    @SerializedName(value="netns")
    private Namespace netns;
    public static final String SERIALIZED_NAME_NETWORK_OPTIONS = "network_options";
    @SerializedName(value="network_options")
    private Map<String, List<String>> networkOptions = new HashMap<String, List<String>>();
    public static final String SERIALIZED_NAME_NO_MANAGE_HOSTNAME = "no_manage_hostname";
    @SerializedName(value="no_manage_hostname")
    private Boolean noManageHostname;
    public static final String SERIALIZED_NAME_NO_MANAGE_HOSTS = "no_manage_hosts";
    @SerializedName(value="no_manage_hosts")
    private Boolean noManageHosts;
    public static final String SERIALIZED_NAME_NO_MANAGE_RESOLV_CONF = "no_manage_resolv_conf";
    @SerializedName(value="no_manage_resolv_conf")
    private Boolean noManageResolvConf;
    public static final String SERIALIZED_NAME_PORTMAPPINGS = "portmappings";
    @SerializedName(value="portmappings")
    private List<@Valid PortMapping> portmappings = new ArrayList<PortMapping>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public PodNetworkConfig networks(Map<String, PerNetworkOptions> networks) {
        this.networks = networks;
        return this;
    }

    public PodNetworkConfig putNetworksItem(String key, PerNetworkOptions networksItem) {
        if (this.networks == null) {
            this.networks = new HashMap<String, PerNetworkOptions>();
        }
        this.networks.put(key, networksItem);
        return this;
    }

    @Nullable
    @Valid
    public Map<String, PerNetworkOptions> getNetworks() {
        return this.networks;
    }

    public void setNetworks(Map<String, PerNetworkOptions> networks) {
        this.networks = networks;
    }

    public PodNetworkConfig cniNetworks(List<String> cniNetworks) {
        this.cniNetworks = cniNetworks;
        return this;
    }

    public PodNetworkConfig addCniNetworksItem(String cniNetworksItem) {
        if (this.cniNetworks == null) {
            this.cniNetworks = new ArrayList<String>();
        }
        this.cniNetworks.add(cniNetworksItem);
        return this;
    }

    @Nullable
    public List<String> getCniNetworks() {
        return this.cniNetworks;
    }

    public void setCniNetworks(List<String> cniNetworks) {
        this.cniNetworks = cniNetworks;
    }

    public PodNetworkConfig dnsOption(List<String> dnsOption) {
        this.dnsOption = dnsOption;
        return this;
    }

    public PodNetworkConfig addDnsOptionItem(String dnsOptionItem) {
        if (this.dnsOption == null) {
            this.dnsOption = new ArrayList<String>();
        }
        this.dnsOption.add(dnsOptionItem);
        return this;
    }

    @Nullable
    public List<String> getDnsOption() {
        return this.dnsOption;
    }

    public void setDnsOption(List<String> dnsOption) {
        this.dnsOption = dnsOption;
    }

    public PodNetworkConfig dnsSearch(List<String> dnsSearch) {
        this.dnsSearch = dnsSearch;
        return this;
    }

    public PodNetworkConfig addDnsSearchItem(String dnsSearchItem) {
        if (this.dnsSearch == null) {
            this.dnsSearch = new ArrayList<String>();
        }
        this.dnsSearch.add(dnsSearchItem);
        return this;
    }

    @Nullable
    public List<String> getDnsSearch() {
        return this.dnsSearch;
    }

    public void setDnsSearch(List<String> dnsSearch) {
        this.dnsSearch = dnsSearch;
    }

    public PodNetworkConfig dnsServer(List<String> dnsServer) {
        this.dnsServer = dnsServer;
        return this;
    }

    public PodNetworkConfig addDnsServerItem(String dnsServerItem) {
        if (this.dnsServer == null) {
            this.dnsServer = new ArrayList<String>();
        }
        this.dnsServer.add(dnsServerItem);
        return this;
    }

    @Nullable
    public List<String> getDnsServer() {
        return this.dnsServer;
    }

    public void setDnsServer(List<String> dnsServer) {
        this.dnsServer = dnsServer;
    }

    public PodNetworkConfig hostadd(List<String> hostadd) {
        this.hostadd = hostadd;
        return this;
    }

    public PodNetworkConfig addHostaddItem(String hostaddItem) {
        if (this.hostadd == null) {
            this.hostadd = new ArrayList<String>();
        }
        this.hostadd.add(hostaddItem);
        return this;
    }

    @Nullable
    public List<String> getHostadd() {
        return this.hostadd;
    }

    public void setHostadd(List<String> hostadd) {
        this.hostadd = hostadd;
    }

    public PodNetworkConfig hostsFile(String hostsFile) {
        this.hostsFile = hostsFile;
        return this;
    }

    @Nullable
    public String getHostsFile() {
        return this.hostsFile;
    }

    public void setHostsFile(String hostsFile) {
        this.hostsFile = hostsFile;
    }

    public PodNetworkConfig netns(Namespace netns) {
        this.netns = netns;
        return this;
    }

    @Nullable
    @Valid
    public Namespace getNetns() {
        return this.netns;
    }

    public void setNetns(Namespace netns) {
        this.netns = netns;
    }

    public PodNetworkConfig networkOptions(Map<String, List<String>> networkOptions) {
        this.networkOptions = networkOptions;
        return this;
    }

    public PodNetworkConfig putNetworkOptionsItem(String key, List<String> networkOptionsItem) {
        if (this.networkOptions == null) {
            this.networkOptions = new HashMap<String, List<String>>();
        }
        this.networkOptions.put(key, networkOptionsItem);
        return this;
    }

    @Nullable
    @Valid
    public Map<String, List<String>> getNetworkOptions() {
        return this.networkOptions;
    }

    public void setNetworkOptions(Map<String, List<String>> networkOptions) {
        this.networkOptions = networkOptions;
    }

    public PodNetworkConfig noManageHostname(Boolean noManageHostname) {
        this.noManageHostname = noManageHostname;
        return this;
    }

    @Nullable
    public Boolean getNoManageHostname() {
        return this.noManageHostname;
    }

    public void setNoManageHostname(Boolean noManageHostname) {
        this.noManageHostname = noManageHostname;
    }

    public PodNetworkConfig noManageHosts(Boolean noManageHosts) {
        this.noManageHosts = noManageHosts;
        return this;
    }

    @Nullable
    public Boolean getNoManageHosts() {
        return this.noManageHosts;
    }

    public void setNoManageHosts(Boolean noManageHosts) {
        this.noManageHosts = noManageHosts;
    }

    public PodNetworkConfig noManageResolvConf(Boolean noManageResolvConf) {
        this.noManageResolvConf = noManageResolvConf;
        return this;
    }

    @Nullable
    public Boolean getNoManageResolvConf() {
        return this.noManageResolvConf;
    }

    public void setNoManageResolvConf(Boolean noManageResolvConf) {
        this.noManageResolvConf = noManageResolvConf;
    }

    public PodNetworkConfig portmappings(List<@Valid PortMapping> portmappings) {
        this.portmappings = portmappings;
        return this;
    }

    public PodNetworkConfig addPortmappingsItem(PortMapping portmappingsItem) {
        if (this.portmappings == null) {
            this.portmappings = new ArrayList<PortMapping>();
        }
        this.portmappings.add(portmappingsItem);
        return this;
    }

    @Nullable
    @Valid
    public @Valid List<@Valid PortMapping> getPortmappings() {
        return this.portmappings;
    }

    public void setPortmappings(List<@Valid PortMapping> portmappings) {
        this.portmappings = portmappings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodNetworkConfig podNetworkConfig = (PodNetworkConfig)o;
        return Objects.equals(this.networks, podNetworkConfig.networks) && Objects.equals(this.cniNetworks, podNetworkConfig.cniNetworks) && Objects.equals(this.dnsOption, podNetworkConfig.dnsOption) && Objects.equals(this.dnsSearch, podNetworkConfig.dnsSearch) && Objects.equals(this.dnsServer, podNetworkConfig.dnsServer) && Objects.equals(this.hostadd, podNetworkConfig.hostadd) && Objects.equals(this.hostsFile, podNetworkConfig.hostsFile) && Objects.equals(this.netns, podNetworkConfig.netns) && Objects.equals(this.networkOptions, podNetworkConfig.networkOptions) && Objects.equals(this.noManageHostname, podNetworkConfig.noManageHostname) && Objects.equals(this.noManageHosts, podNetworkConfig.noManageHosts) && Objects.equals(this.noManageResolvConf, podNetworkConfig.noManageResolvConf) && Objects.equals(this.portmappings, podNetworkConfig.portmappings);
    }

    public int hashCode() {
        return Objects.hash(this.networks, this.cniNetworks, this.dnsOption, this.dnsSearch, this.dnsServer, this.hostadd, this.hostsFile, this.netns, this.networkOptions, this.noManageHostname, this.noManageHosts, this.noManageResolvConf, this.portmappings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PodNetworkConfig {\n");
        sb.append("    networks: ").append(this.toIndentedString(this.networks)).append("\n");
        sb.append("    cniNetworks: ").append(this.toIndentedString(this.cniNetworks)).append("\n");
        sb.append("    dnsOption: ").append(this.toIndentedString(this.dnsOption)).append("\n");
        sb.append("    dnsSearch: ").append(this.toIndentedString(this.dnsSearch)).append("\n");
        sb.append("    dnsServer: ").append(this.toIndentedString(this.dnsServer)).append("\n");
        sb.append("    hostadd: ").append(this.toIndentedString(this.hostadd)).append("\n");
        sb.append("    hostsFile: ").append(this.toIndentedString(this.hostsFile)).append("\n");
        sb.append("    netns: ").append(this.toIndentedString(this.netns)).append("\n");
        sb.append("    networkOptions: ").append(this.toIndentedString(this.networkOptions)).append("\n");
        sb.append("    noManageHostname: ").append(this.toIndentedString(this.noManageHostname)).append("\n");
        sb.append("    noManageHosts: ").append(this.toIndentedString(this.noManageHosts)).append("\n");
        sb.append("    noManageResolvConf: ").append(this.toIndentedString(this.noManageResolvConf)).append("\n");
        sb.append("    portmappings: ").append(this.toIndentedString(this.portmappings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayportmappings;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in PodNetworkConfig is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `PodNetworkConfig` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_CNI_NETWORKS) != null && !jsonObj.get(SERIALIZED_NAME_CNI_NETWORKS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CNI_NETWORKS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `cni_networks` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CNI_NETWORKS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DNS_OPTION) != null && !jsonObj.get(SERIALIZED_NAME_DNS_OPTION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DNS_OPTION).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `dns_option` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DNS_OPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DNS_SEARCH) != null && !jsonObj.get(SERIALIZED_NAME_DNS_SEARCH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DNS_SEARCH).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `dns_search` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DNS_SEARCH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DNS_SERVER) != null && !jsonObj.get(SERIALIZED_NAME_DNS_SERVER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DNS_SERVER).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `dns_server` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DNS_SERVER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HOSTADD) != null && !jsonObj.get(SERIALIZED_NAME_HOSTADD).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_HOSTADD).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `hostadd` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HOSTADD).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HOSTS_FILE) != null && !jsonObj.get(SERIALIZED_NAME_HOSTS_FILE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_HOSTS_FILE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `hostsFile` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HOSTS_FILE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NETNS) != null && !jsonObj.get(SERIALIZED_NAME_NETNS).isJsonNull()) {
            Namespace.validateJsonElement(jsonObj.get(SERIALIZED_NAME_NETNS));
        }
        if (jsonObj.get(SERIALIZED_NAME_PORTMAPPINGS) != null && !jsonObj.get(SERIALIZED_NAME_PORTMAPPINGS).isJsonNull() && (jsonArrayportmappings = jsonObj.getAsJsonArray(SERIALIZED_NAME_PORTMAPPINGS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PORTMAPPINGS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `portmappings` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PORTMAPPINGS).toString()));
            }
            for (int i = 0; i < jsonArrayportmappings.size(); ++i) {
                PortMapping.validateJsonElement(jsonArrayportmappings.get(i));
            }
        }
    }

    public static PodNetworkConfig fromJson(String jsonString) throws IOException {
        return (PodNetworkConfig)JSON.getGson().fromJson(jsonString, PodNetworkConfig.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NETWORKS);
        openapiFields.add(SERIALIZED_NAME_CNI_NETWORKS);
        openapiFields.add(SERIALIZED_NAME_DNS_OPTION);
        openapiFields.add(SERIALIZED_NAME_DNS_SEARCH);
        openapiFields.add(SERIALIZED_NAME_DNS_SERVER);
        openapiFields.add(SERIALIZED_NAME_HOSTADD);
        openapiFields.add(SERIALIZED_NAME_HOSTS_FILE);
        openapiFields.add(SERIALIZED_NAME_NETNS);
        openapiFields.add(SERIALIZED_NAME_NETWORK_OPTIONS);
        openapiFields.add(SERIALIZED_NAME_NO_MANAGE_HOSTNAME);
        openapiFields.add(SERIALIZED_NAME_NO_MANAGE_HOSTS);
        openapiFields.add(SERIALIZED_NAME_NO_MANAGE_RESOLV_CONF);
        openapiFields.add(SERIALIZED_NAME_PORTMAPPINGS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!PodNetworkConfig.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PodNetworkConfig.class));
            return new TypeAdapter<PodNetworkConfig>(this){

                public void write(JsonWriter out, PodNetworkConfig value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public PodNetworkConfig read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    PodNetworkConfig.validateJsonElement(jsonElement);
                    return (PodNetworkConfig)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

