/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.java.podman;

import io.github.pod4dev.java.exceptions.PodmanException;
import io.github.pod4dev.libpodj.ApiClient;
import io.github.pod4dev.libpodj.ApiException;
import io.github.pod4dev.libpodj.JSON;
import java.io.File;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import javax.net.SocketFactory;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.unixdomainsockets.UnixDomainSocketFactory;

public class PodmanClient
extends ApiClient {
    public PodmanClient() {
    }

    public PodmanClient(OkHttpClient client) {
        super(client);
    }

    public PodmanClient(URI podmanUri) {
        OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder();
        switch (podmanUri.getScheme().toLowerCase()) {
            case "unix": {
                httpClientBuilder.socketFactory((SocketFactory)new UnixDomainSocketFactory(new File(podmanUri.getPath())));
                this.setBasePath("http://localhost/v5.0.0");
                break;
            }
            case "http": 
            case "https": 
            case "tcp": {
                this.setBasePath(podmanUri.toString());
                break;
            }
            default: {
                throw new PodmanException("Wrong schema");
            }
        }
        this.setHttpClient(httpClientBuilder.build());
    }

    public RequestBody serialize(Object obj, String contentType) throws ApiException {
        if (obj instanceof byte[]) {
            return RequestBody.create((byte[])((byte[])obj), (MediaType)MediaType.parse((String)contentType));
        }
        if (obj instanceof File) {
            return RequestBody.create((File)((File)obj), (MediaType)MediaType.parse((String)contentType));
        }
        if ("text/plain".equals(contentType) && obj instanceof String) {
            return RequestBody.create((byte[])((String)obj).getBytes(StandardCharsets.UTF_8), (MediaType)MediaType.parse((String)contentType));
        }
        if (this.isJsonMime(contentType)) {
            String content = obj != null ? JSON.serialize((Object)obj) : null;
            return RequestBody.create((byte[])content.getBytes(StandardCharsets.UTF_8), (MediaType)MediaType.parse((String)contentType));
        }
        if (obj instanceof String) {
            return RequestBody.create((byte[])((String)obj).getBytes(StandardCharsets.UTF_8), (MediaType)MediaType.parse((String)contentType));
        }
        throw new ApiException("Content type \"" + contentType + "\" is not supported");
    }
}

