/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.closeable.impl;

import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseableShutdownHook
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloseableShutdownHook.class);
    protected final Set<AutoCloseable> autoCloseables = new HashSet<AutoCloseable>();

    @Override
    public void run() {
        this.autoCloseables.forEach(autoCloseable -> this.doClose((AutoCloseable)autoCloseable));
    }

    protected void doClose(AutoCloseable autoCloseable) {
        try {
            autoCloseable.close();
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Error closing: %s", autoCloseable), e);
        }
    }

    public Set<AutoCloseable> getAutoCloseables() {
        return this.autoCloseables;
    }
}

