/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.heartbeat.impl;

import io.github.qsy7.background.BackgroundWorker;
import io.github.qsy7.heartbeat.Heartbeatable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class HeartbeatInstance {
    protected final Heartbeatable heartbeatable;
    protected final ScheduledFuture future;

    public HeartbeatInstance(Object intercepted) {
        this.heartbeatable = (Heartbeatable)intercepted;
        this.future = this.scheduleHeartbeat();
    }

    public boolean cancel() {
        if (!this.future.isCancelled() && !this.future.isDone()) {
            return this.future.cancel(true);
        }
        return true;
    }

    protected ScheduledFuture scheduleHeartbeat() {
        return BackgroundWorker.EXECUTOR_SERVICE.scheduleAtFixedRate(new HeartbeatRunnable(), this.heartbeatable.getHeartbeatInterval().getSeconds(), this.heartbeatable.getHeartbeatInterval().getSeconds(), TimeUnit.SECONDS);
    }

    private class HeartbeatRunnable
    implements Runnable {
        private HeartbeatRunnable() {
        }

        @Override
        public void run() {
            HeartbeatInstance.this.heartbeatable.onHeartbeat();
        }
    }
}

