/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.infrastructure.inject.core.helper;

import io.github.qsy7.infrastructure.inject.core.ApplicationInstance;
import io.github.qsy7.infrastructure.inject.core.NodeId;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.property.api.enumeration.ApplicationSCMVersion;
import io.github.qsy7.property.api.property.ApplicationEnvironment;
import io.github.qsy7.property.api.property.ApplicationManifestProperty;
import io.github.qsy7.property.api.property.ConfigurableProperty;
import io.github.qsy7.property.modules.environment.EnvironmentPropertySource;
import io.github.qsy7.property.modules.manifest.ManifestPropertySource;

public class ApplicationHelper {
    public static transient ApplicationInstance APPLICATION_INSTANCE;

    public static void setApplicationInstance(ApplicationInstance applicationInstance) {
        ApplicationInstance applicationInstance2;
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.infrastructure.inject.core.helper.ApplicationHelper", "setApplicationInstance", new Object[]{applicationInstance});
        APPLICATION_INSTANCE = applicationInstance2 = applicationInstance;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.infrastructure.inject.core.helper.ApplicationHelper", "setApplicationInstance", new Object[]{applicationInstance}, null, l);
    }

    public static ApplicationInstance getApplicationInstance() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.infrastructure.inject.core.helper.ApplicationHelper", "getApplicationInstance", new Object[0]);
        ApplicationInstance applicationInstance = APPLICATION_INSTANCE;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.infrastructure.inject.core.helper.ApplicationHelper", "getApplicationInstance", new Object[0], applicationInstance, l);
        return applicationInstance;
    }

    public static String getApplicationName() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.infrastructure.inject.core.helper.ApplicationHelper", "getApplicationName", new Object[0]);
        String string = ApplicationHelper.class.getPackage().getImplementationTitle();
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.infrastructure.inject.core.helper.ApplicationHelper", "getApplicationName", new Object[0], string, l);
        return string;
    }

    public static String getImplementationVersion() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.infrastructure.inject.core.helper.ApplicationHelper", "getImplementationVersion", new Object[0]);
        String string = ApplicationInstance.class.getPackage().getImplementationVersion();
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.infrastructure.inject.core.helper.ApplicationHelper", "getImplementationVersion", new Object[0], string, l);
        return string;
    }

    public static String getSCMVersion() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.infrastructure.inject.core.helper.ApplicationHelper", "getSCMVersion", new Object[0]);
        String string = ApplicationHelper.getManifestProperty(ApplicationSCMVersion.class);
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.infrastructure.inject.core.helper.ApplicationHelper", "getSCMVersion", new Object[0], string, l);
        return string;
    }

    public static ApplicationEnvironment getApplicationTargetEnvironment() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.infrastructure.inject.core.helper.ApplicationHelper", "getApplicationTargetEnvironment", new Object[0]);
        ApplicationEnvironment applicationEnvironment = ApplicationEnvironment.valueOf(ApplicationHelper.getManifestProperty(ApplicationEnvironment.class));
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.infrastructure.inject.core.helper.ApplicationHelper", "getApplicationTargetEnvironment", new Object[0], applicationEnvironment, l);
        return applicationEnvironment;
    }

    public static ApplicationEnvironment getApplicationEnvironment() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.infrastructure.inject.core.helper.ApplicationHelper", "getApplicationEnvironment", new Object[0]);
        Object object = EnvironmentPropertySource.get(ApplicationHelper.lookup(ApplicationEnvironment.class));
        object = object == null ? ApplicationEnvironment.Development : ApplicationEnvironment.valueOf((String)object);
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.infrastructure.inject.core.helper.ApplicationHelper", "getApplicationEnvironment", new Object[0], object, l);
        return object;
    }

    public static String getNodeId() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.infrastructure.inject.core.helper.ApplicationHelper", "getNodeId", new Object[0]);
        String string = EnvironmentPropertySource.get(ApplicationHelper.lookup(NodeId.class));
        string = string == null ? "local" : string;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.infrastructure.inject.core.helper.ApplicationHelper", "getNodeId", new Object[0], string, l);
        return string;
    }

    public static String getManifestProperty(Class<? extends ApplicationManifestProperty> clazz) {
        long l = MethodLogUtil.onEnter(LogLevel.INFO, "io.github.qsy7.infrastructure.inject.core.helper.ApplicationHelper", "getManifestProperty", new Object[]{clazz});
        Object object = clazz;
        object = ManifestPropertySource.get(((Class)object).getSimpleName());
        MethodLogUtil.onExit(LogLevel.INFO, "io.github.qsy7.infrastructure.inject.core.helper.ApplicationHelper", "getManifestProperty", new Object[]{clazz}, object, l);
        return object;
    }

    private static String lookup(Class<? extends ConfigurableProperty> clazz) {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.infrastructure.inject.core.helper.ApplicationHelper", "lookup", new Object[]{clazz});
        Object object = clazz;
        object = ((Class)object).getName();
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.infrastructure.inject.core.helper.ApplicationHelper", "lookup", new Object[]{clazz}, object, l);
        return object;
    }

    private ApplicationHelper() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.infrastructure.inject.core.helper.ApplicationHelper", "<init>", new Object[0]);
        ApplicationHelper applicationHelper = this;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.infrastructure.inject.core.helper.ApplicationHelper", "<init>", new Object[0], null, l);
    }
}

