/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.logging.enumeration;

import io.github.qsy7.logging.formatter.CollectionFormatter;
import io.github.qsy7.logging.formatter.MapFormatter;
import io.github.qsy7.logging.util.ArgumentUtil;
import java.util.Collection;
import java.util.Map;

public enum ArgumentType {
    CollectionArgument(Collection.class){

        @Override
        public Object doFormat(boolean isSensitive, Object input, int argumentLength) {
            return CollectionFormatter.format(isSensitive, (Collection)input, argumentLength);
        }

        @Override
        protected int length(Object input) {
            return ((Collection)input).size();
        }
    }
    ,
    MapArgument(Map.class){

        @Override
        protected int length(Object input) {
            return ((Map)input).size();
        }

        @Override
        public Object doFormat(boolean isSensitive, Object input, int argumentLength) {
            return MapFormatter.format(isSensitive, (Map)input, argumentLength);
        }
    }
    ,
    ObjectArrayArgument(Object[].class){

        @Override
        protected int length(Object input) {
            return ((Object[])input).length;
        }

        @Override
        public Object doFormat(boolean isSensitive, Object input, int argumentLength) {
            Object[] inputArray = (Object[])input;
            String[] out = new String[argumentLength];
            for (int i = 0; i < argumentLength; ++i) {
                out[i] = ArgumentUtil.format(inputArray[i], isSensitive);
            }
            return out;
        }
    }
    ,
    ObjectArgument(Object.class){

        @Override
        protected int length(Object input) {
            return 1;
        }

        @Override
        public Object doFormat(boolean isSensitive, Object input, int argumentLength) {
            return ArgumentUtil.format(input, isSensitive);
        }
    };

    private final Class argumentType;

    private ArgumentType(Class argumentType) {
        this.argumentType = argumentType;
    }

    public boolean supports(Class argumentClass) {
        return this.argumentType.isAssignableFrom(argumentClass);
    }

    public Object format(boolean isSensitive, Object input, int numberOfArguments) {
        int inputLength = this.length(input);
        int argumentLength = this.length(numberOfArguments, inputLength);
        boolean hasMore = this.hasMore(numberOfArguments, inputLength);
        Object out = this.doFormat(isSensitive, input, argumentLength);
        if (!hasMore) {
            return out;
        }
        return ArgumentUtil.formatOutput((String[])out, true);
    }

    protected boolean hasMore(int numberOfArguments, int inputLength) {
        return inputLength > numberOfArguments;
    }

    protected abstract Object doFormat(boolean var1, Object var2, int var3);

    protected int length(int numberOfArguments, int inputLength) {
        if (inputLength >= numberOfArguments) {
            return numberOfArguments;
        }
        return inputLength;
    }

    protected abstract int length(Object var1);
}

