/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.logging.util;

import io.github.qsy7.logging.enumeration.ArgumentType;
import io.github.qsy7.logging.util.SensitiveUtil;
import java.util.Arrays;

public class ArgumentUtil {
    public static final int NUMBER_OF_ARGUMENTS_TO_LOG = 3;
    public static String[] AVOID_TO_STRING_CLASSES = new String[]{"javax.persistence.EntityManager", "org.hibernate.internal.SessionImpl"};

    public static Object getArgument(boolean isSensitive, Object argument) {
        return ArgumentUtil.getArgument(isSensitive, argument, 3);
    }

    public static Object getArgument(boolean isSensitive, Object argument, int numberOfArguments) {
        if (argument == null) {
            return "null";
        }
        for (ArgumentType argumentType : ArgumentType.values()) {
            if (!argumentType.supports(argument.getClass())) continue;
            return argumentType.format(isSensitive, argument, numberOfArguments);
        }
        throw new IllegalArgumentException(argument.getClass() + " is not supported");
    }

    public static Object[] getArguments(boolean isSensitive, Object[] arguments) {
        return ArgumentUtil.getArguments(isSensitive, arguments, 3);
    }

    public static Object[] getArguments(boolean isSensitive, Object[] arguments, Object[] contextual) {
        return ArgumentUtil.getArguments(isSensitive, arguments, contextual, 3);
    }

    public static Object[] getArguments(boolean isSensitive, Object[] arguments, Object[] contextual, int numberOfArguments) {
        int i;
        int argumentLength = ArgumentUtil.getArgumentLength(arguments, numberOfArguments);
        Object[] data = Arrays.copyOf(arguments, argumentLength + contextual.length);
        for (i = 0; i < argumentLength; ++i) {
            data[i] = ArgumentUtil.getArgument(isSensitive, arguments[i], numberOfArguments);
        }
        for (i = 0; i < contextual.length; ++i) {
            data[argumentLength + i] = contextual[i];
        }
        return data;
    }

    public static Object[] getArguments(boolean isSensitive, Object[] arguments, int numberOfArguments) {
        if (arguments == null || arguments.length == 0) {
            return null;
        }
        int argumentLength = ArgumentUtil.getArgumentLength(arguments, numberOfArguments);
        Object[] data = new Object[argumentLength];
        for (int i = 0; i < argumentLength; ++i) {
            data[i] = ArgumentUtil.getArgument(isSensitive, arguments[i], numberOfArguments);
        }
        return data;
    }

    public static int getArgumentLength(Object[] arguments, int numberOfArguments) {
        if (arguments == null || arguments.length == 0) {
            return 0;
        }
        if (arguments.length > numberOfArguments) {
            return numberOfArguments;
        }
        return arguments.length;
    }

    public static String[] trim(String[] in, int lastIndex, int numberOfArguments) {
        if (lastIndex < numberOfArguments - 1) {
            return Arrays.copyOf(in, lastIndex + 1);
        }
        return in;
    }

    public static Object formatOutput(String[] arguments, boolean hasMore) {
        if (hasMore) {
            return "first " + arguments.length + "(" + String.join((CharSequence)",", arguments) + ")";
        }
        if (arguments.length > 1) {
            return "(" + String.join((CharSequence)",", arguments) + ")";
        }
        if (arguments.length == 1) {
            return arguments[0];
        }
        return "VOID";
    }

    public static String format(Object element, boolean isSensitive) {
        if (element == null) {
            return "null";
        }
        if (Arrays.binarySearch(AVOID_TO_STRING_CLASSES, element.getClass().getName()) == -1) {
            return SensitiveUtil.format(element.toString(), isSensitive);
        }
        return element.getClass() + "@" + element.hashCode();
    }

    private ArgumentUtil() {
    }
}

