/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.property.impl;

import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.property.api.PropertyManager;
import io.github.qsy7.property.impl.PropertyHelper;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPropertyManager<PropertyClassType> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPropertyManager.class);
    protected final Reflections reflections;
    protected final PropertyManager propertyManager;
    protected boolean invoked;

    /*
     * WARNING - void declaration
     */
    public void call() {
        long l = MethodLogUtil.onEnter(LogLevel.INFO, "io.github.qsy7.property.impl.AbstractPropertyManager", "call", new Object[0]);
        AbstractPropertyManager abstractPropertyManager = this;
        if (!abstractPropertyManager.invoked) {
            try {
                for (Class<PropertyClassType> clazz : abstractPropertyManager.getClasses()) {
                    if (!PropertyHelper.isConcrete(clazz)) continue;
                    try {
                        abstractPropertyManager.processClass(clazz);
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                        void e;
                        LOGGER.warn(String.format("Error configuring: %s", e), reflectiveOperationException);
                    }
                }
            }
            catch (Exception exception) {
                LOGGER.warn("Error configuring", exception);
            }
            abstractPropertyManager.invoked = true;
        }
        MethodLogUtil.onExit(LogLevel.INFO, "io.github.qsy7.property.impl.AbstractPropertyManager", "call", new Object[0], null, l);
    }

    protected abstract Collection<Class<? extends PropertyClassType>> getClasses();

    protected abstract void processClass(Class<? extends PropertyClassType> var1) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException;

    /*
     * WARNING - void declaration
     */
    public AbstractPropertyManager(Reflections reflections, PropertyManager propertyManager) {
        void propertyManager2;
        void reflections2;
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.property.impl.AbstractPropertyManager", "<init>", new Object[]{reflections, propertyManager});
        AbstractPropertyManager abstractPropertyManager = this;
        Reflections reflections3 = reflections;
        PropertyManager propertyManager3 = propertyManager;
        reflections2.invoked = false;
        reflections2.reflections = propertyManager2;
        reflections2.propertyManager = propertyManager3;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.property.impl.AbstractPropertyManager", "<init>", new Object[]{reflections, propertyManager}, null, l);
    }
}

