/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.property.impl;

import io.github.qsy7.logging.annotation.Sensitive;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.property.api.SecretService;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;

public class DefaultSecretService
implements SecretService {
    public DefaultSecretService() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.property.impl.DefaultSecretService", "<init>", new Object[0]);
        DefaultSecretService defaultSecretService = this;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.property.impl.DefaultSecretService", "<init>", new Object[0], null, l);
    }

    @Override
    @Sensitive
    public void put(String key, String message, String plaintext) {
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"secrets", "put", "-key", key, "-message", message});
            process.getOutputStream().write((plaintext + "\n").getBytes());
            process.getOutputStream().flush();
            process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Error getting value:", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Sensitive
    public String get(String key) {
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"secrets", "get", "-o=s", key});
            try (InputStream inputStream = process.getInputStream();){
                String output = IOUtils.toString(inputStream, Charset.defaultCharset());
                if (output == null || output.isEmpty()) {
                    String string2 = null;
                    return string2;
                }
                String string = output.trim();
                return string;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error getting value:", e);
        }
    }
}

