/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.property.impl.source;

import io.github.qsy7.logging.annotation.Sensitive;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.property.api.PropertyManager;
import io.github.qsy7.property.api.SecretService;
import io.github.qsy7.property.api.annotation.PropertyValueType;
import io.github.qsy7.property.api.property.ConfigurableProperty;
import io.github.qsy7.property.api.source.PropertySource;
import io.github.qsy7.property.impl.AbstractPropertyManager;
import io.github.qsy7.property.impl.PropertyHelper;
import io.github.qsy7.property.impl.PropertySourceComparator;
import io.github.qsy7.property.impl.source.DefaultPropertyValue;
import io.github.qsy7.property.impl.source.OptionalPropertyValue;
import io.github.qsy7.property.impl.source.PropertyValue;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.reflections.Reflections;

public class PropertySourceManager
extends AbstractPropertyManager<PropertySource> {
    protected final Map<Class<? extends ConfigurableProperty>, PropertyValue> propertyValueMap;
    protected final Map<Class<? extends ConfigurableProperty>, PropertyValue> encryptedPropertyValueMap;
    protected final SecretService secretService;

    /*
     * WARNING - void declaration
     */
    public PropertySourceManager(Reflections reflections, PropertyManager propertyManager, SecretService secretService) {
        void secretService2;
        void propertyManager2;
        void reflections2;
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.property.impl.source.PropertySourceManager", "<init>", new Object[]{reflections, propertyManager, secretService});
        PropertySourceManager propertySourceManager = this;
        Reflections reflections3 = reflections;
        PropertyManager propertyManager3 = propertyManager;
        SecretService secretService3 = secretService;
        super((Reflections)propertyManager2, (PropertyManager)secretService2);
        reflections2.propertyValueMap = new HashMap<Class<? extends ConfigurableProperty>, PropertyValue>();
        reflections2.encryptedPropertyValueMap = new HashMap<Class<? extends ConfigurableProperty>, PropertyValue>();
        reflections2.secretService = secretService3;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.property.impl.source.PropertySourceManager", "<init>", new Object[]{reflections, propertyManager, secretService}, null, l);
    }

    @Override
    public void call() {
        long l = MethodLogUtil.onEnter(LogLevel.INFO, "io.github.qsy7.property.impl.source.PropertySourceManager", "call", new Object[0]);
        PropertySourceManager propertySourceManager = this;
        super.call();
        propertySourceManager.decryptProperties();
        propertySourceManager.validateProperties();
        MethodLogUtil.onExit(LogLevel.INFO, "io.github.qsy7.property.impl.source.PropertySourceManager", "call", new Object[0], null, l);
    }

    public Iterable<Class<? extends ConfigurableProperty>> getKeys() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.property.impl.source.PropertySourceManager", "getKeys", new Object[0]);
        Object object = this;
        object = ((PropertySourceManager)object).reflections.getSubTypesOf(ConfigurableProperty.class);
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.property.impl.source.PropertySourceManager", "getKeys", new Object[0], object, l);
        return object;
    }

    protected void validateProperties() {
        long l = MethodLogUtil.onEnter(LogLevel.DEBUG, "io.github.qsy7.property.impl.source.PropertySourceManager", "validateProperties", new Object[0]);
        PropertySourceManager propertySourceManager = this;
        propertySourceManager.getKeys().forEach(p -> this.validateProperty((Class<? extends ConfigurableProperty>)p));
        MethodLogUtil.onExit(LogLevel.DEBUG, "io.github.qsy7.property.impl.source.PropertySourceManager", "validateProperties", new Object[0], null, l);
    }

    /*
     * WARNING - void declaration
     */
    protected void validateProperty(Class<? extends ConfigurableProperty> clazz) {
        void value;
        void configurablePropertyClass;
        long l = MethodLogUtil.onEnter(LogLevel.DEBUG, "io.github.qsy7.property.impl.source.PropertySourceManager", "validateProperty", new Object[]{clazz});
        PropertySourceManager propertySourceManager = this;
        Class<? extends ConfigurableProperty> clazz2 = clazz;
        String string = configurablePropertyClass.get(clazz2);
        PropertyHelper.validatePropertyConfiguration((Class<? extends ConfigurableProperty>)value, string);
        MethodLogUtil.onExit(LogLevel.DEBUG, "io.github.qsy7.property.impl.source.PropertySourceManager", "validateProperty", new Object[]{clazz}, null, l);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected List<Class<? extends PropertySource>> getClasses() {
        void orderedSourceClasses;
        long l = MethodLogUtil.onEnter(LogLevel.DEBUG, "io.github.qsy7.property.impl.source.PropertySourceManager", "getClasses", new Object[0]);
        Object object = this;
        ArrayList<Class<PropertySource>> arrayList = new ArrayList<Class<PropertySource>>();
        arrayList.addAll(orderedSourceClasses.reflections.getSubTypesOf(PropertySource.class));
        Collections.sort(arrayList, new PropertySourceComparator());
        object = arrayList;
        MethodLogUtil.onExit(LogLevel.DEBUG, "io.github.qsy7.property.impl.source.PropertySourceManager", "getClasses", new Object[0], object, l);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void processClass(Class<? extends PropertySource> clazz) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        void targetClass;
        long l = MethodLogUtil.onEnter(LogLevel.DEBUG, "io.github.qsy7.property.impl.source.PropertySourceManager", "processClass", new Object[]{clazz});
        PropertySourceManager propertySourceManager = this;
        Class<? extends PropertySource> clazz2 = clazz;
        PropertySource propertySource = clazz2.getConstructor(PropertyManager.class).newInstance(targetClass.propertyManager);
        propertySource.get();
        MethodLogUtil.onExit(LogLevel.DEBUG, "io.github.qsy7.property.impl.source.PropertySourceManager", "processClass", new Object[]{clazz}, null, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void decryptProperties() {
        long l = MethodLogUtil.onEnter(LogLevel.DEBUG, "io.github.qsy7.property.impl.source.PropertySourceManager", "decryptProperties", new Object[0]);
        PropertySourceManager propertySourceManager = this;
        try {
            for (Map.Entry<Class<? extends ConfigurableProperty>, PropertyValue> entry : propertySourceManager.encryptedPropertyValueMap.entrySet()) {
                void encryptedValue;
                void keyName;
                Class<? extends ConfigurableProperty> clazz = entry.getKey();
                String string = ((PropertyValue)keyName.getValue()).getValue();
                if (string == null) {
                    throw new IllegalArgumentException("Encrypted value is null, unable to decrypt it.");
                }
                String string2 = propertySourceManager.decryptProperty(string);
                if (string2 == null) {
                    throw new IllegalArgumentException("Plaintext value is null, check the encrypted value is correct: " + (Class)encryptedValue);
                }
                propertySourceManager.propertyValueMap.put((Class<? extends ConfigurableProperty>)encryptedValue, new DefaultPropertyValue(((PropertyValue)keyName.getValue()).getPropertyType(), string2));
            }
        }
        finally {
            propertySourceManager.encryptedPropertyValueMap.clear();
        }
        MethodLogUtil.onExit(LogLevel.DEBUG, "io.github.qsy7.property.impl.source.PropertySourceManager", "decryptProperties", new Object[0], null, l);
    }

    /*
     * WARNING - void declaration
     */
    public void set(Class<? extends ConfigurableProperty> clazz, String string) {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.property.impl.source.PropertySourceManager", "set", new Object[]{clazz, string});
        PropertySourceManager propertySourceManager = this;
        Class<? extends ConfigurableProperty> clazz2 = clazz;
        String string2 = string;
        if (string2 != null) {
            void value;
            void configurableProperty;
            if (configurableProperty.isSensitive((Class<? extends ConfigurableProperty>)value)) {
                configurableProperty.setSensitiveProperty((Class<? extends ConfigurableProperty>)value, string2);
            } else {
                configurableProperty.setProperty((Class<? extends ConfigurableProperty>)value, string2);
            }
        }
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.property.impl.source.PropertySourceManager", "set", new Object[]{clazz, string}, null, l);
    }

    protected boolean isSensitive(Class<? extends ConfigurableProperty> clazz) {
        long l = MethodLogUtil.onEnter(LogLevel.DEBUG, "io.github.qsy7.property.impl.source.PropertySourceManager", "isSensitive", new Object[]{clazz});
        PropertySourceManager propertySourceManager = this;
        Class<? extends ConfigurableProperty> clazz2 = clazz;
        boolean bl = clazz2.isAnnotationPresent(Sensitive.class);
        MethodLogUtil.onExit(LogLevel.DEBUG, "io.github.qsy7.property.impl.source.PropertySourceManager", "isSensitive", new Object[]{clazz}, bl, l);
        return bl;
    }

    @Sensitive
    protected void setSensitiveProperty(Class<? extends ConfigurableProperty> configurableProperty, String value) {
        this.encryptedPropertyValueMap.put(configurableProperty, new DefaultPropertyValue(PropertySourceManager.getPropertyValueType(configurableProperty), value));
    }

    /*
     * WARNING - void declaration
     */
    protected void setProperty(Class<? extends ConfigurableProperty> clazz, String string) {
        void configurableProperty;
        void value;
        long l = MethodLogUtil.onEnter(LogLevel.DEBUG, "io.github.qsy7.property.impl.source.PropertySourceManager", "setProperty", new Object[]{clazz, string});
        PropertySourceManager propertySourceManager = this;
        Class<? extends ConfigurableProperty> clazz2 = clazz;
        String string2 = string;
        if (PropertyHelper.isOptional((Class<? extends ConfigurableProperty>)value)) {
            configurableProperty.propertyValueMap.put((Class<? extends ConfigurableProperty>)value, new OptionalPropertyValue(PropertySourceManager.getPropertyValueType((Class<? extends ConfigurableProperty>)value), Optional.ofNullable(string2)));
        } else {
            configurableProperty.propertyValueMap.put((Class<? extends ConfigurableProperty>)value, new DefaultPropertyValue(PropertySourceManager.getPropertyValueType((Class<? extends ConfigurableProperty>)value), string2));
        }
        MethodLogUtil.onExit(LogLevel.DEBUG, "io.github.qsy7.property.impl.source.PropertySourceManager", "setProperty", new Object[]{clazz, string}, null, l);
    }

    public static Class getPropertyValueType(Class<? extends ConfigurableProperty> clazz) {
        long l = MethodLogUtil.onEnter(LogLevel.INFO, "io.github.qsy7.property.impl.source.PropertySourceManager", "getPropertyValueType", new Object[]{clazz});
        Class<ConfigurableProperty> clazz2 = clazz;
        clazz2 = clazz2.isAnnotationPresent(PropertyValueType.class) ? clazz2.getAnnotation(PropertyValueType.class).value() : String.class;
        MethodLogUtil.onExit(LogLevel.INFO, "io.github.qsy7.property.impl.source.PropertySourceManager", "getPropertyValueType", new Object[]{clazz}, clazz2, l);
        return clazz2;
    }

    @Sensitive
    protected String decryptProperty(String propertyKey) {
        return this.secretService.get(propertyKey);
    }

    @Sensitive
    public String get(Class<? extends ConfigurableProperty> configurableProperty) {
        PropertyValue defaultPropertyValue = this.propertyValueMap.get(configurableProperty);
        if (defaultPropertyValue != null) {
            return defaultPropertyValue.getValue();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Class type(Class<? extends ConfigurableProperty> clazz) {
        void configurableProperty;
        long l = MethodLogUtil.onEnter(LogLevel.INFO, "io.github.qsy7.property.impl.source.PropertySourceManager", "type", new Object[]{clazz});
        Object object = this;
        Class<? extends ConfigurableProperty> clazz2 = clazz;
        PropertyValue propertyValue = configurableProperty.propertyValueMap.get(clazz2);
        object = propertyValue != null ? propertyValue.getPropertyType() : null;
        MethodLogUtil.onExit(LogLevel.INFO, "io.github.qsy7.property.impl.source.PropertySourceManager", "type", new Object[]{clazz}, object, l);
        return object;
    }

    public Map<Class<? extends ConfigurableProperty>, PropertyValue> getPropertyValueMap() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.property.impl.source.PropertySourceManager", "getPropertyValueMap", new Object[0]);
        Object object = this;
        object = ((PropertySourceManager)object).propertyValueMap;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.property.impl.source.PropertySourceManager", "getPropertyValueMap", new Object[0], object, l);
        return object;
    }

    public Map<Class<? extends ConfigurableProperty>, PropertyValue> getEncryptedPropertyValueMap() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.property.impl.source.PropertySourceManager", "getEncryptedPropertyValueMap", new Object[0]);
        Object object = this;
        object = ((PropertySourceManager)object).encryptedPropertyValueMap;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.property.impl.source.PropertySourceManager", "getEncryptedPropertyValueMap", new Object[0], object, l);
        return object;
    }

    public SecretService getSecretService() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.property.impl.source.PropertySourceManager", "getSecretService", new Object[0]);
        Object object = this;
        object = ((PropertySourceManager)object).secretService;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.property.impl.source.PropertySourceManager", "getSecretService", new Object[0], object, l);
        return object;
    }
}

