/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.infrastructure.inject.core.service;

import io.github.qsy7.closeable.impl.CloseableUtil;
import io.github.qsy7.infrastructure.inject.core.Injector;
import io.github.qsy7.infrastructure.inject.core.service.StartupAware;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.ExceptionUtil;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.property.impl.PropertyHelper;
import jakarta.enterprise.util.AnnotationLiteral;
import java.util.Set;
import java.util.stream.Collectors;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceManager.class);
    protected final Reflections reflections;
    protected final Injector injector;

    public void initialize() {
        long l = MethodLogUtil.onEnter(LogLevel.INFO, "io.github.qsy7.infrastructure.inject.core.service.ServiceManager", "initialize", new Object[0]);
        ServiceManager serviceManager = this;
        ServiceManager serviceManager2 = serviceManager;
        try {
            serviceManager2.getStartupAwareServices().forEach(service -> this.doStartService((Class<? extends StartupAware>)service));
            serviceManager2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (serviceManager2 != null) {
            ExceptionUtil.onException("io.github.qsy7.infrastructure.inject.core.service.ServiceManager", "initialize", new Object[0], (Throwable)((Object)serviceManager2));
        }
        if (serviceManager2 != null) {
            throw serviceManager2;
        }
        MethodLogUtil.onExit(LogLevel.INFO, "io.github.qsy7.infrastructure.inject.core.service.ServiceManager", "initialize", new Object[0], null, l);
    }

    protected Set<Class<? extends StartupAware>> getStartupAwareServices() {
        long l = MethodLogUtil.onEnter(LogLevel.DEBUG, "io.github.qsy7.infrastructure.inject.core.service.ServiceManager", "getStartupAwareServices", new Object[0]);
        ServiceManager serviceManager = this;
        Object object = serviceManager;
        try {
            object = ((ServiceManager)object).reflections.getSubTypesOf(StartupAware.class).stream().filter(serviceClass -> PropertyHelper.isConcrete(serviceClass)).collect(Collectors.toSet());
            return object;
        }
        finally {
            Object var5_4 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void doStartService(Class<? extends StartupAware> clazz) {
        long l = MethodLogUtil.onEnter(LogLevel.DEBUG, "io.github.qsy7.infrastructure.inject.core.service.ServiceManager", "doStartService", new Object[]{clazz});
        ServiceManager serviceManager = this;
        Class<? extends StartupAware> clazz2 = clazz;
        ServiceManager serviceManager2 = serviceManager;
        Class<? extends StartupAware> clazz3 = clazz2;
        try {
            void serviceClass;
            StartupAware startupAware = (StartupAware)serviceManager2.injector.getInstance(serviceClass, new AnnotationLiteral[0]);
            startupAware.startup();
            CloseableUtil.addAutoCloseable(startupAware);
            serviceManager2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (serviceManager2 != null) {
            ExceptionUtil.onException("io.github.qsy7.infrastructure.inject.core.service.ServiceManager", "doStartService", new Object[]{clazz2}, (Throwable)((Object)serviceManager2));
        }
        if (serviceManager2 != null) {
            throw serviceManager2;
        }
        MethodLogUtil.onExit(LogLevel.DEBUG, "io.github.qsy7.infrastructure.inject.core.service.ServiceManager", "doStartService", new Object[]{clazz}, null, l);
    }

    /*
     * WARNING - void declaration
     */
    public ServiceManager(Reflections reflections, Injector injector) {
        void injector2;
        void reflections2;
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.infrastructure.inject.core.service.ServiceManager", "<init>", new Object[]{reflections, injector});
        ServiceManager serviceManager = this;
        Reflections reflections3 = reflections;
        Injector injector3 = injector;
        serviceManager.reflections = reflections2;
        serviceManager.injector = injector2;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.infrastructure.inject.core.service.ServiceManager", "<init>", new Object[]{reflections, injector}, null, l);
    }
}

