/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.logging.util;

import io.github.qsy7.logging.enumeration.ArgumentType;
import io.github.qsy7.logging.util.ObjectFormatUtil;

public class ArgumentUtil {
    public static final int NUMBER_OF_ARGUMENTS_TO_LOG = 3;

    public static String getArgument(boolean isSensitive, Object argument) {
        return ArgumentUtil.getArgument(isSensitive, argument, 3);
    }

    public static String getArgument(boolean isSensitive, Object argument, int numberOfArguments) {
        if (argument == null) {
            return "null";
        }
        for (ArgumentType argumentType : ArgumentType.values()) {
            if (!argumentType.supports(argument.getClass())) continue;
            return argumentType.format(isSensitive, argument, numberOfArguments);
        }
        throw new IllegalArgumentException(String.valueOf(argument.getClass()) + " is not supported");
    }

    public static String getArguments(boolean isSensitive, Object[] arguments) {
        return ArgumentUtil.getArguments(isSensitive, arguments, 3);
    }

    public static String getArguments(boolean isSensitive, Object[] arguments, int numberOfArguments) {
        if (arguments == null) {
            return "null";
        }
        if (arguments.length == 0) {
            return "[]";
        }
        int argumentLength = ArgumentUtil.length(arguments.length, numberOfArguments);
        String[] data = new String[argumentLength];
        for (int i = 0; i < argumentLength; ++i) {
            data[i] = ArgumentUtil.getArgument(isSensitive, arguments[i], numberOfArguments);
        }
        return ObjectFormatUtil.format(numberOfArguments, arguments.length, data);
    }

    public static int length(int numberOfArguments, int inputLength) {
        if (inputLength >= numberOfArguments) {
            return numberOfArguments;
        }
        return inputLength;
    }

    private ArgumentUtil() {
    }
}

