/*
 * Decompiled with CFR 0.152.
 */
package javax.jdo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.jdo.Constants;
import javax.jdo.JDOEnhancer;
import javax.jdo.JDOException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.ObjectState;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.spi.I18NHelper;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateInterrogation;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JDOHelper
implements Constants {
    static final Map<String, String> ATTRIBUTE_PROPERTY_XREF = JDOHelper.createAttributePropertyXref();
    private static final I18NHelper msg = I18NHelper.getInstance("javax.jdo.Bundle");
    private static JDOImplHelper implHelper = AccessController.doPrivileged(new PrivilegedAction<JDOImplHelper>(){

        @Override
        public JDOImplHelper run() {
            return JDOImplHelper.getInstance();
        }
    });
    private static JDOHelper instance = new JDOHelper();
    static JDOImplHelper.StateInterrogationObjectReturn getPersistenceManager = new JDOImplHelper.StateInterrogationObjectReturn(){

        @Override
        public Object get(Object pc, StateInterrogation si) {
            return si.getPersistenceManager(pc);
        }
    };
    static JDOImplHelper.StateInterrogationObjectReturn getObjectId = new JDOImplHelper.StateInterrogationObjectReturn(){

        @Override
        public Object get(Object pc, StateInterrogation si) {
            return si.getObjectId(pc);
        }
    };
    static JDOImplHelper.StateInterrogationObjectReturn getTransactionalObjectId = new JDOImplHelper.StateInterrogationObjectReturn(){

        @Override
        public Object get(Object pc, StateInterrogation si) {
            return si.getTransactionalObjectId(pc);
        }
    };
    static JDOImplHelper.StateInterrogationObjectReturn getVersion = new JDOImplHelper.StateInterrogationObjectReturn(){

        @Override
        public Object get(Object pc, StateInterrogation si) {
            return si.getVersion(pc);
        }
    };
    static JDOImplHelper.StateInterrogationBooleanReturn isPersistent = new JDOImplHelper.StateInterrogationBooleanReturn(){

        @Override
        public Boolean is(Object pc, StateInterrogation si) {
            return si.isPersistent(pc);
        }
    };
    static JDOImplHelper.StateInterrogationBooleanReturn isTransactional = new JDOImplHelper.StateInterrogationBooleanReturn(){

        @Override
        public Boolean is(Object pc, StateInterrogation si) {
            return si.isTransactional(pc);
        }
    };
    static JDOImplHelper.StateInterrogationBooleanReturn isDirty = new JDOImplHelper.StateInterrogationBooleanReturn(){

        @Override
        public Boolean is(Object pc, StateInterrogation si) {
            return si.isDirty(pc);
        }
    };
    static JDOImplHelper.StateInterrogationBooleanReturn isNew = new JDOImplHelper.StateInterrogationBooleanReturn(){

        @Override
        public Boolean is(Object pc, StateInterrogation si) {
            return si.isNew(pc);
        }
    };
    static JDOImplHelper.StateInterrogationBooleanReturn isDeleted = new JDOImplHelper.StateInterrogationBooleanReturn(){

        @Override
        public Boolean is(Object pc, StateInterrogation si) {
            return si.isDeleted(pc);
        }
    };
    static JDOImplHelper.StateInterrogationBooleanReturn isDetached = new JDOImplHelper.StateInterrogationBooleanReturn(){

        @Override
        public Boolean is(Object pc, StateInterrogation si) {
            return si.isDetached(pc);
        }
    };

    static Map<String, String> createAttributePropertyXref() {
        HashMap<String, String> xref = new HashMap<String, String>();
        xref.put("class", "javax.jdo.PersistenceManagerFactoryClass");
        xref.put("connection-driver-name", "javax.jdo.option.ConnectionDriverName");
        xref.put("connection-factory-name", "javax.jdo.option.ConnectionFactoryName");
        xref.put("connection-factory2-name", "javax.jdo.option.ConnectionFactory2Name");
        xref.put("connection-password", "javax.jdo.option.ConnectionPassword");
        xref.put("connection-url", "javax.jdo.option.ConnectionURL");
        xref.put("connection-user-name", "javax.jdo.option.ConnectionUserName");
        xref.put("ignore-cache", "javax.jdo.option.IgnoreCache");
        xref.put("mapping", "javax.jdo.option.Mapping");
        xref.put("multithreaded", "javax.jdo.option.Multithreaded");
        xref.put("nontransactional-read", "javax.jdo.option.NontransactionalRead");
        xref.put("nontransactional-write", "javax.jdo.option.NontransactionalWrite");
        xref.put("optimistic", "javax.jdo.option.Optimistic");
        xref.put("persistence-unit-name", "javax.jdo.option.PersistenceUnitName");
        xref.put("name", "javax.jdo.option.Name");
        xref.put("restore-values", "javax.jdo.option.RestoreValues");
        xref.put("retain-values", "javax.jdo.option.RetainValues");
        xref.put("detach-all-on-commit", "javax.jdo.option.DetachAllOnCommit");
        xref.put("server-time-zone-id", "javax.jdo.option.ServerTimeZoneID");
        xref.put("datastore-read-timeout-millis", "javax.jdo.option.DatastoreReadTimeoutMillis");
        xref.put("datastore-write-timeout-millis", "javax.jdo.option.DatastoreWriteTimeoutMillis");
        return Collections.unmodifiableMap(xref);
    }

    public static JDOHelper getInstance() {
        return instance;
    }

    public static PersistenceManager getPersistenceManager(Object pc) {
        if (pc instanceof PersistenceCapable) {
            return ((PersistenceCapable)pc).jdoGetPersistenceManager();
        }
        return (PersistenceManager)implHelper.nonBinaryCompatibleGet(pc, getPersistenceManager);
    }

    public static void makeDirty(Object pc, String fieldName) {
        if (pc instanceof PersistenceCapable) {
            ((PersistenceCapable)pc).jdoMakeDirty(fieldName);
        } else {
            implHelper.nonBinaryCompatibleMakeDirty(pc, fieldName);
        }
    }

    public static Object getObjectId(Object pc) {
        if (pc instanceof PersistenceCapable) {
            return ((PersistenceCapable)pc).jdoGetObjectId();
        }
        return implHelper.nonBinaryCompatibleGet(pc, getObjectId);
    }

    public static Collection<Object> getObjectIds(Collection<?> pcs) {
        ArrayList<Object> result = new ArrayList<Object>();
        Iterator<?> it = pcs.iterator();
        while (it.hasNext()) {
            result.add(JDOHelper.getObjectId(it.next()));
        }
        return result;
    }

    public static Object[] getObjectIds(Object[] pcs) {
        Object[] result = new Object[pcs.length];
        for (int i = 0; i < pcs.length; ++i) {
            result[i] = JDOHelper.getObjectId(pcs[i]);
        }
        return result;
    }

    public static Object getTransactionalObjectId(Object pc) {
        if (pc instanceof PersistenceCapable) {
            return ((PersistenceCapable)pc).jdoGetTransactionalObjectId();
        }
        return implHelper.nonBinaryCompatibleGet(pc, getTransactionalObjectId);
    }

    public static Object getVersion(Object pc) {
        if (pc instanceof PersistenceCapable) {
            return ((PersistenceCapable)pc).jdoGetVersion();
        }
        return implHelper.nonBinaryCompatibleGet(pc, getVersion);
    }

    public static boolean isDirty(Object pc) {
        if (pc instanceof PersistenceCapable) {
            return ((PersistenceCapable)pc).jdoIsDirty();
        }
        return implHelper.nonBinaryCompatibleIs(pc, isDirty);
    }

    public static boolean isTransactional(Object pc) {
        if (pc instanceof PersistenceCapable) {
            return ((PersistenceCapable)pc).jdoIsTransactional();
        }
        return implHelper.nonBinaryCompatibleIs(pc, isTransactional);
    }

    public static boolean isPersistent(Object pc) {
        if (pc instanceof PersistenceCapable) {
            return ((PersistenceCapable)pc).jdoIsPersistent();
        }
        return implHelper.nonBinaryCompatibleIs(pc, isPersistent);
    }

    public static boolean isNew(Object pc) {
        if (pc instanceof PersistenceCapable) {
            return ((PersistenceCapable)pc).jdoIsNew();
        }
        return implHelper.nonBinaryCompatibleIs(pc, isNew);
    }

    public static boolean isDeleted(Object pc) {
        if (pc instanceof PersistenceCapable) {
            return ((PersistenceCapable)pc).jdoIsDeleted();
        }
        return implHelper.nonBinaryCompatibleIs(pc, isDeleted);
    }

    public static boolean isDetached(Object pc) {
        if (pc instanceof PersistenceCapable) {
            return ((PersistenceCapable)pc).jdoIsDetached();
        }
        return implHelper.nonBinaryCompatibleIs(pc, isDetached);
    }

    public static ObjectState getObjectState(Object pc) {
        if (pc == null) {
            return null;
        }
        if (JDOHelper.isDetached(pc)) {
            if (JDOHelper.isDirty(pc)) {
                return ObjectState.DETACHED_DIRTY;
            }
            return ObjectState.DETACHED_CLEAN;
        }
        if (JDOHelper.isPersistent(pc)) {
            if (JDOHelper.isTransactional(pc)) {
                if (JDOHelper.isDirty(pc)) {
                    if (JDOHelper.isNew(pc)) {
                        if (JDOHelper.isDeleted(pc)) {
                            return ObjectState.PERSISTENT_NEW_DELETED;
                        }
                        return ObjectState.PERSISTENT_NEW;
                    }
                    if (JDOHelper.isDeleted(pc)) {
                        return ObjectState.PERSISTENT_DELETED;
                    }
                    return ObjectState.PERSISTENT_DIRTY;
                }
                return ObjectState.PERSISTENT_CLEAN;
            }
            if (JDOHelper.isDirty(pc)) {
                return ObjectState.PERSISTENT_NONTRANSACTIONAL_DIRTY;
            }
            return ObjectState.HOLLOW_PERSISTENT_NONTRANSACTIONAL;
        }
        if (JDOHelper.isTransactional(pc)) {
            if (JDOHelper.isDirty(pc)) {
                return ObjectState.TRANSIENT_DIRTY;
            }
            return ObjectState.TRANSIENT_CLEAN;
        }
        return ObjectState.TRANSIENT;
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory() {
        ClassLoader cl = JDOHelper.getContextClassLoader();
        return JDOHelper.getPersistenceManagerFactory(null, "", cl, cl);
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(ClassLoader pmfClassLoader) {
        return JDOHelper.getPersistenceManagerFactory(null, "", pmfClassLoader, pmfClassLoader);
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(Map<?, ?> props) {
        return JDOHelper.getPersistenceManagerFactory(null, props, JDOHelper.getContextClassLoader());
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(Map<?, ?> props, ClassLoader pmfClassLoader) {
        return JDOHelper.getPersistenceManagerFactory(null, props, pmfClassLoader);
    }

    protected static PersistenceManagerFactory getPersistenceManagerFactory(Map<?, ?> overrides, Map<?, ?> props, ClassLoader pmfClassLoader) {
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        if (pmfClassLoader == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNullLoader"));
        }
        JDOImplHelper.assertOnlyKnownStandardProperties(overrides);
        JDOImplHelper.assertOnlyKnownStandardProperties(props);
        String pmfClassName = (String)props.get("javax.jdo.PersistenceManagerFactoryClass");
        if (!JDOHelper.isNullOrBlank(pmfClassName)) {
            return JDOHelper.invokeGetPersistenceManagerFactoryOnImplementation(pmfClassName, overrides, props, pmfClassLoader);
        }
        Enumeration<URL> urls = null;
        try {
            urls = JDOHelper.getResources(pmfClassLoader, "META-INF/services/javax.jdo.PersistenceManagerFactory");
        }
        catch (Throwable ex) {
            exceptions.add(ex);
        }
        if (urls != null) {
            while (urls.hasMoreElements()) {
                try {
                    pmfClassName = JDOHelper.getClassNameFromURL(urls.nextElement());
                    PersistenceManagerFactory pmf = JDOHelper.invokeGetPersistenceManagerFactoryOnImplementation(pmfClassName, overrides, props, pmfClassLoader);
                    return pmf;
                }
                catch (Throwable ex) {
                    exceptions.add(ex);
                }
            }
        }
        throw new JDOFatalUserException(msg.msg("EXC_GetPMFNoPMFClassNamePropertyOrPUNameProperty"), exceptions.toArray(new Throwable[exceptions.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getClassNameFromURL(URL url) throws IOException {
        InputStream is = JDOHelper.openStream(url);
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                String[] tokens = line.split("\\s");
                String pmfClassName = tokens[0];
                int indexOfComment = pmfClassName.indexOf("#");
                if (indexOfComment == -1) {
                    String string = pmfClassName;
                    return string;
                }
                String string = pmfClassName.substring(0, indexOfComment);
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(String name) {
        ClassLoader cl = JDOHelper.getContextClassLoader();
        return JDOHelper.getPersistenceManagerFactory(null, name, cl, cl);
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(String name, ClassLoader loader) {
        return JDOHelper.getPersistenceManagerFactory(null, name, loader, loader);
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(String name, ClassLoader resourceLoader, ClassLoader pmfLoader) {
        return JDOHelper.getPersistenceManagerFactory(null, name, resourceLoader, pmfLoader);
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(Map<?, ?> overrides, String name) {
        ClassLoader cl = JDOHelper.getContextClassLoader();
        return JDOHelper.getPersistenceManagerFactory(overrides, name, cl, cl);
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(Map<?, ?> overrides, String name, ClassLoader resourceLoader) {
        return JDOHelper.getPersistenceManagerFactory(overrides, name, resourceLoader, resourceLoader);
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(Map<?, ?> overrides, String name, ClassLoader resourceLoader, ClassLoader pmfLoader) {
        if (pmfLoader == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNullPMFLoader"));
        }
        if (resourceLoader == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNullPropsLoader"));
        }
        Map<Object, Object> props = null;
        String string = name = name == null ? "" : name.trim();
        if (!"".equals(name)) {
            props = JDOHelper.loadPropertiesFromResource(resourceLoader, name);
        }
        if (props != null) {
            props.put("javax.jdo.option.spi.ResourceName", name);
            props.remove("javax.jdo.option.Name");
            return JDOHelper.getPersistenceManagerFactory(overrides, props, pmfLoader);
        }
        props = JDOHelper.getPropertiesFromJdoconfig(name, resourceLoader);
        if (props != null) {
            props.put("javax.jdo.option.Name", name);
            props.remove("javax.jdo.option.spi.ResourceName");
            return JDOHelper.getPersistenceManagerFactory(overrides, props, pmfLoader);
        }
        if (!"".equals(name)) {
            props = new Properties();
            props.put("javax.jdo.option.PersistenceUnitName", name);
            return JDOHelper.getPersistenceManagerFactory(overrides, props, pmfLoader);
        }
        throw new JDOFatalUserException(msg.msg("EXC_NoPMFConfigurableViaPropertiesOrXML", name));
    }

    protected static PersistenceManagerFactory invokeGetPersistenceManagerFactoryOnImplementation(String pmfClassName, Map<?, ?> overrides, Map<?, ?> properties, ClassLoader cl) {
        if (overrides != null) {
            try {
                Class<?> implClass = JDOHelper.forName(pmfClassName, true, cl);
                Method m = JDOHelper.getMethod(implClass, "getPersistenceManagerFactory", new Class[]{Map.class, Map.class});
                PersistenceManagerFactory pmf = (PersistenceManagerFactory)JDOHelper.invoke(m, null, new Object[]{overrides, properties});
                if (pmf == null) {
                    throw new JDOFatalInternalException(msg.msg("EXC_GetPMFNullPMF", pmfClassName));
                }
                return pmf;
            }
            catch (ClassNotFoundException e) {
                throw new JDOFatalUserException(msg.msg("EXC_GetPMFClassNotFound", pmfClassName), e);
            }
            catch (NoSuchMethodException e) {
                throw new JDOFatalInternalException(msg.msg("EXC_GetPMFNoSuchMethod2", pmfClassName), e);
            }
            catch (NullPointerException e) {
                throw new JDOFatalInternalException(msg.msg("EXC_GetPMFNullPointerException", pmfClassName), e);
            }
            catch (IllegalAccessException e) {
                throw new JDOFatalUserException(msg.msg("EXC_GetPMFIllegalAccess", pmfClassName), e);
            }
            catch (ClassCastException e) {
                throw new JDOFatalInternalException(msg.msg("EXC_GetPMFClassCastException", pmfClassName), e);
            }
            catch (InvocationTargetException ite) {
                Throwable nested = ite.getTargetException();
                if (nested instanceof JDOException) {
                    throw (JDOException)nested;
                }
                throw new JDOFatalInternalException(msg.msg("EXC_GetPMFUnexpectedException"), ite);
            }
        }
        try {
            Class<?> implClass = JDOHelper.forName(pmfClassName, true, cl);
            Method m = JDOHelper.getMethod(implClass, "getPersistenceManagerFactory", new Class[]{Map.class});
            PersistenceManagerFactory pmf = (PersistenceManagerFactory)JDOHelper.invoke(m, null, new Object[]{properties});
            if (pmf == null) {
                throw new JDOFatalInternalException(msg.msg("EXC_GetPMFNullPMF", pmfClassName));
            }
            return pmf;
        }
        catch (ClassNotFoundException e) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFClassNotFound", pmfClassName), e);
        }
        catch (NoSuchMethodException e) {
            throw new JDOFatalInternalException(msg.msg("EXC_GetPMFNoSuchMethod", pmfClassName), e);
        }
        catch (NullPointerException e) {
            throw new JDOFatalInternalException(msg.msg("EXC_GetPMFNullPointerException", pmfClassName), e);
        }
        catch (IllegalAccessException e) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFIllegalAccess", pmfClassName), e);
        }
        catch (ClassCastException e) {
            throw new JDOFatalInternalException(msg.msg("EXC_GetPMFClassCastException", pmfClassName), e);
        }
        catch (InvocationTargetException ite) {
            Throwable nested = ite.getTargetException();
            if (nested instanceof JDOException) {
                throw (JDOException)nested;
            }
            throw new JDOFatalInternalException(msg.msg("EXC_GetPMFUnexpectedException"), ite);
        }
    }

    protected static Map<Object, Object> loadPropertiesFromResource(ClassLoader resourceLoader, String name) {
        InputStream in = null;
        Properties props = null;
        try {
            in = JDOHelper.getResourceAsStream(resourceLoader, name);
            if (in != null) {
                props = new Properties();
                props.load(in);
            }
        }
        catch (IOException ioe) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFIOExceptionRsrc", name), ioe);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return props;
    }

    protected static Map<Object, Object> getPropertiesFromJdoconfig(String name, ClassLoader resourceLoader) {
        return JDOHelper.getNamedPMFProperties(name, resourceLoader, "META-INF/jdoconfig.xml");
    }

    protected static Map<Object, Object> getNamedPMFProperties(String name, ClassLoader resourceLoader, String jdoconfigResourceName) {
        HashMap<String, Map<Object, Object>> propertiesByNameInAllConfigs = new HashMap<String, Map<Object, Object>>();
        try {
            URL firstFoundConfigURL = null;
            Enumeration<URL> resources = JDOHelper.getResources(resourceLoader, jdoconfigResourceName);
            if (resources.hasMoreElements()) {
                ArrayList<URL> processedResources = new ArrayList<URL>();
                DocumentBuilderFactory factory = JDOHelper.getDocumentBuilderFactory();
                do {
                    URL currentConfigURL;
                    if (processedResources.contains(currentConfigURL = resources.nextElement())) continue;
                    processedResources.add(currentConfigURL);
                    Map<String, Map<Object, Object>> propertiesByNameInCurrentConfig = JDOHelper.readNamedPMFProperties(currentConfigURL, name, factory);
                    if (propertiesByNameInCurrentConfig.containsKey(name)) {
                        if (firstFoundConfigURL == null) {
                            firstFoundConfigURL = currentConfigURL;
                        }
                        if (propertiesByNameInAllConfigs.containsKey(name)) {
                            throw new JDOFatalUserException(msg.msg("EXC_DuplicateRequestedNamedPMFFoundInDifferentConfigs", "".equals(name) ? "(anonymous)" : name, firstFoundConfigURL.toExternalForm(), currentConfigURL.toExternalForm()));
                        }
                    }
                    propertiesByNameInAllConfigs.putAll(propertiesByNameInCurrentConfig);
                } while (resources.hasMoreElements());
            }
        }
        catch (FactoryConfigurationError e) {
            throw new JDOFatalUserException(msg.msg("ERR_NoDocumentBuilderFactory"), e);
        }
        catch (IOException ioe) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFIOExceptionRsrc", name), ioe);
        }
        return (Map)propertiesByNameInAllConfigs.get(name);
    }

    protected static DocumentBuilderFactory getDocumentBuilderFactory() {
        DocumentBuilderFactory factory = implHelper.getRegisteredDocumentBuilderFactory();
        if (factory == null) {
            factory = JDOHelper.getDefaultDocumentBuilderFactory();
        }
        return factory;
    }

    protected static DocumentBuilderFactory getDefaultDocumentBuilderFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(true);
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setExpandEntityReferences(true);
        return factory;
    }

    protected static ErrorHandler getErrorHandler() {
        ErrorHandler handler = implHelper.getRegisteredErrorHandler();
        if (handler == null) {
            handler = JDOHelper.getDefaultErrorHandler();
        }
        return handler;
    }

    protected static ErrorHandler getDefaultErrorHandler() {
        return new ErrorHandler(){

            @Override
            public void error(SAXParseException exception) throws SAXException {
                throw exception;
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                throw exception;
            }

            @Override
            public void warning(SAXParseException exception) throws SAXException {
            }
        };
    }

    protected static Map<String, Map<Object, Object>> readNamedPMFProperties(URL url, String requestedPMFName, DocumentBuilderFactory factory) {
        requestedPMFName = requestedPMFName == null ? "" : requestedPMFName.trim();
        HashMap<String, Map<Object, Object>> propertiesByName = new HashMap<String, Map<Object, Object>>();
        InputStream in = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(JDOHelper.getErrorHandler());
            in = JDOHelper.openStream(url);
            Document doc = builder.parse(in);
            Element root = doc.getDocumentElement();
            if (root == null) {
                throw new JDOFatalUserException(msg.msg("EXC_InvalidJDOConfigNoRoot", url.toExternalForm()));
            }
            NodeList pmfs = root.getElementsByTagName("persistence-manager-factory");
            for (int i = 0; i < pmfs.getLength(); ++i) {
                Node pmfElement = pmfs.item(i);
                Properties pmfPropertiesFromAttributes = JDOHelper.readPropertiesFromPMFElementAttributes(pmfElement);
                Properties pmfPropertiesFromElements = JDOHelper.readPropertiesFromPMFSubelements(pmfElement, url);
                String pmfNameFromAtts = pmfPropertiesFromAttributes.getProperty("javax.jdo.option.Name");
                String pmfNameFromElem = pmfPropertiesFromElements.getProperty("javax.jdo.option.Name");
                String pmfName = null;
                if (JDOHelper.isNullOrBlank(pmfNameFromAtts)) {
                    pmfName = !JDOHelper.isNullOrBlank(pmfNameFromElem) ? pmfNameFromElem : "";
                } else {
                    if (!JDOHelper.isNullOrBlank(pmfNameFromElem)) {
                        throw new JDOFatalUserException(msg.msg("EXC_DuplicatePMFNamePropertyFoundWithinConfig", pmfNameFromAtts, pmfNameFromElem, url.toExternalForm()));
                    }
                    pmfName = pmfNameFromAtts;
                }
                String string = pmfName = pmfName == null ? "" : pmfName.trim();
                if (requestedPMFName.equals(pmfName)) {
                    for (String string2 : pmfPropertiesFromAttributes.keySet()) {
                        if (!pmfPropertiesFromElements.contains(string2)) continue;
                        throw new JDOFatalUserException(msg.msg("EXC_DuplicatePropertyFound", string2, pmfName, url.toExternalForm()));
                    }
                }
                Properties pmfProps = new Properties();
                pmfProps.putAll((Map<?, ?>)pmfPropertiesFromAttributes);
                pmfProps.putAll((Map<?, ?>)pmfPropertiesFromElements);
                if (pmfName.equals(requestedPMFName) && propertiesByName.containsKey(pmfName)) {
                    throw new JDOFatalUserException(msg.msg("EXC_DuplicateRequestedNamedPMFFoundInSameConfig", pmfName, url.toExternalForm()));
                }
                propertiesByName.put(pmfName, pmfProps);
            }
            HashMap<String, Map<Object, Object>> hashMap = propertiesByName;
            return hashMap;
        }
        catch (IOException ioe) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFIOExceptionRsrc", url.toString()), ioe);
        }
        catch (ParserConfigurationException e) {
            throw new JDOFatalInternalException(msg.msg("EXC_ParserConfigException"), e);
        }
        catch (SAXParseException e) {
            throw new JDOFatalUserException(msg.msg("EXC_SAXParseException", url.toExternalForm(), new Integer(e.getLineNumber()), new Integer(e.getColumnNumber())), e);
        }
        catch (SAXException e) {
            throw new JDOFatalUserException(msg.msg("EXC_SAXException", url.toExternalForm()), e);
        }
        catch (JDOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new JDOFatalUserException(msg.msg("EXC_SAXException", url.toExternalForm()), e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected static Properties readPropertiesFromPMFElementAttributes(Node pmfElement) {
        Properties p = new Properties();
        NamedNodeMap attributes = pmfElement.getAttributes();
        if (attributes == null) {
            return p;
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node att = attributes.item(i);
            String attName = att.getNodeName();
            String attValue = att.getNodeValue().trim();
            String jdoPropertyName = ATTRIBUTE_PROPERTY_XREF.get(attName);
            p.put(jdoPropertyName != null ? jdoPropertyName : attName, attValue);
        }
        return p;
    }

    protected static Properties readPropertiesFromPMFSubelements(Node pmfElement, URL url) {
        Properties p = new Properties();
        NodeList elements = pmfElement.getChildNodes();
        if (elements == null) {
            return p;
        }
        for (int i = 0; i < elements.getLength(); ++i) {
            Node element = elements.item(i);
            if (element.getNodeType() != 1) continue;
            String elementName = element.getNodeName();
            NamedNodeMap attributes = element.getAttributes();
            if ("property".equalsIgnoreCase(elementName)) {
                String propertyName;
                Node nameAtt = attributes.getNamedItem("name");
                if (nameAtt == null) {
                    throw new JDOFatalUserException(msg.msg("EXC_PropertyElementHasNoNameAttribute", url));
                }
                String name = nameAtt.getNodeValue().trim();
                if ("".equals(name)) {
                    throw new JDOFatalUserException(msg.msg("EXC_PropertyElementNameAttributeHasNoValue", name, url));
                }
                String jdoPropertyName = ATTRIBUTE_PROPERTY_XREF.get(name);
                String string = propertyName = jdoPropertyName != null ? jdoPropertyName : name;
                if (p.containsKey(propertyName)) {
                    throw new JDOFatalUserException(msg.msg("EXC_DuplicatePropertyNameGivenInPropertyElement", propertyName, url));
                }
                Node valueAtt = attributes.getNamedItem("value");
                String value = valueAtt == null ? null : valueAtt.getNodeValue().trim();
                p.put(propertyName, value);
                continue;
            }
            if (!"instance-lifecycle-listener".equals(elementName)) continue;
            Node listenerAtt = attributes.getNamedItem("listener");
            if (listenerAtt == null) {
                throw new JDOFatalUserException(msg.msg("EXC_MissingListenerAttribute", url));
            }
            String listener = listenerAtt.getNodeValue().trim();
            if ("".equals(listener)) {
                throw new JDOFatalUserException(msg.msg("EXC_MissingListenerAttributeValue", url));
            }
            listener = "javax.jdo.listener.InstanceLifecycleListener." + listener;
            Node classesAtt = attributes.getNamedItem("classes");
            String value = classesAtt == null ? "" : classesAtt.getNodeValue().trim();
            p.put(listener, value);
        }
        return p;
    }

    protected static boolean isNullOrBlank(String s) {
        return s == null || "".equals(s.trim());
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(File propsFile) {
        return JDOHelper.getPersistenceManagerFactory(propsFile, JDOHelper.getContextClassLoader());
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(File propsFile, ClassLoader loader) {
        if (propsFile == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNullFile"));
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(propsFile);
            PersistenceManagerFactory persistenceManagerFactory = JDOHelper.getPersistenceManagerFactory(in, loader);
            return persistenceManagerFactory;
        }
        catch (FileNotFoundException fnfe) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNoFile", propsFile), fnfe);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(String jndiLocation, Context context) {
        return JDOHelper.getPersistenceManagerFactory(jndiLocation, context, JDOHelper.getContextClassLoader());
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(String jndiLocation, Context context, ClassLoader loader) {
        if (jndiLocation == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNullJndiLoc"));
        }
        if (loader == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNullLoader"));
        }
        try {
            if (context == null) {
                context = new InitialContext();
            }
            Object o = context.lookup(jndiLocation);
            return (PersistenceManagerFactory)PortableRemoteObject.narrow(o, PersistenceManagerFactory.class);
        }
        catch (NamingException ne) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNamingException", jndiLocation, loader), ne);
        }
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(InputStream stream) {
        return JDOHelper.getPersistenceManagerFactory(stream, JDOHelper.getContextClassLoader());
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(InputStream stream, ClassLoader loader) {
        if (stream == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNullStream"));
        }
        Properties props = new Properties();
        try {
            props.load(stream);
        }
        catch (IOException ioe) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFIOExceptionStream"), ioe);
        }
        return JDOHelper.getPersistenceManagerFactory(props, loader);
    }

    public static JDOEnhancer getEnhancer() {
        return JDOHelper.getEnhancer(JDOHelper.getContextClassLoader());
    }

    public static JDOEnhancer getEnhancer(ClassLoader loader) {
        ClassLoader ctrLoader = loader;
        if (ctrLoader == null) {
            ctrLoader = Thread.currentThread().getContextClassLoader();
        }
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        int numberOfJDOEnhancers = 0;
        try {
            Enumeration<URL> urls = JDOHelper.getResources(loader, "META-INF/services/javax.jdo.JDOEnhancer");
            if (urls != null) {
                while (urls.hasMoreElements()) {
                    ++numberOfJDOEnhancers;
                    try {
                        String enhancerClassName = JDOHelper.getClassNameFromURL(urls.nextElement());
                        Class<?> enhancerClass = JDOHelper.forName(enhancerClassName, true, ctrLoader);
                        JDOEnhancer enhancer = (JDOEnhancer)enhancerClass.newInstance();
                        return enhancer;
                    }
                    catch (Throwable ex) {
                        exceptions.add(ex);
                    }
                }
            }
        }
        catch (Throwable ex) {
            exceptions.add(ex);
        }
        throw new JDOFatalUserException(msg.msg("EXC_GetEnhancerNoValidEnhancerAvailable", numberOfJDOEnhancers), exceptions.toArray(new Throwable[exceptions.size()]));
    }

    private static ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private static InputStream getResourceAsStream(final ClassLoader resourceLoader, final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                return resourceLoader.getResourceAsStream(name);
            }
        });
    }

    private static Method getMethod(final Class<?> implClass, final String methodName, final Class<?>[] parameterTypes) throws NoSuchMethodException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws NoSuchMethodException {
                    return implClass.getMethod(methodName, parameterTypes);
                }
            });
        }
        catch (PrivilegedActionException ex) {
            throw (NoSuchMethodException)ex.getException();
        }
    }

    private static Object invoke(final Method method, final Object instance, final Object[] parameters) throws IllegalAccessException, InvocationTargetException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws IllegalAccessException, InvocationTargetException {
                    return method.invoke(instance, parameters);
                }
            });
        }
        catch (PrivilegedActionException ex) {
            Exception cause = ex.getException();
            if (cause instanceof IllegalAccessException) {
                throw (IllegalAccessException)cause;
            }
            throw (InvocationTargetException)cause;
        }
    }

    protected static Enumeration<URL> getResources(final ClassLoader resourceLoader, final String resourceName) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Enumeration<URL>>(){

                @Override
                public Enumeration<URL> run() throws IOException {
                    return resourceLoader.getResources(resourceName);
                }
            });
        }
        catch (PrivilegedActionException ex) {
            throw (IOException)ex.getException();
        }
    }

    private static Class<?> forName(final String name, final boolean init, final ClassLoader loader) throws ClassNotFoundException {
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                @Override
                public Class<?> run() throws ClassNotFoundException {
                    return Class.forName(name, init, loader);
                }
            });
        }
        catch (PrivilegedActionException ex) {
            throw (ClassNotFoundException)ex.getException();
        }
    }

    private static InputStream openStream(final URL url) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() throws IOException {
                    return url.openStream();
                }
            });
        }
        catch (PrivilegedActionException ex) {
            throw (IOException)ex.getException();
        }
    }
}

