/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jdo.Extent;
import javax.jdo.JDOException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.JDONullIdentityException;
import javax.jdo.JDOOptimisticVerificationException;
import javax.jdo.JDOQLTypedQuery;
import javax.jdo.JDOUnsupportedOptionException;
import javax.jdo.JDOUserException;
import javax.jdo.ObjectState;
import javax.jdo.PersistenceManager;
import javax.jdo.Transaction;
import javax.jdo.datastore.JDOConnection;
import javax.jdo.datastore.Sequence;
import javax.jdo.identity.SingleFieldIdentity;
import javax.jdo.listener.InstanceLifecycleListener;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.Configuration;
import org.datanucleus.DetachState;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchGroup;
import org.datanucleus.FetchPlan;
import org.datanucleus.FetchPlanState;
import org.datanucleus.PropertyNames;
import org.datanucleus.api.jdo.DataNucleusHelperJDO;
import org.datanucleus.api.jdo.JDOAdapter;
import org.datanucleus.api.jdo.JDOConnectionImpl;
import org.datanucleus.api.jdo.JDOConnectionJDBCImpl;
import org.datanucleus.api.jdo.JDOExtent;
import org.datanucleus.api.jdo.JDOFetchGroup;
import org.datanucleus.api.jdo.JDOFetchPlan;
import org.datanucleus.api.jdo.JDOPersistenceManagerFactory;
import org.datanucleus.api.jdo.JDOQuery;
import org.datanucleus.api.jdo.JDOSequence;
import org.datanucleus.api.jdo.JDOTransaction;
import org.datanucleus.api.jdo.LifecycleListenerForClass;
import org.datanucleus.api.jdo.exceptions.TransactionNotActiveException;
import org.datanucleus.api.jdo.exceptions.TransactionNotWritableException;
import org.datanucleus.api.jdo.query.JDOQLTypedQueryImpl;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.exceptions.TransactionActiveOnCloseException;
import org.datanucleus.flush.FlushMode;
import org.datanucleus.identity.SCOID;
import org.datanucleus.identity.SingleFieldId;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.FetchGroupMetaData;
import org.datanucleus.metadata.FetchPlanMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.QueryLanguage;
import org.datanucleus.metadata.QueryMetaData;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.store.NucleusConnection;
import org.datanucleus.store.NucleusSequence;
import org.datanucleus.store.query.Query;
import org.datanucleus.transaction.TransactionEventListener;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class JDOPersistenceManager
implements PersistenceManager {
    public static final NucleusLogger LOGGER = NucleusLogger.getLoggerInstance("DataNucleus.JDO");
    private boolean closed = false;
    private Map<Object, Object> userObjectMap = null;
    private Object userObject = null;
    protected ExecutionContext ec;
    protected Transaction jdotx;
    protected JDOPersistenceManagerFactory pmf;
    protected JDOFetchPlan fetchPlan = null;
    private Set<JDOFetchGroup> jdoFetchGroups = null;

    public JDOPersistenceManager(JDOPersistenceManagerFactory pmf, String userName, String password) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("user", userName);
        options.put("password", password);
        this.ec = pmf.getNucleusContext().getExecutionContext(this, options);
        this.pmf = pmf;
        this.fetchPlan = new JDOFetchPlan(this.ec.getFetchPlan());
        this.jdotx = new JDOTransaction(this, this.ec.getTransaction());
    }

    @Override
    public void close() {
        if (this.pmf != null) {
            this.pmf.releasePersistenceManager(this);
        }
        this.internalClose();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    protected void internalClose() {
        if (this.closed) {
            return;
        }
        try {
            this.ec.close();
        }
        catch (TransactionActiveOnCloseException tae) {
            throw new JDOUserException(tae.getMessage(), this);
        }
        catch (NucleusException ne) {
            throw JDOAdapter.getJDOExceptionForNucleusException(ne);
        }
        this.userObject = null;
        this.userObjectMap = null;
        this.fetchPlan = null;
        this.jdoFetchGroups = null;
        this.jdotx = null;
        this.ec = null;
        this.pmf = null;
        this.closed = true;
    }

    public ExecutionContext getExecutionContext() {
        return this.ec;
    }

    @Override
    public JDOPersistenceManagerFactory getPersistenceManagerFactory() {
        return this.pmf;
    }

    @Override
    public boolean getDetachAllOnCommit() {
        this.assertIsOpen();
        return this.ec.getBooleanProperty(PropertyNames.PROPERTY_DETACH_ALL_ON_COMMIT);
    }

    @Override
    public boolean getCopyOnAttach() {
        this.assertIsOpen();
        return this.ec.getBooleanProperty(PropertyNames.PROPERTY_COPY_ON_ATTACH);
    }

    @Override
    public javax.jdo.FetchPlan getFetchPlan() {
        return this.fetchPlan;
    }

    @Override
    public boolean getIgnoreCache() {
        this.assertIsOpen();
        return this.ec.getBooleanProperty("datanucleus.ignorecache");
    }

    @Override
    public boolean getMultithreaded() {
        this.assertIsOpen();
        return this.ec.getBooleanProperty("datanucleus.multithreaded");
    }

    @Override
    public void setDetachAllOnCommit(boolean flag) {
        this.assertIsOpen();
        this.ec.setProperty(PropertyNames.PROPERTY_DETACH_ALL_ON_COMMIT, flag);
    }

    @Override
    public void setCopyOnAttach(boolean flag) {
        this.assertIsOpen();
        this.ec.setProperty(PropertyNames.PROPERTY_COPY_ON_ATTACH, flag);
    }

    @Override
    public void setIgnoreCache(boolean flag) {
        this.assertIsOpen();
        this.ec.setProperty("datanucleus.ignorecache", flag);
    }

    @Override
    public void setMultithreaded(boolean flag) {
        this.assertIsOpen();
        this.ec.setProperty("datanucleus.multithreaded", flag);
    }

    @Override
    public void setDatastoreReadTimeoutMillis(Integer timeout) {
        this.assertIsOpen();
        if (!this.ec.getStoreManager().getSupportedOptions().contains("Datastore.Timeout")) {
            throw new JDOUnsupportedOptionException("This datastore doesn't support read timeouts");
        }
        this.ec.setProperty("datanucleus.datastorereadtimeout", timeout);
    }

    @Override
    public Integer getDatastoreReadTimeoutMillis() {
        this.assertIsOpen();
        return this.ec.getIntProperty("datanucleus.datastorereadtimeout");
    }

    @Override
    public void setDatastoreWriteTimeoutMillis(Integer timeout) {
        this.assertIsOpen();
        if (!this.ec.getStoreManager().getSupportedOptions().contains("Datastore.Timeout")) {
            throw new JDOUnsupportedOptionException("This datastore doesn't support write timeouts");
        }
        this.ec.setProperty("datanucleus.datastorewritetimeout", timeout);
    }

    @Override
    public Integer getDatastoreWriteTimeoutMillis() {
        this.assertIsOpen();
        return this.ec.getIntProperty("datanucleus.datastorewritetimeout");
    }

    @Override
    public Date getServerDate() {
        this.assertIsOpen();
        try {
            return this.ec.getStoreManager().getDatastoreDate();
        }
        catch (NucleusException ne) {
            throw JDOAdapter.getJDOExceptionForNucleusException(ne);
        }
    }

    @Override
    public Transaction currentTransaction() {
        this.assertIsOpen();
        return this.jdotx;
    }

    private void jdoEvict(Object obj) {
        try {
            this.ec.evictObject(obj);
        }
        catch (NucleusException ne) {
            throw JDOAdapter.getJDOExceptionForNucleusException(ne);
        }
    }

    @Override
    public void evict(Object obj) {
        this.assertIsOpen();
        this.jdoEvict(obj);
    }

    @Override
    public void evictAll(boolean subclasses, Class cls) {
        this.assertIsOpen();
        try {
            this.ec.evictObjects(cls, subclasses);
        }
        catch (NucleusException ne) {
            throw JDOAdapter.getJDOExceptionForNucleusException(ne);
        }
    }

    @Override
    public void evictAll(Object ... pcs) {
        this.evictAll(Arrays.asList(pcs));
    }

    @Override
    public void evictAll(Collection pcs) {
        this.assertIsOpen();
        ArrayList<JDOException> failures = new ArrayList<JDOException>();
        for (Object pc : pcs) {
            try {
                this.jdoEvict(pc);
            }
            catch (JDOException e) {
                failures.add(e);
            }
        }
        if (!failures.isEmpty()) {
            throw new JDOUserException(Localiser.msg("010036"), failures.toArray(new Exception[0]));
        }
    }

    @Override
    public void evictAll() {
        this.assertIsOpen();
        this.ec.evictAllObjects();
    }

    private void jdoRefresh(Object obj) {
        try {
            this.ec.refreshObject(obj);
        }
        catch (NucleusException ne) {
            throw JDOAdapter.getJDOExceptionForNucleusException(ne);
        }
    }

    @Override
    public void refresh(Object obj) {
        this.assertIsOpen();
        this.jdoRefresh(obj);
    }

    @Override
    public void refreshAll(Object ... pcs) {
        this.refreshAll(Arrays.asList(pcs));
    }

    @Override
    public void refreshAll(Collection pcs) {
        this.assertIsOpen();
        ArrayList<JDOException> failures = new ArrayList<JDOException>();
        for (Object pc : pcs) {
            try {
                this.jdoRefresh(pc);
            }
            catch (JDOException e) {
                failures.add(e);
            }
        }
        if (!failures.isEmpty()) {
            throw new JDOUserException(Localiser.msg("010037"), failures.toArray(new Exception[0]));
        }
    }

    @Override
    public void refreshAll() {
        this.assertIsOpen();
        try {
            this.ec.refreshAllObjects();
        }
        catch (NucleusException ne) {
            throw JDOAdapter.getJDOExceptionForNucleusException(ne);
        }
    }

    @Override
    public void refreshAll(JDOException exc) {
        Throwable[] nestedExceptions;
        Object obj = exc.getFailedObject();
        if (obj != null) {
            this.refresh(obj);
        }
        if ((nestedExceptions = exc.getNestedExceptions()) != null) {
            for (Throwable nestedExc : nestedExceptions) {
                if (!(nestedExc instanceof JDOException)) continue;
                this.refreshAll((JDOException)nestedExc);
            }
        }
    }

    @Override
    public void retrieve(Object pc, boolean useFetchPlan) {
        this.assertIsOpen();
        try {
            this.ec.retrieveObjects(useFetchPlan, pc);
        }
        catch (NucleusException ne) {
            throw new JDOUserException(Localiser.msg("010038"), ne);
        }
    }

    @Override
    public void retrieve(Object pc) {
        this.retrieve(pc, false);
    }

    @Override
    public void retrieveAll(Object ... pcs) {
        this.retrieveAll(false, pcs);
    }

    @Override
    public void retrieveAll(boolean useFetchPlan, Object ... pcs) {
        this.assertIsOpen();
        if (pcs == null) {
            throw new NullPointerException();
        }
        try {
            this.ec.retrieveObjects(useFetchPlan, pcs);
        }
        catch (NucleusException ne) {
            Throwable[] nesteds = ne.getNestedExceptions();
            if (nesteds == null || nesteds.length == 0) {
                throw new JDOUserException(Localiser.msg("010038"), ne);
            }
            throw new JDOUserException(Localiser.msg("010038"), nesteds);
        }
    }

    @Override
    public void retrieveAll(Collection pcs, boolean useFetchPlan) {
        if (pcs == null) {
            throw new NullPointerException();
        }
        this.retrieveAll(useFetchPlan, pcs.toArray());
    }

    @Override
    public void retrieveAll(Collection pcs) {
        this.retrieveAll(pcs, false);
    }

    private <T> T jdoMakePersistent(T obj) {
        try {
            return this.ec.persistObject(obj, false);
        }
        catch (NucleusException ne) {
            throw JDOAdapter.getJDOExceptionForNucleusException(ne);
        }
    }

    @Override
    public <T> T makePersistent(T obj) {
        this.assertIsOpen();
        this.assertWritable();
        if (obj == null) {
            return null;
        }
        return this.jdoMakePersistent(obj);
    }

    @Override
    public <T> T[] makePersistentAll(T ... pcs) {
        return this.makePersistentAll((Collection<T>)Arrays.asList(pcs)).toArray(new Object[0]);
    }

    @Override
    public <T> Collection<T> makePersistentAll(Collection<T> pcs) {
        this.assertIsOpen();
        this.assertWritable();
        try {
            Object[] persistedPcs = this.ec.persistObjects(pcs.toArray(new Object[0]));
            List<Object> persisted = Arrays.asList(persistedPcs);
            return persisted;
        }
        catch (NucleusUserException nue) {
            Throwable[] failures = nue.getNestedExceptions();
            throw new JDOUserException(Localiser.msg("010039"), failures);
        }
    }

    private void jdoDeletePersistent(Object obj) {
        try {
            this.ec.deleteObject(obj);
        }
        catch (NucleusException ne) {
            throw JDOAdapter.getJDOExceptionForNucleusException(ne);
        }
    }

    @Override
    public void deletePersistent(Object obj) {
        this.assertIsOpen();
        this.assertWritable();
        this.jdoDeletePersistent(obj);
    }

    @Override
    public void deletePersistentAll(Object ... pcs) {
        this.deletePersistentAll(Arrays.asList(pcs));
    }

    @Override
    public void deletePersistentAll(Collection pcs) {
        this.assertIsOpen();
        this.assertWritable();
        try {
            this.ec.deleteObjects(pcs.toArray(new Object[0]));
        }
        catch (NucleusUserException nue) {
            Throwable[] failures = nue.getNestedExceptions();
            throw new JDOUserException(Localiser.msg("010040"), failures);
        }
    }

    private void jdoMakeTransient(Object pc, FetchPlanState state) {
        try {
            this.ec.makeObjectTransient(pc, state);
        }
        catch (NucleusException ne) {
            throw JDOAdapter.getJDOExceptionForNucleusException(ne);
        }
    }

    @Override
    public void makeTransient(Object pc, boolean useFetchPlan) {
        this.assertIsOpen();
        FetchPlanState state = null;
        if (useFetchPlan) {
            state = new FetchPlanState();
        }
        this.jdoMakeTransient(pc, state);
    }

    @Override
    public void makeTransient(Object pc) {
        this.makeTransient(pc, false);
    }

    @Override
    public void makeTransientAll(Object ... pcs) {
        this.makeTransientAll(Arrays.asList(pcs));
    }

    @Override
    public void makeTransientAll(boolean includeFetchPlan, Object ... pcs) {
        this.makeTransientAll(Arrays.asList(pcs), includeFetchPlan);
    }

    @Override
    public void makeTransientAll(Collection pcs, boolean useFetchPlan) {
        this.assertIsOpen();
        ArrayList<RuntimeException> failures = new ArrayList<RuntimeException>();
        Iterator i = pcs.iterator();
        FetchPlanState state = null;
        if (useFetchPlan) {
            state = new FetchPlanState();
        }
        while (i.hasNext()) {
            Object pc = i.next();
            try {
                this.jdoMakeTransient(pc, state);
            }
            catch (RuntimeException e) {
                failures.add(e);
            }
        }
        if (!failures.isEmpty()) {
            throw new JDOUserException(Localiser.msg("010041"), failures.toArray(new Exception[0]));
        }
    }

    @Override
    public void makeTransientAll(Collection pcs) {
        this.makeTransientAll(pcs, false);
    }

    private void jdoMakeTransactional(Object pc) {
        try {
            this.ec.makeObjectTransactional(pc);
        }
        catch (NucleusException ne) {
            throw JDOAdapter.getJDOExceptionForNucleusException(ne);
        }
    }

    @Override
    public void makeTransactional(Object pc) {
        this.assertIsOpen();
        this.jdoMakeTransactional(pc);
    }

    @Override
    public void makeTransactionalAll(Object ... pcs) {
        this.makeTransactionalAll(Arrays.asList(pcs));
    }

    @Override
    public void makeTransactionalAll(Collection pcs) {
        this.assertIsOpen();
        this.assertActiveTransaction();
        ArrayList<RuntimeException> failures = new ArrayList<RuntimeException>();
        for (Object pc : pcs) {
            try {
                this.jdoMakeTransactional(pc);
            }
            catch (RuntimeException e) {
                failures.add(e);
            }
        }
        if (!failures.isEmpty()) {
            throw new JDOUserException(Localiser.msg("010042"), failures.toArray(new Exception[0]));
        }
    }

    private void jdoMakeNontransactional(Object obj) {
        try {
            this.ec.makeObjectNontransactional(obj);
        }
        catch (NucleusException ne) {
            throw JDOAdapter.getJDOExceptionForNucleusException(ne);
        }
    }

    @Override
    public void makeNontransactional(Object pc) {
        this.assertIsOpen();
        if (pc == null) {
            return;
        }
        if (!((Persistable)pc).dnIsTransactional() && !((Persistable)pc).dnIsPersistent()) {
            throw new JDOUserException(Localiser.msg("011004"));
        }
        if (!((Persistable)pc).dnIsTransactional() && ((Persistable)pc).dnIsPersistent()) {
            return;
        }
        this.jdoMakeNontransactional(pc);
    }

    @Override
    public void makeNontransactionalAll(Object ... pcs) {
        this.makeNontransactionalAll(Arrays.asList(pcs));
    }

    @Override
    public void makeNontransactionalAll(Collection pcs) {
        this.assertIsOpen();
        this.assertActiveTransaction();
        ArrayList<RuntimeException> failures = new ArrayList<RuntimeException>();
        for (Object pc : pcs) {
            try {
                this.jdoMakeNontransactional(pc);
            }
            catch (RuntimeException e) {
                failures.add(e);
            }
        }
        if (!failures.isEmpty()) {
            throw new JDOUserException(Localiser.msg("010043"), failures.toArray(new Exception[0]));
        }
    }

    private <T> T jdoDetachCopy(T obj, FetchPlanState state) {
        this.ec.assertClassPersistable(obj.getClass());
        try {
            return this.ec.detachObjectCopy(state, obj);
        }
        catch (NucleusException ne) {
            throw JDOAdapter.getJDOExceptionForNucleusException(ne);
        }
    }

    @Override
    public <T> T detachCopy(T pc) {
        this.assertIsOpen();
        if (pc == null) {
            return null;
        }
        try {
            this.ec.assertClassPersistable(pc.getClass());
            this.assertReadable("detachCopy");
            return this.jdoDetachCopy(pc, new DetachState(this.ec.getApiAdapter()));
        }
        catch (NucleusException ne) {
            throw JDOAdapter.getJDOExceptionForNucleusException(ne);
        }
    }

    @Override
    public <T> T[] detachCopyAll(T ... pcs) {
        return this.detachCopyAll((Collection<T>)Arrays.asList(pcs)).toArray(new Object[0]);
    }

    @Override
    public <T> Collection<T> detachCopyAll(Collection<T> pcs) {
        this.assertIsOpen();
        this.assertReadable("detachCopyAll");
        DetachState state = new DetachState(this.ec.getApiAdapter());
        ArrayList<T> detacheds = new ArrayList<T>();
        for (T pc : pcs) {
            if (pc == null) {
                detacheds.add(null);
                continue;
            }
            detacheds.add(this.jdoDetachCopy(pc, state));
        }
        return detacheds;
    }

    @Override
    public javax.jdo.Query newQuery() {
        return this.newQuery("javax.jdo.query.JDOQL", null);
    }

    @Override
    public javax.jdo.Query newQuery(Object obj) {
        if (obj != null && obj instanceof JDOQuery) {
            String language = ((JDOQuery)obj).getLanguage();
            return this.newQuery(language, obj);
        }
        return this.newQuery(null, obj);
    }

    @Override
    public javax.jdo.Query newQuery(String query) {
        return this.newQuery("javax.jdo.query.JDOQL", (Object)query);
    }

    @Override
    public javax.jdo.Query newQuery(String language, Object query) {
        Query internalQuery;
        String queryLanguage;
        block14: {
            this.assertIsOpen();
            queryLanguage = language;
            if (queryLanguage == null) {
                queryLanguage = QueryLanguage.JDOQL.name();
            } else if (queryLanguage.equals("javax.jdo.query.JDOQL")) {
                queryLanguage = QueryLanguage.JDOQL.name();
            } else if (queryLanguage.equals("javax.jdo.query.SQL")) {
                queryLanguage = QueryLanguage.SQL.name();
            } else if (queryLanguage.equals("javax.jdo.query.JPQL")) {
                queryLanguage = QueryLanguage.JPQL.name();
            }
            if (!this.ec.getStoreManager().supportsQueryLanguage(queryLanguage)) {
                throw new JDOUserException(Localiser.msg("011006", queryLanguage));
            }
            internalQuery = null;
            try {
                if (query == null) {
                    internalQuery = this.ec.getStoreManager().newQuery(queryLanguage, this.ec);
                    break block14;
                }
                if (query instanceof JDOQuery) {
                    internalQuery = this.ec.getStoreManager().newQuery(queryLanguage, this.ec, ((JDOQuery)query).getInternalQuery());
                    break block14;
                }
                if (query instanceof String) {
                    internalQuery = this.ec.getStoreManager().newQuery(queryLanguage, this.ec, (String)query);
                    break block14;
                }
                throw new JDOUserException("Cannot create new query with argument of type " + query.getClass().getName());
            }
            catch (NucleusException ne) {
                throw JDOAdapter.getJDOExceptionForNucleusException(ne);
            }
        }
        if (this.ec.getFlushMode() == FlushMode.QUERY) {
            internalQuery.addExtension("datanucleus.query.flushbeforeexecution", Boolean.TRUE);
        }
        return new JDOQuery(this, internalQuery, queryLanguage);
    }

    @Override
    public <T> javax.jdo.Query<T> newQuery(Class<T> cls) {
        javax.jdo.Query query = this.newQuery();
        query.setClass(cls);
        return query;
    }

    @Override
    public <T> javax.jdo.Query<T> newQuery(Extent<T> cln) {
        javax.jdo.Query query = this.newQuery();
        query.setClass(cln.getCandidateClass());
        query.setCandidates(cln);
        return query;
    }

    @Override
    public <T> javax.jdo.Query<T> newQuery(Class<T> cls, Collection<T> cln) {
        javax.jdo.Query query = this.newQuery();
        query.setClass(cls);
        query.setCandidates(cln);
        return query;
    }

    @Override
    public <T> javax.jdo.Query<T> newQuery(Class<T> cls, String filter) {
        javax.jdo.Query query = this.newQuery();
        query.setClass(cls);
        query.setFilter(filter);
        return query;
    }

    @Override
    public <T> javax.jdo.Query<T> newQuery(Class<T> cls, Collection<T> cln, String filter) {
        javax.jdo.Query query = this.newQuery();
        query.setClass(cls);
        query.setCandidates(cln);
        query.setFilter(filter);
        return query;
    }

    @Override
    public <T> javax.jdo.Query<T> newQuery(Extent<T> cln, String filter) {
        javax.jdo.Query query = this.newQuery();
        query.setClass(cln.getCandidateClass());
        query.setCandidates(cln);
        query.setFilter(filter);
        return query;
    }

    @Override
    public <T> JDOQLTypedQuery<T> newJDOQLTypedQuery(Class<T> cls) {
        return new JDOQLTypedQueryImpl<T>(this, cls);
    }

    @Override
    public <T> javax.jdo.Query<T> newNamedQuery(Class<T> cls, String queryName) {
        FetchPlanMetaData fpmd;
        Map<String, String> extmds;
        this.assertIsOpen();
        if (queryName == null) {
            throw new JDOUserException(Localiser.msg("011005", null, cls));
        }
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        QueryMetaData qmd = this.ec.getMetaDataManager().getMetaDataForQuery(cls, clr, queryName);
        if (qmd == null) {
            throw new JDOUserException(Localiser.msg("011005", queryName, cls));
        }
        javax.jdo.Query query = this.newQuery(qmd.getLanguage(), (Object)qmd.getQuery());
        if (cls != null) {
            query.setClass(cls);
            if (!this.ec.getStoreManager().managesClass(cls.getName())) {
                this.ec.getStoreManager().manageClasses(clr, cls.getName());
            }
        }
        if (qmd.getLanguage().equals(QueryLanguage.JDOQL.name()) && (qmd.isUnique() || qmd.getResultClass() != null)) {
            throw new JDOUserException(Localiser.msg("011007", queryName));
        }
        if (qmd.isUnique()) {
            query.setUnique(true);
        }
        if (qmd.getResultClass() != null) {
            Class resultCls;
            block16: {
                resultCls = null;
                try {
                    resultCls = clr.classForName(qmd.getResultClass());
                }
                catch (ClassNotResolvedException cnre) {
                    if (cls == null) break block16;
                    try {
                        String resultClassName = cls.getPackage().getName() + "." + qmd.getResultClass();
                        resultCls = clr.classForName(resultClassName);
                    }
                    catch (ClassNotResolvedException cnre2) {
                        throw new JDOUserException(Localiser.msg("011008", queryName, qmd.getResultClass()));
                    }
                }
            }
            query.setResultClass(resultCls);
        }
        if ((extmds = qmd.getExtensions()) != null) {
            for (Map.Entry<String, String> entry : extmds.entrySet()) {
                query.addExtension(entry.getKey(), entry.getValue());
            }
        }
        if (qmd.isUnmodifiable()) {
            query.setUnmodifiable();
        }
        if (qmd.getFetchPlanName() != null && (fpmd = this.ec.getMetaDataManager().getMetaDataForFetchPlan(qmd.getFetchPlanName())) != null) {
            FetchGroupMetaData[] fgmds;
            FetchPlan fp = new FetchPlan(this.ec, clr);
            fp.removeGroup("default");
            for (FetchGroupMetaData fgmd : fgmds = fpmd.getFetchGroupMetaData()) {
                fp.addGroup(fgmd.getName());
            }
            fp.setMaxFetchDepth(fpmd.getMaxFetchDepth());
            fp.setFetchSize(fpmd.getFetchSize());
            ((JDOQuery)query).getInternalQuery().setFetchPlan(fp);
        }
        return query;
    }

    @Override
    public <T> Extent<T> getExtent(Class<T> pcClass, boolean subclasses) {
        this.assertIsOpen();
        try {
            return new JDOExtent(this, this.ec.getExtent(pcClass, subclasses));
        }
        catch (NucleusException ne) {
            throw JDOAdapter.getJDOExceptionForNucleusException(ne);
        }
    }

    @Override
    public <T> Extent<T> getExtent(Class<T> pcClass) {
        return this.getExtent(pcClass, true);
    }

    @Override
    public <T> T newInstance(Class<T> pc) {
        this.assertIsOpen();
        try {
            return this.ec.newInstance(pc);
        }
        catch (NucleusException ne) {
            throw JDOAdapter.getJDOExceptionForNucleusException(ne);
        }
    }

    @Override
    public Object newObjectIdInstance(Class pcClass, Object key) {
        this.assertIsOpen();
        try {
            return this.ec.newObjectId(pcClass, key);
        }
        catch (NucleusException ne) {
            throw JDOAdapter.getJDOExceptionForNucleusException(ne);
        }
    }

    @Override
    public Set getManagedObjects() {
        return this.ec.getManagedObjects();
    }

    @Override
    public Set getManagedObjects(Class ... classes) {
        return this.ec.getManagedObjects(classes);
    }

    public Set getManagedObjects(EnumSet states) {
        if (states == null) {
            return null;
        }
        String[] stateNames = new String[states.size()];
        Iterator iter = states.iterator();
        int i = 0;
        while (iter.hasNext()) {
            ObjectState state = (ObjectState)((Object)iter.next());
            stateNames[i++] = state.toString();
        }
        return this.ec.getManagedObjects(stateNames);
    }

    public Set getManagedObjects(EnumSet states, Class ... classes) {
        if (states == null) {
            return null;
        }
        String[] stateNames = new String[states.size()];
        Iterator iter = states.iterator();
        int i = 0;
        while (iter.hasNext()) {
            ObjectState state = (ObjectState)((Object)iter.next());
            stateNames[i++] = state.toString();
        }
        return this.ec.getManagedObjects(stateNames, classes);
    }

    @Override
    public Object getObjectById(Object id) {
        return this.getObjectById(id, true);
    }

    @Override
    public Object getObjectById(Object id, boolean validate) {
        this.assertIsOpen();
        if (id == null) {
            throw new JDONullIdentityException(Localiser.msg("010044"));
        }
        try {
            Object theId = id;
            if (id instanceof SingleFieldIdentity) {
                theId = DataNucleusHelperJDO.getDataNucleusIdentityForSingleFieldIdentity((SingleFieldIdentity)id);
            }
            return this.ec.findObject(theId, validate);
        }
        catch (NucleusException ne) {
            throw JDOAdapter.getJDOExceptionForNucleusException(ne);
        }
    }

    @Override
    public <T> T getObjectById(Class<T> cls, Object key) {
        try {
            return this.ec.findObject(cls, key);
        }
        catch (NucleusException ne) {
            throw JDOAdapter.getJDOExceptionForNucleusException(ne);
        }
    }

    @Override
    public Object[] getObjectsById(boolean validate, Object ... oids) {
        this.assertIsOpen();
        if (oids == null) {
            throw new JDOUserException(Localiser.msg("011002"));
        }
        Object[] theOids = new Object[oids.length];
        for (int i = 0; i < oids.length; ++i) {
            if (oids[i] != null) {
                if (oids[i] instanceof SingleFieldIdentity) {
                    theOids[i] = DataNucleusHelperJDO.getDataNucleusIdentityForSingleFieldIdentity((SingleFieldIdentity)oids[i]);
                    continue;
                }
                theOids[i] = oids[i];
                continue;
            }
            theOids[i] = null;
        }
        return this.ec.findObjectsById(theOids, validate);
    }

    @Override
    public Object[] getObjectsById(Object ... oids) {
        return this.getObjectsById(true, oids);
    }

    @Override
    public Collection getObjectsById(Collection oids) {
        return this.getObjectsById(oids, true);
    }

    @Override
    public Collection getObjectsById(Collection oids, boolean validate) {
        this.assertIsOpen();
        if (oids == null) {
            throw new JDOUserException(Localiser.msg("011002"));
        }
        if (oids.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        Object[] oidArray = new Object[oids.size()];
        int j = 0;
        for (Object oid : oids) {
            Object id = oid;
            if (id != null && id instanceof SingleFieldIdentity) {
                id = DataNucleusHelperJDO.getDataNucleusIdentityForSingleFieldIdentity((SingleFieldIdentity)id);
            }
            oidArray[j++] = id;
        }
        Persistable[] objs = this.ec.findObjectsById(oidArray, validate);
        List<Persistable> objects = Arrays.asList(objs);
        return objects;
    }

    public <T> T getObjectByUnique(Class<T> cls, String[] fieldNames, Object[] fieldValues) {
        try {
            return this.ec.findObjectByUnique(cls, fieldNames, fieldValues);
        }
        catch (NucleusException ne) {
            throw JDOAdapter.getJDOExceptionForNucleusException(ne);
        }
    }

    @Override
    public Object getObjectId(Object pc) {
        Persistable p;
        this.assertIsOpen();
        if (pc != null && pc instanceof Persistable && ((p = (Persistable)pc).dnIsPersistent() || p.dnIsDetached())) {
            Object id = p.dnGetObjectId();
            if (id != null && id instanceof SingleFieldId) {
                id = DataNucleusHelperJDO.getSingleFieldIdentityForDataNucleusIdentity((SingleFieldId)id, pc.getClass());
            }
            return id;
        }
        return null;
    }

    @Override
    public Object getTransactionalObjectId(Object pc) {
        this.assertIsOpen();
        return ((Persistable)pc).dnGetTransactionalObjectId();
    }

    @Override
    public Class getObjectIdClass(Class cls) {
        this.assertIsOpen();
        if (!this.ec.getNucleusContext().getApiAdapter().isPersistable(cls) || !this.hasPersistenceInformationForClass(cls)) {
            return null;
        }
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        AbstractClassMetaData cmd = this.ec.getMetaDataManager().getMetaDataForClass(cls, clr);
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            return this.ec.getNucleusContext().getIdentityManager().getDatastoreIdClass();
        }
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            try {
                return this.ec.getClassLoaderResolver().classForName(this.ec.getMetaDataManager().getMetaDataForClass(cls, clr).getObjectidClass(), null);
            }
            catch (ClassNotResolvedException e) {
                String msg = Localiser.msg("011009", cls.getName());
                LOGGER.error(msg);
                throw new JDOException(msg);
            }
        }
        if (cmd.isRequiresExtent()) {
            return this.ec.getNucleusContext().getIdentityManager().getDatastoreIdClass();
        }
        return SCOID.class;
    }

    @Override
    public Object putUserObject(Object key, Object value) {
        this.assertIsOpen();
        if (key == null) {
            return null;
        }
        if (this.userObjectMap == null) {
            this.userObjectMap = new HashMap<Object, Object>();
        }
        if (value == null) {
            return this.userObjectMap.remove(key);
        }
        return this.userObjectMap.put(key, value);
    }

    @Override
    public Object getUserObject(Object key) {
        this.assertIsOpen();
        if (key == null) {
            return null;
        }
        if (this.userObjectMap == null) {
            return null;
        }
        return this.userObjectMap.get(key);
    }

    @Override
    public Object removeUserObject(Object key) {
        this.assertIsOpen();
        if (key == null) {
            return null;
        }
        if (this.userObjectMap == null) {
            return null;
        }
        return this.userObjectMap.remove(key);
    }

    @Override
    public void setUserObject(Object userObject) {
        this.assertIsOpen();
        this.userObject = userObject;
    }

    @Override
    public Object getUserObject() {
        this.assertIsOpen();
        return this.userObject;
    }

    @Override
    public void flush() {
        this.assertIsOpen();
        try {
            this.ec.flush();
        }
        catch (NucleusException ne) {
            if (ne instanceof NucleusOptimisticException) {
                Throwable[] nested = ne.getNestedExceptions();
                Throwable[] jdoNested = new JDOOptimisticVerificationException[nested.length];
                for (int i = 0; i < nested.length; ++i) {
                    jdoNested[i] = (JDOOptimisticVerificationException)JDOAdapter.getJDOExceptionForNucleusException((NucleusException)nested[i]);
                }
                throw new JDOOptimisticVerificationException(ne.getMessage(), jdoNested);
            }
            throw JDOAdapter.getJDOExceptionForNucleusException(ne);
        }
    }

    @Override
    public void checkConsistency() {
        this.assertIsOpen();
        if (!this.ec.getTransaction().isActive()) {
            return;
        }
        if (this.ec.getTransaction().getOptimistic()) {
            throw new JDOUserException("checkConsistency() not yet implemented for optimistic transactions");
        }
        this.flush();
    }

    @Override
    public Sequence getSequence(String sequenceName) {
        this.assertIsOpen();
        SequenceMetaData seqmd = this.ec.getMetaDataManager().getMetaDataForSequence(this.ec.getClassLoaderResolver(), sequenceName);
        if (seqmd == null) {
            throw new JDOUserException(Localiser.msg("017000", sequenceName));
        }
        Sequence seq = null;
        if (seqmd.getFactoryClass() != null) {
            seq = this.pmf.getSequenceForFactoryClass(seqmd.getFactoryClass());
            if (seq == null) {
                Class factory = this.ec.getClassLoaderResolver().classForName(seqmd.getFactoryClass());
                if (factory == null) {
                    throw new JDOUserException(Localiser.msg("017001", sequenceName, seqmd.getFactoryClass()));
                }
                Class[] argTypes = null;
                Object[] arguments = null;
                if (seqmd.getStrategy() != null) {
                    argTypes = new Class[]{String.class, String.class};
                    arguments = new Object[]{seqmd.getName(), seqmd.getStrategy().toString()};
                } else {
                    argTypes = new Class[]{String.class};
                    arguments = new Object[]{seqmd.getName()};
                }
                try {
                    Method newInstanceMethod = factory.getMethod("newInstance", argTypes);
                    seq = (Sequence)newInstanceMethod.invoke(null, arguments);
                }
                catch (Exception e) {
                    throw new JDOUserException(Localiser.msg("017002", seqmd.getFactoryClass(), e.getMessage()));
                }
                this.pmf.addSequenceForFactoryClass(seqmd.getFactoryClass(), seq);
            }
        } else {
            NucleusSequence nucSeq = this.ec.getStoreManager().getNucleusSequence(this.ec, seqmd);
            seq = new JDOSequence(nucSeq);
        }
        return seq;
    }

    @Override
    public void addInstanceLifecycleListener(InstanceLifecycleListener listener, Class ... classes) {
        this.assertIsOpen();
        if (listener == null) {
            return;
        }
        if ((classes = LifecycleListenerForClass.canonicaliseClasses(classes)) != null && classes.length == 0) {
            return;
        }
        this.ec.getCallbackHandler().addListener(listener, classes);
    }

    @Override
    public void removeInstanceLifecycleListener(InstanceLifecycleListener listener) {
        this.assertIsOpen();
        this.ec.getCallbackHandler().removeListener(listener);
    }

    protected void assertIsOpen() {
        if (this.isClosed()) {
            throw new JDOFatalUserException(Localiser.msg("011000"));
        }
    }

    protected void assertActiveTransaction() {
        if (!this.ec.getTransaction().isActive()) {
            throw new TransactionNotActiveException();
        }
    }

    protected void assertWritable() {
        if (!this.ec.getTransaction().isActive() && !this.ec.getTransaction().getNontransactionalWrite()) {
            throw new TransactionNotWritableException();
        }
    }

    protected void assertReadable(String operation) {
        if (!this.ec.getTransaction().isActive() && !this.ec.getTransaction().getNontransactionalRead()) {
            throw new JDOUserException(Localiser.msg("011001", operation));
        }
    }

    protected boolean hasPersistenceInformationForClass(Class cls) {
        return this.ec.hasPersistenceInformationForClass(cls);
    }

    @Override
    public JDOConnection getDataStoreConnection() {
        try {
            NucleusConnection nconn = this.ec.getStoreManager().getNucleusConnection(this.ec);
            if (this.ec.getStoreManager().isJdbcStore()) {
                return new JDOConnectionJDBCImpl(nconn);
            }
            return new JDOConnectionImpl(nconn);
        }
        catch (NucleusException ne) {
            throw JDOAdapter.getJDOExceptionForNucleusException(ne);
        }
    }

    @Override
    public javax.jdo.FetchGroup getFetchGroup(Class cls, String name) {
        JDOFetchGroup jdoGrp2;
        if (this.jdoFetchGroups == null) {
            this.jdoFetchGroups = new HashSet<JDOFetchGroup>();
        }
        for (JDOFetchGroup jdoGrp2 : this.jdoFetchGroups) {
            if (!jdoGrp2.getName().equals(name) || jdoGrp2.getType() != cls || jdoGrp2.isUnmodifiable()) continue;
            return jdoGrp2;
        }
        jdoGrp2 = (JDOFetchGroup)this.getPersistenceManagerFactory().getFetchGroup(cls, name);
        FetchGroup internalGrp = jdoGrp2.getInternalFetchGroup();
        FetchGroup internalCopy = new FetchGroup(internalGrp);
        jdoGrp2 = new JDOFetchGroup(internalCopy);
        this.ec.addInternalFetchGroup(internalCopy);
        this.jdoFetchGroups.add(jdoGrp2);
        return jdoGrp2;
    }

    @Override
    public void setProperty(String propertyName, Object value) {
        this.assertIsOpen();
        try {
            this.ec.setProperty(propertyName.toLowerCase(), value);
        }
        catch (NucleusException ne) {
            throw JDOAdapter.getJDOExceptionForNucleusException(ne);
        }
    }

    @Override
    public Map<String, Object> getProperties() {
        this.assertIsOpen();
        HashMap<String, Object> pmProps = new HashMap<String, Object>();
        Map<String, Object> ecProps = this.ec.getProperties();
        Iterator<Map.Entry<String, Object>> propertiesIter = ecProps.entrySet().iterator();
        Configuration conf = this.ec.getNucleusContext().getConfiguration();
        while (propertiesIter.hasNext()) {
            Map.Entry<String, Object> entry = propertiesIter.next();
            String ecPropName = entry.getKey();
            String pmPropName = conf.getPropertyNameWithInternalPropertyName(ecPropName, "javax.jdo");
            pmProps.put(pmPropName != null ? pmPropName : ecPropName, entry.getValue());
        }
        return pmProps;
    }

    @Override
    public Set<String> getSupportedProperties() {
        this.assertIsOpen();
        return this.ec.getSupportedProperties();
    }

    public void addTransactionEventListener(TransactionEventListener listener) {
        this.assertIsOpen();
        this.ec.getTransaction().bindTransactionEventListener(listener);
    }

    public void removeTransactionEventListener(TransactionEventListener listener) {
        this.assertIsOpen();
        this.ec.getTransaction().removeTransactionEventListener(listener);
    }
}

