/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo;

import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.spi.StateInterrogation;
import org.datanucleus.api.jdo.DataNucleusHelperJDO;
import org.datanucleus.enhancement.ExecutionContextReference;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.identity.SingleFieldId;

public class JDOStateInterrogation
implements StateInterrogation {
    @Override
    public Object getObjectId(Object pc) {
        try {
            Object id = ((Persistable)pc).dnGetObjectId();
            if (id != null && id instanceof SingleFieldId) {
                return DataNucleusHelperJDO.getSingleFieldIdentityForDataNucleusIdentity((SingleFieldId)id, pc.getClass());
            }
            return id;
        }
        catch (NucleusException ne) {
            throw new JDOUserException("Exception thrown getting object id", ne);
        }
    }

    @Override
    public PersistenceManager getPersistenceManager(Object pc) {
        ExecutionContextReference ec = ((Persistable)pc).dnGetExecutionContext();
        return ec != null ? (PersistenceManager)ec.getOwner() : null;
    }

    @Override
    public Object getTransactionalObjectId(Object pc) {
        Object id = ((Persistable)pc).dnGetTransactionalObjectId();
        if (id != null && id instanceof SingleFieldId) {
            return DataNucleusHelperJDO.getSingleFieldIdentityForDataNucleusIdentity((SingleFieldId)id, pc.getClass());
        }
        return id;
    }

    @Override
    public Object getVersion(Object pc) {
        return ((Persistable)pc).dnGetVersion();
    }

    @Override
    public Boolean isDeleted(Object pc) {
        return ((Persistable)pc).dnIsDeleted();
    }

    @Override
    public Boolean isDetached(Object pc) {
        return ((Persistable)pc).dnIsDetached();
    }

    @Override
    public Boolean isDirty(Object pc) {
        return ((Persistable)pc).dnIsDirty();
    }

    @Override
    public Boolean isNew(Object pc) {
        return ((Persistable)pc).dnIsNew();
    }

    @Override
    public Boolean isPersistent(Object pc) {
        return ((Persistable)pc).dnIsPersistent();
    }

    @Override
    public Boolean isTransactional(Object pc) {
        return ((Persistable)pc).dnIsTransactional();
    }

    @Override
    public boolean makeDirty(Object pc, String fieldName) {
        ((Persistable)pc).dnMakeDirty(fieldName);
        return true;
    }
}

