/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.jdo.AttributeConverter;
import javax.jdo.annotations.Column;
import javax.jdo.annotations.Discriminator;
import javax.jdo.annotations.DiscriminatorStrategy;
import javax.jdo.annotations.Embedded;
import javax.jdo.annotations.Extension;
import javax.jdo.annotations.FetchGroup;
import javax.jdo.annotations.FetchPlan;
import javax.jdo.annotations.ForeignKey;
import javax.jdo.annotations.ForeignKeyAction;
import javax.jdo.annotations.IdGeneratorStrategy;
import javax.jdo.annotations.Index;
import javax.jdo.annotations.InheritanceStrategy;
import javax.jdo.annotations.Join;
import javax.jdo.annotations.NullValue;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.PersistenceModifier;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.Query;
import javax.jdo.annotations.SequenceStrategy;
import javax.jdo.annotations.Unique;
import javax.jdo.annotations.VersionStrategy;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.PropertyNames;
import org.datanucleus.api.jdo.DataNucleusHelperJDO;
import org.datanucleus.api.jdo.JDOTypeConverter;
import org.datanucleus.api.jdo.JDOTypeConverterUtils;
import org.datanucleus.api.jdo.metadata.JDOAnnotationUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractElementMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ArrayMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ContainerMetaData;
import org.datanucleus.metadata.DatastoreIdentityMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.ElementMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.EventListenerMetaData;
import org.datanucleus.metadata.FetchGroupMemberMetaData;
import org.datanucleus.metadata.FetchGroupMetaData;
import org.datanucleus.metadata.FetchPlanMetaData;
import org.datanucleus.metadata.FieldMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.FileMetaData;
import org.datanucleus.metadata.ForeignKeyMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.IndexedValue;
import org.datanucleus.metadata.InheritanceMetaData;
import org.datanucleus.metadata.InvalidClassMetaDataException;
import org.datanucleus.metadata.InvalidMetaDataException;
import org.datanucleus.metadata.JoinMetaData;
import org.datanucleus.metadata.KeyMetaData;
import org.datanucleus.metadata.MapMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.OrderMetaData;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.metadata.PrimaryKeyMetaData;
import org.datanucleus.metadata.PropertyMetaData;
import org.datanucleus.metadata.QueryLanguage;
import org.datanucleus.metadata.QueryMetaData;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.metadata.UniqueMetaData;
import org.datanucleus.metadata.ValueGenerationStrategy;
import org.datanucleus.metadata.ValueMetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.annotations.AbstractAnnotationReader;
import org.datanucleus.metadata.annotations.AnnotationObject;
import org.datanucleus.metadata.annotations.Member;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class JDOAnnotationReader
extends AbstractAnnotationReader {
    AnnotationObject persistenceCapableDefaults = null;

    public JDOAnnotationReader(MetaDataManager mgr) {
        super(mgr);
        this.setSupportedAnnotationPackages(new String[]{"javax.jdo", "org.datanucleus.api.jdo.annotations"});
        this.persistenceCapableDefaults = this.getAnnotationObjectsForAnnotations(PersistenceCapableModel.class.getSimpleName(), PersistenceCapableModel.class.getAnnotations())[0];
        this.addSupportedDuplicateAnnotations(PersistenceCapable.class.getName());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected AbstractClassMetaData processClassAnnotations(PackageMetaData pmd, Class cls, AnnotationObject[] annotations, ClassLoaderResolver clr) {
        if (annotations == null || annotations.length == 0) {
            return null;
        }
        AbstractClassMetaData cmd = null;
        AnnotationObject pcAnnotation = this.isClassPersistable(annotations);
        if (pcAnnotation != null) {
            cmd = cls.isInterface() ? pmd.newInterfaceMetaData(ClassUtils.getClassNameForClass(cls)) : pmd.newClassMetaData(ClassUtils.getClassNameForClass(cls));
            cmd.setPersistenceModifier(ClassPersistenceModifier.PERSISTENCE_CAPABLE);
            this.processPersistenceCapableAnnotation(cls, cmd, pcAnnotation.getNameValueMap());
        } else if (this.isClassPersistenceAware(annotations)) {
            cmd = pmd.newClassMetaData(ClassUtils.getClassNameForClass(cls));
            cmd.setPersistenceModifier(ClassPersistenceModifier.PERSISTENCE_AWARE);
        } else if (this.doesClassHaveNamedQueries(annotations)) {
            cmd = pmd.newClassMetaData(ClassUtils.getClassNameForClass(cls));
            cmd.setPersistenceModifier(ClassPersistenceModifier.NON_PERSISTENT);
        } else {
            return null;
        }
        this.processNamedQueries(cmd, cls, annotations);
        if (cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
            return cmd;
        }
        for (AnnotationObject annotation : annotations) {
            String name;
            Annotation[] values;
            FileMetaData filemd;
            String strategy;
            String annName = annotation.getName();
            if (annName.equals(JDOAnnotationUtils.PERSISTENCE_CAPABLE)) continue;
            Map<String, Object> annotationValues = annotation.getNameValueMap();
            if (annName.equals(JDOAnnotationUtils.EMBEDDED_ONLY)) {
                cmd.setEmbeddedOnly(true);
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.VERSION)) {
                VersionStrategy versionStrategy = (VersionStrategy)((Object)annotationValues.get("strategy"));
                String string = JDOAnnotationUtils.getVersionStrategyString(versionStrategy);
                String indexed = (String)annotationValues.get("indexed");
                String column = (String)annotationValues.get("column");
                Column[] columnArray = (Column[])annotationValues.get("columns");
                VersionMetaData vermd = cmd.newVersionMetaData();
                vermd.setStrategy(string);
                vermd.setColumnName(column);
                vermd.setIndexed(IndexedValue.getIndexedValue(indexed));
                if (columnArray != null && columnArray.length > 0) {
                    ColumnMetaData colmd = JDOAnnotationUtils.getColumnMetaDataForColumnAnnotation(columnArray[0]);
                    vermd.setColumnMetaData(colmd);
                }
                JDOAnnotationUtils.addExtensionsToMetaData(vermd, (Extension[])annotationValues.get("extensions"));
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.DATASTORE_IDENTITY)) {
                strategy = JDOAnnotationUtils.getValueGenerationStrategyString((IdGeneratorStrategy)((Object)annotationValues.get("strategy")));
                String string = (String)annotationValues.get("customStrategy");
                if (!StringUtils.isWhitespace(string)) {
                    strategy = string;
                }
                String sequence = (String)annotationValues.get("sequence");
                String column = (String)annotationValues.get("column");
                Column[] columnArray = (Column[])annotationValues.get("columns");
                DatastoreIdentityMetaData idmd = cmd.newDatastoreIdentityMetaData();
                idmd.setColumnName(column);
                idmd.setValueStrategy(ValueGenerationStrategy.getIdentityStrategy(strategy));
                idmd.setSequence(sequence);
                if (columnArray != null && columnArray.length > 0) {
                    ColumnMetaData colmd = JDOAnnotationUtils.getColumnMetaDataForColumnAnnotation(columnArray[0]);
                    idmd.setColumnMetaData(colmd);
                }
                JDOAnnotationUtils.addExtensionsToMetaData(idmd, (Extension[])annotationValues.get("extensions"));
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.PRIMARY_KEY)) {
                String pkName = (String)annotationValues.get("name");
                String string = (String)annotationValues.get("column");
                Column[] columns = (Column[])annotationValues.get("columns");
                PrimaryKeyMetaData pkmd = cmd.newPrimaryKeyMetaData();
                pkmd.setName(pkName);
                pkmd.setColumnName(string);
                if (columns != null && columns.length > 0) {
                    for (Column column : columns) {
                        pkmd.addColumn(JDOAnnotationUtils.getColumnMetaDataForColumnAnnotation(column));
                    }
                }
                JDOAnnotationUtils.addExtensionsToMetaData(pkmd, (Extension[])annotationValues.get("extensions"));
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.JOINS)) {
                Join[] js = (Join[])annotationValues.get("value");
                if (js == null || js.length <= 0) continue;
                for (Join join : js) {
                    JoinMetaData joinmd = cmd.newJoinMetaData();
                    joinmd.setTable(join.table());
                    joinmd.setColumnName(join.column());
                    joinmd.setIndexed(IndexedValue.getIndexedValue(join.indexed()));
                    joinmd.setOuter(MetaDataUtils.getBooleanForString(join.outer(), false));
                    joinmd.setUnique(join.unique());
                    joinmd.setDeleteAction(JDOAnnotationUtils.getForeignKeyActionString(join.deleteAction()));
                    JDOAnnotationUtils.addExtensionsToMetaData(joinmd, join.extensions());
                }
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.JOIN)) {
                JoinMetaData joinmd = cmd.newJoinMetaData();
                joinmd.setTable((String)annotationValues.get("table"));
                joinmd.setColumnName((String)annotationValues.get("column"));
                joinmd.setIndexed(IndexedValue.getIndexedValue((String)annotationValues.get("indexed")));
                joinmd.setOuter(MetaDataUtils.getBooleanForString((String)annotationValues.get("outer"), false));
                joinmd.setUnique((String)annotationValues.get("unique"));
                joinmd.setDeleteAction(((ForeignKeyAction)((Object)annotationValues.get("deleteAction"))).toString());
                JDOAnnotationUtils.addExtensionsToMetaData(joinmd, (Extension[])annotationValues.get("extensions"));
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.INHERITANCE)) {
                InheritanceMetaData inhmd;
                strategy = JDOAnnotationUtils.getInheritanceStrategyString((InheritanceStrategy)((Object)annotationValues.get("strategy")));
                String string = (String)annotationValues.get("customStrategy");
                if (!StringUtils.isWhitespace(string)) {
                    strategy = string;
                }
                if ((inhmd = cmd.getInheritanceMetaData()) == null) {
                    inhmd = cmd.newInheritanceMetaData();
                }
                inhmd.setStrategy(strategy);
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.DISCRIMINATOR)) {
                DiscriminatorStrategy discriminatorStrategy = (DiscriminatorStrategy)((Object)annotationValues.get("strategy"));
                String string = JDOAnnotationUtils.getDiscriminatorStrategyString(discriminatorStrategy);
                String column = (String)annotationValues.get("column");
                String indexed = (String)annotationValues.get("indexed");
                String string2 = (String)annotationValues.get("value");
                Column[] columns = (Column[])annotationValues.get("columns");
                InheritanceMetaData inhmd = cmd.getInheritanceMetaData();
                if (inhmd == null) {
                    inhmd = cmd.newInheritanceMetaData();
                }
                DiscriminatorMetaData dismd = inhmd.newDiscriminatorMetaData();
                dismd.setColumnName(column);
                dismd.setValue(string2);
                dismd.setStrategy(string);
                dismd.setIndexed(indexed);
                if (columns == null || columns.length <= 0) continue;
                ColumnMetaData colmd = JDOAnnotationUtils.getColumnMetaDataForColumnAnnotation(columns[0]);
                dismd.setColumnMetaData(colmd);
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.FETCHPLANS)) {
                void var17_77;
                FetchPlan[] fetchPlanArray;
                filemd = (FileMetaData)pmd.getParent();
                FetchPlan[] column = fetchPlanArray = (FetchPlan[])annotationValues.get("value");
                int indexed = column.length;
                boolean bl = false;
                while (var17_77 < indexed) {
                    FetchPlan plan = column[var17_77];
                    FetchPlanMetaData fpmd = filemd.newFetchPlanMetaData(plan.name());
                    fpmd.setFetchSize(plan.fetchSize());
                    fpmd.setMaxFetchDepth(plan.maxFetchDepth());
                    int numGroups = plan.fetchGroups().length;
                    for (int k = 0; k < numGroups; ++k) {
                        fpmd.addFetchGroup(new FetchGroupMetaData(plan.fetchGroups()[k]));
                    }
                    ++var17_77;
                }
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.FETCHPLAN)) {
                String[] fpFetchGroups;
                filemd = (FileMetaData)pmd.getParent();
                FetchPlanMetaData fetchPlanMetaData = filemd.newFetchPlanMetaData((String)annotationValues.get("name"));
                fetchPlanMetaData.setFetchSize((Integer)annotationValues.get("fetchSize"));
                fetchPlanMetaData.setMaxFetchDepth((Integer)annotationValues.get("maxFetchDepth"));
                for (String fpFetchGroup : fpFetchGroups = (String[])annotationValues.get("fetchGroups")) {
                    fetchPlanMetaData.addFetchGroup(new FetchGroupMetaData(fpFetchGroup));
                }
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.FETCHGROUPS)) {
                FetchGroup[] groups;
                for (FetchGroup fetchGroup : groups = (FetchGroup[])annotationValues.get("value")) {
                    FetchGroupMetaData fgmd = cmd.newFetchGroupMetaData(fetchGroup.name());
                    if (!StringUtils.isWhitespace(fetchGroup.postLoad())) {
                        fgmd.setPostLoad(Boolean.valueOf(fetchGroup.postLoad()));
                    }
                    int numFields = fetchGroup.members().length;
                    for (int k = 0; k < numFields; ++k) {
                        FetchGroupMemberMetaData fgmmd = new FetchGroupMemberMetaData(fgmd, fetchGroup.members()[k].name());
                        fgmmd.setRecursionDepth(fetchGroup.members()[k].recursionDepth());
                        fgmd.addMember(fgmmd);
                    }
                    int numGroups = fetchGroup.fetchGroups().length;
                    for (int k = 0; k < numGroups; ++k) {
                        fgmd.addFetchGroup(new FetchGroupMetaData(fetchGroup.fetchGroups()[k]));
                    }
                }
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.FETCHGROUP)) {
                Persistent[] fields;
                FetchGroupMetaData fgmd = cmd.newFetchGroupMetaData((String)annotationValues.get("name"));
                String string = (String)annotationValues.get("postLoad");
                if (!StringUtils.isWhitespace(string)) {
                    fgmd.setPostLoad(Boolean.valueOf(string));
                }
                if ((fields = (Persistent[])annotationValues.get("members")) == null) continue;
                for (Persistent field : fields) {
                    FetchGroupMemberMetaData fgmmd = new FetchGroupMemberMetaData(fgmd, field.name());
                    fgmmd.setRecursionDepth(field.recursionDepth());
                    fgmd.addMember(fgmmd);
                }
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.SEQUENCE)) {
                void var17_83;
                String seqName = (String)annotationValues.get("name");
                String string = JDOAnnotationUtils.getSequenceStrategyString((SequenceStrategy)((Object)annotationValues.get("strategy")));
                String seqSeq = (String)annotationValues.get("datastoreSequence");
                Class seqFactory = (Class)annotationValues.get("factoryClass");
                Object var17_81 = null;
                if (seqFactory != null && seqFactory != Void.TYPE) {
                    String string3 = seqFactory.getName();
                }
                Integer seqSize = (Integer)annotationValues.get("allocationSize");
                Integer seqStart = (Integer)annotationValues.get("initialValue");
                if (StringUtils.isWhitespace(seqName)) {
                    throw new InvalidClassMetaDataException("044155", new Object[]{cmd.getFullClassName()});
                }
                SequenceMetaData seqmd = new SequenceMetaData(seqName, string);
                seqmd.setFactoryClass((String)var17_83);
                seqmd.setDatastoreSequence(seqSeq);
                if (seqSize != null) {
                    seqmd.setAllocationSize(seqSize);
                }
                if (seqStart != null) {
                    seqmd.setInitialValue(seqStart);
                }
                JDOAnnotationUtils.addExtensionsToMetaData(seqmd, (Extension[])annotationValues.get("extensions"));
                cmd.getPackageMetaData().addSequence(seqmd);
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.INDICES)) {
                values = (Index[])annotationValues.get("value");
                if (values == null || values.length <= 0) continue;
                for (Index index : values) {
                    IndexMetaData idxmd = JDOAnnotationUtils.getIndexMetaData(index.name(), index.table(), index.unique(), index.members(), index.columns());
                    if (idxmd.getNumberOfColumns() == 0 && idxmd.getNumberOfMembers() == 0) {
                        NucleusLogger.METADATA.warn(Localiser.msg("044204", cls.getName()));
                        continue;
                    }
                    cmd.addIndex(idxmd);
                    idxmd.setParent(cmd);
                }
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.INDEX)) {
                name = (String)annotationValues.get("name");
                String string = (String)annotationValues.get("table");
                String unique = (String)annotationValues.get("unique");
                String[] members = (String[])annotationValues.get("members");
                Column[] columnArray = (Column[])annotationValues.get("columns");
                IndexMetaData idxmd = JDOAnnotationUtils.getIndexMetaData(name, string, unique, members, columnArray);
                JDOAnnotationUtils.addExtensionsToMetaData(idxmd, (Extension[])annotationValues.get("extensions"));
                if (idxmd.getNumberOfColumns() == 0 && idxmd.getNumberOfMembers() == 0) {
                    NucleusLogger.METADATA.warn(Localiser.msg("044204", cls.getName()));
                    continue;
                }
                cmd.addIndex(idxmd);
                idxmd.setParent(cmd);
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.UNIQUES)) {
                values = (Unique[])annotationValues.get("value");
                if (values == null || values.length <= 0) continue;
                for (Annotation annotation2 : values) {
                    UniqueMetaData unimd = JDOAnnotationUtils.getUniqueMetaData(annotation2.name(), annotation2.table(), annotation2.deferred(), annotation2.members(), annotation2.columns());
                    if (unimd.getNumberOfColumns() == 0 && unimd.getNumberOfMembers() == 0) {
                        NucleusLogger.METADATA.warn(Localiser.msg("044205", cls.getName()));
                        continue;
                    }
                    cmd.addUniqueConstraint(unimd);
                    unimd.setParent(cmd);
                }
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.UNIQUE)) {
                name = (String)annotationValues.get("name");
                String string = (String)annotationValues.get("table");
                String deferred = (String)annotationValues.get("deferred");
                String[] members = (String[])annotationValues.get("members");
                Column[] columnArray = (Column[])annotationValues.get("columns");
                UniqueMetaData unimd = JDOAnnotationUtils.getUniqueMetaData(name, string, deferred, members, columnArray);
                JDOAnnotationUtils.addExtensionsToMetaData(unimd, (Extension[])annotationValues.get("extensions"));
                if (unimd.getNumberOfColumns() == 0 && unimd.getNumberOfMembers() == 0) {
                    NucleusLogger.METADATA.warn(Localiser.msg("044205", cls.getName()));
                    continue;
                }
                cmd.addUniqueConstraint(unimd);
                unimd.setParent(cmd);
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.FOREIGNKEYS)) {
                values = (ForeignKey[])annotationValues.get("value");
                if (values == null || values.length <= 0) continue;
                for (Annotation annotation3 : values) {
                    String deleteAction = JDOAnnotationUtils.getForeignKeyActionString(annotation3.deleteAction());
                    String updateAction = JDOAnnotationUtils.getForeignKeyActionString(annotation3.updateAction());
                    ForeignKeyMetaData fkmd = JDOAnnotationUtils.getFKMetaData(annotation3.name(), annotation3.table(), annotation3.unique(), annotation3.deferred(), deleteAction, updateAction, annotation3.members(), annotation3.columns());
                    if (fkmd.getNumberOfColumns() == 0 && fkmd.getNumberOfMembers() == 0) {
                        NucleusLogger.METADATA.warn(Localiser.msg("044206", cls.getName()));
                        continue;
                    }
                    cmd.addForeignKey(fkmd);
                    fkmd.setParent(cmd);
                }
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.FOREIGNKEY)) {
                name = (String)annotationValues.get("name");
                String string = (String)annotationValues.get("table");
                String unique = (String)annotationValues.get("unique");
                String deferred = (String)annotationValues.get("deferred");
                String string4 = JDOAnnotationUtils.getForeignKeyActionString((ForeignKeyAction)((Object)annotationValues.get("deleteAction")));
                String updateAction = JDOAnnotationUtils.getForeignKeyActionString((ForeignKeyAction)((Object)annotationValues.get("updateAction")));
                String[] members = (String[])annotationValues.get("members");
                Column[] columns = (Column[])annotationValues.get("columns");
                ForeignKeyMetaData fkmd = JDOAnnotationUtils.getFKMetaData(name, string, unique, deferred, string4, updateAction, members, columns);
                JDOAnnotationUtils.addExtensionsToMetaData(fkmd, (Extension[])annotationValues.get("extensions"));
                if (fkmd.getNumberOfColumns() == 0 && fkmd.getNumberOfMembers() == 0) {
                    NucleusLogger.METADATA.warn(Localiser.msg("044206", cls.getName()));
                    continue;
                }
                cmd.addForeignKey(fkmd);
                fkmd.setParent(cmd);
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.COLUMNS)) {
                Column[] cols = (Column[])annotationValues.get("value");
                if (cols == null || cols.length <= 0) continue;
                for (Column column : cols) {
                    ColumnMetaData colmd = JDOAnnotationUtils.getColumnMetaDataForColumnAnnotation(column);
                    JDOAnnotationUtils.addExtensionsToMetaData(colmd, column.extensions());
                    colmd.setParent(cmd);
                    cmd.addUnmappedColumn(colmd);
                }
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.CACHEABLE)) {
                String cache = (String)annotationValues.get("value");
                if (cache == null || !cache.equalsIgnoreCase("false")) continue;
                cmd.setCacheable(false);
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.EXTENSIONS)) {
                values = (Extension[])annotationValues.get("value");
                if (values == null || values.length <= 0) continue;
                for (Annotation annotation4 : values) {
                    String vendorName = annotation4.vendorName();
                    if (StringUtils.isWhitespace(vendorName)) {
                        throw new InvalidMetaDataException("044160", vendorName, annotation4.key().toString(), annotation4.value().toString());
                    }
                    if (!vendorName.equalsIgnoreCase("datanucleus")) continue;
                    cmd.addExtension(annotation4.key().toString(), annotation4.value().toString());
                }
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.EXTENSION)) {
                String vendorName = (String)annotationValues.get("vendorName");
                if (StringUtils.isWhitespace(vendorName)) {
                    throw new InvalidMetaDataException("044160", vendorName, annotationValues.get("key"), annotationValues.get("value"));
                }
                if (!vendorName.equalsIgnoreCase("datanucleus")) continue;
                cmd.addExtension((String)annotationValues.get("key"), (String)annotationValues.get("value"));
                continue;
            }
            if (annName.equals(JDOAnnotationUtils.PERSISTENCE_AWARE) || annName.equals(JDOAnnotationUtils.QUERIES) || annName.equals(JDOAnnotationUtils.QUERY)) continue;
            NucleusLogger.METADATA.debug(Localiser.msg("044203", cls.getName(), annotation.getName()));
        }
        NucleusLogger.METADATA.debug(Localiser.msg("044200", cls.getName(), "JDO"));
        return cmd;
    }

    private void processPersistenceCapableAnnotation(Class cls, AbstractClassMetaData cmd, Map<String, Object> annotationValues) {
        Persistent[] members;
        String schName;
        String catName;
        String identityType = JDOAnnotationUtils.getIdentityTypeString((javax.jdo.annotations.IdentityType)((Object)annotationValues.get("identityType")));
        cmd.setIdentityType(IdentityType.getIdentityType(identityType));
        Class idClass = (Class)annotationValues.get("objectIdClass");
        if (idClass != null && idClass != Void.TYPE) {
            cmd.setObjectIdClass(DataNucleusHelperJDO.getObjectIdClassForInputIdClass(idClass.getName()));
        }
        cmd.setEmbeddedOnly((String)annotationValues.get("embeddedOnly"));
        cmd.setCacheable((String)annotationValues.get("cacheable"));
        String serializeRead = (String)annotationValues.get("serializeRead");
        if (serializeRead != null) {
            cmd.setSerializeRead(serializeRead.equals("true"));
        }
        cmd.setRequiresExtent((String)annotationValues.get("requiresExtent"));
        if (this.mmgr.getNucleusContext().getConfiguration().getBooleanProperty(PropertyNames.PROPERTY_METADATA_ALWAYS_DETACHABLE)) {
            cmd.setDetachable(true);
        } else {
            cmd.setDetachable((String)annotationValues.get("detachable"));
        }
        JDOAnnotationUtils.addExtensionsToMetaData(cmd, (Extension[])annotationValues.get("extensions"));
        String tblName = (String)annotationValues.get("table");
        if (!StringUtils.isWhitespace(tblName)) {
            cmd.setTable(tblName);
        }
        if (!StringUtils.isWhitespace(catName = (String)annotationValues.get("catalog"))) {
            cmd.setCatalog(catName);
        }
        if (!StringUtils.isWhitespace(schName = (String)annotationValues.get("schema"))) {
            cmd.setSchema(schName);
        }
        if ((members = (Persistent[])annotationValues.get("members")) != null) {
            for (Persistent member : members) {
                String memberName = member.name();
                if (memberName.indexOf(46) > 0) {
                    memberName = memberName.substring(memberName.lastIndexOf(46) + 1);
                }
                boolean isField = this.isMemberOfClassAField(cls, memberName);
                AbstractMemberMetaData fmd = this.getFieldMetaDataForPersistent(cmd, member, isField);
                cmd.addMember(fmd);
            }
        }
    }

    protected void processNamedQueries(AbstractClassMetaData cmd, Class cls, AnnotationObject[] annotations) {
        for (AnnotationObject annotation : annotations) {
            Map<String, Object> annotationValues = annotation.getNameValueMap();
            String annName = annotation.getName();
            if (annName.equals(JDOAnnotationUtils.QUERIES)) {
                Query[] qs;
                for (Query query : qs = (Query[])annotationValues.get("value")) {
                    String resultClassName;
                    String lang = JDOAnnotationUtils.getQueryLanguageName(query.language());
                    if (!StringUtils.isWhitespace(lang)) {
                        if (lang.equals("javax.jdo.query.JDOQL")) {
                            lang = QueryLanguage.JDOQL.name();
                        } else if (lang.equals("javax.jdo.query.SQL")) {
                            lang = QueryLanguage.SQL.name();
                        } else if (lang.equals("javax.jdo.query.JPQL")) {
                            lang = QueryLanguage.JPQL.name();
                        }
                    }
                    String string = resultClassName = query.resultClass() != null && query.resultClass() != Void.TYPE ? query.resultClass().getName() : null;
                    if (StringUtils.isWhitespace(query.name())) {
                        throw new InvalidClassMetaDataException("044154", new Object[]{cmd.getFullClassName()});
                    }
                    QueryMetaData qmd = new QueryMetaData(query.name());
                    qmd.setScope(cls.getName());
                    qmd.setLanguage(lang);
                    qmd.setUnmodifiable(query.unmodifiable());
                    qmd.setResultClass(resultClassName);
                    qmd.setUnique(query.unique());
                    qmd.setFetchPlanName(query.fetchPlan());
                    qmd.setQuery(query.value());
                    JDOAnnotationUtils.addExtensionsToMetaData(qmd, query.extensions());
                    cmd.addQuery(qmd);
                    qmd.setParent(cmd);
                }
                continue;
            }
            if (!annName.equals(JDOAnnotationUtils.QUERY)) continue;
            String unmodifiable = "" + annotationValues.get("unmodifiable");
            Class resultClassValue = (Class)annotationValues.get("resultClass");
            String resultClassName = resultClassValue != null && resultClassValue != Void.TYPE ? resultClassValue.getName() : null;
            String lang = JDOAnnotationUtils.getQueryLanguageName((String)annotationValues.get("language"));
            if (!StringUtils.isWhitespace(lang)) {
                if (lang.equals("javax.jdo.query.JDOQL")) {
                    lang = QueryLanguage.JDOQL.name();
                } else if (lang.equals("javax.jdo.query.SQL")) {
                    lang = QueryLanguage.SQL.name();
                } else if (lang.equals("javax.jdo.query.JPQL")) {
                    lang = QueryLanguage.JPQL.name();
                }
            }
            if (StringUtils.isWhitespace((String)annotationValues.get("name"))) {
                throw new InvalidClassMetaDataException("044154", new Object[]{cmd.getFullClassName()});
            }
            QueryMetaData qmd = new QueryMetaData((String)annotationValues.get("name"));
            qmd.setScope(cls.getName());
            qmd.setLanguage(lang);
            qmd.setUnmodifiable(unmodifiable);
            qmd.setResultClass(resultClassName);
            qmd.setUnique((String)annotationValues.get("unique"));
            qmd.setFetchPlanName((String)annotationValues.get("fetchPlan"));
            qmd.setQuery((String)annotationValues.get("value"));
            JDOAnnotationUtils.addExtensionsToMetaData(qmd, (Extension[])annotationValues.get("extensions"));
            cmd.addQuery(qmd);
            qmd.setParent(cmd);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected AbstractMemberMetaData processMemberAnnotations(AbstractClassMetaData cmd, Member member, AnnotationObject[] annotations) {
        if (annotations == null || annotations.length == 0) {
            return null;
        }
        AbstractMemberMetaData mmd = null;
        boolean primaryKey = false;
        boolean serialised = false;
        boolean embeddedMember = false;
        boolean nonPersistentField = false;
        boolean transactionalField = false;
        String cacheable = null;
        Class[] elementTypes = null;
        String embeddedElement = null;
        String serializedElement = null;
        String dependentElement = null;
        Class[] keyTypes = null;
        String embeddedKey = null;
        String serializedKey = null;
        String dependentKey = null;
        Class[] valueTypes = null;
        String embeddedValue = null;
        String serializedValue = null;
        String dependentValue = null;
        String embeddedOwnerField = null;
        String embeddedNullIndicatorColumn = null;
        String embeddedNullIndicatorValue = null;
        Persistent[] embeddedMembers = null;
        Persistent[] embeddedElementMembers = null;
        Persistent[] embeddedKeyMembers = null;
        Persistent[] embeddedValueMembers = null;
        ColumnMetaData[] colmds = null;
        JoinMetaData joinmd = null;
        MetaData elemmd = null;
        MetaData keymd = null;
        MetaData valuemd = null;
        MetaData ordermd = null;
        IndexMetaData idxmd = null;
        UniqueMetaData unimd = null;
        ForeignKeyMetaData fkmd = null;
        HashMap<String, String> extensions = null;
        Class convertConverterCls = null;
        FieldPersistenceModifier updateModifier = null;
        for (AnnotationObject annotation : annotations) {
            String name;
            Annotation[] embeddedMappings;
            JDOTypeConverter typeConv;
            TypeManager typeMgr;
            Boolean disableConversion;
            Class converterCls;
            String uniqueName;
            String unique;
            String indexName;
            String string = annotation.getName();
            Map<String, Object> annotationValues = annotation.getNameValueMap();
            if (string.equals(JDOAnnotationUtils.PERSISTENT)) {
                FieldPersistenceModifier modifier;
                String pkStr = "" + annotationValues.get("primaryKey");
                Boolean pk = null;
                if (!StringUtils.isWhitespace(pkStr)) {
                    pk = Boolean.valueOf(pkStr);
                }
                String dfgStr = (String)annotationValues.get("defaultFetchGroup");
                Boolean dfg = null;
                if (!StringUtils.isWhitespace(dfgStr)) {
                    dfg = Boolean.valueOf(dfgStr);
                }
                String string2 = JDOAnnotationUtils.getNullValueString((NullValue)((Object)annotationValues.get("nullValue")));
                String embStr = (String)annotationValues.get("embedded");
                Boolean embedded = null;
                if (!StringUtils.isWhitespace(embStr)) {
                    embedded = Boolean.valueOf(embStr);
                }
                String serStr = (String)annotationValues.get("serialized");
                Boolean serialized = null;
                if (!StringUtils.isWhitespace(serStr)) {
                    serialized = Boolean.valueOf(serStr);
                }
                String depStr = (String)annotationValues.get("dependent");
                Boolean dependent = null;
                if (!StringUtils.isWhitespace(depStr)) {
                    dependent = Boolean.valueOf(depStr);
                }
                String valueStrategy = JDOAnnotationUtils.getValueGenerationStrategyString((IdGeneratorStrategy)((Object)annotationValues.get("valueStrategy")));
                String customValueStrategy = (String)annotationValues.get("customValueStrategy");
                if (!StringUtils.isWhitespace(customValueStrategy)) {
                    valueStrategy = customValueStrategy;
                }
                if ((modifier = JDOAnnotationUtils.getFieldPersistenceModifier((PersistenceModifier)((Object)annotationValues.get("persistenceModifier")))) == null) {
                    modifier = FieldPersistenceModifier.PERSISTENT;
                }
                String string3 = (String)annotationValues.get("sequence");
                String mappedBy = (String)annotationValues.get("mappedBy");
                String table = (String)annotationValues.get("table");
                String column = (String)annotationValues.get("column");
                String loadFetchGroup = (String)annotationValues.get("loadFetchGroup");
                String fieldTypeName = null;
                int recursionDepth = (Integer)annotationValues.get("recursionDepth");
                cacheable = (String)annotationValues.get("cacheable");
                Class[] fieldTypes = (Class[])annotationValues.get("types");
                if (fieldTypes != null && fieldTypes.length > 0) {
                    StringBuilder typeStr = new StringBuilder();
                    for (Class fieldType : fieldTypes) {
                        if (typeStr.length() > 0) {
                            typeStr.append(',');
                        }
                        if (fieldType == null || fieldType == Void.TYPE) continue;
                        typeStr.append(fieldType.getName());
                    }
                    fieldTypeName = typeStr.toString();
                }
                dependentElement = (String)annotationValues.get("dependentElement");
                serializedElement = (String)annotationValues.get("serializedElement");
                embeddedElement = (String)annotationValues.get("embeddedElement");
                dependentKey = (String)annotationValues.get("dependentKey");
                serializedKey = (String)annotationValues.get("serializedKey");
                embeddedKey = (String)annotationValues.get("embeddedKey");
                dependentValue = (String)annotationValues.get("dependentValue");
                serializedValue = (String)annotationValues.get("serializedValue");
                embeddedValue = (String)annotationValues.get("embeddedValue");
                Class converterCls2 = (Class)annotationValues.get("converter");
                if (converterCls2 == AttributeConverter.UseDefault.class) {
                    converterCls2 = null;
                }
                Boolean disableConversion2 = (Boolean)annotationValues.get("useDefaultConversion");
                AbstractMemberMetaData abstractMemberMetaData = mmd = member.isProperty() ? new PropertyMetaData((MetaData)cmd, member.getName()) : new FieldMetaData((MetaData)cmd, member.getName());
                if (this.isPersistenceContext()) {
                    if (disableConversion2 != null && disableConversion2.booleanValue()) {
                        mmd.setTypeConverterDisabled();
                    } else if (converterCls2 != null) {
                        TypeManager typeMgr2 = this.mmgr.getNucleusContext().getTypeManager();
                        if (typeMgr2.getTypeConverterForName(converterCls2.getName()) == null) {
                            AttributeConverter conv = JDOTypeConverterUtils.createAttributeConverter(this.mmgr.getNucleusContext(), converterCls2);
                            Class attrType = JDOTypeConverterUtils.getAttributeTypeForAttributeConverter(converterCls2, member.getType());
                            Class dbType2 = JDOTypeConverterUtils.getDatastoreTypeForAttributeConverter(converterCls2, attrType, null);
                            JDOTypeConverter typeConv2 = new JDOTypeConverter(conv);
                            typeMgr2.registerConverter(converterCls2.getName(), typeConv2, attrType, dbType2, false, null);
                        }
                        mmd.setTypeConverterName(converterCls2.getName());
                    }
                }
                if (modifier != null) {
                    mmd.setPersistenceModifier(modifier);
                }
                if (dfg != null) {
                    mmd.setDefaultFetchGroup(dfg);
                }
                if (pk != null) {
                    mmd.setPrimaryKey(pk);
                }
                if (embedded != null) {
                    mmd.setEmbedded(embedded);
                }
                if (serialized != null) {
                    mmd.setSerialised(serialized);
                }
                if (dependent != null) {
                    mmd.setDependent(dependent);
                }
                mmd.setNullValue(org.datanucleus.metadata.NullValue.getNullValue(string2));
                mmd.setMappedBy(mappedBy);
                mmd.setColumn(column);
                mmd.setTable(table);
                mmd.setRecursionDepth(recursionDepth);
                mmd.setLoadFetchGroup(loadFetchGroup);
                mmd.setValueStrategy(valueStrategy);
                mmd.setSequence(string3);
                mmd.setFieldTypes(fieldTypeName);
                Column[] columns2 = (Column[])annotationValues.get("columns");
                if (columns2 != null && columns2.length > 0) {
                    for (Column col : columns2) {
                        mmd.addColumn(JDOAnnotationUtils.getColumnMetaDataForColumnAnnotation(col));
                    }
                }
                JDOAnnotationUtils.addExtensionsToMetaData(mmd, (Extension[])annotationValues.get("extensions"));
                continue;
            }
            if (string.equals(JDOAnnotationUtils.PRIMARY_KEY)) {
                primaryKey = true;
                if (cmd.getIdentityType() != IdentityType.DATASTORE) continue;
                cmd.setIdentityType(IdentityType.APPLICATION);
                continue;
            }
            if (string.equals(JDOAnnotationUtils.SERIALIZED)) {
                serialised = true;
                continue;
            }
            if (string.equals(JDOAnnotationUtils.NOTPERSISTENT)) {
                nonPersistentField = true;
                continue;
            }
            if (string.equals(JDOAnnotationUtils.TRANSACTIONAL)) {
                transactionalField = true;
                continue;
            }
            if (string.equals(JDOAnnotationUtils.VERSION)) {
                VersionMetaData vermd = cmd.newVersionMetaData();
                vermd.setMemberName(member.getName());
                VersionStrategy versionStrategy = (VersionStrategy)((Object)annotationValues.get("strategy"));
                String strategy = null;
                if (versionStrategy == VersionStrategy.UNSPECIFIED) {
                    if (Number.class.isAssignableFrom(member.getType())) {
                        strategy = "version-number";
                    } else if (Date.class.isAssignableFrom(member.getType()) || Instant.class.isAssignableFrom(member.getType()) || LocalTime.class.isAssignableFrom(member.getType()) || LocalDateTime.class.isAssignableFrom(member.getType())) {
                        strategy = "date-time";
                    }
                } else {
                    strategy = JDOAnnotationUtils.getVersionStrategyString(versionStrategy);
                }
                vermd.setStrategy(strategy);
                String indexed2 = (String)annotationValues.get("indexed");
                vermd.setIndexed(IndexedValue.getIndexedValue(indexed2));
                JDOAnnotationUtils.addExtensionsToMetaData(vermd, (Extension[])annotationValues.get("extensions"));
                continue;
            }
            if (string.equals(JDOAnnotationUtils.COLUMNS)) {
                Column[] cols = (Column[])annotationValues.get("value");
                if (cols == null || cols.length <= 0) continue;
                colmds = new ColumnMetaData[cols.length];
                for (int j = 0; j < cols.length; ++j) {
                    colmds[j] = JDOAnnotationUtils.getColumnMetaDataForColumnAnnotation(cols[j]);
                    JDOAnnotationUtils.addExtensionsToMetaData(colmds[j], cols[j].extensions());
                }
                continue;
            }
            if (string.equals(JDOAnnotationUtils.COLUMN)) {
                colmds = new ColumnMetaData[]{JDOAnnotationUtils.getColumnMetaDataForAnnotations(annotationValues)};
                JDOAnnotationUtils.addExtensionsToMetaData(colmds[0], (Extension[])annotationValues.get("extensions"));
                continue;
            }
            if (string.equals(JDOAnnotationUtils.JOIN)) {
                String joinColumn = (String)annotationValues.get("column");
                String joinOuter = (String)annotationValues.get("outer");
                String deleteAction = JDOAnnotationUtils.getForeignKeyActionString((ForeignKeyAction)((Object)annotationValues.get("deleteAction")));
                String pkName = (String)annotationValues.get("primaryKey");
                String string4 = (String)annotationValues.get("foreignKey");
                String generateFK = (String)annotationValues.get("generateForeignKey");
                String indexed3 = (String)annotationValues.get("indexed");
                String indexName2 = (String)annotationValues.get("index");
                String unique2 = (String)annotationValues.get("unique");
                String uniqueName2 = (String)annotationValues.get("uniqueKey");
                String generatePK = (String)annotationValues.get("generatePrimaryKey");
                if (!StringUtils.isWhitespace(uniqueName2)) {
                    unique2 = "true";
                }
                if (!StringUtils.isWhitespace(indexName2)) {
                    indexed3 = "true";
                }
                Column[] joinColumns = (Column[])annotationValues.get("columns");
                joinmd = new JoinMetaData();
                joinmd.setColumnName(joinColumn);
                joinmd.setOuter(MetaDataUtils.getBooleanForString(joinOuter, false));
                joinmd.setIndexed(IndexedValue.getIndexedValue(indexed3));
                joinmd.setUnique(unique2);
                joinmd.setDeleteAction(deleteAction);
                if (!StringUtils.isWhitespace(pkName)) {
                    PrimaryKeyMetaData pkmd = new PrimaryKeyMetaData();
                    pkmd.setName(pkName);
                    joinmd.setPrimaryKeyMetaData(pkmd);
                } else if (generatePK != null && generatePK.equalsIgnoreCase("true")) {
                    joinmd.setPrimaryKeyMetaData(new PrimaryKeyMetaData());
                }
                if (!StringUtils.isWhitespace(string4)) {
                    ForeignKeyMetaData joinFkmd = joinmd.getForeignKeyMetaData();
                    if (joinFkmd == null) {
                        joinFkmd = new ForeignKeyMetaData();
                        joinFkmd.setName(string4);
                        joinmd.setForeignKeyMetaData(joinFkmd);
                    } else {
                        joinFkmd.setName(string4);
                    }
                } else if (generateFK != null && generateFK.equalsIgnoreCase("true")) {
                    joinmd.setForeignKeyMetaData(new ForeignKeyMetaData());
                }
                if (!StringUtils.isWhitespace(indexName2)) {
                    IndexMetaData joinIdxmd = joinmd.getIndexMetaData();
                    if (joinIdxmd == null) {
                        joinIdxmd = new IndexMetaData();
                        joinmd.setIndexMetaData(joinIdxmd);
                    }
                    joinIdxmd.setName(indexName2);
                }
                if (!StringUtils.isWhitespace(uniqueName2)) {
                    UniqueMetaData joinUnimd = joinmd.getUniqueMetaData();
                    if (joinUnimd == null) {
                        joinUnimd = new UniqueMetaData();
                        joinmd.setUniqueMetaData(joinUnimd);
                    }
                    joinUnimd.setName(uniqueName2);
                }
                if (joinColumns != null && joinColumns.length > 0) {
                    void var62_184;
                    Column[] joinUnimd = joinColumns;
                    int modifier = joinUnimd.length;
                    boolean bl = false;
                    while (var62_184 < modifier) {
                        Column joinCol = joinUnimd[var62_184];
                        joinmd.addColumn(JDOAnnotationUtils.getColumnMetaDataForColumnAnnotation(joinCol));
                        ++var62_184;
                    }
                }
                JDOAnnotationUtils.addExtensionsToMetaData(joinmd, (Extension[])annotationValues.get("extensions"));
                continue;
            }
            if (string.equals(JDOAnnotationUtils.ELEMENT)) {
                Column[] elementColumns;
                void var52_131;
                elementTypes = (Class[])annotationValues.get("types");
                embeddedElement = (String)annotationValues.get("embedded");
                serializedElement = (String)annotationValues.get("serialized");
                dependentElement = (String)annotationValues.get("dependent");
                String elementDeleteAction = JDOAnnotationUtils.getForeignKeyActionString((ForeignKeyAction)((Object)annotationValues.get("deleteAction")));
                String elementUpdateAction = JDOAnnotationUtils.getForeignKeyActionString((ForeignKeyAction)((Object)annotationValues.get("updateAction")));
                String fkName = (String)annotationValues.get("foreignKey");
                String generateFK = (String)annotationValues.get("generateForeignKey");
                String string5 = (String)annotationValues.get("indexed");
                indexName = (String)annotationValues.get("index");
                unique = (String)annotationValues.get("unique");
                uniqueName = (String)annotationValues.get("uniqueKey");
                converterCls = (Class)annotationValues.get("converter");
                if (converterCls == AttributeConverter.UseDefault.class) {
                    converterCls = null;
                }
                disableConversion = (Boolean)annotationValues.get("useDefaultConversion");
                if (!StringUtils.isWhitespace(uniqueName)) {
                    unique = "true";
                }
                if (!StringUtils.isWhitespace(indexName)) {
                    String string6 = "true";
                }
                elemmd = new ElementMetaData();
                ((AbstractElementMetaData)elemmd).setTable((String)annotationValues.get("table"));
                ((AbstractElementMetaData)elemmd).setColumnName((String)annotationValues.get("column"));
                ((AbstractElementMetaData)elemmd).setDeleteAction(elementDeleteAction);
                ((AbstractElementMetaData)elemmd).setUpdateAction(elementUpdateAction);
                ((AbstractElementMetaData)elemmd).setIndexed(IndexedValue.getIndexedValue((String)var52_131));
                ((AbstractElementMetaData)elemmd).setUnique(MetaDataUtils.getBooleanForString(unique, false));
                ((AbstractElementMetaData)elemmd).setMappedBy((String)annotationValues.get("mappedBy"));
                if (!StringUtils.isWhitespace(fkName)) {
                    ForeignKeyMetaData elemFkmd = ((AbstractElementMetaData)elemmd).getForeignKeyMetaData();
                    if (elemFkmd == null) {
                        elemFkmd = new ForeignKeyMetaData();
                        elemFkmd.setName(fkName);
                        ((AbstractElementMetaData)elemmd).setForeignKeyMetaData(elemFkmd);
                    } else {
                        elemFkmd.setName(fkName);
                    }
                } else if (generateFK != null && generateFK.equalsIgnoreCase("true")) {
                    ((AbstractElementMetaData)elemmd).setForeignKeyMetaData(new ForeignKeyMetaData());
                }
                if (!StringUtils.isWhitespace(indexName)) {
                    IndexMetaData elemIdxmd = ((AbstractElementMetaData)elemmd).getIndexMetaData();
                    if (elemIdxmd == null) {
                        elemIdxmd = new IndexMetaData();
                        ((AbstractElementMetaData)elemmd).setIndexMetaData(elemIdxmd);
                    }
                    elemIdxmd.setName(indexName);
                }
                if (!StringUtils.isWhitespace(uniqueName)) {
                    UniqueMetaData elemUnimd = ((AbstractElementMetaData)elemmd).getUniqueMetaData();
                    if (elemUnimd == null) {
                        elemUnimd = new UniqueMetaData();
                        ((AbstractElementMetaData)elemmd).setUniqueMetaData(elemUnimd);
                    }
                    elemUnimd.setName(uniqueName);
                }
                if ((elementColumns = (Column[])annotationValues.get("columns")) != null && elementColumns.length > 0) {
                    for (Column column : elementColumns) {
                        ((AbstractElementMetaData)elemmd).addColumn(JDOAnnotationUtils.getColumnMetaDataForColumnAnnotation(column));
                    }
                }
                if (this.isPersistenceContext()) {
                    if (disableConversion != null && disableConversion.booleanValue()) {
                        elemmd.addExtension("type-converter-disabled", "true");
                    } else if (converterCls != null) {
                        typeMgr = this.mmgr.getNucleusContext().getTypeManager();
                        if (typeMgr.getTypeConverterForName(converterCls.getName()) == null) {
                            AttributeConverter conv = JDOTypeConverterUtils.createAttributeConverter(this.mmgr.getNucleusContext(), converterCls);
                            Class attrType = JDOTypeConverterUtils.getAttributeTypeForAttributeConverter(converterCls, ClassUtils.getCollectionElementType(member.getType(), member.getGenericType()));
                            Class clazz = JDOTypeConverterUtils.getDatastoreTypeForAttributeConverter(converterCls, attrType, null);
                            typeConv = new JDOTypeConverter(conv);
                            typeMgr.registerConverter(converterCls.getName(), typeConv, attrType, clazz, false, null);
                        }
                        elemmd.addExtension("type-converter-name", converterCls.getName());
                    }
                }
                JDOAnnotationUtils.addExtensionsToMetaData(elemmd, (Extension[])annotationValues.get("extensions"));
                embeddedMappings = (Embedded[])annotationValues.get("embeddedMapping");
                if (embeddedMappings == null || embeddedMappings.length <= 0) continue;
                EmbeddedMetaData embmd = new EmbeddedMetaData();
                embmd.setOwnerMember(embeddedMappings[0].ownerMember());
                embmd.setNullIndicatorColumn(embeddedMappings[0].nullIndicatorColumn());
                embmd.setNullIndicatorValue(embeddedMappings[0].nullIndicatorValue());
                try {
                    Discriminator disc = embeddedMappings[0].discriminatorColumnName();
                    if (disc != null) {
                        DiscriminatorMetaData discriminatorMetaData = embmd.newDiscriminatorMetaData();
                        discriminatorMetaData.setColumnName(disc.column());
                        discriminatorMetaData.setStrategy(JDOAnnotationUtils.getDiscriminatorStrategyString(disc.strategy()));
                    }
                }
                catch (Throwable disc) {
                    // empty catch block
                }
                ((AbstractElementMetaData)elemmd).setEmbeddedMetaData(embmd);
                embeddedElementMembers = embeddedMappings[0].members();
                continue;
            }
            if (string.equals(JDOAnnotationUtils.KEY)) {
                Column[] keyColumns;
                void var52_134;
                keyTypes = (Class[])annotationValues.get("types");
                embeddedKey = (String)annotationValues.get("embedded");
                serializedKey = (String)annotationValues.get("serialized");
                dependentKey = (String)annotationValues.get("dependent");
                String keyDeleteAction = JDOAnnotationUtils.getForeignKeyActionString((ForeignKeyAction)((Object)annotationValues.get("deleteAction")));
                String keyUpdateAction = JDOAnnotationUtils.getForeignKeyActionString((ForeignKeyAction)((Object)annotationValues.get("updateAction")));
                String fkName = (String)annotationValues.get("foreignKey");
                String generateFK = (String)annotationValues.get("generateForeignKey");
                String string7 = (String)annotationValues.get("indexed");
                indexName = (String)annotationValues.get("index");
                unique = (String)annotationValues.get("unique");
                uniqueName = (String)annotationValues.get("uniqueKey");
                converterCls = (Class)annotationValues.get("converter");
                if (converterCls == AttributeConverter.UseDefault.class) {
                    converterCls = null;
                }
                disableConversion = (Boolean)annotationValues.get("useDefaultConversion");
                if (!StringUtils.isWhitespace(uniqueName)) {
                    unique = "true";
                }
                if (!StringUtils.isWhitespace(indexName)) {
                    String string8 = "true";
                }
                keymd = new KeyMetaData();
                ((AbstractElementMetaData)keymd).setTable((String)annotationValues.get("table"));
                ((AbstractElementMetaData)keymd).setColumnName((String)annotationValues.get("column"));
                ((AbstractElementMetaData)keymd).setDeleteAction(keyDeleteAction);
                ((AbstractElementMetaData)keymd).setUpdateAction(keyUpdateAction);
                ((AbstractElementMetaData)keymd).setIndexed(IndexedValue.getIndexedValue((String)var52_134));
                ((AbstractElementMetaData)keymd).setUnique(MetaDataUtils.getBooleanForString(unique, false));
                ((AbstractElementMetaData)keymd).setMappedBy((String)annotationValues.get("mappedBy"));
                if (!StringUtils.isWhitespace(fkName)) {
                    ForeignKeyMetaData keyFkmd = ((AbstractElementMetaData)keymd).getForeignKeyMetaData();
                    if (keyFkmd == null) {
                        keyFkmd = new ForeignKeyMetaData();
                        keyFkmd.setName(fkName);
                        ((AbstractElementMetaData)keymd).setForeignKeyMetaData(keyFkmd);
                    } else {
                        keyFkmd.setName(fkName);
                    }
                } else if (generateFK != null && generateFK.equalsIgnoreCase("true")) {
                    ((AbstractElementMetaData)keymd).setForeignKeyMetaData(new ForeignKeyMetaData());
                }
                if (!StringUtils.isWhitespace(indexName)) {
                    IndexMetaData keyIdxmd = ((AbstractElementMetaData)keymd).getIndexMetaData();
                    if (keyIdxmd == null) {
                        keyIdxmd = new IndexMetaData();
                        ((AbstractElementMetaData)keymd).setIndexMetaData(keyIdxmd);
                    }
                    keyIdxmd.setName(indexName);
                }
                if (!StringUtils.isWhitespace(uniqueName)) {
                    UniqueMetaData keyUnimd = ((AbstractElementMetaData)keymd).getUniqueMetaData();
                    if (keyUnimd == null) {
                        keyUnimd = new UniqueMetaData();
                        ((AbstractElementMetaData)keymd).setUniqueMetaData(keyUnimd);
                    }
                    keyUnimd.setName(uniqueName);
                }
                if ((keyColumns = (Column[])annotationValues.get("columns")) != null && keyColumns.length > 0) {
                    for (Annotation annotation2 : keyColumns) {
                        ((AbstractElementMetaData)keymd).addColumn(JDOAnnotationUtils.getColumnMetaDataForColumnAnnotation((Column)annotation2));
                    }
                }
                if (this.isPersistenceContext()) {
                    if (disableConversion != null && disableConversion.booleanValue()) {
                        keymd.addExtension("type-converter-disabled", "true");
                    } else if (converterCls != null) {
                        typeMgr = this.mmgr.getNucleusContext().getTypeManager();
                        if (typeMgr.getTypeConverterForName(converterCls.getName()) == null) {
                            AttributeConverter conv = JDOTypeConverterUtils.createAttributeConverter(this.mmgr.getNucleusContext(), converterCls);
                            Class attrType = JDOTypeConverterUtils.getAttributeTypeForAttributeConverter(converterCls, ClassUtils.getMapKeyType(member.getType(), member.getGenericType()));
                            Class clazz = JDOTypeConverterUtils.getDatastoreTypeForAttributeConverter(converterCls, attrType, null);
                            typeConv = new JDOTypeConverter(conv);
                            typeMgr.registerConverter(converterCls.getName(), typeConv, attrType, clazz, false, null);
                        }
                        keymd.addExtension("type-converter-name", converterCls.getName());
                    }
                }
                JDOAnnotationUtils.addExtensionsToMetaData(keymd, (Extension[])annotationValues.get("extensions"));
                embeddedMappings = (Embedded[])annotationValues.get("embeddedMapping");
                if (embeddedMappings == null || embeddedMappings.length <= 0) continue;
                EmbeddedMetaData embmd = new EmbeddedMetaData();
                embmd.setOwnerMember(embeddedMappings[0].ownerMember());
                embmd.setNullIndicatorColumn(embeddedMappings[0].nullIndicatorColumn());
                embmd.setNullIndicatorValue(embeddedMappings[0].nullIndicatorValue());
                ((AbstractElementMetaData)keymd).setEmbeddedMetaData(embmd);
                embeddedKeyMembers = embeddedMappings[0].members();
                continue;
            }
            if (string.equals(JDOAnnotationUtils.VALUE)) {
                Column[] valueColumns;
                void var52_137;
                valueTypes = (Class[])annotationValues.get("types");
                embeddedValue = (String)annotationValues.get("embedded");
                serializedValue = (String)annotationValues.get("serialized");
                dependentValue = (String)annotationValues.get("dependent");
                String valueDeleteAction = JDOAnnotationUtils.getForeignKeyActionString((ForeignKeyAction)((Object)annotationValues.get("deleteAction")));
                String valueUpdateAction = JDOAnnotationUtils.getForeignKeyActionString((ForeignKeyAction)((Object)annotationValues.get("updateAction")));
                String fkName = (String)annotationValues.get("foreignKey");
                String generateFK = (String)annotationValues.get("generateForeignKey");
                String string9 = (String)annotationValues.get("indexed");
                indexName = (String)annotationValues.get("index");
                unique = (String)annotationValues.get("unique");
                uniqueName = (String)annotationValues.get("uniqueKey");
                converterCls = (Class)annotationValues.get("converter");
                if (converterCls == AttributeConverter.UseDefault.class) {
                    converterCls = null;
                }
                disableConversion = (Boolean)annotationValues.get("useDefaultConversion");
                if (!StringUtils.isWhitespace(uniqueName)) {
                    unique = "true";
                }
                if (!StringUtils.isWhitespace(indexName)) {
                    String string10 = "true";
                }
                valuemd = new ValueMetaData();
                ((AbstractElementMetaData)valuemd).setTable((String)annotationValues.get("table"));
                ((AbstractElementMetaData)valuemd).setColumnName((String)annotationValues.get("column"));
                ((AbstractElementMetaData)valuemd).setDeleteAction(valueDeleteAction);
                ((AbstractElementMetaData)valuemd).setUpdateAction(valueUpdateAction);
                ((AbstractElementMetaData)valuemd).setIndexed(IndexedValue.getIndexedValue((String)var52_137));
                ((AbstractElementMetaData)valuemd).setUnique(MetaDataUtils.getBooleanForString(unique, false));
                ((AbstractElementMetaData)valuemd).setMappedBy((String)annotationValues.get("mappedBy"));
                if (!StringUtils.isWhitespace(fkName)) {
                    ForeignKeyMetaData valueFkmd = ((AbstractElementMetaData)valuemd).getForeignKeyMetaData();
                    if (valueFkmd == null) {
                        valueFkmd = new ForeignKeyMetaData();
                        valueFkmd.setName(fkName);
                        ((AbstractElementMetaData)valuemd).setForeignKeyMetaData(valueFkmd);
                    } else {
                        valueFkmd.setName(fkName);
                    }
                } else if (generateFK != null && generateFK.equalsIgnoreCase("true")) {
                    ((AbstractElementMetaData)valuemd).setForeignKeyMetaData(new ForeignKeyMetaData());
                }
                if (!StringUtils.isWhitespace(indexName)) {
                    IndexMetaData valueIdxmd = ((AbstractElementMetaData)valuemd).getIndexMetaData();
                    if (valueIdxmd == null) {
                        valueIdxmd = new IndexMetaData();
                        ((AbstractElementMetaData)valuemd).setIndexMetaData(valueIdxmd);
                    }
                    valueIdxmd.setName(indexName);
                }
                if (!StringUtils.isWhitespace(uniqueName)) {
                    UniqueMetaData valueUnimd = ((AbstractElementMetaData)valuemd).getUniqueMetaData();
                    if (valueUnimd == null) {
                        valueUnimd = new UniqueMetaData();
                        ((AbstractElementMetaData)valuemd).setUniqueMetaData(valueUnimd);
                    }
                    valueUnimd.setName(uniqueName);
                }
                if ((valueColumns = (Column[])annotationValues.get("columns")) != null && valueColumns.length > 0) {
                    for (Annotation annotation3 : valueColumns) {
                        ((AbstractElementMetaData)valuemd).addColumn(JDOAnnotationUtils.getColumnMetaDataForColumnAnnotation((Column)annotation3));
                    }
                }
                if (this.isPersistenceContext()) {
                    if (disableConversion != null && disableConversion.booleanValue()) {
                        valuemd.addExtension("type-converter-disabled", "true");
                    } else if (converterCls != null) {
                        typeMgr = this.mmgr.getNucleusContext().getTypeManager();
                        if (typeMgr.getTypeConverterForName(converterCls.getName()) == null) {
                            AttributeConverter conv = JDOTypeConverterUtils.createAttributeConverter(this.mmgr.getNucleusContext(), converterCls);
                            Class attrType = JDOTypeConverterUtils.getAttributeTypeForAttributeConverter(converterCls, ClassUtils.getMapValueType(member.getType(), member.getGenericType()));
                            Class clazz = JDOTypeConverterUtils.getDatastoreTypeForAttributeConverter(converterCls, attrType, null);
                            typeConv = new JDOTypeConverter(conv);
                            typeMgr.registerConverter(converterCls.getName(), typeConv, attrType, clazz, false, null);
                        }
                        valuemd.addExtension("type-converter-name", converterCls.getName());
                    }
                }
                JDOAnnotationUtils.addExtensionsToMetaData(valuemd, (Extension[])annotationValues.get("extensions"));
                embeddedMappings = (Embedded[])annotationValues.get("embeddedMapping");
                if (embeddedMappings == null || embeddedMappings.length <= 0) continue;
                EmbeddedMetaData embmd = new EmbeddedMetaData();
                embmd.setOwnerMember(embeddedMappings[0].ownerMember());
                embmd.setNullIndicatorColumn(embeddedMappings[0].nullIndicatorColumn());
                embmd.setNullIndicatorValue(embeddedMappings[0].nullIndicatorValue());
                ((AbstractElementMetaData)valuemd).setEmbeddedMetaData(embmd);
                embeddedValueMembers = embeddedMappings[0].members();
                continue;
            }
            if (string.equals(JDOAnnotationUtils.ORDER)) {
                ordermd = new OrderMetaData();
                ((OrderMetaData)ordermd).setColumnName((String)annotationValues.get("column"));
                ((OrderMetaData)ordermd).setMappedBy((String)annotationValues.get("mappedBy"));
                Column[] orderColumns = (Column[])annotationValues.get("columns");
                if (orderColumns != null && orderColumns.length > 0) {
                    for (Column column : orderColumns) {
                        ((OrderMetaData)ordermd).addColumn(JDOAnnotationUtils.getColumnMetaDataForColumnAnnotation(column));
                    }
                }
                JDOAnnotationUtils.addExtensionsToMetaData(ordermd, (Extension[])annotationValues.get("extensions"));
                continue;
            }
            if (string.equals(JDOAnnotationUtils.EMBEDDED)) {
                embeddedMember = true;
                embeddedOwnerField = (String)annotationValues.get("ownerMember");
                if (StringUtils.isWhitespace(embeddedOwnerField)) {
                    embeddedOwnerField = null;
                }
                if (StringUtils.isWhitespace(embeddedNullIndicatorColumn = (String)annotationValues.get("nullIndicatorColumn"))) {
                    embeddedNullIndicatorColumn = null;
                }
                if (StringUtils.isWhitespace(embeddedNullIndicatorValue = (String)annotationValues.get("nullIndicatorValue"))) {
                    embeddedNullIndicatorValue = null;
                }
                if ((embeddedMembers = (Persistent[])annotationValues.get("members")) == null || embeddedMembers.length != 0) continue;
                embeddedMembers = null;
                continue;
            }
            if (string.equals(JDOAnnotationUtils.INDEX)) {
                name = (String)annotationValues.get("name");
                String table = (String)annotationValues.get("table");
                String unique3 = (String)annotationValues.get("unique");
                String[] members = (String[])annotationValues.get("members");
                Column[] columnArray = (Column[])annotationValues.get("columns");
                idxmd = JDOAnnotationUtils.getIndexMetaData(name, table, unique3, members, columnArray);
                JDOAnnotationUtils.addExtensionsToMetaData(idxmd, (Extension[])annotationValues.get("extensions"));
                continue;
            }
            if (string.equals(JDOAnnotationUtils.UNIQUE)) {
                name = (String)annotationValues.get("name");
                String table = (String)annotationValues.get("table");
                String deferred = (String)annotationValues.get("deferred");
                String[] members = (String[])annotationValues.get("members");
                Column[] columnArray = (Column[])annotationValues.get("columns");
                unimd = JDOAnnotationUtils.getUniqueMetaData(name, table, deferred, members, columnArray);
                JDOAnnotationUtils.addExtensionsToMetaData(unimd, (Extension[])annotationValues.get("extensions"));
                continue;
            }
            if (string.equals(JDOAnnotationUtils.FOREIGNKEY)) {
                name = (String)annotationValues.get("name");
                String table = (String)annotationValues.get("table");
                String unique4 = (String)annotationValues.get("unique");
                String deferred = (String)annotationValues.get("deferred");
                String string11 = JDOAnnotationUtils.getForeignKeyActionString((ForeignKeyAction)((Object)annotationValues.get("deleteAction")));
                String updateAction = JDOAnnotationUtils.getForeignKeyActionString((ForeignKeyAction)((Object)annotationValues.get("updateAction")));
                String[] members = (String[])annotationValues.get("members");
                Column[] columns3 = (Column[])annotationValues.get("columns");
                fkmd = JDOAnnotationUtils.getFKMetaData(name, table, unique4, deferred, string11, updateAction, members, columns3);
                JDOAnnotationUtils.addExtensionsToMetaData(fkmd, (Extension[])annotationValues.get("extensions"));
                continue;
            }
            if (string.equals(JDOAnnotationUtils.CACHEABLE)) {
                String cache = (String)annotationValues.get("value");
                if (cache == null) continue;
                cacheable = cache;
                continue;
            }
            if (string.equals(JDOAnnotationUtils.CONVERT)) {
                Boolean enabled;
                convertConverterCls = (Class)annotationValues.get("value");
                if (convertConverterCls == AttributeConverter.UseDefault.class) {
                    convertConverterCls = null;
                }
                if (!(enabled = (Boolean)annotationValues.get("enabled")).booleanValue()) {
                    convertConverterCls = null;
                }
                if (convertConverterCls == null) continue;
                updateModifier = FieldPersistenceModifier.PERSISTENT;
                continue;
            }
            if (string.equals(JDOAnnotationUtils.EXTENSIONS)) {
                Extension[] values = (Extension[])annotationValues.get("value");
                if (values == null || values.length <= 0) continue;
                extensions = new HashMap<String, String>(values.length);
                for (Extension extension : values) {
                    String vendorName = extension.vendorName();
                    if (StringUtils.isWhitespace(vendorName)) {
                        throw new InvalidMetaDataException("044160", vendorName, extension.key().toString(), extension.value().toString());
                    }
                    if (!vendorName.equalsIgnoreCase("datanucleus")) continue;
                    extensions.put(extension.key().toString(), extension.value().toString());
                }
                continue;
            }
            if (string.equals(JDOAnnotationUtils.EXTENSION)) {
                String vendorName = (String)annotationValues.get("vendorName");
                if (StringUtils.isWhitespace(vendorName)) {
                    throw new InvalidMetaDataException("044160", vendorName, annotationValues.get("key"), annotationValues.get("value"));
                }
                if (!vendorName.equalsIgnoreCase("datanucleus")) continue;
                extensions = new HashMap(1);
                extensions.put((String)annotationValues.get("key"), (String)annotationValues.get("value"));
                continue;
            }
            NucleusLogger.METADATA.debug(Localiser.msg("044211", cmd.getFullClassName(), member.getName(), annotation.getName()));
        }
        if (mmd == null && (transactionalField || nonPersistentField || primaryKey || colmds != null || serialised || embeddedOwnerField != null || embeddedMember || embeddedNullIndicatorColumn != null || embeddedNullIndicatorValue != null || embeddedMembers != null || elemmd != null || keymd != null || valuemd != null || ordermd != null || idxmd != null || unimd != null || fkmd != null || joinmd != null || extensions != null || convertConverterCls != null)) {
            AbstractMemberMetaData abstractMemberMetaData = mmd = member.isProperty() ? new PropertyMetaData((MetaData)cmd, member.getName()) : new FieldMetaData((MetaData)cmd, member.getName());
            if (updateModifier != null && mmd.getPersistenceModifier() == FieldPersistenceModifier.DEFAULT) {
                mmd.setPersistenceModifier(updateModifier);
            }
            if (primaryKey) {
                mmd.setPersistenceModifier(FieldPersistenceModifier.PERSISTENT);
                mmd.setPrimaryKey(primaryKey);
            }
            if (serialised) {
                mmd.setPersistenceModifier(FieldPersistenceModifier.PERSISTENT);
            }
        }
        if (mmd != null) {
            AbstractMemberMetaData embfmd;
            String memberName;
            cmd.addMember(mmd);
            if (primaryKey) {
                mmd.setPrimaryKey(true);
            }
            if (serialised) {
                mmd.setSerialised(true);
            }
            if (embeddedMember) {
                mmd.setEmbedded(true);
            }
            if (nonPersistentField) {
                mmd.setNotPersistent();
            }
            if (transactionalField) {
                mmd.setTransactional();
            }
            if (this.isPersistenceContext() && convertConverterCls != null) {
                TypeManager typeMgr = this.mmgr.getNucleusContext().getTypeManager();
                if (typeMgr.getTypeConverterForName(convertConverterCls.getName()) == null) {
                    AttributeConverter conv = JDOTypeConverterUtils.createAttributeConverter(this.mmgr.getNucleusContext(), convertConverterCls);
                    Class attrType = JDOTypeConverterUtils.getAttributeTypeForAttributeConverter(convertConverterCls, member.getType());
                    Class dbType = JDOTypeConverterUtils.getDatastoreTypeForAttributeConverter(convertConverterCls, attrType, null);
                    JDOTypeConverter jDOTypeConverter = new JDOTypeConverter(conv);
                    typeMgr.registerConverter(convertConverterCls.getName(), jDOTypeConverter, attrType, dbType, false, null);
                }
                mmd.setTypeConverterName(convertConverterCls.getName());
            }
            if (embeddedMember && (embeddedOwnerField != null || embeddedNullIndicatorColumn != null || embeddedNullIndicatorValue != null || embeddedMembers != null)) {
                EmbeddedMetaData embmd = new EmbeddedMetaData();
                embmd.setOwnerMember(embeddedOwnerField);
                embmd.setNullIndicatorColumn(embeddedNullIndicatorColumn);
                embmd.setNullIndicatorValue(embeddedNullIndicatorValue);
                mmd.setEmbeddedMetaData(embmd);
                if (embeddedMembers != null && embeddedMembers.length > 0) {
                    for (void var46_60 : embeddedMembers) {
                        Object memberName2 = var46_60.name();
                        if (((String)memberName2).indexOf(46) > 0) {
                            memberName2 = ((String)memberName2).substring(((String)memberName2).lastIndexOf(46) + 1);
                        }
                        AbstractMemberMetaData embfmd2 = this.getFieldMetaDataForPersistent(embmd, (Persistent)var46_60, this.isMemberOfClassAField(member.getType(), (String)memberName2));
                        embmd.addMember(embfmd2);
                    }
                }
            }
            TypeManager typeManager = this.mmgr.getNucleusContext().getTypeManager();
            Object containerHandler = typeManager.getContainerHandler(member.getType());
            ContainerMetaData contmd = null;
            if (containerHandler != null) {
                contmd = (ContainerMetaData)containerHandler.newMetaData();
            }
            if (contmd instanceof CollectionMetaData) {
                Class collectionElementType = null;
                StringBuilder stringBuilder = new StringBuilder();
                if (elementTypes != null && elementTypes.length > 0 && elementTypes[0] != Void.TYPE) {
                    for (Class elementType : elementTypes) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(',');
                        }
                        stringBuilder.append(elementType.getName());
                    }
                    collectionElementType = elementTypes[0];
                } else {
                    collectionElementType = ClassUtils.getCollectionElementType(member.getType(), member.getGenericType());
                }
                contmd = new CollectionMetaData();
                contmd.setParent(mmd);
                ContainerMetaData collmd = contmd;
                ((CollectionMetaData)collmd).setElementType(stringBuilder.toString());
                if (!StringUtils.isWhitespace(embeddedElement)) {
                    ((CollectionMetaData)collmd).setEmbeddedElement(Boolean.valueOf(embeddedElement));
                }
                if (!StringUtils.isWhitespace(serializedElement)) {
                    ((CollectionMetaData)collmd).setSerializedElement(Boolean.valueOf(serializedElement));
                }
                if (!StringUtils.isWhitespace(dependentElement)) {
                    ((CollectionMetaData)collmd).setDependentElement(Boolean.valueOf(dependentElement));
                }
                if ((embeddedElementMembers != null || "true".equalsIgnoreCase(embeddedElement)) && elemmd == null) {
                    elemmd = new ElementMetaData();
                    mmd.setElementMetaData((ElementMetaData)elemmd);
                }
                if (elemmd != null && embeddedElementMembers != null) {
                    EmbeddedMetaData embmd = ((AbstractElementMetaData)elemmd).getEmbeddedMetaData();
                    if ("true".equalsIgnoreCase(embeddedElement) && ((AbstractElementMetaData)elemmd).getEmbeddedMetaData() == null) {
                        embmd = ((AbstractElementMetaData)elemmd).newEmbeddedMetaData();
                    }
                    for (void var52_144 : embeddedElementMembers) {
                        memberName = var52_144.name();
                        if (memberName.indexOf(46) > 0) {
                            memberName = memberName.substring(memberName.lastIndexOf(46) + 1);
                        }
                        embfmd = this.getFieldMetaDataForPersistent(embmd, (Persistent)var52_144, this.isMemberOfClassAField(collectionElementType, memberName));
                        embmd.addMember(embfmd);
                    }
                }
            } else if (contmd instanceof ArrayMetaData) {
                StringBuilder elementTypeStr = new StringBuilder();
                if (elementTypes != null && elementTypes.length > 0 && elementTypes[0] != Void.TYPE) {
                    for (Class elementType : elementTypes) {
                        if (elementTypeStr.length() > 0) {
                            elementTypeStr.append(',');
                        }
                        elementTypeStr.append(elementType.getName());
                    }
                } else {
                    elementTypeStr.append(member.getType().getComponentType().getName());
                }
                contmd = new ArrayMetaData();
                contmd.setParent(mmd);
                ArrayMetaData arrayMetaData = (ArrayMetaData)contmd;
                arrayMetaData.setElementType(elementTypeStr.toString());
                if (!StringUtils.isWhitespace(embeddedElement)) {
                    arrayMetaData.setEmbeddedElement(Boolean.valueOf(embeddedElement));
                }
                if (!StringUtils.isWhitespace(serializedElement)) {
                    arrayMetaData.setSerializedElement(Boolean.valueOf(serializedElement));
                }
                if (!StringUtils.isWhitespace(dependentElement)) {
                    arrayMetaData.setDependentElement(Boolean.valueOf(dependentElement));
                }
            } else if (contmd instanceof MapMetaData) {
                EmbeddedMetaData embmd;
                void var46_68;
                Class mapKeyType = null;
                mapKeyType = keyTypes != null && keyTypes.length > 0 && keyTypes[0] != Void.TYPE ? keyTypes[0] : ClassUtils.getMapKeyType(member.getType(), member.getGenericType());
                Object var46_65 = null;
                if (valueTypes != null && valueTypes.length > 0 && valueTypes[0] != Void.TYPE) {
                    Class clazz = valueTypes[0];
                } else {
                    Class clazz = ClassUtils.getMapValueType(member.getType(), member.getGenericType());
                }
                contmd = new MapMetaData();
                contmd.setParent(mmd);
                MapMetaData mapmd = (MapMetaData)contmd;
                mapmd.setKeyType(mapKeyType != null ? mapKeyType.getName() : null);
                if (!StringUtils.isWhitespace(embeddedKey)) {
                    mapmd.setEmbeddedKey(Boolean.valueOf(embeddedKey));
                }
                if (!StringUtils.isWhitespace(serializedKey)) {
                    mapmd.setSerializedKey(Boolean.valueOf(serializedKey));
                }
                if (!StringUtils.isWhitespace(dependentKey)) {
                    mapmd.setDependentKey(Boolean.valueOf(dependentKey));
                }
                mapmd.setValueType(var46_68 != null ? var46_68.getName() : null);
                if (!StringUtils.isWhitespace(embeddedValue)) {
                    mapmd.setEmbeddedValue(Boolean.valueOf(embeddedValue));
                }
                if (!StringUtils.isWhitespace(serializedValue)) {
                    mapmd.setSerializedValue(Boolean.valueOf(serializedValue));
                }
                if (!StringUtils.isWhitespace(dependentValue)) {
                    mapmd.setDependentValue(Boolean.valueOf(dependentValue));
                }
                if ((embeddedKeyMembers != null || "true".equalsIgnoreCase(embeddedKey)) && keymd == null) {
                    keymd = new KeyMetaData();
                    mmd.setKeyMetaData((KeyMetaData)keymd);
                }
                if (keymd != null && embeddedKeyMembers != null) {
                    embmd = ((AbstractElementMetaData)keymd).getEmbeddedMetaData();
                    if ("true".equalsIgnoreCase(embeddedKey) && ((AbstractElementMetaData)keymd).getEmbeddedMetaData() == null) {
                        embmd = ((AbstractElementMetaData)keymd).newEmbeddedMetaData();
                    }
                    for (void var52_146 : embeddedKeyMembers) {
                        memberName = var52_146.name();
                        if (memberName.indexOf(46) > 0) {
                            memberName = memberName.substring(memberName.lastIndexOf(46) + 1);
                        }
                        embfmd = this.getFieldMetaDataForPersistent(embmd, (Persistent)var52_146, this.isMemberOfClassAField(mapKeyType, memberName));
                        embmd.addMember(embfmd);
                    }
                }
                if ((embeddedKeyMembers != null || "true".equalsIgnoreCase(embeddedKey)) && valuemd == null) {
                    valuemd = new ValueMetaData();
                    mmd.setValueMetaData((ValueMetaData)valuemd);
                }
                if (valuemd != null && embeddedValueMembers != null) {
                    embmd = ((AbstractElementMetaData)valuemd).getEmbeddedMetaData();
                    if ("true".equalsIgnoreCase(embeddedValue) && ((AbstractElementMetaData)valuemd).getEmbeddedMetaData() == null) {
                        embmd = ((AbstractElementMetaData)valuemd).newEmbeddedMetaData();
                    }
                    for (void var52_148 : embeddedValueMembers) {
                        memberName = var52_148.name();
                        if (memberName.indexOf(46) > 0) {
                            memberName = memberName.substring(memberName.lastIndexOf(46) + 1);
                        }
                        embfmd = this.getFieldMetaDataForPersistent(embmd, (Persistent)var52_148, this.isMemberOfClassAField((Class)var46_68, memberName));
                        embmd.addMember(embfmd);
                    }
                }
            }
            if (contmd != null) {
                mmd.setContainer(contmd);
                if (elemmd != null) {
                    elemmd.setParent(mmd);
                    mmd.setElementMetaData((ElementMetaData)elemmd);
                    if (((AbstractElementMetaData)elemmd).getMappedBy() != null && mmd.getMappedBy() == null) {
                        mmd.setMappedBy(((AbstractElementMetaData)elemmd).getMappedBy());
                    }
                }
                if (keymd != null) {
                    keymd.setParent(mmd);
                    mmd.setKeyMetaData((KeyMetaData)keymd);
                }
                if (valuemd != null) {
                    valuemd.setParent(mmd);
                    mmd.setValueMetaData((ValueMetaData)valuemd);
                }
                if (ordermd != null) {
                    ordermd.setParent(mmd);
                    mmd.setOrderMetaData((OrderMetaData)ordermd);
                }
            }
            if (joinmd != null) {
                mmd.setJoinMetaData(joinmd);
            }
            if (colmds != null) {
                for (ColumnMetaData colmd : colmds) {
                    mmd.addColumn(colmd);
                }
            }
            if (idxmd != null) {
                mmd.setIndexMetaData(idxmd);
            }
            if (unimd != null) {
                mmd.setUniqueMetaData(unimd);
            }
            if (fkmd != null) {
                mmd.setForeignKeyMetaData(fkmd);
            }
            if (cacheable != null && cacheable.equalsIgnoreCase("false")) {
                mmd.setCacheable(false);
            }
            if (extensions != null) {
                mmd.addExtensions(extensions);
            }
        }
        return mmd;
    }

    @Override
    protected void processMethodAnnotations(AbstractClassMetaData cmd, Method method) {
        Annotation[] annotations = method.getAnnotations();
        if (annotations != null && annotations.length > 0) {
            EventListenerMetaData elmd = cmd.getListenerForClass(cmd.getFullClassName());
            for (Annotation annotation : annotations) {
                String annotationTypeName = annotation.annotationType().getName();
                if (!annotationTypeName.equals("javax.jdo.annotations.PreStore") && !annotationTypeName.equals("javax.jdo.annotations.PreDelete") && !annotationTypeName.equals("javax.jdo.annotations.PreAttach") && !annotationTypeName.equals("javax.jdo.annotations.PostAttach") && !annotationTypeName.equals("javax.jdo.annotations.PreDetach") && !annotationTypeName.equals("javax.jdo.annotations.PostDetach") && !annotationTypeName.equals("javax.jdo.annotations.PreClear") && !annotationTypeName.equals("javax.jdo.annotations.PostLoad")) continue;
                if (elmd == null) {
                    elmd = new EventListenerMetaData(cmd.getFullClassName());
                    cmd.addListener(elmd);
                }
                elmd.addCallback(annotationTypeName, method.getDeclaringClass().getName(), method.getName());
            }
        }
    }

    private AbstractMemberMetaData getFieldMetaDataForPersistent(MetaData parent, Persistent member, boolean isField) {
        Extension[] memberExts;
        Column[] columns;
        AbstractMemberMetaData fmd = isField ? new FieldMetaData(parent, member.name()) : new PropertyMetaData(parent, member.name());
        FieldPersistenceModifier modifier = JDOAnnotationUtils.getFieldPersistenceModifier(member.persistenceModifier());
        if (modifier != null) {
            fmd.setPersistenceModifier(modifier);
        }
        if (!StringUtils.isWhitespace(member.defaultFetchGroup())) {
            fmd.setDefaultFetchGroup(Boolean.valueOf(member.defaultFetchGroup()));
        }
        if (!StringUtils.isWhitespace(member.primaryKey())) {
            fmd.setPrimaryKey(Boolean.valueOf(member.primaryKey()));
        }
        if (!StringUtils.isWhitespace(member.embedded())) {
            fmd.setEmbedded(Boolean.valueOf(member.embedded()));
        }
        if (!StringUtils.isWhitespace(member.serialized())) {
            fmd.setSerialised(Boolean.valueOf(member.serialized()));
        }
        if (!StringUtils.isWhitespace(member.dependent())) {
            fmd.setDependent(Boolean.valueOf(member.dependent()));
        }
        String nullValue = JDOAnnotationUtils.getNullValueString(member.nullValue());
        fmd.setNullValue(org.datanucleus.metadata.NullValue.getNullValue(nullValue));
        fmd.setMappedBy(member.mappedBy());
        fmd.setColumn(member.column());
        fmd.setTable(member.table());
        fmd.setLoadFetchGroup(member.loadFetchGroup());
        fmd.setCacheable(Boolean.valueOf(member.cacheable()));
        fmd.setRecursionDepth(member.recursionDepth());
        String valueStrategy = JDOAnnotationUtils.getValueGenerationStrategyString(member.valueStrategy());
        if (!StringUtils.isWhitespace(member.customValueStrategy())) {
            valueStrategy = member.customValueStrategy();
        }
        fmd.setValueStrategy(valueStrategy);
        fmd.setSequence(member.sequence());
        String fieldTypeName = null;
        Class[] fieldTypes = member.types();
        if (fieldTypes != null && fieldTypes.length > 0) {
            StringBuilder typeStr = new StringBuilder();
            for (Class fieldType : fieldTypes) {
                if (typeStr.length() > 0) {
                    typeStr.append(',');
                }
                if (fieldType == null || fieldType == Void.TYPE) continue;
                typeStr.append(fieldType.getName());
            }
            fieldTypeName = typeStr.toString();
        }
        fmd.setFieldTypes(fieldTypeName);
        Class<? extends AttributeConverter> converterCls = member.converter();
        if (converterCls.getName().equals(AttributeConverter.UseDefault.class.getName())) {
            converterCls = null;
        }
        if (converterCls != null) {
            TypeManager typeMgr = this.mmgr.getNucleusContext().getTypeManager();
            if (typeMgr.getTypeConverterForName(converterCls.getName()) == null) {
                // empty if block
            }
            fmd.setTypeConverterName(converterCls.getName());
        }
        if (member.useDefaultConversion()) {
            fmd.setTypeConverterDisabled();
        }
        if ((columns = member.columns()) != null && columns.length > 0) {
            for (Column column : columns) {
                fmd.addColumn(JDOAnnotationUtils.getColumnMetaDataForColumnAnnotation(column));
            }
        }
        if ((memberExts = member.extensions()) != null && memberExts.length > 0) {
            for (Extension memberExt : memberExts) {
                fmd.addExtension(memberExt.key(), memberExt.value());
            }
        }
        return fmd;
    }

    private boolean isMemberOfClassAField(Class cls, String memberName) {
        try {
            cls.getDeclaredField(memberName);
        }
        catch (NoSuchFieldException nsfe) {
            return false;
        }
        return true;
    }

    protected AnnotationObject isClassPersistable(AnnotationObject[] annotations) {
        AnnotationObject result = null;
        for (AnnotationObject annotation : annotations) {
            String annName = annotation.getName();
            if (!annName.equals(JDOAnnotationUtils.PERSISTENCE_CAPABLE)) continue;
            result = result == null ? annotation : this.mergeAnnotation(this.persistenceCapableDefaults, result, annotation);
        }
        return result;
    }

    AnnotationObject mergeAnnotation(AnnotationObject defaults, AnnotationObject base, AnnotationObject dup) {
        Map<String, Object> baseEntry = base.getNameValueMap();
        Map<String, Object> dupEntry = dup.getNameValueMap();
        for (Map.Entry<String, Object> entry : defaults.getNameValueMap().entrySet()) {
            Object dupValue;
            String key = entry.getKey();
            Object defaultValue = entry.getValue();
            if (this.valueEqual(defaultValue, dupValue = dupEntry.get(key))) continue;
            NucleusLogger.METADATA.warn("Merging duplicated PersistenceCapable annotation : using key=" + key + " with value=" + dupValue + " instead of " + baseEntry.get(key));
            baseEntry.put(key, dupValue);
        }
        return base;
    }

    boolean valueEqual(Object defaultValue, Object dupValue) {
        if (defaultValue == null) {
            return dupValue == null;
        }
        if (defaultValue == Void.TYPE) {
            return dupValue == Void.TYPE;
        }
        if ("".equals(defaultValue)) {
            return "".equals(dupValue);
        }
        return defaultValue.equals(dupValue);
    }

    protected boolean isClassPersistenceAware(AnnotationObject[] annotations) {
        for (AnnotationObject annotation : annotations) {
            String annName = annotation.getName();
            if (!annName.equals(JDOAnnotationUtils.PERSISTENCE_AWARE)) continue;
            return true;
        }
        return false;
    }

    protected boolean doesClassHaveNamedQueries(AnnotationObject[] annotations) {
        for (AnnotationObject annotation : annotations) {
            String annName = annotation.getName();
            if (!annName.equals(JDOAnnotationUtils.QUERIES) && !annName.equals(JDOAnnotationUtils.QUERY)) continue;
            return true;
        }
        return false;
    }

    @PersistenceCapable
    protected class PersistenceCapableModel {
        protected PersistenceCapableModel() {
        }
    }
}

