/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo.query;

import java.util.ArrayList;
import javax.jdo.JDOException;
import javax.jdo.JDOQLTypedSubquery;
import javax.jdo.PersistenceManager;
import javax.jdo.query.BooleanExpression;
import javax.jdo.query.CharacterExpression;
import javax.jdo.query.CollectionExpression;
import javax.jdo.query.DateExpression;
import javax.jdo.query.DateTimeExpression;
import javax.jdo.query.NumericExpression;
import javax.jdo.query.PersistableExpression;
import javax.jdo.query.StringExpression;
import javax.jdo.query.TimeExpression;
import org.datanucleus.api.jdo.query.AbstractJDOQLTypedQuery;
import org.datanucleus.api.jdo.query.BooleanExpressionImpl;
import org.datanucleus.api.jdo.query.CharacterExpressionImpl;
import org.datanucleus.api.jdo.query.CollectionExpressionImpl;
import org.datanucleus.api.jdo.query.DateExpressionImpl;
import org.datanucleus.api.jdo.query.DateTimeExpressionImpl;
import org.datanucleus.api.jdo.query.ExpressionImpl;
import org.datanucleus.api.jdo.query.JDOQLTypedQueryImpl;
import org.datanucleus.api.jdo.query.NumericExpressionImpl;
import org.datanucleus.api.jdo.query.StringExpressionImpl;
import org.datanucleus.api.jdo.query.TimeExpressionImpl;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.query.expression.Expression;
import org.datanucleus.store.query.expression.VariableExpression;
import org.datanucleus.util.ClassUtils;

public class JDOQLTypedSubqueryImpl<T>
extends AbstractJDOQLTypedQuery<T>
implements JDOQLTypedSubquery<T> {
    private static final long serialVersionUID = 8872729615681952405L;

    public JDOQLTypedSubqueryImpl(PersistenceManager pm, Class<T> candidateClass, String candidateAlias, AbstractJDOQLTypedQuery parentQuery) {
        super(pm, candidateClass, candidateAlias, parentQuery);
    }

    public JDOQLTypedSubqueryImpl(PersistenceManager pm, Class<T> candidateClass, String candidateAlias, ExpressionImpl<T> candidates, AbstractJDOQLTypedQuery parentQuery) {
        super(pm, candidateClass, candidates, candidateAlias, parentQuery);
    }

    public String getAlias() {
        return "VAR_" + this.candidateAlias.toUpperCase();
    }

    @Override
    public PersistableExpression candidate() {
        String candName = this.candidateCls.getName();
        int pos = candName.lastIndexOf(46);
        String qName = candName.substring(0, pos + 1) + JDOQLTypedQueryImpl.getQueryClassNameForClassName(candName.substring(pos + 1));
        try {
            Class qClass = this.ec.getClassLoaderResolver().classForName(qName);
            Object candObj = ClassUtils.newInstance(qClass, new Class[]{PersistableExpression.class, String.class}, new Object[]{null, this.candidateAlias});
            if (candObj == null || !(candObj instanceof PersistableExpression)) {
                throw new JDOException("Class " + this.candidateCls.getName() + " has a Query class but the candidate is invalid");
            }
            return (PersistableExpression)candObj;
        }
        catch (NucleusException ne) {
            throw new JDOException("Class " + this.candidateCls.getName() + " has a Query class but the candidate is invalid", ne);
        }
    }

    @Override
    public JDOQLTypedSubquery<T> filter(BooleanExpression expr) {
        this.discardCompiled();
        this.filter = (BooleanExpressionImpl)expr;
        return this;
    }

    @Override
    public JDOQLTypedSubquery<T> groupBy(javax.jdo.query.Expression ... exprs) {
        this.discardCompiled();
        if (exprs != null && exprs.length > 0) {
            this.grouping = new ArrayList();
            for (int i = 0; i < exprs.length; ++i) {
                this.grouping.add((ExpressionImpl)exprs[i]);
            }
        }
        return this;
    }

    @Override
    public JDOQLTypedSubquery<T> having(javax.jdo.query.Expression expr) {
        this.discardCompiled();
        this.having = (ExpressionImpl)expr;
        return this;
    }

    @Override
    public <S> NumericExpression<S> selectUnique(NumericExpression<S> expr) {
        return (NumericExpression)this.internalSelect(expr, NumericExpressionImpl.class);
    }

    @Override
    public StringExpression selectUnique(StringExpression expr) {
        return (StringExpression)this.internalSelect(expr, StringExpressionImpl.class);
    }

    @Override
    public DateExpression selectUnique(DateExpression expr) {
        return (DateExpression)this.internalSelect(expr, DateExpressionImpl.class);
    }

    @Override
    public DateTimeExpression selectUnique(DateTimeExpression expr) {
        return (DateTimeExpression)this.internalSelect(expr, DateTimeExpressionImpl.class);
    }

    @Override
    public TimeExpression selectUnique(TimeExpression expr) {
        return (TimeExpression)this.internalSelect(expr, TimeExpressionImpl.class);
    }

    @Override
    public CharacterExpression selectUnique(CharacterExpression expr) {
        return (CharacterExpression)this.internalSelect(expr, CharacterExpressionImpl.class);
    }

    @Override
    public CollectionExpression select(CollectionExpression expr) {
        return (CollectionExpression)this.internalSelect(expr, CollectionExpressionImpl.class);
    }

    protected javax.jdo.query.Expression internalSelect(javax.jdo.query.Expression expr, Class implClass) {
        this.discardCompiled();
        this.result = new ArrayList();
        this.result.add((ExpressionImpl)expr);
        VariableExpression varExpr = new VariableExpression(this.getAlias());
        try {
            return (javax.jdo.query.Expression)ClassUtils.newInstance(implClass, new Class[]{Expression.class}, new Object[]{varExpr});
        }
        catch (NucleusException ne) {
            throw new JDOException("Unable to create expression of type " + expr.getClass().getName() + " due to error", ne);
        }
    }
}

