/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo.state;

import org.datanucleus.FetchPlan;
import org.datanucleus.api.jdo.exceptions.TransactionNotReadableException;
import org.datanucleus.api.jdo.exceptions.TransactionNotWritableException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.state.IllegalStateTransitionException;
import org.datanucleus.state.LifeCycleState;
import org.datanucleus.transaction.Transaction;
import org.datanucleus.util.Localiser;

class Hollow
extends LifeCycleState {
    protected Hollow() {
        this.isPersistent = true;
        this.isDirty = false;
        this.isNew = false;
        this.isDeleted = false;
        this.isTransactional = false;
        this.stateType = 4;
    }

    @Override
    public LifeCycleState transitionDeletePersistent(DNStateManager sm) {
        sm.clearLoadedFlags();
        return this.changeState(sm, 8);
    }

    @Override
    public LifeCycleState transitionMakeTransactional(DNStateManager sm, boolean refreshFields) {
        if (refreshFields) {
            sm.refreshLoadedFields();
        }
        return this.changeState(sm, 2);
    }

    @Override
    public LifeCycleState transitionMakeTransient(DNStateManager sm, boolean useFetchPlan, boolean detachAllOnCommit) {
        if (useFetchPlan) {
            sm.loadUnloadedFieldsInFetchPlan();
        }
        return this.changeState(sm, 0);
    }

    @Override
    public LifeCycleState transitionCommit(DNStateManager sm, Transaction tx) {
        throw new IllegalStateTransitionException(this, "commit", sm);
    }

    @Override
    public LifeCycleState transitionRollback(DNStateManager sm, Transaction tx) {
        throw new IllegalStateTransitionException(this, "rollback", sm);
    }

    @Override
    public LifeCycleState transitionReadField(DNStateManager sm, boolean isLoaded) {
        Transaction tx = sm.getExecutionContext().getTransaction();
        if (!tx.isActive() && !tx.getNontransactionalRead()) {
            throw new TransactionNotReadableException(Localiser.msg("027000"), sm.getInternalObjectId());
        }
        if (!tx.isActive() && sm.getClassMetaData().getIdentityType() == IdentityType.NONDURABLE && !isLoaded) {
            throw new NucleusUserException("Not able to read fields of nondurable object when in HOLLOW state");
        }
        if (!tx.getOptimistic() && tx.isActive()) {
            return this.changeState(sm, 2);
        }
        return this.changeState(sm, 9);
    }

    @Override
    public LifeCycleState transitionWriteField(DNStateManager sm) {
        Transaction tx = sm.getExecutionContext().getTransaction();
        if (!tx.isActive() && !tx.getNontransactionalWrite()) {
            throw new TransactionNotWritableException(Localiser.msg("027001"), sm.getInternalObjectId());
        }
        return this.changeState(sm, tx.isActive() ? 3 : 9);
    }

    @Override
    public LifeCycleState transitionRetrieve(DNStateManager sm, boolean fgOnly) {
        if (fgOnly) {
            sm.loadUnloadedFieldsInFetchPlan();
        } else {
            sm.loadUnloadedFields();
        }
        Transaction tx = sm.getExecutionContext().getTransaction();
        if (!tx.getOptimistic() && tx.isActive()) {
            return this.changeState(sm, 2);
        }
        if (tx.getOptimistic()) {
            return this.changeState(sm, 9);
        }
        return super.transitionRetrieve(sm, fgOnly);
    }

    @Override
    public LifeCycleState transitionRetrieve(DNStateManager sm, FetchPlan fetchPlan) {
        sm.loadUnloadedFieldsOfClassInFetchPlan(fetchPlan);
        Transaction tx = sm.getExecutionContext().getTransaction();
        if (!tx.getOptimistic() && tx.isActive()) {
            return this.changeState(sm, 2);
        }
        if (tx.getOptimistic()) {
            return this.changeState(sm, 9);
        }
        return super.transitionRetrieve(sm, fetchPlan);
    }

    @Override
    public LifeCycleState transitionRefresh(DNStateManager sm) {
        sm.clearSavedFields();
        sm.refreshFieldsInFetchPlan();
        sm.unloadNonFetchPlanFields();
        return this;
    }

    @Override
    public LifeCycleState transitionDetach(DNStateManager sm) {
        return this.changeState(sm, 11);
    }

    @Override
    public LifeCycleState transitionSerialize(DNStateManager sm) {
        Transaction tx = sm.getExecutionContext().getTransaction();
        if (tx.isActive() && !tx.getOptimistic()) {
            return this.changeState(sm, 2);
        }
        return this;
    }

    @Override
    public String toString() {
        return "HOLLOW";
    }
}

