/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.logging.util;

import io.github.qsy7.logging.ContextualLoggable;
import io.github.qsy7.logging.enumeration.LogLevel;
import java.lang.ref.WeakReference;
import java.security.SecureRandom;
import java.util.Base64;
import org.slf4j.LoggerFactory;

public class ExceptionUtil {
    private static final ThreadLocal<WeakReference<Integer>> EXCEPTION_REFERENCE = new ThreadLocal();
    public static final SecureRandom random = new SecureRandom();
    public static final Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();
    public static int idLength = 8;

    public static void onException(ContextualLoggable contextualLoggable, String typeName, String methodName, Object[] arguments, Throwable throwable) {
        ExceptionUtil.onException(typeName, methodName, arguments, throwable);
        LogLevel.ERROR.log(LoggerFactory.getLogger(typeName), "Contextual Details:\n{}", contextualLoggable.printContextualInformation());
    }

    public static void onException(String typeName, String methodName, Object[] arguments, Throwable throwable) {
        if (ExceptionUtil.wasAlreadyLogged(throwable)) {
            return;
        }
        EXCEPTION_REFERENCE.set(new WeakReference<Integer>(throwable.hashCode()));
        LogLevel.ERROR.log(LoggerFactory.getLogger(typeName), "{}({}){}", methodName, arguments, ExceptionUtil.getStackTrace(throwable, ExceptionUtil.getExceptionId()));
    }

    private static boolean wasAlreadyLogged(Throwable throwable) {
        if (EXCEPTION_REFERENCE.get() == null) {
            return false;
        }
        if (EXCEPTION_REFERENCE.get().get() == null) {
            return false;
        }
        return ((Integer)EXCEPTION_REFERENCE.get().get()).equals(throwable.hashCode());
    }

    public static String getExceptionId() {
        byte[] buffer = new byte[idLength];
        random.nextBytes(buffer);
        return encoder.encodeToString(buffer);
    }

    public static String getStackTrace(Throwable throwable, String exceptionId) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(" - " + exceptionId + "\n");
        buffer.append(throwable.getClass());
        if (throwable.getMessage() != null) {
            buffer.append(":");
            buffer.append(throwable.getMessage());
            buffer.append("\n");
        }
        if (throwable.getCause() != null) {
            buffer.append(throwable.getCause().getMessage());
            buffer.append("\n");
        }
        for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
            buffer.append("\t" + stackTraceElement.toString() + "\n");
        }
        return buffer.toString();
    }

    private ExceptionUtil() {
    }
}

