/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.property.impl.source;

import io.github.qsy7.logging.annotation.Sensitive;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.ExceptionUtil;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.property.api.PropertyManager;
import io.github.qsy7.property.api.SecretService;
import io.github.qsy7.property.api.annotation.PropertyValueType;
import io.github.qsy7.property.api.property.ConfigurableProperty;
import io.github.qsy7.property.api.source.PropertySource;
import io.github.qsy7.property.impl.AbstractPropertyManager;
import io.github.qsy7.property.impl.PropertyHelper;
import io.github.qsy7.property.impl.PropertySourceComparator;
import io.github.qsy7.property.impl.source.DefaultPropertyValue;
import io.github.qsy7.property.impl.source.OptionalPropertyValue;
import io.github.qsy7.property.impl.source.PropertyValue;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.reflections.Reflections;

public class PropertySourceManager
extends AbstractPropertyManager<PropertySource> {
    protected final Map<Class<? extends ConfigurableProperty>, PropertyValue> propertyValueMap;
    protected final Map<Class<? extends ConfigurableProperty>, PropertyValue> encryptedPropertyValueMap;
    protected final SecretService secretService;

    /*
     * WARNING - void declaration
     */
    public PropertySourceManager(Reflections reflections, PropertyManager propertyManager, SecretService secretService) {
        void secretService2;
        void propertyManager2;
        void reflections2;
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.property.impl.source.PropertySourceManager", "<init>", new Object[]{reflections, propertyManager, secretService});
        PropertySourceManager propertySourceManager = this;
        Reflections reflections3 = reflections;
        PropertyManager propertyManager3 = propertyManager;
        SecretService secretService3 = secretService;
        super((Reflections)reflections2, (PropertyManager)propertyManager2);
        propertySourceManager.propertyValueMap = new HashMap<Class<? extends ConfigurableProperty>, PropertyValue>();
        propertySourceManager.encryptedPropertyValueMap = new HashMap<Class<? extends ConfigurableProperty>, PropertyValue>();
        propertySourceManager.secretService = secretService2;
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.property.impl.source.PropertySourceManager", "<init>", new Object[]{reflections, propertyManager, secretService}, null, l);
    }

    @Override
    public void call() {
        long l = MethodLogUtil.onEnter(LogLevel.INFO, "io.github.qsy7.property.impl.source.PropertySourceManager", "call", new Object[0]);
        PropertySourceManager propertySourceManager = this;
        PropertySourceManager propertySourceManager2 = propertySourceManager;
        try {
            super.call();
            propertySourceManager2.decryptProperties();
            propertySourceManager2.validateProperties();
            propertySourceManager2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (propertySourceManager2 != null) {
            ExceptionUtil.onException("io.github.qsy7.property.impl.source.PropertySourceManager", "call", new Object[0], (Throwable)((Object)propertySourceManager2));
        }
        if (propertySourceManager2 != null) {
            throw propertySourceManager2;
        }
        MethodLogUtil.onExit(LogLevel.INFO, "io.github.qsy7.property.impl.source.PropertySourceManager", "call", new Object[0], null, l);
    }

    public Iterable<Class<? extends ConfigurableProperty>> getKeys() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.property.impl.source.PropertySourceManager", "getKeys", new Object[0]);
        PropertySourceManager propertySourceManager = this;
        Object object = propertySourceManager;
        try {
            object = ((PropertySourceManager)object).reflections.getSubTypesOf(ConfigurableProperty.class);
            return object;
        }
        finally {
            Throwable throwable = null;
        }
    }

    protected void validateProperties() {
        long l = MethodLogUtil.onEnter(LogLevel.DEBUG, "io.github.qsy7.property.impl.source.PropertySourceManager", "validateProperties", new Object[0]);
        PropertySourceManager propertySourceManager = this;
        PropertySourceManager propertySourceManager2 = propertySourceManager;
        try {
            propertySourceManager2.getKeys().forEach(p -> this.validateProperty((Class<? extends ConfigurableProperty>)p));
            propertySourceManager2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (propertySourceManager2 != null) {
            ExceptionUtil.onException("io.github.qsy7.property.impl.source.PropertySourceManager", "validateProperties", new Object[0], (Throwable)((Object)propertySourceManager2));
        }
        if (propertySourceManager2 != null) {
            throw propertySourceManager2;
        }
        MethodLogUtil.onExit(LogLevel.DEBUG, "io.github.qsy7.property.impl.source.PropertySourceManager", "validateProperties", new Object[0], null, l);
    }

    /*
     * WARNING - void declaration
     */
    protected void validateProperty(Class<? extends ConfigurableProperty> clazz) {
        long l = MethodLogUtil.onEnter(LogLevel.DEBUG, "io.github.qsy7.property.impl.source.PropertySourceManager", "validateProperty", new Object[]{clazz});
        PropertySourceManager propertySourceManager = this;
        Class<? extends ConfigurableProperty> clazz2 = clazz;
        PropertySourceManager propertySourceManager2 = propertySourceManager;
        Class<? extends ConfigurableProperty> clazz3 = clazz2;
        try {
            void configurablePropertyClass;
            String value = propertySourceManager2.get((Class<? extends ConfigurableProperty>)configurablePropertyClass);
            PropertyHelper.validatePropertyConfiguration((Class<? extends ConfigurableProperty>)configurablePropertyClass, value);
            propertySourceManager2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (propertySourceManager2 != null) {
            ExceptionUtil.onException("io.github.qsy7.property.impl.source.PropertySourceManager", "validateProperty", new Object[]{clazz2}, (Throwable)((Object)propertySourceManager2));
        }
        if (propertySourceManager2 != null) {
            throw propertySourceManager2;
        }
        MethodLogUtil.onExit(LogLevel.DEBUG, "io.github.qsy7.property.impl.source.PropertySourceManager", "validateProperty", new Object[]{clazz}, null, l);
    }

    @Override
    protected List<Class<? extends PropertySource>> getClasses() {
        long l = MethodLogUtil.onEnter(LogLevel.DEBUG, "io.github.qsy7.property.impl.source.PropertySourceManager", "getClasses", new Object[0]);
        PropertySourceManager propertySourceManager = this;
        Object object = propertySourceManager;
        try {
            ArrayList<Class<PropertySource>> orderedSourceClasses = new ArrayList<Class<PropertySource>>();
            orderedSourceClasses.addAll(((PropertySourceManager)object).reflections.getSubTypesOf(PropertySource.class));
            Collections.sort(orderedSourceClasses, new PropertySourceComparator());
            object = orderedSourceClasses;
            return object;
        }
        finally {
            Object var5_4 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void processClass(Class<? extends PropertySource> clazz) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        long l = MethodLogUtil.onEnter(LogLevel.DEBUG, "io.github.qsy7.property.impl.source.PropertySourceManager", "processClass", new Object[]{clazz});
        PropertySourceManager propertySourceManager = this;
        Class<? extends PropertySource> clazz2 = clazz;
        PropertySourceManager propertySourceManager2 = propertySourceManager;
        Class<? extends PropertySource> clazz3 = clazz2;
        try {
            void targetClass;
            PropertySource propertySource = (PropertySource)targetClass.getConstructor(PropertyManager.class).newInstance(propertySourceManager2.propertyManager);
            propertySource.get();
            propertySourceManager2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (propertySourceManager2 != null) {
            ExceptionUtil.onException("io.github.qsy7.property.impl.source.PropertySourceManager", "processClass", new Object[]{clazz2}, (Throwable)((Object)propertySourceManager2));
        }
        if (propertySourceManager2 != null) {
            throw propertySourceManager2;
        }
        MethodLogUtil.onExit(LogLevel.DEBUG, "io.github.qsy7.property.impl.source.PropertySourceManager", "processClass", new Object[]{clazz}, null, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decryptProperties() {
        long l = MethodLogUtil.onEnter(LogLevel.DEBUG, "io.github.qsy7.property.impl.source.PropertySourceManager", "decryptProperties", new Object[0]);
        PropertySourceManager propertySourceManager = this;
        PropertySourceManager propertySourceManager2 = propertySourceManager;
        try {
            try {
                for (Map.Entry<Class<? extends ConfigurableProperty>, PropertyValue> entry : propertySourceManager2.encryptedPropertyValueMap.entrySet()) {
                    Class<? extends ConfigurableProperty> keyName = entry.getKey();
                    String encryptedValue = entry.getValue().getValue();
                    if (encryptedValue == null) {
                        throw new IllegalArgumentException("Encrypted value is null, unable to decrypt it.");
                    }
                    String plaintextValue = propertySourceManager2.decryptProperty(encryptedValue);
                    if (plaintextValue == null) {
                        throw new IllegalArgumentException("Plaintext value is null, check the encrypted value is correct: " + String.valueOf(keyName));
                    }
                    propertySourceManager2.propertyValueMap.put(keyName, new DefaultPropertyValue(entry.getValue().getPropertyType(), plaintextValue));
                }
            }
            finally {
                propertySourceManager2.encryptedPropertyValueMap.clear();
            }
            propertySourceManager2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (propertySourceManager2 != null) {
            ExceptionUtil.onException("io.github.qsy7.property.impl.source.PropertySourceManager", "decryptProperties", new Object[0], (Throwable)((Object)propertySourceManager2));
        }
        if (propertySourceManager2 != null) {
            throw propertySourceManager2;
        }
        MethodLogUtil.onExit(LogLevel.DEBUG, "io.github.qsy7.property.impl.source.PropertySourceManager", "decryptProperties", new Object[0], null, l);
    }

    /*
     * WARNING - void declaration
     */
    public void set(Class<? extends ConfigurableProperty> clazz, String string) {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.property.impl.source.PropertySourceManager", "set", new Object[]{clazz, string});
        PropertySourceManager propertySourceManager = this;
        Class<? extends ConfigurableProperty> clazz2 = clazz;
        String string2 = string;
        PropertySourceManager propertySourceManager2 = propertySourceManager;
        Class<? extends ConfigurableProperty> clazz3 = clazz2;
        String string3 = string2;
        try {
            void value;
            if (value != null) {
                void configurableProperty;
                if (propertySourceManager2.isSensitive((Class<? extends ConfigurableProperty>)configurableProperty)) {
                    propertySourceManager2.setSensitiveProperty((Class<? extends ConfigurableProperty>)configurableProperty, (String)value);
                } else {
                    propertySourceManager2.setProperty((Class<? extends ConfigurableProperty>)configurableProperty, (String)value);
                }
            }
            propertySourceManager2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (propertySourceManager2 != null) {
            ExceptionUtil.onException("io.github.qsy7.property.impl.source.PropertySourceManager", "set", new Object[]{clazz2, string2}, (Throwable)((Object)propertySourceManager2));
        }
        if (propertySourceManager2 != null) {
            throw propertySourceManager2;
        }
        MethodLogUtil.onExit(LogLevel.TRACE, "io.github.qsy7.property.impl.source.PropertySourceManager", "set", new Object[]{clazz, string}, null, l);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isSensitive(Class<? extends ConfigurableProperty> clazz) {
        boolean bl;
        long l = MethodLogUtil.onEnter(LogLevel.DEBUG, "io.github.qsy7.property.impl.source.PropertySourceManager", "isSensitive", new Object[]{clazz});
        PropertySourceManager propertySourceManager = this;
        Class<? extends ConfigurableProperty> clazz2 = clazz;
        PropertySourceManager propertySourceManager2 = propertySourceManager;
        Class<? extends ConfigurableProperty> clazz3 = clazz2;
        try {
            void configurablePropertyClass;
            bl = configurablePropertyClass.isAnnotationPresent(Sensitive.class);
            clazz3 = null;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        if (clazz3 != null) {
            ExceptionUtil.onException("io.github.qsy7.property.impl.source.PropertySourceManager", "isSensitive", new Object[]{clazz2}, clazz3);
        }
        if (clazz3 != null) {
            throw clazz3;
        }
        boolean bl2 = bl;
        MethodLogUtil.onExit(LogLevel.DEBUG, "io.github.qsy7.property.impl.source.PropertySourceManager", "isSensitive", new Object[]{clazz}, bl2, l);
        return bl2;
    }

    @Sensitive
    protected void setSensitiveProperty(Class<? extends ConfigurableProperty> configurableProperty, String value) {
        this.encryptedPropertyValueMap.put(configurableProperty, new DefaultPropertyValue(PropertySourceManager.getPropertyValueType(configurableProperty), value));
    }

    /*
     * WARNING - void declaration
     */
    protected void setProperty(Class<? extends ConfigurableProperty> clazz, String string) {
        long l = MethodLogUtil.onEnter(LogLevel.DEBUG, "io.github.qsy7.property.impl.source.PropertySourceManager", "setProperty", new Object[]{clazz, string});
        PropertySourceManager propertySourceManager = this;
        Class<? extends ConfigurableProperty> clazz2 = clazz;
        String string2 = string;
        PropertySourceManager propertySourceManager2 = propertySourceManager;
        Class<? extends ConfigurableProperty> clazz3 = clazz2;
        String string3 = string2;
        try {
            void configurableProperty;
            if (PropertyHelper.isOptional((Class<? extends ConfigurableProperty>)configurableProperty)) {
                propertySourceManager2.propertyValueMap.put((Class<? extends ConfigurableProperty>)configurableProperty, new OptionalPropertyValue(PropertySourceManager.getPropertyValueType((Class<? extends ConfigurableProperty>)configurableProperty), Optional.ofNullable(value)));
            } else {
                propertySourceManager2.propertyValueMap.put((Class<? extends ConfigurableProperty>)configurableProperty, new DefaultPropertyValue(PropertySourceManager.getPropertyValueType((Class<? extends ConfigurableProperty>)configurableProperty), (String)value));
            }
            propertySourceManager2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (propertySourceManager2 != null) {
            ExceptionUtil.onException("io.github.qsy7.property.impl.source.PropertySourceManager", "setProperty", new Object[]{clazz2, string2}, (Throwable)((Object)propertySourceManager2));
        }
        if (propertySourceManager2 != null) {
            throw propertySourceManager2;
        }
        MethodLogUtil.onExit(LogLevel.DEBUG, "io.github.qsy7.property.impl.source.PropertySourceManager", "setProperty", new Object[]{clazz, string}, null, l);
    }

    /*
     * WARNING - void declaration
     */
    public static Class getPropertyValueType(Class<? extends ConfigurableProperty> clazz) {
        long l = MethodLogUtil.onEnter(LogLevel.INFO, "io.github.qsy7.property.impl.source.PropertySourceManager", "getPropertyValueType", new Object[]{clazz});
        Class<? extends ConfigurableProperty> clazz2 = clazz;
        Class<ConfigurableProperty> clazz3 = clazz2;
        try {
            void configurableProperty;
            clazz3 = configurableProperty.isAnnotationPresent(PropertyValueType.class) ? configurableProperty.getAnnotation(PropertyValueType.class).value() : String.class;
        }
        catch (Throwable throwable) {
            clazz3 = null;
        }
        Throwable throwable = null;
        if (throwable != null) {
            ExceptionUtil.onException("io.github.qsy7.property.impl.source.PropertySourceManager", "getPropertyValueType", new Object[]{clazz2}, throwable);
        }
        if (throwable != null) {
            throw throwable;
        }
        clazz2 = clazz3;
        MethodLogUtil.onExit(LogLevel.INFO, "io.github.qsy7.property.impl.source.PropertySourceManager", "getPropertyValueType", new Object[]{clazz}, clazz2, l);
        return clazz2;
    }

    @Sensitive
    protected String decryptProperty(String propertyKey) {
        return this.secretService.get(propertyKey);
    }

    @Sensitive
    public String get(Class<? extends ConfigurableProperty> configurableProperty) {
        PropertyValue defaultPropertyValue = this.propertyValueMap.get(configurableProperty);
        if (defaultPropertyValue != null) {
            return defaultPropertyValue.getValue();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Class type(Class<? extends ConfigurableProperty> clazz) {
        long l = MethodLogUtil.onEnter(LogLevel.INFO, "io.github.qsy7.property.impl.source.PropertySourceManager", "type", new Object[]{clazz});
        PropertySourceManager propertySourceManager = this;
        Class<? extends ConfigurableProperty> clazz2 = clazz;
        Object object = propertySourceManager;
        Class<? extends ConfigurableProperty> clazz3 = clazz2;
        try {
            void configurableProperty;
            PropertyValue defaultPropertyValue = ((PropertySourceManager)object).propertyValueMap.get(configurableProperty);
            object = defaultPropertyValue != null ? defaultPropertyValue.getPropertyType() : null;
        }
        catch (Throwable throwable) {
            object = null;
        }
        clazz3 = null;
        if (clazz3 != null) {
            ExceptionUtil.onException("io.github.qsy7.property.impl.source.PropertySourceManager", "type", new Object[]{clazz2}, clazz3);
        }
        if (clazz3 != null) {
            throw clazz3;
        }
        propertySourceManager = object;
        MethodLogUtil.onExit(LogLevel.INFO, "io.github.qsy7.property.impl.source.PropertySourceManager", "type", new Object[]{clazz}, propertySourceManager, l);
        return propertySourceManager;
    }

    public Map<Class<? extends ConfigurableProperty>, PropertyValue> getPropertyValueMap() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.property.impl.source.PropertySourceManager", "getPropertyValueMap", new Object[0]);
        PropertySourceManager propertySourceManager = this;
        Object object = propertySourceManager;
        try {
            object = ((PropertySourceManager)object).propertyValueMap;
            return object;
        }
        finally {
            Throwable throwable = null;
        }
    }

    public Map<Class<? extends ConfigurableProperty>, PropertyValue> getEncryptedPropertyValueMap() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.property.impl.source.PropertySourceManager", "getEncryptedPropertyValueMap", new Object[0]);
        PropertySourceManager propertySourceManager = this;
        Object object = propertySourceManager;
        try {
            object = ((PropertySourceManager)object).encryptedPropertyValueMap;
            return object;
        }
        finally {
            Throwable throwable = null;
        }
    }

    public SecretService getSecretService() {
        long l = MethodLogUtil.onEnter(LogLevel.TRACE, "io.github.qsy7.property.impl.source.PropertySourceManager", "getSecretService", new Object[0]);
        PropertySourceManager propertySourceManager = this;
        Object object = propertySourceManager;
        try {
            object = ((PropertySourceManager)object).secretService;
            return object;
        }
        finally {
            Throwable throwable = null;
        }
    }
}

