/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo;

import java.util.Map;
import javax.jdo.JDOOptimisticVerificationException;
import javax.jdo.JDOUnsupportedOptionException;
import javax.transaction.Synchronization;
import org.datanucleus.api.jdo.JDOAdapter;
import org.datanucleus.api.jdo.JDOPersistenceManager;
import org.datanucleus.api.jdo.JDOPersistenceManagerFactory;
import org.datanucleus.api.jdo.exceptions.TransactionActiveException;
import org.datanucleus.api.jdo.exceptions.TransactionCommitingException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.transaction.Transaction;
import org.datanucleus.transaction.TransactionEventListener;
import org.datanucleus.transaction.TransactionUtils;

public class JDOTransaction
implements javax.jdo.Transaction {
    Transaction tx;
    JDOPersistenceManager pm;

    public JDOTransaction(JDOPersistenceManager pm, Transaction tx) {
        this.tx = tx;
        this.pm = pm;
    }

    @Override
    public JDOPersistenceManager getPersistenceManager() {
        return this.pm;
    }

    @Override
    public boolean isActive() {
        return this.tx.isActive();
    }

    @Override
    public void begin() {
        this.tx.begin();
    }

    @Override
    public void commit() {
        try {
            this.tx.commit();
        }
        catch (NucleusException ne) {
            if (ne.getNestedExceptions() != null) {
                if (ne.getNestedExceptions()[0] instanceof NucleusOptimisticException) {
                    if (ne.getNestedExceptions().length > 1) {
                        int numNested = ne.getNestedExceptions().length;
                        Throwable[] jdoNested = new JDOOptimisticVerificationException[numNested];
                        for (int i = 0; i < numNested; ++i) {
                            NucleusOptimisticException nested = (NucleusOptimisticException)ne.getNestedExceptions()[i];
                            jdoNested[i] = (JDOOptimisticVerificationException)JDOAdapter.getJDOExceptionForNucleusException(nested);
                        }
                        throw new JDOOptimisticVerificationException(ne.getMessage(), jdoNested);
                    }
                    NucleusException ex = ne.getNestedExceptions()[0] instanceof NucleusException ? (NucleusException)ne.getNestedExceptions()[0] : new NucleusException(ne.getNestedExceptions()[0].getMessage(), ne.getNestedExceptions()[0]);
                    Throwable[] nested = ex.getNestedExceptions();
                    Throwable[] jdoNested = new JDOOptimisticVerificationException[nested.length];
                    for (int i = 0; i < nested.length; ++i) {
                        NucleusException nestedEx = nested[i] instanceof NucleusException ? (NucleusException)nested[i] : new NucleusException(nested[i].getMessage(), nested[i]);
                        jdoNested[i] = (JDOOptimisticVerificationException)JDOAdapter.getJDOExceptionForNucleusException(nestedEx);
                    }
                    throw new JDOOptimisticVerificationException(ne.getMessage(), jdoNested);
                }
                NucleusException ex = ne.getNestedExceptions()[0] instanceof NucleusException ? (NucleusException)ne.getNestedExceptions()[0] : new NucleusException(ne.getNestedExceptions()[0].getMessage(), ne.getNestedExceptions()[0]);
                throw JDOAdapter.getJDOExceptionForNucleusException(ex);
            }
            throw JDOAdapter.getJDOExceptionForNucleusException(ne);
        }
    }

    @Override
    public void rollback() {
        try {
            this.tx.rollback();
        }
        catch (NucleusException jpe) {
            throw JDOAdapter.getJDOExceptionForNucleusException(jpe);
        }
    }

    @Override
    public boolean getNontransactionalRead() {
        return this.tx.getNontransactionalRead();
    }

    @Override
    public boolean getNontransactionalWrite() {
        return this.tx.getNontransactionalWrite();
    }

    public boolean getNontransactionalWriteAutoCommit() {
        return this.tx.getNontransactionalWriteAutoCommit();
    }

    @Override
    public boolean getOptimistic() {
        return this.tx.getOptimistic();
    }

    @Override
    public boolean getRestoreValues() {
        return this.tx.getRestoreValues();
    }

    @Override
    public boolean getRetainValues() {
        return this.tx.getRetainValues();
    }

    @Override
    public boolean getRollbackOnly() {
        return this.tx.getRollbackOnly();
    }

    @Override
    public Synchronization getSynchronization() {
        return this.tx.getSynchronization();
    }

    @Override
    public void setNontransactionalRead(boolean flag) {
        this.assertNotCommitting();
        this.tx.setNontransactionalRead(flag);
    }

    @Override
    public void setNontransactionalWrite(boolean flag) {
        this.assertNotCommitting();
        this.tx.setNontransactionalWrite(flag);
    }

    public void setNontransactionalWriteAutoCommit(boolean flag) {
        this.assertNotCommitting();
        this.tx.setNontransactionalWriteAutoCommit(flag);
    }

    @Override
    public void setOptimistic(boolean opt) {
        this.assertNotInUse();
        this.assertNotCommitting();
        this.tx.setOptimistic(opt);
    }

    @Override
    public void setRestoreValues(boolean restore) {
        this.assertNotInUse();
        this.assertNotCommitting();
        this.tx.setRestoreValues(restore);
    }

    @Override
    public void setRetainValues(boolean retain) {
        this.assertNotCommitting();
        this.tx.setRetainValues(retain);
    }

    @Override
    public void setRollbackOnly() {
        if (this.tx.isActive()) {
            this.tx.setRollbackOnly();
        }
    }

    @Override
    public void setSynchronization(Synchronization synch) {
        this.tx.setSynchronization(synch);
    }

    @Override
    public void setIsolationLevel(String level) {
        this.assertNotCommitting();
        if (this.tx.isActive() && !this.tx.getOptimistic()) {
            throw new JDOUnsupportedOptionException("Cannot change the transaction isolation level while a datastore transaction is active");
        }
        JDOPersistenceManagerFactory pmf = this.pm.getPersistenceManagerFactory();
        if (!pmf.supportedOptions().contains("javax.jdo.option.TransactionIsolationLevel." + level)) {
            throw new JDOUnsupportedOptionException("Isolation level \"" + level + "\" not supported by this datastore");
        }
        int isolationLevel = TransactionUtils.getTransactionIsolationLevelForName(level);
        this.tx.setOption("transaction.isolation", isolationLevel);
    }

    @Override
    public String getIsolationLevel() {
        Object value;
        Map<String, Object> txOptions = this.tx.getOptions();
        Object object = value = txOptions != null ? txOptions.get("transaction.isolation") : null;
        if (value != null) {
            return TransactionUtils.getNameForTransactionIsolationLevel((Integer)value);
        }
        return null;
    }

    public void setSavepoint(String name) {
        if (name == null) {
            throw new IllegalStateException("No savepoint name provided so cannot set savepoint");
        }
        if (!this.tx.isActive()) {
            throw new IllegalStateException("No active transaction so cannot set savepoint");
        }
        this.tx.setSavepoint(name);
    }

    public void releaseSavepoint(String name) {
        if (name == null) {
            throw new IllegalStateException("No savepoint name provided so cannot release savepoint");
        }
        if (!this.tx.isActive()) {
            throw new IllegalStateException("No active transaction so cannot release a savepoint");
        }
        this.tx.releaseSavepoint(name);
    }

    public void rollbackToSavepoint(String name) {
        if (name == null) {
            throw new IllegalStateException("No savepoint name provided so cannot rollback to savepoint");
        }
        if (!this.tx.isActive()) {
            throw new IllegalStateException("No active transaction so cannot rollback to savepoint");
        }
        this.tx.rollbackToSavepoint(name);
    }

    protected void assertNotCommitting() {
        if (this.tx.isCommitting()) {
            throw new TransactionCommitingException(this);
        }
    }

    protected void assertNotInUse() {
        if (this.tx.isActive()) {
            throw new TransactionActiveException(this);
        }
    }

    @Override
    public Boolean getSerializeRead() {
        return this.tx.getSerializeRead();
    }

    @Override
    public void setSerializeRead(Boolean serialize) {
        this.assertNotCommitting();
        this.tx.setSerializeRead(serialize);
    }

    public void setOption(String option, int value) {
        this.tx.setOption(option, value);
    }

    public void setOption(String option, boolean value) {
        this.tx.setOption(option, value);
    }

    public void setOption(String option, String value) {
        this.tx.setOption(option, value);
    }

    public void registerEventListener(TransactionEventListener listener) {
        this.tx.bindTransactionEventListener(listener);
    }

    public void deregisterEventListener(TransactionEventListener listener) {
        this.tx.removeTransactionEventListener(listener);
    }
}

