/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo.metadata.api;

import javax.jdo.JDOUserException;
import javax.jdo.annotations.SequenceStrategy;
import javax.jdo.metadata.ClassMetadata;
import javax.jdo.metadata.InterfaceMetadata;
import javax.jdo.metadata.PackageMetadata;
import javax.jdo.metadata.SequenceMetadata;
import org.datanucleus.api.jdo.metadata.api.AbstractMetadataImpl;
import org.datanucleus.api.jdo.metadata.api.ClassMetadataImpl;
import org.datanucleus.api.jdo.metadata.api.InterfaceMetadataImpl;
import org.datanucleus.api.jdo.metadata.api.JDOMetadataImpl;
import org.datanucleus.api.jdo.metadata.api.SequenceMetadataImpl;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.metadata.SequenceMetaData;
import org.datanucleus.util.ClassUtils;

public class PackageMetadataImpl
extends AbstractMetadataImpl
implements PackageMetadata {
    public PackageMetadataImpl(PackageMetaData pmd) {
        super(pmd);
    }

    public PackageMetaData getInternal() {
        return (PackageMetaData)this.internalMD;
    }

    @Override
    public String getName() {
        return this.getInternal().getName();
    }

    @Override
    public String getCatalog() {
        return this.getInternal().getCatalog();
    }

    @Override
    public PackageMetadata setCatalog(String cat) {
        this.getInternal().setCatalog(cat);
        return this;
    }

    @Override
    public String getSchema() {
        return this.getInternal().getSchema();
    }

    @Override
    public PackageMetadata setSchema(String sch) {
        this.getInternal().setSchema(sch);
        return this;
    }

    @Override
    public ClassMetadata[] getClasses() {
        ClassMetadata[] classes = new ClassMetadataImpl[this.getNumberOfClasses()];
        for (int i = 0; i < classes.length; ++i) {
            classes[i] = new ClassMetadataImpl(this.getInternal().getClass(i));
            ((ClassMetadataImpl)classes[i]).parent = this;
        }
        return classes;
    }

    @Override
    public int getNumberOfClasses() {
        return this.getInternal().getNoOfClasses();
    }

    @Override
    public ClassMetadata newClassMetadata(String name) {
        ClassMetaData internalCmd = this.getInternal().newClassMetaData(name);
        ClassMetadataImpl cmd = new ClassMetadataImpl(internalCmd);
        cmd.parent = this;
        return cmd;
    }

    @Override
    public ClassMetadata newClassMetadata(Class cls) {
        if (cls.isInterface()) {
            throw new JDOUserException("Canot create new class metadata for " + cls.getName() + " since it is an interface!");
        }
        ClassMetaData internalCmd = this.getInternal().newClassMetaData(ClassUtils.getClassNameForClass(cls));
        ClassMetadataImpl cmd = new ClassMetadataImpl(internalCmd);
        cmd.parent = this;
        return cmd;
    }

    @Override
    public InterfaceMetadata[] getInterfaces() {
        InterfaceMetadata[] interfaces = new InterfaceMetadataImpl[this.getNumberOfInterfaces()];
        for (int i = 0; i < interfaces.length; ++i) {
            interfaces[i] = new InterfaceMetadataImpl(this.getInternal().getInterface(i));
            ((InterfaceMetadataImpl)interfaces[i]).parent = this;
        }
        return interfaces;
    }

    @Override
    public int getNumberOfInterfaces() {
        return this.getInternal().getNoOfInterfaces();
    }

    @Override
    public InterfaceMetadata newInterfaceMetadata(String name) {
        InterfaceMetaData internalImd = this.getInternal().newInterfaceMetaData(name);
        InterfaceMetadataImpl imd = new InterfaceMetadataImpl(internalImd);
        imd.parent = this;
        return imd;
    }

    @Override
    public InterfaceMetadata newInterfaceMetadata(Class cls) {
        if (!cls.isInterface()) {
            throw new JDOUserException("Canot create new interface metadata for " + cls.getName() + " since not interface!");
        }
        InterfaceMetaData internalImd = this.getInternal().newInterfaceMetaData(ClassUtils.getClassNameForClass(cls));
        InterfaceMetadataImpl imd = new InterfaceMetadataImpl(internalImd);
        imd.parent = this;
        return imd;
    }

    @Override
    public SequenceMetadata[] getSequences() {
        SequenceMetaData[] internalSeqmds = this.getInternal().getSequences();
        if (internalSeqmds == null) {
            return null;
        }
        SequenceMetadata[] seqmds = new SequenceMetadataImpl[internalSeqmds.length];
        for (int i = 0; i < seqmds.length; ++i) {
            seqmds[i] = new SequenceMetadataImpl(internalSeqmds[i]);
            ((SequenceMetadataImpl)seqmds[i]).parent = this;
        }
        return seqmds;
    }

    @Override
    public int getNumberOfSequences() {
        return this.getInternal().getNoOfSequences();
    }

    @Override
    public SequenceMetadata newSequenceMetadata(String name, SequenceStrategy strategy) {
        String str = null;
        if (strategy == SequenceStrategy.CONTIGUOUS) {
            str = org.datanucleus.metadata.SequenceStrategy.CONTIGUOUS.toString();
        } else if (strategy == SequenceStrategy.NONCONTIGUOUS) {
            str = org.datanucleus.metadata.SequenceStrategy.NONCONTIGUOUS.toString();
        } else if (strategy == SequenceStrategy.NONTRANSACTIONAL) {
            str = org.datanucleus.metadata.SequenceStrategy.NONTRANSACTIONAL.toString();
        }
        SequenceMetaData internalSeqmd = this.getInternal().newSequenceMetaData(name, str);
        SequenceMetadataImpl seqmd = new SequenceMetadataImpl(internalSeqmd);
        seqmd.parent = this;
        return seqmd;
    }

    @Override
    public AbstractMetadataImpl getParent() {
        if (this.parent == null) {
            this.parent = new JDOMetadataImpl(((PackageMetaData)this.internalMD).getFileMetaData());
        }
        return super.getParent();
    }
}

