package io.github.qsy7.examples.queue;

import com.google.inject.AbstractModule;
import io.github.qsy7.datastore.DefaultQueryBuilderResolver;
import io.github.qsy7.datastore.api.repository.QueryBuilderResolver;
import io.github.qsy7.datastore.api.repository.Repository;
import io.github.qsy7.datastore.modules.GoogleGuicePersistModule;
import io.github.qsy7.datastore.modules.jpa.JpaRepository;
import io.github.qsy7.infrastructure.inject.providers.guice.GuiceApplicationModule;
import io.github.qsy7.queue.jpa.guice.QueueModule;

public class QueueGuiceCLIModule extends AbstractModule implements GuiceApplicationModule {
  @Override
  protected void configure() {
    install(new QueueModule());
    install(new GoogleGuicePersistModule());
    bind(Repository.class).to(JpaRepository.class);
    bind(QueryBuilderResolver.class).to(DefaultQueryBuilderResolver.class);
    // install(new PrometheusMetricsModule());
  }
}
