package io.github.qsy7.browser.impl.service.urifilter;

import io.github.qsy7.browser.api.service.URIFilter;
import io.github.qsy7.browser.impl.service.util.URIUtil;

public abstract class AbstractURIFilter implements URIFilter {
  @Override
  public boolean matches(String uri) {
    return (doMatch(URIUtil.removeProtocol(uri)));
  }

  protected abstract boolean doMatch(final String uri);
}
