// Generated by delombok at Fri Jan 12 23:33:02 EST 2024
package io.github.qsy7.encryption.impl;

import io.github.qsy7.encryption.enumeration.EncryptionAlgorithm;
import io.github.qsy7.encryption.property.EncryptionKeyLength;
import io.github.qsy7.encryption.property.IVFilePath;
import io.github.qsy7.encryption.property.InitializationVectorLength;
import io.github.qsy7.encryption.property.KeyFilePath;
import io.github.qsy7.encryption.service.SaltService;
import io.github.qsy7.property.api.annotation.Property;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.Key;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.apache.commons.io.IOUtils;

@Singleton
public class RuntimeEncryptionConfiguration {
  protected final String keyFilePath;
  protected final String ivFilePath;
  protected byte[] keyData;
  protected byte[] ivData;
  // TODO: generate this automatically on startup
  // protected String sharedSecret;
  protected final SaltService saltService;
  protected Key key;
  protected IvParameterSpec iv;

  @Inject
  public RuntimeEncryptionConfiguration(@Property(KeyFilePath.class) String keyFilePath, @Property(IVFilePath.class) String ivFilePath, SaltService saltService) throws IOException {
    this.keyFilePath = keyFilePath;
    this.ivFilePath = ivFilePath;
    this.saltService = saltService;
    setupKey();
  }

  protected void setupKey() throws IOException {
    if (new File(keyFilePath).exists()) {
      keyData = new byte[EncryptionKeyLength.L_256];
      ivData = new byte[InitializationVectorLength.B_16];
      // read key from file
      IOUtils.read(new FileInputStream(keyFilePath), keyData);
      IOUtils.read(new FileInputStream(ivFilePath), ivData);
    } else {
      // generate key and write it
      keyData = saltService.generate(EncryptionKeyLength.L_256);
      try (FileOutputStream fos = new FileOutputStream(new File(keyFilePath))) {
        fos.write(keyData);
      }
      ivData = saltService.generate(InitializationVectorLength.B_16);
      try (FileOutputStream fos = new FileOutputStream(new File(ivFilePath))) {
        fos.write(ivData);
      }
    }
    key = new SecretKeySpec(keyData, EncryptionAlgorithm.AES.getAlgorithmName());
    iv = new IvParameterSpec(ivData);
  }

  @java.lang.SuppressWarnings("all")
  public String getKeyFilePath() {
    return this.keyFilePath;
  }

  @java.lang.SuppressWarnings("all")
  public String getIvFilePath() {
    return this.ivFilePath;
  }

  @java.lang.SuppressWarnings("all")
  public byte[] getKeyData() {
    return this.keyData;
  }

  @java.lang.SuppressWarnings("all")
  public byte[] getIvData() {
    return this.ivData;
  }

  @java.lang.SuppressWarnings("all")
  public SaltService getSaltService() {
    return this.saltService;
  }

  @java.lang.SuppressWarnings("all")
  public Key getKey() {
    return this.key;
  }

  @java.lang.SuppressWarnings("all")
  public IvParameterSpec getIv() {
    return this.iv;
  }
}
