package io.github.qsy7.linux.builder.impl.service.module.funtoo.portage;

import io.github.qsy7.linux.builder.api.model.configuration.BuildConfiguration;
import io.github.qsy7.linux.builder.api.model.configuration.StringConfiguration;
import io.github.qsy7.linux.builder.api.service.BuildService;
import io.github.qsy7.linux.builder.impl.service.annotation.ModuleSupports;
import io.github.qsy7.linux.builder.impl.service.enumeration.DistributionConfiguration;
import io.github.qsy7.linux.builder.impl.service.enumeration.PortageConfigurationType;
import io.github.qsy7.linux.builder.impl.service.util.configuration.StringConfigurer;
import javax.inject.Inject;

@ModuleSupports(
    distribution = DistributionConfiguration.Gentoo,
    configurer = StringConfigurer.class,
    configurationClass = StringConfiguration.class)
public class PackageAcceptKeywordsModule extends AbstractPortagePackageModule {
  @Inject
  public PackageAcceptKeywordsModule(
      BuildService buildService,
      BuildConfiguration buildConfiguration,
      DistributionConfiguration distributionConfiguration) {
    super(
        buildService,
        buildConfiguration,
        distributionConfiguration,
        PortageConfigurationType.Keywords);
  }
}
