package io.github.qsy7.linux.builder.impl.service.provider;

import io.github.qsy7.infrastructure.inject.core.helper.ApplicationHelper;
import io.github.qsy7.linux.builder.api.service.GroupaddService;
import io.github.qsy7.linux.builder.impl.service.enumeration.DistributionConfiguration;
import javax.inject.Inject;
import javax.inject.Provider;

public class GroupaddServiceProvider implements Provider<GroupaddService> {
  protected final GroupaddService groupaddService;

  @Inject
  public GroupaddServiceProvider(final DistributionConfiguration distributionConfiguration) {
    super();

    groupaddService =
        ApplicationHelper.getApplicationInstance()
            .getInjector()
            .getInstance(distributionConfiguration.getImplementingGroupaddServiceClass());
  }

  @Override
  public GroupaddService get() {
    return groupaddService;
  }
}
