package io.github.qsy7.linux.builder.impl.service.module;

import io.github.qsy7.linux.builder.api.model.configuration.BuildConfiguration;
import io.github.qsy7.linux.builder.api.model.configuration.StringConfiguration;
import io.github.qsy7.linux.builder.api.service.BuildService;
import io.github.qsy7.linux.builder.api.service.HostnameService;
import io.github.qsy7.linux.builder.impl.service.annotation.ModuleSupports;
import io.github.qsy7.linux.builder.impl.service.enumeration.DistributionConfiguration;
import io.github.qsy7.linux.builder.impl.service.util.configuration.StringConfigurer;
import javax.inject.Inject;

@ModuleSupports(
    distribution = DistributionConfiguration.Linux,
    configurer = StringConfigurer.class,
    configurationClass = StringConfiguration.class)
public class HostnameModule extends AbstractSingleModule<StringConfiguration> {
  protected final HostnameService hostnameService;

  @Inject
  public HostnameModule(
      BuildService buildService,
      BuildConfiguration buildConfiguration,
      DistributionConfiguration distributionConfiguration,
      HostnameService hostnameService) {
    super(buildService, buildConfiguration, distributionConfiguration);
    this.hostnameService = hostnameService;
  }

  @Override
  public void document() {}

  @Override
  protected void doRun() throws Exception {
    hostnameService.set(configuration.getContent());
  }
}
