package io.github.qsy7.linux.builder.impl.service.provider;

import io.github.qsy7.infrastructure.inject.core.helper.ApplicationHelper;
import io.github.qsy7.linux.builder.api.service.GroupsService;
import io.github.qsy7.linux.builder.impl.service.enumeration.DistributionConfiguration;
import javax.inject.Inject;
import javax.inject.Provider;

public class GroupsServiceProvider implements Provider<GroupsService> {
  protected final GroupsService groupsService;

  @Inject
  public GroupsServiceProvider(final DistributionConfiguration distributionConfiguration) {
    super();

    this.groupsService =
        ApplicationHelper.getApplicationInstance()
            .getInjector()
            .getInstance(distributionConfiguration.getImplementingGroupsServiceClass());
  }

  @Override
  public GroupsService get() {
    return groupsService;
  }
}
