/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.linux.builder.impl.service.module;

import io.github.qsy7.datastore.api.model.entity.AbstractEntity;
import io.github.qsy7.download.api.model.Download;
import io.github.qsy7.download.api.service.DownloadService;
import io.github.qsy7.file.api.service.DirectoryCopierService;
import io.github.qsy7.linux.builder.api.model.configuration.BuildConfiguration;
import io.github.qsy7.linux.builder.api.model.configuration.ISOConfiguration;
import io.github.qsy7.linux.builder.api.service.BuildService;
import io.github.qsy7.linux.builder.impl.service.annotation.ModuleSupports;
import io.github.qsy7.linux.builder.impl.service.enumeration.DistributionConfiguration;
import io.github.qsy7.linux.builder.impl.service.module.AbstractSingleModule;
import io.github.qsy7.linux.builder.impl.service.util.configuration.YamlConfigurer;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.shell.api.enumeration.MountAction;
import io.github.qsy7.shell.api.enumeration.VFSType;
import io.github.qsy7.shell.api.model.MountCommand;
import io.github.qsy7.shell.api.model.MountPoint;
import io.github.qsy7.shell.api.service.MountService;
import io.github.qsy7.shell.api.service.ShellExecutionService;
import java.io.File;
import javax.inject.Inject;

@ModuleSupports(distribution=DistributionConfiguration.Linux, configurer=YamlConfigurer.class, configurationClass=ISOConfiguration.class)
public class IsoModule
extends AbstractSingleModule<ISOConfiguration> {
    public static final String ISO_FILE = "ISO-FILE";
    public static final String ISO_ROOT_CONTENTS = "ISO-ROOT-CONTENTS";
    protected final DownloadService downloadService;
    protected final MountService mountService;
    protected final DirectoryCopierService directoryCopierService;
    protected final ShellExecutionService shellExecutionService;

    /*
     * WARNING - void declaration
     */
    @Inject
    public IsoModule(BuildService buildService, BuildConfiguration buildConfiguration, DistributionConfiguration distributionConfiguration, DownloadService downloadService, MountService mountService, DirectoryCopierService directoryCopierService, ShellExecutionService shellExecutionService) {
        void shellExecutionService2;
        void directoryCopierService2;
        void mountService2;
        void downloadService2;
        void distributionConfiguration2;
        void buildConfiguration2;
        void buildService2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.module.IsoModule", (String)"<init>", (Object[])new Object[]{buildService, buildConfiguration, distributionConfiguration, downloadService, mountService, directoryCopierService, shellExecutionService});
        IsoModule isoModule = this;
        BuildService buildService3 = buildService;
        BuildConfiguration buildConfiguration3 = buildConfiguration;
        DistributionConfiguration distributionConfiguration3 = distributionConfiguration;
        DownloadService downloadService3 = downloadService;
        MountService mountService3 = mountService;
        DirectoryCopierService directoryCopierService3 = directoryCopierService;
        ShellExecutionService shellExecutionService3 = shellExecutionService;
        super((BuildService)buildConfiguration2, (BuildConfiguration)distributionConfiguration2, (DistributionConfiguration)downloadService2);
        buildService2.downloadService = mountService2;
        buildService2.mountService = directoryCopierService2;
        buildService2.directoryCopierService = shellExecutionService2;
        buildService2.shellExecutionService = shellExecutionService3;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.linux.builder.impl.service.module.IsoModule", (String)"<init>", (Object[])new Object[]{buildService, buildConfiguration, distributionConfiguration, downloadService, mountService, directoryCopierService, shellExecutionService}, null, (long)l);
    }

    public void document() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.module.IsoModule", (String)"document", (Object[])new Object[0]);
        IsoModule isoModule = this;
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.module.IsoModule", (String)"document", (Object[])new Object[0], null, (long)l);
    }

    @Override
    public void doRun() throws Exception {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.module.IsoModule", (String)"doRun", (Object[])new Object[0]);
        IsoModule isoModule = this;
        isoModule.setupRoot();
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.linux.builder.impl.service.module.IsoModule", (String)"doRun", (Object[])new Object[0], null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean setupRoot() throws Exception {
        boolean bl;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.module.IsoModule", (String)"setupRoot", (Object[])new Object[0]);
        IsoModule isoModule = this;
        File file = new File(isoModule.buildConfiguration.getRootDirectory() + "/bin/bash");
        if (file.exists()) {
            bl = false;
        } else {
            void bash;
            bash.extractRootFS(bash.downloadISO());
            bl = true;
        }
        boolean bl2 = bl;
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.module.IsoModule", (String)"setupRoot", (Object[])new Object[0], (Object)bl2, (long)l);
        return bl2;
    }

    protected File downloadISO() throws Exception {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.module.IsoModule", (String)"downloadISO", (Object[])new Object[0]);
        Object object = this;
        object = ((IsoModule)object).downloadService.download(new Download(((ISOConfiguration)((IsoModule)object).configuration).getDownloadURI(), ((ISOConfiguration)((IsoModule)object).configuration).getDownloadChecksum()));
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.module.IsoModule", (String)"downloadISO", (Object[])new Object[0], (Object)object, (long)l);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void extractRootFS(File file) throws Exception {
        void targetFileMountPoint;
        void isoFile;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.module.IsoModule", (String)"extractRootFS", (Object[])new Object[]{file});
        IsoModule isoModule = this;
        File file2 = file;
        isoFile.prepareDirectory(new File(isoFile.buildConfiguration.getRootDirectory()));
        MountPoint mountPoint = isoFile.getImageMountPoint(file2);
        MountPoint mountPoint2 = isoFile.getImageContentsMountPoint(mountPoint);
        try {
            void targetImageContents;
            isoFile.prepareDirectory(new File(isoFile.buildConfiguration.getBuildDirectory() + "/" + targetFileMountPoint.getMountPoint()));
            File file3 = new File(isoFile.buildConfiguration.getBuildDirectory() + "/" + mountPoint2.getMountPoint());
            isoFile.prepareDirectory(file3);
            isoFile.doMount((MountPoint)targetFileMountPoint);
            isoFile.doMount((MountPoint)targetImageContents);
            isoFile.directoryCopierService.copy(file3.toPath(), new File(isoFile.buildConfiguration.getRootDirectory()).toPath());
        }
        finally {
            isoFile.doUnmount(mountPoint2);
            isoFile.doUnmount((MountPoint)targetFileMountPoint);
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.module.IsoModule", (String)"extractRootFS", (Object[])new Object[]{file}, null, (long)l);
    }

    protected void prepareDirectory(File file) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.module.IsoModule", (String)"prepareDirectory", (Object[])new Object[]{file});
        IsoModule isoModule = this;
        File file2 = file;
        if (!file2.exists()) {
            file2.mkdirs();
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.module.IsoModule", (String)"prepareDirectory", (Object[])new Object[]{file}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected MountPoint getImageMountPoint(File file) {
        void isoFile;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.module.IsoModule", (String)"getImageMountPoint", (Object[])new Object[]{file});
        IsoModule isoModule = this;
        File file2 = file;
        isoModule = new MountPoint("/images/" + isoFile.buildConfiguration.getScmConfiguration().getTag().getTag() + "/" + isoFile.buildConfiguration.getVariant(), file2.getAbsolutePath(), VFSType.AUTO);
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.module.IsoModule", (String)"getImageMountPoint", (Object[])new Object[]{file}, (Object)isoModule, (long)l);
        return isoModule;
    }

    /*
     * WARNING - void declaration
     */
    protected MountPoint getImageContentsMountPoint(MountPoint mountPoint) {
        void isoFileMountPoint;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.module.IsoModule", (String)"getImageContentsMountPoint", (Object[])new Object[]{mountPoint});
        IsoModule isoModule = this;
        MountPoint mountPoint2 = mountPoint;
        isoModule = new MountPoint("/image-contents/" + isoFileMountPoint.buildConfiguration.getScmConfiguration().getTag().getTag() + "/" + isoFileMountPoint.buildConfiguration.getVariant(), isoFileMountPoint.buildConfiguration.getBuildDirectory() + File.separator + mountPoint2.getMountPoint() + ((ISOConfiguration)isoFileMountPoint.configuration).getRootFSPath(), VFSType.AUTO);
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.module.IsoModule", (String)"getImageContentsMountPoint", (Object[])new Object[]{mountPoint}, (Object)isoModule, (long)l);
        return isoModule;
    }

    /*
     * WARNING - void declaration
     */
    protected void doMount(MountPoint mountPoint) throws Exception {
        void mountPoint2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.module.IsoModule", (String)"doMount", (Object[])new Object[]{mountPoint});
        IsoModule isoModule = this;
        MountPoint mountPoint3 = mountPoint;
        mountPoint2.mountService.execute((AbstractEntity)new MountCommand().withMountAction(MountAction.Mount).withMountPoint(mountPoint3).withRootPath(mountPoint2.buildConfiguration.getBuildDirectory()));
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.module.IsoModule", (String)"doMount", (Object[])new Object[]{mountPoint}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected void doUnmount(MountPoint mountPoint) throws Exception {
        void mountPoint2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.module.IsoModule", (String)"doUnmount", (Object[])new Object[]{mountPoint});
        IsoModule isoModule = this;
        MountPoint mountPoint3 = mountPoint;
        mountPoint2.mountService.execute((AbstractEntity)new MountCommand().withMountAction(MountAction.Unmount).withMountPoint(mountPoint3).withRootPath(mountPoint2.buildConfiguration.getBuildDirectory()));
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.linux.builder.impl.service.module.IsoModule", (String)"doUnmount", (Object[])new Object[]{mountPoint}, null, (long)l);
    }
}

