/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.queue.api.model;

import io.github.qsy7.datastore.api.model.entity.AbstractEntity;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.queue.api.enumeration.ExecutionState;
import io.github.qsy7.queue.api.model.AbstractQueued;
import io.github.qsy7.queue.api.model.Unqueueable;
import io.github.qsy7.queue.api.model.Worker;
import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;

@Entity
public class JobExecution
extends AbstractEntity
implements Unqueueable {
    @ManyToOne(optional=false)
    @JoinColumn(nullable=false, updatable=false)
    protected AbstractQueued queued;
    @Column(nullable=false, updatable=false)
    protected int attemptIndex;
    @Column(updatable=false)
    protected LocalDateTime startDateTime;
    @Column(insertable=false)
    protected LocalDateTime endDateTime;
    @Column(updatable=false)
    protected LocalDateTime timeoutDateTime;
    @Column(insertable=false)
    protected LocalDateTime updateDateTime;
    @Lob
    @Column(insertable=false)
    protected Throwable throwable;
    @Enumerated
    @Column(insertable=false)
    protected ExecutionState executionState;
    @ManyToOne(optional=false)
    @JoinColumn(nullable=false, updatable=false)
    protected Worker worker;

    /*
     * WARNING - void declaration
     */
    public JobExecution(AbstractQueued abstractQueued) {
        void queued;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"<init>", (Object[])new Object[]{abstractQueued});
        JobExecution jobExecution = this;
        AbstractQueued abstractQueued2 = abstractQueued;
        queued.queued = abstractQueued2;
        queued.attemptIndex = abstractQueued2.getJobExecutions().size();
        queued.startDateTime = LocalDateTime.now();
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"<init>", (Object[])new Object[]{abstractQueued}, null, (long)l);
    }

    public AbstractQueued getQueued() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"getQueued", (Object[])new Object[0]);
        AbstractEntity abstractEntity = this;
        abstractEntity = abstractEntity.queued;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"getQueued", (Object[])new Object[0], (Object)abstractEntity, (long)l);
        return abstractEntity;
    }

    public int getAttemptIndex() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"getAttemptIndex", (Object[])new Object[0]);
        JobExecution jobExecution = this;
        int n = jobExecution.attemptIndex;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"getAttemptIndex", (Object[])new Object[0], (Object)n, (long)l);
        return n;
    }

    public LocalDateTime getStartDateTime() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"getStartDateTime", (Object[])new Object[0]);
        Object object = this;
        object = ((JobExecution)object).startDateTime;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"getStartDateTime", (Object[])new Object[0], (Object)object, (long)l);
        return object;
    }

    public LocalDateTime getEndDateTime() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"getEndDateTime", (Object[])new Object[0]);
        Object object = this;
        object = ((JobExecution)object).endDateTime;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"getEndDateTime", (Object[])new Object[0], (Object)object, (long)l);
        return object;
    }

    public LocalDateTime getTimeoutDateTime() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"getTimeoutDateTime", (Object[])new Object[0]);
        Object object = this;
        object = ((JobExecution)object).timeoutDateTime;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"getTimeoutDateTime", (Object[])new Object[0], (Object)object, (long)l);
        return object;
    }

    public LocalDateTime getUpdateDateTime() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"getUpdateDateTime", (Object[])new Object[0]);
        Object object = this;
        object = ((JobExecution)object).updateDateTime;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"getUpdateDateTime", (Object[])new Object[0], (Object)object, (long)l);
        return object;
    }

    public Throwable getThrowable() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"getThrowable", (Object[])new Object[0]);
        Object object = this;
        object = ((JobExecution)object).throwable;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"getThrowable", (Object[])new Object[0], (Object)object, (long)l);
        return object;
    }

    public ExecutionState getExecutionState() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"getExecutionState", (Object[])new Object[0]);
        Object object = this;
        object = object.executionState;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"getExecutionState", (Object[])new Object[0], (Object)object, (long)l);
        return object;
    }

    public Worker getWorker() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"getWorker", (Object[])new Object[0]);
        Object object = this;
        object = object.worker;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"getWorker", (Object[])new Object[0], (Object)object, (long)l);
        return object;
    }

    public void setQueued(AbstractQueued abstractQueued) {
        AbstractQueued abstractQueued2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"setQueued", (Object[])new Object[]{abstractQueued});
        JobExecution jobExecution = this;
        queued.queued = abstractQueued2 = abstractQueued;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"setQueued", (Object[])new Object[]{abstractQueued}, null, (long)l);
    }

    public void setAttemptIndex(int n) {
        int n2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"setAttemptIndex", (Object[])new Object[]{n});
        JobExecution jobExecution = this;
        attemptIndex.attemptIndex = n2 = n;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"setAttemptIndex", (Object[])new Object[]{n}, null, (long)l);
    }

    public void setStartDateTime(LocalDateTime localDateTime) {
        LocalDateTime localDateTime2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"setStartDateTime", (Object[])new Object[]{localDateTime});
        JobExecution jobExecution = this;
        startDateTime.startDateTime = localDateTime2 = localDateTime;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"setStartDateTime", (Object[])new Object[]{localDateTime}, null, (long)l);
    }

    public void setEndDateTime(LocalDateTime localDateTime) {
        LocalDateTime localDateTime2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"setEndDateTime", (Object[])new Object[]{localDateTime});
        JobExecution jobExecution = this;
        endDateTime.endDateTime = localDateTime2 = localDateTime;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"setEndDateTime", (Object[])new Object[]{localDateTime}, null, (long)l);
    }

    public void setTimeoutDateTime(LocalDateTime localDateTime) {
        LocalDateTime localDateTime2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"setTimeoutDateTime", (Object[])new Object[]{localDateTime});
        JobExecution jobExecution = this;
        timeoutDateTime.timeoutDateTime = localDateTime2 = localDateTime;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"setTimeoutDateTime", (Object[])new Object[]{localDateTime}, null, (long)l);
    }

    public void setUpdateDateTime(LocalDateTime localDateTime) {
        LocalDateTime localDateTime2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"setUpdateDateTime", (Object[])new Object[]{localDateTime});
        JobExecution jobExecution = this;
        updateDateTime.updateDateTime = localDateTime2 = localDateTime;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"setUpdateDateTime", (Object[])new Object[]{localDateTime}, null, (long)l);
    }

    public void setThrowable(Throwable throwable) {
        Throwable throwable2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"setThrowable", (Object[])new Object[]{throwable});
        JobExecution jobExecution = this;
        throwable.throwable = throwable2 = throwable;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"setThrowable", (Object[])new Object[]{throwable}, null, (long)l);
    }

    public void setExecutionState(ExecutionState executionState) {
        ExecutionState executionState2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"setExecutionState", (Object[])new Object[]{executionState});
        JobExecution jobExecution = this;
        executionState.executionState = executionState2 = executionState;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"setExecutionState", (Object[])new Object[]{executionState}, null, (long)l);
    }

    public void setWorker(Worker worker) {
        Worker worker2;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"setWorker", (Object[])new Object[]{worker});
        JobExecution jobExecution = this;
        worker.worker = worker2 = worker;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"setWorker", (Object[])new Object[]{worker}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object object) {
        boolean bl;
        void o;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"equals", (Object[])new Object[]{object});
        JobExecution jobExecution = this;
        Object object2 = object;
        if (object2 == o) {
            bl = true;
        } else if (!(object2 instanceof JobExecution)) {
            bl = false;
        } else {
            JobExecution jobExecution2 = (JobExecution)object2;
            if (!jobExecution2.canEqual(o)) {
                bl = false;
            } else if (o.getAttemptIndex() != jobExecution2.getAttemptIndex()) {
                bl = false;
            } else {
                void other$queued;
                void this$queued;
                AbstractQueued abstractQueued = o.getQueued();
                AbstractQueued abstractQueued2 = this$queued.getQueued();
                if (other$queued == null ? abstractQueued2 != null : !other$queued.equals(abstractQueued2)) {
                    bl = false;
                } else {
                    void other$executionState;
                    ExecutionState executionState = o.getExecutionState();
                    ExecutionState executionState2 = this$queued.getExecutionState();
                    bl = !(other$executionState == null ? executionState2 != null : !other$executionState.equals((Object)executionState2));
                }
            }
        }
        boolean bl2 = bl;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"equals", (Object[])new Object[]{object}, (Object)bl2, (long)l);
        return bl2;
    }

    protected boolean canEqual(Object object) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"canEqual", (Object[])new Object[]{object});
        JobExecution jobExecution = this;
        Object object2 = object;
        boolean bl = object2 instanceof JobExecution;
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"canEqual", (Object[])new Object[]{object}, (Object)bl, (long)l);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void $queued;
        void PRIME;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"hashCode", (Object[])new Object[0]);
        JobExecution jobExecution = this;
        int n = 59;
        int n2 = 1;
        n2 = n2 * 59 + PRIME.getAttemptIndex();
        AbstractQueued abstractQueued = PRIME.getQueued();
        $queued = $queued * 59 + (abstractQueued == null ? 43 : ((Object)abstractQueued).hashCode());
        ExecutionState executionState = PRIME.getExecutionState();
        void var3_3 = $queued = $queued * 59 + (executionState == null ? 43 : ((Object)((Object)executionState)).hashCode());
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"hashCode", (Object[])new Object[0], (Object)((int)var3_3), (long)l);
        return (int)var3_3;
    }

    public String toString() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"toString", (Object[])new Object[0]);
        Object object = this;
        object = "JobExecution(queued=" + ((JobExecution)object).queued + ", attemptIndex=" + ((JobExecution)object).attemptIndex + ", startDateTime=" + ((JobExecution)object).startDateTime + ", endDateTime=" + ((JobExecution)object).endDateTime + ", timeoutDateTime=" + ((JobExecution)object).timeoutDateTime + ", updateDateTime=" + ((JobExecution)object).updateDateTime + ", throwable=" + ((JobExecution)object).throwable + ", executionState=" + ((JobExecution)object).executionState + ", worker=" + ((JobExecution)object).worker + ")";
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"toString", (Object[])new Object[0], (Object)object, (long)l);
        return object;
    }

    public JobExecution() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"<init>", (Object[])new Object[0]);
        JobExecution jobExecution = this;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.api.model.JobExecution", (String)"<init>", (Object[])new Object[0], null, (long)l);
    }
}

