/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.queue.impl.scheduling;

import io.github.qsy7.closeable.impl.CloseableUtil;
import io.github.qsy7.infrastructure.inject.core.service.StartupAware;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.ExceptionUtil;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.queue.api.annotation.Job;
import io.github.qsy7.queue.api.model.AbstractQueued;
import io.github.qsy7.queue.api.model.QueuedJob;
import io.github.qsy7.queue.api.model.ScheduleInstance;
import io.github.qsy7.queue.api.service.QueueService;
import io.github.qsy7.queue.impl.worker.enumeration.ScheduleType;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JobQueuer
implements StartupAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobQueuer.class);
    protected final QueueService queueService;
    protected final Reflections reflections;

    /*
     * WARNING - void declaration
     */
    @Inject
    public JobQueuer(QueueService queueService, Reflections reflections) {
        void reflections2;
        void queueService2;
        JobQueuer jobQueuer = this;
        QueueService queueService3 = queueService;
        Reflections reflections3 = reflections;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"<init>", (Object[])new Object[]{queueService3, reflections3});
        JobQueuer jobQueuer2 = jobQueuer;
        QueueService queueService4 = queueService3;
        Reflections reflections4 = reflections3;
        jobQueuer2.queueService = queueService2;
        jobQueuer2.reflections = reflections2;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"<init>", (Object[])new Object[]{queueService3, reflections3}, null, (long)l);
        CloseableUtil.addAutoCloseable((AutoCloseable)((AutoCloseable)((Object)this)));
    }

    public void startup() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"startup", (Object[])new Object[0]);
        JobQueuer jobQueuer = this;
        JobQueuer jobQueuer2 = jobQueuer;
        try {
            jobQueuer2.cancelOldJobs();
            jobQueuer2.scheduleJobs();
            jobQueuer2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (jobQueuer2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"startup", (Object[])new Object[0], (Throwable)((Object)jobQueuer2));
        }
        if (jobQueuer2 != null) {
            throw jobQueuer2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"startup", (Object[])new Object[0], null, (long)l);
    }

    public void close() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"close", (Object[])new Object[0]);
        JobQueuer jobQueuer = this;
        JobQueuer jobQueuer2 = jobQueuer;
        jobQueuer2 = null;
        if (jobQueuer2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"close", (Object[])new Object[0], (Throwable)((Object)jobQueuer2));
        }
        if (jobQueuer2 != null) {
            throw jobQueuer2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"close", (Object[])new Object[0], null, (long)l);
    }

    protected void cancelOldJobs() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"cancelOldJobs", (Object[])new Object[0]);
        JobQueuer jobQueuer = this;
        JobQueuer jobQueuer2 = jobQueuer;
        try {
            jobQueuer2.queueService.findAbortedJobExecutions().stream().forEach(queuedJob -> this.cancelJob((AbstractQueued)queuedJob));
            jobQueuer2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (jobQueuer2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"cancelOldJobs", (Object[])new Object[0], (Throwable)((Object)jobQueuer2));
        }
        if (jobQueuer2 != null) {
            throw jobQueuer2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"cancelOldJobs", (Object[])new Object[0], null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean cancelJob(AbstractQueued abstractQueued) {
        boolean bl;
        boolean bl2;
        AbstractQueued abstractQueued2;
        AbstractQueued abstractQueued3;
        long l;
        block5: {
            l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"cancelJob", (Object[])new Object[]{abstractQueued});
            JobQueuer jobQueuer = this;
            abstractQueued3 = abstractQueued;
            JobQueuer jobQueuer2 = jobQueuer;
            abstractQueued2 = abstractQueued3;
            try {
                void queuedJob;
                if (QueuedJob.class.isAssignableFrom(queuedJob.getClass())) {
                    jobQueuer2.queueService.cancel((AbstractQueued)queuedJob);
                    bl2 = true;
                    break block5;
                }
                bl2 = false;
            }
            catch (Throwable throwable) {
                bl = false;
            }
        }
        bl = bl2;
        abstractQueued2 = null;
        if (abstractQueued2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"cancelJob", (Object[])new Object[]{abstractQueued3}, (Throwable)abstractQueued2);
        }
        if (abstractQueued2 != null) {
            throw abstractQueued2;
        }
        boolean bl3 = bl;
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"cancelJob", (Object[])new Object[]{abstractQueued}, (Object)bl3, (long)l);
        return bl3;
    }

    protected void scheduleJobs() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"scheduleJobs", (Object[])new Object[0]);
        JobQueuer jobQueuer = this;
        JobQueuer jobQueuer2 = jobQueuer;
        try {
            jobQueuer2.getQueuedJobs().stream().forEach(queuedJob -> this.scheduleJob((QueuedJob)queuedJob));
            jobQueuer2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (jobQueuer2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"scheduleJobs", (Object[])new Object[0], (Throwable)((Object)jobQueuer2));
        }
        if (jobQueuer2 != null) {
            throw jobQueuer2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"scheduleJobs", (Object[])new Object[0], null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    protected void scheduleJob(QueuedJob queuedJob) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"scheduleJob", (Object[])new Object[]{queuedJob});
        JobQueuer jobQueuer = this;
        QueuedJob queuedJob2 = queuedJob;
        JobQueuer jobQueuer2 = jobQueuer;
        QueuedJob queuedJob3 = queuedJob2;
        try {
            try {
                void queuedJob4;
                jobQueuer2.queueService.queue((AbstractQueued)queuedJob4);
            }
            catch (Exception e) {
                LOGGER.warn("Error running queuedJob", (Throwable)e);
            }
            jobQueuer2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (jobQueuer2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"scheduleJob", (Object[])new Object[]{queuedJob2}, (Throwable)((Object)jobQueuer2));
        }
        if (jobQueuer2 != null) {
            throw jobQueuer2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"scheduleJob", (Object[])new Object[]{queuedJob}, null, (long)l);
    }

    protected Set<QueuedJob> getQueuedJobs() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"getQueuedJobs", (Object[])new Object[0]);
        JobQueuer jobQueuer = this;
        Object object = jobQueuer;
        try {
            HashSet<QueuedJob> queuedJobs = new HashSet<QueuedJob>();
            for (Class jobClass : ((JobQueuer)object).reflections.getTypesAnnotatedWith(Job.class)) {
                Job job = jobClass.getAnnotation(Job.class);
                ((JobQueuer)object).addJobs(queuedJobs, ((JobQueuer)object).getScheduleInstances(job), jobClass, job.jobExecutionConfiguration().system());
            }
            object = queuedJobs;
            return object;
        }
        finally {
            Object var5_4 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Set<ScheduleInstance> getScheduleInstances(Job job) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"getScheduleInstances", (Object[])new Object[]{job});
        JobQueuer jobQueuer = this;
        Job job2 = job;
        Object object = jobQueuer;
        Job job3 = job2;
        try {
            void jobAnnotation;
            HashSet scheduleInstances = new HashSet();
            Arrays.stream(ScheduleType.values()).forEach(arg_0 -> JobQueuer.lambda$getScheduleInstances$2(scheduleInstances, (Job)jobAnnotation, arg_0));
            object = scheduleInstances;
            return object;
        }
        finally {
            job3 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void addJobs(Set<QueuedJob> set, Set<ScheduleInstance> set2, Class clazz, boolean bl) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"addJobs", (Object[])new Object[]{set, set2, clazz, bl});
        JobQueuer jobQueuer = this;
        Set<QueuedJob> set3 = set;
        Set<ScheduleInstance> set4 = set2;
        Class clazz2 = clazz;
        boolean bl2 = bl;
        JobQueuer jobQueuer2 = jobQueuer;
        Set<QueuedJob> set5 = set3;
        Set<ScheduleInstance> set6 = set4;
        Class clazz3 = clazz2;
        boolean bl3 = bl2;
        try {
            void system;
            void jobClass;
            void queuedJobs;
            void scheduleInstances;
            scheduleInstances.stream().forEach(arg_0 -> jobQueuer2.lambda$addJobs$3((Set)queuedJobs, (Class)jobClass, (boolean)system, arg_0));
            jobQueuer2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (jobQueuer2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"addJobs", (Object[])new Object[]{set3, set4, clazz2, bl2}, (Throwable)((Object)jobQueuer2));
        }
        if (jobQueuer2 != null) {
            throw jobQueuer2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.scheduling.JobQueuer", (String)"addJobs", (Object[])new Object[]{set, set2, clazz, bl}, null, (long)l);
    }

    private /* synthetic */ void lambda$addJobs$3(Set queuedJobs, Class jobClass, boolean system, ScheduleInstance scheduleInstance) {
        queuedJobs.add((QueuedJob)this.queueService.queue((AbstractQueued)new QueuedJob(jobClass, scheduleInstance, system)));
    }

    private static /* synthetic */ void lambda$getScheduleInstances$2(Set scheduleInstances, Job jobAnnotation, ScheduleType scheduleType) {
        scheduleType.getScheduleInstanceBuilder().getDelay(scheduleInstances, jobAnnotation);
    }
}

