/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.queue.impl.worker;

import io.github.qsy7.closeable.impl.CloseableUtil;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.ExceptionUtil;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.property.api.annotation.Property;
import io.github.qsy7.property.api.enumeration.NoOperation;
import io.github.qsy7.queue.api.job.AbstractRunnable;
import io.github.qsy7.queue.api.job.RunningFuture;
import io.github.qsy7.queue.api.model.AbstractQueued;
import io.github.qsy7.queue.api.model.JobExecution;
import io.github.qsy7.queue.api.model.Worker;
import io.github.qsy7.queue.api.service.JobWorkerService;
import io.github.qsy7.queue.impl.worker.builder.JobBuilder;
import io.github.qsy7.queue.impl.worker.property.ExecutorServiceShutdownTimeoutUnits;
import io.github.qsy7.queue.impl.worker.property.ExecutorServiceShutdownTimeoutValue;
import io.github.qsy7.queue.impl.worker.scheduler.Scheduler;
import jakarta.inject.Inject;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DefaultJobWorkerService
implements JobWorkerService,
AutoCloseable {
    protected final boolean noOperation;
    protected final long shutdownTimeout;
    protected final TimeUnit shutdownTimeoutUnits;
    protected final JobBuilder jobBuilder;
    protected final Worker worker;
    protected final ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    protected boolean shutdown;
    protected final Set<RunningFuture> runningFutures;

    /*
     * WARNING - void declaration
     */
    @Inject
    public DefaultJobWorkerService(@Property(value=NoOperation.class) boolean bl, @Property(value=ExecutorServiceShutdownTimeoutValue.class) long l, @Property(value=ExecutorServiceShutdownTimeoutUnits.class) TimeUnit timeUnit, JobBuilder jobBuilder, Worker worker) {
        void worker2;
        void jobBuilder2;
        void shutdownTimeoutUnits;
        void shutdownTimeout;
        void noOperation;
        DefaultJobWorkerService defaultJobWorkerService = this;
        boolean bl2 = bl;
        long l2 = l;
        TimeUnit timeUnit2 = timeUnit;
        JobBuilder jobBuilder3 = jobBuilder;
        Worker worker3 = worker;
        long l3 = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"<init>", (Object[])new Object[]{bl2, l2, timeUnit2, jobBuilder3, worker3});
        DefaultJobWorkerService defaultJobWorkerService2 = defaultJobWorkerService;
        boolean bl3 = bl2;
        long l4 = l2;
        TimeUnit timeUnit3 = timeUnit2;
        JobBuilder jobBuilder4 = jobBuilder3;
        Worker worker4 = worker3;
        defaultJobWorkerService2.scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(Runtime.getRuntime().availableProcessors() * 2);
        defaultJobWorkerService2.runningFutures = new ConcurrentSkipListSet<RunningFuture>();
        defaultJobWorkerService2.noOperation = noOperation;
        defaultJobWorkerService2.shutdownTimeout = shutdownTimeout;
        defaultJobWorkerService2.shutdownTimeoutUnits = shutdownTimeoutUnits;
        defaultJobWorkerService2.jobBuilder = jobBuilder2;
        defaultJobWorkerService2.worker = worker2;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"<init>", (Object[])new Object[]{bl2, l2, timeUnit2, jobBuilder3, worker3}, null, (long)l3);
        CloseableUtil.addAutoCloseable((AutoCloseable)this);
    }

    @Override
    public void close() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"close", (Object[])new Object[0]);
        DefaultJobWorkerService defaultJobWorkerService = this;
        DefaultJobWorkerService defaultJobWorkerService2 = defaultJobWorkerService;
        try {
            defaultJobWorkerService2.scheduledThreadPoolExecutor.shutdown();
            try {
                if (!defaultJobWorkerService2.scheduledThreadPoolExecutor.awaitTermination(defaultJobWorkerService2.shutdownTimeout, defaultJobWorkerService2.shutdownTimeoutUnits)) {
                    defaultJobWorkerService2.updateCancelledJobs();
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Error during shutdown", e);
            }
            defaultJobWorkerService2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (defaultJobWorkerService2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"close", (Object[])new Object[0], (Throwable)((Object)defaultJobWorkerService2));
        }
        if (defaultJobWorkerService2 != null) {
            throw defaultJobWorkerService2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"close", (Object[])new Object[0], null, (long)l);
    }

    protected void updateCancelledJobs() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"updateCancelledJobs", (Object[])new Object[0]);
        DefaultJobWorkerService defaultJobWorkerService = this;
        DefaultJobWorkerService defaultJobWorkerService2 = defaultJobWorkerService;
        try {
            defaultJobWorkerService2.scheduledThreadPoolExecutor.shutdownNow().stream().forEach(runnable -> this.handleRemovalOfRunnable((Runnable)runnable));
            defaultJobWorkerService2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (defaultJobWorkerService2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"updateCancelledJobs", (Object[])new Object[0], (Throwable)((Object)defaultJobWorkerService2));
        }
        if (defaultJobWorkerService2 != null) {
            throw defaultJobWorkerService2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"updateCancelledJobs", (Object[])new Object[0], null, (long)l);
    }

    protected void handleRemovalOfRunnable(Runnable runnable) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"handleRemovalOfRunnable", (Object[])new Object[]{runnable});
        DefaultJobWorkerService defaultJobWorkerService = this;
        Runnable runnable2 = runnable;
        DefaultJobWorkerService defaultJobWorkerService2 = defaultJobWorkerService;
        Runnable runnable3 = runnable2;
        defaultJobWorkerService2 = null;
        if (defaultJobWorkerService2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"handleRemovalOfRunnable", (Object[])new Object[]{runnable2}, (Throwable)((Object)defaultJobWorkerService2));
        }
        if (defaultJobWorkerService2 != null) {
            throw defaultJobWorkerService2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"handleRemovalOfRunnable", (Object[])new Object[]{runnable}, null, (long)l);
    }

    protected void checkIfShutdown() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"checkIfShutdown", (Object[])new Object[0]);
        DefaultJobWorkerService defaultJobWorkerService = this;
        DefaultJobWorkerService defaultJobWorkerService2 = defaultJobWorkerService;
        try {
            if (defaultJobWorkerService2.isShutdown()) {
                throw new IllegalStateException("Executor service is shutting down");
            }
            defaultJobWorkerService2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (defaultJobWorkerService2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"checkIfShutdown", (Object[])new Object[0], (Throwable)((Object)defaultJobWorkerService2));
        }
        if (defaultJobWorkerService2 != null) {
            throw defaultJobWorkerService2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"checkIfShutdown", (Object[])new Object[0], null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    public AbstractQueued queue(AbstractQueued abstractQueued) {
        void v0;
        AbstractQueued abstractQueued2;
        DefaultJobWorkerService defaultJobWorkerService;
        AbstractQueued abstractQueued3;
        DefaultJobWorkerService defaultJobWorkerService2;
        long l;
        block5: {
            l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"queue", (Object[])new Object[]{abstractQueued});
            defaultJobWorkerService2 = this;
            abstractQueued3 = abstractQueued;
            defaultJobWorkerService = defaultJobWorkerService2;
            abstractQueued2 = abstractQueued3;
            try {
                void queued;
                defaultJobWorkerService.checkIfShutdown();
                if (defaultJobWorkerService.isNoOperation()) {
                    v0 = queued;
                    break block5;
                }
                defaultJobWorkerService.doQueue((AbstractQueued)queued);
                v0 = queued;
            }
            catch (Throwable throwable) {
                defaultJobWorkerService = null;
            }
        }
        defaultJobWorkerService = v0;
        abstractQueued2 = null;
        if (abstractQueued2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"queue", (Object[])new Object[]{abstractQueued3}, (Throwable)abstractQueued2);
        }
        if (abstractQueued2 != null) {
            throw abstractQueued2;
        }
        defaultJobWorkerService2 = defaultJobWorkerService;
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"queue", (Object[])new Object[]{abstractQueued}, (Object)defaultJobWorkerService2, (long)l);
        return defaultJobWorkerService2;
    }

    /*
     * WARNING - void declaration
     */
    protected void doQueue(AbstractQueued abstractQueued) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"doQueue", (Object[])new Object[]{abstractQueued});
        DefaultJobWorkerService defaultJobWorkerService = this;
        AbstractQueued abstractQueued2 = abstractQueued;
        DefaultJobWorkerService defaultJobWorkerService2 = defaultJobWorkerService;
        AbstractQueued abstractQueued3 = abstractQueued2;
        try {
            void queued;
            AbstractRunnable runnable = defaultJobWorkerService2.jobBuilder.prepareCallableJob((AbstractQueued)queued);
            Scheduler scheduler = null;
            Future f = scheduler.schedule(defaultJobWorkerService2.scheduledThreadPoolExecutor, runnable, queued);
            RunningFuture runningFuture = new RunningFuture(f, queued.getId().intValue(), queued.getCurrentJobExecution().getId().intValue(), runnable.hashCode());
            defaultJobWorkerService2.runningFutures.add(runningFuture);
            runnable.setRunningFuture(runningFuture);
            defaultJobWorkerService2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (defaultJobWorkerService2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"doQueue", (Object[])new Object[]{abstractQueued2}, (Throwable)((Object)defaultJobWorkerService2));
        }
        if (defaultJobWorkerService2 != null) {
            throw defaultJobWorkerService2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"doQueue", (Object[])new Object[]{abstractQueued}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    public void cancel(AbstractQueued abstractQueued) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"cancel", (Object[])new Object[]{abstractQueued});
        DefaultJobWorkerService defaultJobWorkerService = this;
        AbstractQueued abstractQueued2 = abstractQueued;
        DefaultJobWorkerService defaultJobWorkerService2 = defaultJobWorkerService;
        AbstractQueued abstractQueued3 = abstractQueued2;
        try {
            void queued;
            Optional<RunningFuture> runningFutureOptional = defaultJobWorkerService2.runningFutures.stream().filter(arg_0 -> DefaultJobWorkerService.lambda$cancel$1((AbstractQueued)queued, arg_0)).findFirst();
            if (!runningFutureOptional.isPresent()) {
                throw new IllegalStateException("Requested queued is not present and must have already completed or failed:" + String.valueOf(queued));
            }
            runningFutureOptional.get().getFuture().cancel(true);
            defaultJobWorkerService2.remove(runningFutureOptional.get());
            defaultJobWorkerService2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (defaultJobWorkerService2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"cancel", (Object[])new Object[]{abstractQueued2}, (Throwable)((Object)defaultJobWorkerService2));
        }
        if (defaultJobWorkerService2 != null) {
            throw defaultJobWorkerService2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"cancel", (Object[])new Object[]{abstractQueued}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    public void cancel(JobExecution jobExecution) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"cancel", (Object[])new Object[]{jobExecution});
        DefaultJobWorkerService defaultJobWorkerService = this;
        JobExecution jobExecution2 = jobExecution;
        DefaultJobWorkerService defaultJobWorkerService2 = defaultJobWorkerService;
        JobExecution jobExecution3 = jobExecution2;
        try {
            void jobExecution4;
            Optional<RunningFuture> runningFutureOptional = defaultJobWorkerService2.runningFutures.stream().filter(arg_0 -> DefaultJobWorkerService.lambda$cancel$2((JobExecution)jobExecution4, arg_0)).findFirst();
            if (!runningFutureOptional.isPresent()) {
                throw new IllegalStateException("Requested job execution is not present and must have already completed or failed:" + String.valueOf(jobExecution4));
            }
            runningFutureOptional.get().getFuture().cancel(true);
            defaultJobWorkerService2.remove(runningFutureOptional.get());
            defaultJobWorkerService2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (defaultJobWorkerService2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"cancel", (Object[])new Object[]{jobExecution2}, (Throwable)((Object)defaultJobWorkerService2));
        }
        if (defaultJobWorkerService2 != null) {
            throw defaultJobWorkerService2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"cancel", (Object[])new Object[]{jobExecution}, null, (long)l);
    }

    /*
     * WARNING - void declaration
     */
    public void remove(RunningFuture runningFuture) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"remove", (Object[])new Object[]{runningFuture});
        DefaultJobWorkerService defaultJobWorkerService = this;
        RunningFuture runningFuture2 = runningFuture;
        DefaultJobWorkerService defaultJobWorkerService2 = defaultJobWorkerService;
        RunningFuture runningFuture3 = runningFuture2;
        try {
            void runningFuture4;
            defaultJobWorkerService2.runningFutures.remove(runningFuture4);
            defaultJobWorkerService2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (defaultJobWorkerService2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"remove", (Object[])new Object[]{runningFuture2}, (Throwable)((Object)defaultJobWorkerService2));
        }
        if (defaultJobWorkerService2 != null) {
            throw defaultJobWorkerService2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"remove", (Object[])new Object[]{runningFuture}, null, (long)l);
    }

    public boolean isNoOperation() {
        Throwable throwable;
        boolean bl;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"isNoOperation", (Object[])new Object[0]);
        DefaultJobWorkerService defaultJobWorkerService = this;
        DefaultJobWorkerService defaultJobWorkerService2 = defaultJobWorkerService;
        try {
            bl = defaultJobWorkerService2.noOperation;
            throwable = null;
        }
        catch (Throwable throwable2) {
            bl = false;
        }
        if (throwable != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"isNoOperation", (Object[])new Object[0], throwable);
        }
        if (throwable != null) {
            throw throwable;
        }
        boolean bl2 = bl;
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"isNoOperation", (Object[])new Object[0], (Object)bl2, (long)l);
        return bl2;
    }

    public long getShutdownTimeout() {
        Throwable throwable;
        long l;
        long l2 = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"getShutdownTimeout", (Object[])new Object[0]);
        DefaultJobWorkerService defaultJobWorkerService = this;
        DefaultJobWorkerService defaultJobWorkerService2 = defaultJobWorkerService;
        try {
            l = defaultJobWorkerService2.shutdownTimeout;
            throwable = null;
        }
        catch (Throwable throwable2) {
            l = 0L;
        }
        if (throwable != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"getShutdownTimeout", (Object[])new Object[0], throwable);
        }
        if (throwable != null) {
            throw throwable;
        }
        long l3 = l;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"getShutdownTimeout", (Object[])new Object[0], (Object)l3, (long)l2);
        return l3;
    }

    public TimeUnit getShutdownTimeoutUnits() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"getShutdownTimeoutUnits", (Object[])new Object[0]);
        DefaultJobWorkerService defaultJobWorkerService = this;
        Object object = defaultJobWorkerService;
        try {
            object = object.shutdownTimeoutUnits;
            return object;
        }
        finally {
            Throwable throwable = null;
        }
    }

    public JobBuilder getJobBuilder() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"getJobBuilder", (Object[])new Object[0]);
        DefaultJobWorkerService defaultJobWorkerService = this;
        Object object = defaultJobWorkerService;
        try {
            object = ((DefaultJobWorkerService)object).jobBuilder;
            return object;
        }
        finally {
            Throwable throwable = null;
        }
    }

    public Worker getWorker() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"getWorker", (Object[])new Object[0]);
        DefaultJobWorkerService defaultJobWorkerService = this;
        DefaultJobWorkerService defaultJobWorkerService2 = defaultJobWorkerService;
        try {
            defaultJobWorkerService2 = defaultJobWorkerService2.worker;
            return defaultJobWorkerService2;
        }
        finally {
            Throwable throwable = null;
        }
    }

    public ScheduledThreadPoolExecutor getScheduledThreadPoolExecutor() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"getScheduledThreadPoolExecutor", (Object[])new Object[0]);
        DefaultJobWorkerService defaultJobWorkerService = this;
        AutoCloseable autoCloseable = defaultJobWorkerService;
        try {
            autoCloseable = autoCloseable.scheduledThreadPoolExecutor;
            return autoCloseable;
        }
        finally {
            Throwable throwable = null;
        }
    }

    public boolean isShutdown() {
        Throwable throwable;
        boolean bl;
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"isShutdown", (Object[])new Object[0]);
        DefaultJobWorkerService defaultJobWorkerService = this;
        DefaultJobWorkerService defaultJobWorkerService2 = defaultJobWorkerService;
        try {
            bl = defaultJobWorkerService2.shutdown;
            throwable = null;
        }
        catch (Throwable throwable2) {
            bl = false;
        }
        if (throwable != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"isShutdown", (Object[])new Object[0], throwable);
        }
        if (throwable != null) {
            throw throwable;
        }
        boolean bl2 = bl;
        MethodLogUtil.onExit((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"isShutdown", (Object[])new Object[0], (Object)bl2, (long)l);
        return bl2;
    }

    public Set<RunningFuture> getRunningFutures() {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.impl.worker.DefaultJobWorkerService", (String)"getRunningFutures", (Object[])new Object[0]);
        DefaultJobWorkerService defaultJobWorkerService = this;
        Object object = defaultJobWorkerService;
        try {
            object = ((DefaultJobWorkerService)object).runningFutures;
            return object;
        }
        finally {
            Throwable throwable = null;
        }
    }

    private static /* synthetic */ boolean lambda$cancel$2(JobExecution jobExecution, RunningFuture runningFuture) {
        return runningFuture.getExecutionId() == jobExecution.getId().intValue();
    }

    private static /* synthetic */ boolean lambda$cancel$1(AbstractQueued queued, RunningFuture runningFuture) {
        return runningFuture.getQueuedId() == queued.getId().intValue();
    }
}

