/*
 * Decompiled with CFR 0.152.
 */
package io.github.qsy7.queue.impl.worker.builder;

import io.github.qsy7.infrastructure.inject.core.helper.ApplicationHelper;
import io.github.qsy7.logging.enumeration.LogLevel;
import io.github.qsy7.logging.util.ExceptionUtil;
import io.github.qsy7.logging.util.MethodLogUtil;
import io.github.qsy7.property.api.annotation.Property;
import io.github.qsy7.queue.api.job.AbstractRunnable;
import io.github.qsy7.queue.api.model.AbstractQueued;
import io.github.qsy7.queue.impl.worker.property.JobExecutionHeartbeatTimeoutUnits;
import io.github.qsy7.queue.impl.worker.property.JobExecutionHeartbeatTimeoutValue;
import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.inject.Inject;
import java.time.Duration;
import java.time.temporal.ChronoUnit;

public class JobBuilder {
    protected final long interruptGracePeriodValue;
    protected final ChronoUnit interruptGracePeriodUnits;
    protected final long heartbeatIntervalValue;
    protected final ChronoUnit heartbeatIntervalUnits;

    /*
     * WARNING - void declaration
     */
    @Inject
    public JobBuilder(long l, ChronoUnit chronoUnit, @Property(value=JobExecutionHeartbeatTimeoutValue.class) long l2, @Property(value=JobExecutionHeartbeatTimeoutUnits.class) ChronoUnit chronoUnit2) {
        void heartbeatIntervalUnits;
        void heartbeatIntervalValue;
        void interruptGracePeriodUnits;
        void interruptGracePeriodValue;
        long l3 = MethodLogUtil.onEnter((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.impl.worker.builder.JobBuilder", (String)"<init>", (Object[])new Object[]{l, chronoUnit, l2, chronoUnit2});
        JobBuilder jobBuilder = this;
        long l4 = l;
        ChronoUnit chronoUnit3 = chronoUnit;
        long l5 = l2;
        ChronoUnit chronoUnit4 = chronoUnit2;
        jobBuilder.interruptGracePeriodValue = interruptGracePeriodValue;
        jobBuilder.interruptGracePeriodUnits = interruptGracePeriodUnits;
        jobBuilder.heartbeatIntervalValue = heartbeatIntervalValue;
        jobBuilder.heartbeatIntervalUnits = heartbeatIntervalUnits;
        MethodLogUtil.onExit((LogLevel)LogLevel.TRACE, (String)"io.github.qsy7.queue.impl.worker.builder.JobBuilder", (String)"<init>", (Object[])new Object[]{l, chronoUnit, l2, chronoUnit2}, null, (long)l3);
    }

    /*
     * WARNING - void declaration
     */
    public AbstractRunnable prepareCallableJob(AbstractQueued abstractQueued) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.INFO, (String)"io.github.qsy7.queue.impl.worker.builder.JobBuilder", (String)"prepareCallableJob", (Object[])new Object[]{abstractQueued});
        JobBuilder jobBuilder = this;
        AbstractQueued abstractQueued2 = abstractQueued;
        JobBuilder jobBuilder2 = jobBuilder;
        AbstractQueued abstractQueued3 = abstractQueued2;
        try {
            void queued;
            AbstractRunnable runnable = jobBuilder2.getRunnable((AbstractQueued)queued);
            jobBuilder2.setup(runnable, (AbstractQueued)queued);
            jobBuilder2 = runnable;
            return jobBuilder2;
        }
        finally {
            abstractQueued3 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractRunnable getRunnable(AbstractQueued abstractQueued) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.worker.builder.JobBuilder", (String)"getRunnable", (Object[])new Object[]{abstractQueued});
        JobBuilder jobBuilder = this;
        AbstractQueued abstractQueued2 = abstractQueued;
        JobBuilder jobBuilder2 = jobBuilder;
        AbstractQueued abstractQueued3 = abstractQueued2;
        try {
            void queued;
            jobBuilder2 = (AbstractRunnable)ApplicationHelper.getApplicationInstance().getInjector().getInstance(queued.getJobExecutorClass(), new AnnotationLiteral[0]);
            return jobBuilder2;
        }
        finally {
            abstractQueued3 = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void setup(AbstractRunnable abstractRunnable, AbstractQueued abstractQueued) {
        long l = MethodLogUtil.onEnter((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.worker.builder.JobBuilder", (String)"setup", (Object[])new Object[]{abstractRunnable, abstractQueued});
        JobBuilder jobBuilder = this;
        AbstractRunnable abstractRunnable2 = abstractRunnable;
        AbstractQueued abstractQueued2 = abstractQueued;
        JobBuilder jobBuilder2 = jobBuilder;
        AbstractRunnable abstractRunnable3 = abstractRunnable2;
        AbstractQueued abstractQueued3 = abstractQueued2;
        try {
            void queued;
            void runnable;
            runnable.setQueued((AbstractQueued)queued);
            runnable.setHeartbeatInterval(Duration.of(jobBuilder2.heartbeatIntervalValue, jobBuilder2.heartbeatIntervalUnits));
            runnable.setInterruptGracePeriodTimeout(Duration.of(jobBuilder2.heartbeatIntervalValue, jobBuilder2.heartbeatIntervalUnits));
            jobBuilder2 = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (jobBuilder2 != null) {
            ExceptionUtil.onException((String)"io.github.qsy7.queue.impl.worker.builder.JobBuilder", (String)"setup", (Object[])new Object[]{abstractRunnable2, abstractQueued2}, (Throwable)((Object)jobBuilder2));
        }
        if (jobBuilder2 != null) {
            throw jobBuilder2;
        }
        MethodLogUtil.onExit((LogLevel)LogLevel.DEBUG, (String)"io.github.qsy7.queue.impl.worker.builder.JobBuilder", (String)"setup", (Object[])new Object[]{abstractRunnable, abstractQueued}, null, (long)l);
    }
}

