package io.github.qsy7.shell.impl.collector;

import com.google.common.eventbus.EventBus;
import io.github.qsy7.shell.api.service.OutputCollector;

public class EventBusOutputCollector implements OutputCollector {
  protected final EventBus eventBus;

  public EventBusOutputCollector(EventBus eventBus) {

    this.eventBus = eventBus;
  }

  @Override
  public void onData(String line, boolean isError) {
    eventBus.post(line);
  }
}
